; RTX ON - code by TomCat/Abaddon
; Entry for the 1st 256 byte intro compo at Deadline demoscene party

; the very first RTX demosecene prod with a short precalc :-) keep calm...
; special thanks to insomniac for the blurring idea!

; Greetings to:
; Rrrola, Kuemmel, Harekiet, Digimind, Sensenstahl, HellMood, TheMechanist
; ern0, mu6k, Nap, Ionic, Picard, Eagle, Nagz, Jimmi, Gargaj & Buckethead.

; Respect to:
; Frag, Khamoon, Baudsurfer, p01, y0bi, Baze, Devreci, Dee, Pirx & Tigrou.

; 2018 FASM source - kapor@dit.hu

ORG 256

 CWD                            ; zero to Red
 XCHG   CX,AX                   ; zero to Green and Blue
 MOV    AL,13H                  ; set video mode 320x200
.1:
 INT    10H                     ; call VGA Bios
 MOV    AX,1010H                ; clear all the colors to hide the fx
 DEC    BX                      ; repeat so many times
 JNZ    .1                      ; after the loop BX, CX, DX = 0

 MOV    BP,text                 ; using BP to easy index the code segment
 PUSH   0A000H                  ; ES and DS both points to the video memory
 POP    DS                      ; for a shorter blur code
 PUSH   DS
 POP    ES
 MOV    DI,24+8*14+48+8*13+320*9; starting position to draw
.2:
 MOV    BX,320                  ; the linelen constant for cheaper indexes
 MOV    CL,45                   ; number of iterations of the blur
.7:

.8:
 ADD    AL,[SI+1]               ; AL contains 0 at start, and last color later
 ADC    AH,CH                   ; summing the 4 neighbours
.6:
 ADD    AL,[SI+BX]
 ADC    AH,CH
 NEG    BX
 JS     .6
 SHR    AX,2                    ; dividing by 4
 MOV    [SI],AL                 ; writing back the average
 INC    SI                      ; go to the next pixel
 JNZ    .8

 CMP    CL,5                    ; after 40 iterations
 JNE    .9                      ; and before the last 5 iterations
 PUSHA                          ; insert some smaller blocks (3x2 pixel)
 DEC    AX
 PUSH   320*55+181              ; scr pos of left breast
 PUSH   320*52+247              ; scr pos of right breast
 PUSH   320*118+232             ; scr pos of navel
@@:
 POP    DI
 MOV    [DI+BX],AX
 STOSW
 MOV    [DI+BX],AL
 STOSB
 INC    DX
 JPO    @B
 POPA
.9:
 LOOP   .7

 MOV    SI,26*14-16             ; number of bits
 MOV    DL,14                   ; coloums of the image
.3:
 MOV    CL,26                   ; raws of the image
.4:
 BT     [BP-text+bits],SI       ; the bit means a block colored with 0 or 255
 SALC
 CBW
 MOV    BX,7                    ; drawing the bigblocks (8x7 pixel)
.5:
 STOSW
 STOSW
 STOSW
 STOSW
 ADD    DI,320-8
 DEC    BX
 JNZ    .5
 DEC    SI                      ; counting the bits left
 LOOPNZ .4                      ; repeat until bottom of scr or end of bits
 SUB    DI,320*7*26+8
 DEC    DX                      ; go to next coloum
 JNZ    .3
 ADD    DI,-7430H               ; DI = 24+8*13+320*9
 JPE    .2                      ; loop twice and we need the carry later

print:
 MOV    BL,254                  ; color idx of RTX off caption
 MOV    DL,13                   ; cursor position for the 1st text
 PUSH   CS
 POP    ES
 MOV    AH,13H
 MOV    CL,7                    ; writing 7 characters
 INT    10H                     ; VGA BIOS call, write string from ES:BP
 ADC    BYTE [BP+5],CL          ; correcting the text from off to on
 DEC    CX                      ; we need one byte shorter 2nd text
 DEC    BX                      ; color idx of RTX on caption
 MOV    DL,34                   ; cursor position for the 2nd text
 INT    10H                     ; VGA BIOS call, write string from ES:BP

setpal:
.1:
 IMUL   DX,BX,6DH               ; setting the color palette
 IMUL   CX,BX,3FH               ; from color black to brown
 IMUL   AX,BX,30H
 CMP    BL,105
 JB     .2
 IMUL   DX,BX,37H               ; then from brown to yellowish body color
 IMUL   CX,BX,50H
 IMUL   AX,BX,5CH
 ADD    DH,016H
 ADD    CH,0F9H
 ADD    AH,0EDH
.2:
 MOV    CL,AH                   ; DH/CH/CL->R/G/B
 MOV    AX,1010H                ; set only one color by the VGA BIOS
 INT    10H
 DEC    BX                      ; BX is the color index
 JNZ    .1                      ; one by one from #253 to #1
 DEC    BX                      ; after the loop BX, CX, DH = 0
 MOV    CX,256*42+42
 INT    10H                     ; set color #255: nearly gray
 DEC    BX
 MOV    DH,28
 INT    10H                     ; set color #254: turquoise blue
 DEC    BX
 MOV    CL,0
 INT    10H                     ; set color #253: nVidia green

 CBW                            ; AH = 0
 INT    16H                     ; waiting for keypress
RETN                            ; return to DOS prompt

bits:
 file 'BITS4.BIN':0,44          ; bits of image

text:
 DB 'RTX off'                   ; 1st text
