comment +
                .code by bitl/7dump.
                aleks_gs @ yahoo.com

   0\   /0           "PAINTRIP"
             256 byte MS-DOS intro
    ..
           GrEeTiNgS  & ReSpEct:
    ^^^^^       HellMood, sensenstahl
           TomCatAbaddon, rrrola
       wbc\\bz7, p01, pestis
           Asato, iONic, Optimus
          superogue,   Kuemmel,
             Digimind, and you! ;)
   
            This source for TASM!
              For compilation  run:
              tasm /m2 paintrip.asm
          tlink /t paintrip.obj

comment end! +

.model tiny
.data
     Y  DW 0A000h             ; VGA screen segment
     R  DW 75                 ; For motion routine (speed and radius)
     P  DW 31                 ; For palette routine
     F  DW 20
     D16 DW 16                ; For sqrt-table routine

     db 0F1h  ; fyl2x           Data for self-modifying trick
     db 0FFh  ; fcos
     db 0FCh  ; frndint
     db 0FAh  ; fsqrt

.code
.386
org 0100h

start:
     mov al, 13h              ; set VGA 320x200x8bpp
     int 10h

     add dh, al               ; cs + 1300h
     mov fs, dx               ; segment for framebuffer

     add dh, al               ; cs + 2600h
     mov gs, dx               ; segment for precals table

;     push bx                  ; init var for part-counter

     lea bx, Y                ; init BX as pointer to Y (used throughout)

     mov es, word ptr [bx]    ; ES = 0xA000

;**********************************************************************
; BLOCK OF RUNTIME CODE MODIFICATION (for switching effects)
;**********************************************************************
@nextpart:

     pop di
     inc di                          ; part-counter
     and di, 3                       ; if (si = 4) then si:=0
     push di

     mov dl, byte ptr [bx+10+di]     ; Let's the self-modifying! ;)
     mov byte ptr [@table+13], dl    ; update opcode in the sqrt-table routine

                                     ; Default presets:
     mov bp, 4                       ;   - Set number of passes = 4 (default)
     mov al, 6                       ;   - Parametr for sqrt-table
     mov dl, 01h                     ;   - Byte for modifying opcode (ADD)

     dec di                          ; if part-counter>0 then goto @init
     jns @init                       ;
                                     ; XOR-part presets
     shr bp, 1                       ;    - Set number of passes = 2
     shl al, 1                       ;    - Parametr for sqrt-tables =12
     mov dl, 31h                     ;    - Byte for modifying opcode (XOR)
     inc di                          ; di=0

@init:
     mov byte ptr [@drawline+11], dl ; modifying opcode in draw inner loop


;**********************************************************************
; PRECALS TABLE                 x=cos(sqrt(M)/D6)*D16+D16
;**********************************************************************
;     xor di, di
     mov ch, 255              ;
     fninit                   ;              0\   /0
@table:                       ;                
     mov word ptr [bx], ax    ; D6            ..
     fild word ptr [bx]       ;               
     mov word ptr [bx], di    ;                 
     fild word ptr [bx]       ; M             
     fsqrt                    ;              
     fdiv st, st(1)           ;                 
     fcos ;<-OPCODE modifiable;              
     fimul word ptr [bx+8]    ; *D16           
     fiadd word ptr [bx+8]    ; +D16         
     fistp word ptr gs:[di]   ;                 
     fstp st                  ;                   
     inc di                   ;                 
loop @table                   ;

;**********************************************************************
; SET PALETTE   r=cos(c/F)*P+P, g=cos(c/F+1)*P+P, b=cos(c/F+2)*P+P
;**********************************************************************
     xchg ax, cx              ; ax = 0
     mov dx, 3c8h             ;
     out dx, al               ;
     inc dx                   ;
@palette:                     ;
     fldz                     ;
     mov cl, 3                ;               0| |0
     @rgb:                    ;                
        mov byte ptr [bx], ah ;               
        fild word ptr [bx]    ;               
        fidiv word ptr [bx+6] ; /F            
        fadd st, st(1)        ; +0 (1,2)        
        fcos                  ; COS         
        fimul word ptr [bx+4] ; *P              
        fiadd word ptr [bx+4] ; +P           
        fistp word ptr [bx]   ;                
        mov al, byte ptr [bx] ;              
        fld1                  ;                 
        faddp st(1), st       ;                   
        out dx, al            ;                   
     loop @rgb                ;                 
     fstp st                  ;
     inc ah                   ;
jnz @palette                  ;

;**********************************************************************
; SOME INITS
;**********************************************************************

     mov dx, 3d4h             ; set double height line screen mode (320x100)
     mov ax, 309h
     out dx, ax

     push ax                  ; time for one part (sec=AX/70 fps)

;**********************************************************************
; MAIN LOOP
;**********************************************************************
@mainloop:                    ; input assume: CH=0

     mov ax, bp               ; set count of passes

     pop si                   ; animate var
     dec si
     jz @nextpart             ; part switcher
     push si

@pass:
                              ; Call motion trajectory ("8")
                              ; x:=cos(Q/R+pass)*R; y:=sin(Q/R+pass)*x;
     fild word ptr [esp]      ; fild Q         . .
     fidiv word ptr [bx+2]    ; /R             | |
                              ;                
     mov word ptr [bx], ax    ;               
     fiadd word ptr [bx]      ; +pass         
                              ;               
     fsincos                  ;                
     fimul word ptr [bx+2]    ; *R           
     fmul st(1), st           ; y               
                              ;                
     fiadd word ptr [bx+2]    ; x+R           
                              ;              
     fistp word ptr [bx]      ; get X           
     mov dx, word ptr [bx]    ;                   
     fistp word ptr [bx]      ; get Y             
     add word ptr [bx], 50    ;                 
                              ;
     xor di, di               ;
     mov cl, 100              ; for y:=0 to 99 do begin
  @draw:                      ;
     mov si, cx               ;
     sub si, word ptr [bx]    ; yy:=y-Ycenter
     imul si, si              ; yy:=yy*yy;
                              ;
     push bx                  ; save pointer to Y
                              ;
     push cx                  ;
     mov cl, 160              ; for x:=0 to 159 do
        @drawline:            ;
            mov bx, cx        ; xx:=x-Xcenter;
            sub bx, dx        ;
            imul bx, bx       ; m:=yy+xx*xx;
            mov bx, gs:[bx+si]; Read from sqrt-table
            add fs:[di], bx   ; Add to frame-buffer (this opcode modifiable)
            inc di            ;
            inc di            ;
        loop @drawline        ;
     pop cx                   ;
                              ;
     pop bx                   ; restore pointer Y
     loop @draw               ;
                              ;
     dec ax                   ;
jnz @pass                     ;


                              ; Wait for vertical retrace
     mov  dx, 3DAh
@w1:
;     in   al, dx
;     test al, 8
;     jnz  @w1
@w2:
     in   al, dx
     test al, 8
     jz   @w2


                              ; move buffer to screen
     xor si, si               ;
     xor ax, ax               ;
     xchg cx, di              ; DI=0, CX=32000
     shr cx, 1                ; CX=16000
@l:                           ;
     db 64h                   ; prefix for "movsw ES:[di], FS:[si]"
     movsw                    ;
     mov fs:[si-2], ax        ; clear old data
loop @l                       ;


     in al, 60h               ; wait for ESC
     dec ax                   ;
jnz @mainloop                 ; none received, start over


;**********************************************************************
; EXIT
;**********************************************************************
;     mov ax, 3                ; back to text
;     int 10h                  ; mode
     int 20h                  ; exit

end start


