; Name:             auwline.asm
; Assemble:         tasm.exe auwline.asm
; Link:             tlink.exe /t auwline.obj
; Run in DOSBox:    auwline.com

ESC_ASCII_CODE EQU 27

.MODEL tiny

.DATA
	MSG db "TRP$"

	SINVERT		DW 0
	COUNT		DB 0
.CODE
.386
ORG 0100h


start:
	; set video mode 320x200x8
	mov		ax, 0013h
	int 	10h			

mainloop:

    ; Segment to video memory
	; use es;di for the address 0a000h:0000
	mov 	ax, 0a000h
    mov 	es, ax
    xor 	di,di

    add byte ptr [COUNT], 2

	
;calc 1 sine function
;add 160
;for 0 to 200
;  draw white (0fh) line until sin (cx)
;  draw black (00h) line until 320

	xor bh,bh
	mov bl, 199 ;line counter; 0 to 199
yloop:
	mov cl, byte ptr [COUNT]
	
    add cl, bl
	add cl, bl
	call get_sine_integer
	add ax, 160				; additional shift sin value around horizontal center 160
	;mov word ptr [SINVERT], ax	;save sin value, ax will be destroyed
	 mov dx, ax
	mov al, 79            ; paars2
	;add al, cl
;	mov al, cl
;	and al, 15
;	add al, 16;
	
   ; mov dx, 0
xloop_left:
	mov cx,dx 
	;mov 	cx, word ptr [SINVERT]	;how many bytes
;	mov dx, bx
;	shr	dx, 2
;	add cx, dx
  ;  CLD                     		;Let's move in forward direction
    REP     stosb                   ;Compare this line to example for STOS

	mov al, 34            ; paars
;	xor al, al            ; paars
xloop_right:
	mov 	cx, 320					;how many bytes
	sub 	cx, dx ;word ptr [SINVERT]  ; a little less: 320-amount_of_white
	;sub     cx, dx
    REP     stosb
	
	dec bl
	jnz yloop


;text
	;MOV DH, 23
	;MOV DL, 36
	mov dx, 1724h
	;MOV BH,0
	MOV AH,2
	INT 10h
	mov ah,9
	lea dx,MSG
	int 21h



	xor al, al
	mov ah, 01h ; checks if a key is pressed
    int 16h
    jz mainloop ; zero = no pressed


exit:
	;set text mode
	mov		ax, 0003h
	int 	10h			

    mov al, 4Ch           ; http://www.ctyme.com/intr/rb-2974.htm
    int 21h


get_sine_integer:           ; Args: CX = angle (degree!), Return: AX = Y (signed!)
	push cx
	mov bp, sp              ; BP = SP (local stack space) for FPU-accesses
    fild word ptr [bp]      ; ST(0): CX
    fldpi                   ; ST(0)=Pi, ST(1)=CX
    fmulp                   ; ST(0)=Pi*CX
    mov word ptr [bp], 128
    fidiv word ptr [bp]     ; ST(0)=(Pi*CX)/180 (formula for degree to rad)
    fsin                    ; ST(0)=sine (rad)
    mov word ptr [bp], 78   ; Scale the result by 50 (e.g. 0.8 => 40.0)
    fimul word ptr [bp]     ; ST(0)=sine*scale
;    fchs                    ; reverse sign because video counts from top to bottom
    fistp word ptr [bp]     ; store integer with rounding to local stack space
    pop ax                  ; AX = local stack space
	ret                     ; Return: AX = Y (signed!)

END start