; Dogcattle!
; by Mike Erwin, aka Danger Cobra M
; Turbo Assembler, Intel 386, VGA mode 12h

P386N
IDEAL
MODEL tiny

CODESEG
   org 100h
Start:
   mov ax, 12h ; graphics mode, 640x480 16 colors
   int 10h
   mov ax, 0A000h
   mov es, ax ; now ES points to screen memory (top-left)
   
MainLoop:
   mov di, 640
   mov dx, 16 ; Dogcownt
DogcowLoop:
   mov bl, DogcowRows
   mov si, dx
   mov bh, [offset Dogrot + si]
   mov si, offset DogcowBitmap
   call FillRowsPattern

   add di, 640
   dec dx ; Dogcownt
   jnz short DogcowLoop
   
   mov ah, 1 ; read keypress
   int 16h
   jz short MainLoop

   mov ax, 3 ; text mode
   int 10h
   ret ; exit to DOS

PROC ByteSwap
   ; 486 has BSWAP...
   ror ax, 8
   ror eax, 16
   ror ax, 8
   ret
ENDP

PROC FillRowsPattern
 @@Loop:   
   lodsd ; read next row of bitmap into eax
   call ByteSwap
   mov cl, bh
   ror eax, cl
   call ByteSwap
   mov cx, 20 ; write pattern across whole screen (640/32 = 20)
   rep stosd
   dec bl
   jnz short @@Loop
   ret
ENDP

DATASEG

Dogrot db 0, 5, 20, 30, 7, 2, 12, 9, 17, 1, 5, 10, 23, 13, 0, 0

; bitmap patterns are 32 px wide, up to 255 px tall

DogcowRows equ 22
Label DogcowBitmap DWord
   dd 4h, 0c00ah, 400bh, 4010h, 80008024h, 0c0008040h, 40014080h, 40023078h 
   dd 40fc0f04h, 80e00f04h, 0e10704h, 0c18103h, 28003h, 20003h, 20002h
   dd 0c23f02h, 214002h, 118002h, 98002h, 98002h, 128004h, 1c0007h

END Start
