/* $Id: txt_table.c 1.12 Sun, 23 May 1999 17:26:04 +0200 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>

#include "partitiontable.h"
#include "globalvars.h"
#include "center_str.h"
#include "mk_partition_name.h"
#include "get_date_string.h"
#include "txt_table.h"


/* function pointer */
static void (*txt_table__print_table)(table_entry_t par_table[], char *partition_name[]);

void
txt_table__print_mbr_partition(table_entry_t par_table[], const char *blockfilename, const char *header_description)
{
	const char *hash_line_full;
	const char *hash_line_ends;
	unsigned int i;
	char date_str[32];
	char *line1, *line2, *tmp;
	char *m_descr = "";
	char *partition_name[4];
	for (i = 0; i < 4; i++)
		partition_name[i] = mk_partition_name(blockfilename, i+1);;
	if (header_description[0] != '\0')
		m_descr = center_str("#", (char *)header_description,"#\n", width);
	if (width == 72)
		txt_table__print_table = txt_table__print_table__72;
	else
		txt_table__print_table = txt_table__print_table__80;

	tmp = malloc(strlen("Partition table printout for  (CHS=//)")+3*10
			+ strlen(blockfilename) + 1);
	sprintf(tmp, "Partition table printout for %s (CHS=%u/%u/%u)",
		blockfilename,
		TOTAL_CYLINDERS, HEADS_PR_CYLINDER, SECTORS_PR_TRACK);
	line1 = center_str("#", tmp, "#", width);
	free(tmp);

	get_date_string(date_str, sizeof(date_str));
	tmp = malloc(strlen("generated  by printpar version " VERSION) +
				strlen(date_str) + 1);
	sprintf(tmp, "generated %s by printpar version " VERSION, date_str);
	line2 = center_str("#", tmp, "#", width);
	free(tmp);

	if (width == 72) {
		hash_line_full = "########################################################################";
		hash_line_ends = "#                                                                      #";
	} else {
		hash_line_full = "################################################################################";
		hash_line_ends = "#                                                                              #";
	}

	fprintf(outfile,
"\n%s\n"
"%s\n"
"%s\n"
"%s"
"%s\n"
"%s\n"
"%s\n"
"\n\tPartition table at Master Boot Record (CHS=0/0/1) offset 0x1BE\n",
		hash_line_full, hash_line_ends,
		line1, m_descr, line2,
		hash_line_ends, hash_line_full);
	txt_table__print_table(par_table, partition_name);
	if (header_description[0] != '\0')
		free(m_descr);
}

void
txt_table__print_drive_table(table_entry_t par_table[], const char *blockfilename,
				loff_t sector, unsigned int par_no)
{
	char *partition_name[4] = {NULL, "", "", ""};
	partition_name[0] = mk_partition_name(blockfilename, par_no);
	fprintf(outfile, "\tDrive table at sector "
		"CHS=%Lu/%Lu/%Lu offset 0x1BE\n",
		sectors2C(sector), sectors2H(sector),
		sectors2S(sector));
	txt_table__print_table(par_table, partition_name);
	free(partition_name[0]);
}

void
txt_table__print_table__72(table_entry_t par_table[], char *partition_name[])
{
	int i;
	fprintf(outfile, 
"+------+-----+--------------+-----+--------------+----------+----------+\n"
"|      |     |     Start    |     |      End     | Relative |Number of |\n"
"| Part |boot |Head Cyl Sect.|syst |Head Cyl Sect.|Start Sect| Sectors  |\n"
"+------+-----+--------------+-----+--------------+----------+----------+\n");
	for (i = 0; i < 4; i++)
		txt_table__print_table_entry__72(&par_table[i], partition_name[i]);
	fprintf(outfile,
"+------+-----+--------------+-----+--------------+----------+----------+\n\n");
}

void
txt_table__print_table__80(table_entry_t par_table[], char *partition_name[])
{
	int i;
	fprintf(outfile, 
"+--------+--------+---------------+------+---------------+----------+----------+\n"
"| parti- |        |     Start     |      |      End      | Relative |Number of |\n"
"| tion   |bootable|Head Cyl Sector|System|Head Cyl Sector|Start Sect| Sectors  |\n"
"+--------+--------+---------------+------+---------------+----------+----------+\n");
	for (i = 0; i < 4; i++)
		txt_table__print_table_entry__80(&par_table[i], partition_name[i]);
	fprintf(outfile,
"+--------+--------+---------------+------+---------------+----------+----------+\n\n");
}

void
txt_table__print_table_entry__72(table_entry_t *te, char *partition_name)
{
	#define PRINT_WIDTH 8
	char *tmp = malloc(strlen(partition_name) + PRINT_WIDTH + 1);
	tmp = center_str("|", partition_name, "|",  PRINT_WIDTH );
	#undef PRINT_WIDTH
	fprintf(outfile, tmp);
	free(tmp);
	if (te->bootable == 0 && te->system == 0)
		fprintf(outfile, "    0|");
	else
		fprintf(outfile, " 0x%02X|", te->bootable);
	fprintf(outfile, " %3u %4u  %2u |",
		te->start_head,
		te->start_cylinder,
		te->start_sector);
	if (te->system == 0)
		fprintf(outfile, "    0|");
	else
		fprintf(outfile, " 0x%02X|", te->system);
	fprintf(outfile, " %3u %4u  %2u |",
		te->end_head,
		te->end_cylinder,
		te->end_sector);
	fprintf(outfile, " %8u |", te->relative_start_sector);
	fprintf(outfile, " %8u |", te->number_of_sectors);
	fprintf(outfile, "\n");
}

void
txt_table__print_table_entry__80(table_entry_t *te, char *partition_name)
{
	#define PRINT_WIDTH 10
	char *tmp = malloc(strlen(partition_name) + PRINT_WIDTH + 1);
	tmp = center_str("|", partition_name, "|",  PRINT_WIDTH );
	#undef PRINT_WIDTH
	fprintf(outfile, tmp);
	free(tmp);
	if (te->bootable == 0 && te->system == 0)
		fprintf(outfile, "     0  |");
	else
		fprintf(outfile, "  0x%02X  |", te->bootable);
	fprintf(outfile, " %3u  %4u  %2u |",
		te->start_head,
		te->start_cylinder,
		te->start_sector);
	if (te->system == 0)
		fprintf(outfile, "    0 |");
	else
		fprintf(outfile, " 0x%02X |", te->system);
	fprintf(outfile, " %3u  %4u  %2u |",
		te->end_head,
		te->end_cylinder,
		te->end_sector);
	fprintf(outfile, " %8u |", te->relative_start_sector);
	fprintf(outfile, " %8u |", te->number_of_sectors);
	fprintf(outfile, "\n");
}

