/* $Id: txt_chart.c 1.11 Mon, 11 Jan 1999 22:30:10 +0100 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <limits.h>
#include <linux/hdreg.h>
#include <string.h>
#include <math.h>

#include "byte.h"
#include "boolean.h"
#include "partitiontable.h"
#include "error.h"
#include "globalvars.h"
#include "mk_partition_name.h"
#include "is_extended_partition.h"
#include "compute_startend_cyl.h"

#include "txt_chart.h"
#include "tree.h"
#include "center_str.h"
#include "stretch_str.h"

void push_extended(table_entry_t *te, char *partition_name);
void push_partition(table_entry_t *te, char *partition_name);
void insert_freespace_nodes(void);

void
txt_chart__print_mbr_partition(table_entry_t par_table[], const char *blockfilename, const char *header_description)
{
	unsigned int i;
	char *partition_name[4];
	for (i=0; i<4; i++) {
		partition_name[i] = mk_partition_name(blockfilename, i+1);
	}
#define CHART_HEADER_LINES 4
	fprintf(outfile, "\n                        Disk %s (CHS=%u/%u/%u)\n"
		"                        %s\n\n",
		blockfilename,
		TOTAL_CYLINDERS, HEADS_PR_CYLINDER, SECTORS_PR_TRACK,
		header_description);
	total_ext_lines = 0;
	printed_ext_lines = 0;
	extended_is_present = false;
	for (i=0; i<4; i++) {
		if (is_extended_partition(par_table[i])) {
			extended_is_present = true;
			push_extended(&par_table[i], partition_name[i]);
		} else if (par_table[i].entry_type != unused) {
			push_partition(&par_table[i], partition_name[i]);
		}
	}
	for (i=0; i<4; i++)
		free(partition_name[i]);
}


/* fixme: this function needs a rewrite to handle non-standard drive tables */
void
txt_chart__print_drive_table(table_entry_t par_table[],
				const char *blockfilename,
				loff_t sector __attribute__((__unused__)),
				unsigned int par_no)
{
	char *partition_name = mk_partition_name(blockfilename, par_no);
	push_partition(&par_table[0], partition_name);
	free(partition_name);
	if (is_extended_partition(par_table[1]))
		saved_ext_par_relative_start_sect =
		par_table[1].relative_start_sector;
}


/* this function is called only once from txt_chart__print_mbr_partition */
void
push_extended(table_entry_t *te, char *partition_name)
{
	char *tmp = stretch_str(partition_name);
	compute_startend_cyl(te,&extended_data.startcyl, &extended_data.endcyl);
	extended_data.par_name = center_str("", tmp, "", 7);
	free(tmp);
}

void
push_partition(table_entry_t *te, char *partition_name)
{
	unsigned int absolute_start_cyl, absolute_end_cyl;
	compute_startend_cyl(te, &absolute_start_cyl, &absolute_end_cyl);
	add_node(&partition_tree, absolute_start_cyl, absolute_end_cyl,
		te->number_of_sectors, partition_name);
}


void
insert_freespace_nodes(void)
{
	twalk(partition_tree, examine_freespace);
	if (last_par_end < TOTAL_CYLINDERS-1) {
		unsigned int start = last_par_end + 1;
		unsigned int end   = TOTAL_CYLINDERS - 1;
		unsigned int nos   = (end - start + 1)
			* HEADS_PR_CYLINDER * SECTORS_PR_TRACK;
		if (partition_starts_on_head_1(start))
			nos -= SECTORS_PR_TRACK;
		add_node(&freespace_tree, start, end, nos, "freespace");
	}
	twalk(freespace_tree, merge_ptree_and_delete_ftree);
}


void
txt_chart__post_print(void)
{
	int saved_lines_pr_page;
	insert_freespace_nodes();
	saved_lines_pr_page = lines_pr_page;
	if (scale.use_whole_page) {
		lines_pr_page -= CHART_HEADER_LINES;
		lines_pr_page -= txt_chart__number_of_separators;
		if (lines_pr_page < 1)
			lines_pr_page = 1;
	} else {
		double d = (scale.one_hundred_mb_length / 100) *
			cylinders2MB(TOTAL_CYLINDERS);
		if (rint(d) > lines_pr_page_max) {
			error("too many lines (%.f>%d)\n", d,lines_pr_page_max);
			exit(1);
		}
		lines_pr_page = rint(d);
	}
	if (extended_is_present) {
		CEN_total_ext_lines = 0;
		twalk(partition_tree, calculate_ext_numlines);
		total_ext_lines = CEN_total_ext_lines - 1/* exclude last sep */;
	}

	twalk(partition_tree, print_and_delete_tree);
	if (extended_is_present)
		free(extended_data.par_name);
	lines_pr_page = saved_lines_pr_page;
}

