/* $Id: ps_table.h 1.6 Tue, 05 Jan 1999 21:32:12 +0100 hlovdal $ */

#ifndef __PS_TABLE_H
#define __PS_TABLE_H

#include <stdio.h>
#include <sys/types.h>
#include "partitiontable.h"
#include "globalvars.h"

/* page break for postscript table before hda9, hda15, hda21, hda27, ...  */
#define time_for_pagebreak(par_no)		\
(						\
	(((par_no)-3) % 6) == 0			\
)

void ps_table__print_prolog(ps_encoding_t ps_encoding);
void ps_table__print_trailer(void);
void ps_table__print_mbr_partition(table_entry_t par_table[], const char *blockfilename, const char *header_description);
void ps_table__print_drive_table(table_entry_t par_table[], const char *blockfilename, loff_t sector, unsigned int par_no);
void ps_table__print_table(table_entry_t par_table[], char *partition_name[]);
void ps_table__print_table_entry(table_entry_t *te, char *partition_name);

#endif /* __PS_TABLE_H */

