/* $Id: partitiontable.h 1.3 Mon, 11 Jan 1999 22:30:10 +0100 hlovdal $ */

#ifndef __PARTITIONTABLE_H
#define __PARTITIONTABLE_H

#include "byte.h"
#include "geometry.h"

typedef enum {
	unused,
	primary,		/* partition entries defined in MBR	*/
	extended,		/* '0x05' entry defined in MBR		*/
	logical,		/* partition entries in drive table	*/
	drive_table_link,	/* '0x05' entry defined in drive table	*/
} entry_type_t;

typedef struct {
	byte bootable;
	byte start_head;
	word start_cylinder;
	byte start_sector;
	byte system;
	byte end_head;
	word end_cylinder;
	byte end_sector;
	dword relative_start_sector;
	dword number_of_sectors;
/* the following field sort of doesn't belong here, but it is very convenient */
	entry_type_t entry_type;
} table_entry_t;

/* cylinder/sector in "int 13 format":
      msb     lsb
   FEDCBA98 76543210
   -------- --------
   cccccccc CcSsssss */

#define get_cylinder(lsb, msb)		( (((lsb) & 0xC0) << 2) | (msb) )
#define get_sector(lsb)			( (lsb) & 0x3F )
#define get_dword(b0, b1, b2, b3)				\
(								\
	((b3) << 3*8) | ((b2) << 2*8) | ((b1) << 8) | (b0)	\
)


#define chs2sectors(C, H, S)					\
(								\
	((S) - 1) +						\
	((H) * SECTORS_PR_TRACK) +				\
	((C) * HEADS_PR_CYLINDER * SECTORS_PR_TRACK)		\
)

#define sectors2C(abs_sect)					\
(								\
	((abs_sect) / SECTORS_PR_TRACK) / HEADS_PR_CYLINDER	\
)

#define sectors2H(abs_sect)					\
(								\
	((abs_sect) / SECTORS_PR_TRACK) % HEADS_PR_CYLINDER	\
)

#define sectors2S(abs_sect)					\
(								\
	((abs_sect) % SECTORS_PR_TRACK) + 1			\
)


#define sectors2MB(s)						\
(								\
	(s) / (double) (1024*1024/BYTES_PR_SECTOR)		\
	/*	(s * BYTES_PR_SECTOR) / (1024*1024)	*/	\
)

#define cylinders2MB(c)						\
(								\
	sectors2MB((c) * HEADS_PR_CYLINDER * SECTORS_PR_TRACK)	\
)

#endif /* __PARTITIONTABLE_H */
