/* $Id: mk_partition_name.c 1.2 Tue, 01 Dec 1998 21:53:57 +0100 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "mk_partition_name.h"

/* returns a malloc'ed partition name */
char *
mk_partition_name(const char *blockfilename, unsigned int par_no)
{
	char *ret, numstr[10 + 1]; /* uint max 10 digits */
	const char *tmp;
	if (blockfilename == NULL || *blockfilename == '\0')
		return NULL;
	tmp = strrchr(blockfilename, '/');
	if (tmp == NULL)
		tmp = blockfilename;	/* "/dev/" not prefixed */
	else
		tmp++;
	sprintf(numstr, "%u", par_no);
	ret = malloc(strlen(tmp) + strlen(numstr) + 1);
	strcpy(ret, tmp);
	strcat(ret, numstr);
	return ret;
}
