/* $Id: geometry.h 1.2 Tue, 01 Dec 1998 21:53:57 +0100 hlovdal $ */

#ifdef NOEXTERN
  #ifdef __GEOMETRY_H_WITHEXTERN
    #error "Error: this file is already included, but without without \
	NOEXTERN defined"
  #endif
#endif


#ifndef __GEOMETRY_H
#define __GEOMETRY_H

#ifdef NOEXTERN
  #undef EXTERN
  #define EXTERN
#else
  #define __GEOMETRY_H_WITHEXTERN
  #undef EXTERN
  #define EXTERN extern
#endif

#include <linux/hdreg.h>
#include "boolean.h"

EXTERN struct hd_geometry       disk_geometry;


#define BYTES_PR_SECTOR         512
#define SECTORS_PR_TRACK        disk_geometry.sectors
#define HEADS_PR_CYLINDER       disk_geometry.heads
#define TOTAL_CYLINDERS         disk_geometry.cylinders


boolean_t get_disk_geometry(int fd);


#endif /* __GEOMETRY_H */
