/* $Id: geometry.c 1.4 Sun, 23 May 1999 22:15:21 +0200 hlovdal $ */

#include <stdio.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>

#include "boolean.h"
#include "error.h"
#include "geometry.h"
#include "globalvars.h"

boolean_t
get_disk_geometry(int fd)
{
#ifdef HDIO_REQ
	#define HDIO_IOCTL	 HDIO_REQ
	#define HDIO_IOCTL_STR	"HDIO_REQ"
#else
	#define HDIO_IOCTL	 HDIO_GETGEO
	#define HDIO_IOCTL_STR	"HDIO_GETGEO"
#endif
	if (ioctl(fd, HDIO_IOCTL, &disk_geometry) != 0) {
		error("ioctl " HDIO_IOCTL_STR " failed: %s\n", strerror(errno));
		return false;
	}
	if (disk_geometry.cylinders == 1024)
		error("minor warning: the kernel reports that the disk has\n"
			"1024 cylinders but that is most likely wrong.");
	return true;
#undef HDIO_IOCTL
#undef HDIO_IOCTL_STR
}
