#
#
# dirc pre-alpha      ~R15                by Disq/No Carrier (disq@iname.com)
#

source dstruc.tcl
source windows.tcl
source colors.tcl
source config.tcl

set version "dirc pre-alpha ~R15 by disq"
set servers [join $servers]
set sck 0
set chans ""
set l_all ""
set listmode 0
set querys ""
set myip ""
set gotip("","") ""
set wins("","") ""
set dbusers("") ""
set hist(s,"","") ""
set hist(i,"") ""
set hist(t,"") ""
set away 0
set oper 0
set netname ""
set notify(names) [string tolower $notify(names)]
set notify(notyet) $notify(names)
set notify(online) ""
set notify(interval) [expr "$notify(interval)*1000"]
set travtime [expr "$travtime*1000"]
set usedsk "0"

global server serverport servers mynick ident realname sck version myip
global chans querys autojoin nickcomplete rightkickreason defaultawayreason
global listmode l_all nukes gotip aexec wins away quitmsg netname
global defaultbackreason rightklinereason rightzlinereason hist notify
global travmsg travtime dbusers usedsk

proc init {args} {
global servers mynick ident realname
window.main
wm protocol . WM_DELETE_WINDOW {disconnect; killwin .}
foreach a $servers { .b.servers insert end $a }
.a.u_nick insert 0 $mynick
.a.u_ident insert 0 $ident
.a.u_realname insert 0 $realname
.b.servers selection set 0
}

proc readsock {args} {
global sck server chans mynick listmode l_all pagebell aexec wins away travtime
global querys version ident myip autojoin gotip netname oper hist notify dbusers

gets $sck data
##puts $data ;# lalala
set dtag ""

#set from [lindex $data 0]
#set cmd [lindex $data 1]
#set to [lindex $data 2]
#set bla [lrange $data 0 2]
set from ""; set cmd ""; set to ""; set rest ""
scan $data "%s %s %s" from cmd to
set rest [rtrimleft $data "$from $cmd $to "]

set from [string trimleft $from ":"]
if { $from=="$server" } { set from "" }

set longfrom $from
set bla [expr "[string first "!" $from] - 1"]
if {$bla>-1} { set from [string range $from 0 $bla]
               set fromhost [string range $longfrom [expr "$bla + 2"] end]
               set bla [expr "[string first "@" $fromhost] + 1"]
               if {$bla>-1} { set fromip [string range $fromhost $bla end] }
	       }

set data "\n$from $cmd $to $rest"
if {$from=="PING"} {
  set dtag ctcp
  puts $sck "PONG $cmd $rest"
  flush $sck
  }
if {$cmd=="JOIN"} {
 set chan [string tolower [string trimleft $to ":"]]
 if {$from==$mynick} {
   set bla ".serverwin.chan_"
   for { set i 0 } { $i<[string length $chan] } {incr i} {
    set a [string index $chan $i]
    if {$a=="#"} {set a "0"}
    if {$a=="&"} {set a "1"}
    if {$a=="."} {set a "2"}
    set bla "$bla$a"
    }
   set cc [crypt $chan]
   set wins(w,$cc) $bla
   set wins(t,$cc) ""
   set wins(m,$cc) ""
   set wins(b,$cc) ""

   set wins(mb,$cc,n) 0; set wins(mb,$cc,t) 0; set wins(mb,$cc,i) 0
   set wins(mb,$cc,s) 0; set wins(mb,$cc,p) 0; set wins(mb,$cc,m) 0
   set wins(mb,$cc,k) ""; set wins(mb,$cc,l) ""

   window.chanwin $bla
   set hist(s,$cc,0) "";set hist(i,$cc) 0;set hist(t,$cc) 0
   wnumbind $chan $bla
   
   lappend chans $chan
   
   colors $bla.ft.text
   bind $bla.entry <Return> "tochan $chan $bla"
   bind $bla.entry <Up> "hist.up $bla.entry $chan"
   bind $bla.entry <Down> "hist.down $bla.entry $chan"
   focus $bla
   wm protocol $bla WM_DELETE_WINDOW "toserver /l $chan
                                      killwin $bla"
   wm iconname $bla "[string tolower $chan]"
   bind $bla <FocusIn> "updatetitle $bla 0"
   bind $bla.ft.text <ButtonRelease-2> "window.modes $wins(w,$cc).modes $chan"
   bind $bla.ft.text <ButtonRelease-3> "window.modes $wins(w,$cc).modes $chan"
   toserver "/c $chan"
   toserver "/who $chan"
   } else {
    set bla $wins(w,[crypt $chan])
    set ni [$bla.fn.nicks get 0 end]
    lappend ni $from   
    set ni [lsort $ni]
    $bla.fn.nicks delete 0 end
    foreach a $ni { $bla.fn.nicks insert end $a }
    }
   set bla $wins(w,[crypt $chan])
   instext $bla.ft.text join "\n*** $from\($fromhost\) has joined $chan"
   updatetitle $bla 1
   set cf [crypt $from]
   set dbusers($cf) $fromhost
   
   if {$from!=$mynick} {
    set a "$from!$fromhost"
    set b [.serverwin.quickwin.a.l get 0 end]
    if {[dsearch 0 $a $b]==-1} {.serverwin.quickwin.a.l insert end $a}
    if {$travtime>0} {after $travtime "travban $from $chan $fromhost"}
    }
   set data ""
 }			   

if {$cmd=="PART"} {
 set chan [string tolower [string trimleft $to ":"]]

 set cc [crypt $chan]
 set nc [lsearch $chans $chan]
 set bla $wins(w,$cc)
  
  if {$from==$mynick} {
   killwin $bla
   set chans [lreplace $chans $nc $nc]
   wnumunbind $chan $bla
   set wins(w,$cc) ""
   set wins(m,$cc) ""
   set wins(t,$cc) ""
   set wins(b,$cc) ""
   } else {
     instext $bla.ft.text part "\n*** $from\($fromhost\) has left $chan"
     updatetitle $bla 1
# ##
     set n [lsearch $chans $chan]
     set w $bla
     set ni [$w.fn.nicks get 0 end]
     set n [lsearch $ni $from]
     if {$n<0} { set n [lsearch $ni "+$from"] }
     if {$n<0} { set n [lsearch $ni "@$from"] }
     if {$n<0} { set n [lsearch $ni "+@$from"] }
     if {$n<0} { set n [lsearch $ni "@+$from"] }
     set ni [lreplace $ni $n $n]
     set ni [lsort $ni]
     $bla.fn.nicks delete 0 end
     foreach a $ni { $bla.fn.nicks insert end $a }
     
     if {$travtime>0} {
        set r [canceltravban "travban $from $chan*"]
        if {$r==1} {travban $from $chan $fromhost}
        }
     }
   set data ""
 }
if {$cmd=="353"} {  ## NAMES
# set c [string tolower [lindex $rest 1]]
# set ni [lrange $rest 2 end]
 scan $rest "%s %s" bla c
 set ni [rtrimleft $rest "$bla $c "]
 set c [string tolower $c]
 if { [string index $ni 0]==":" } { set ni [string range $ni 1 end] }
 set i [lsearch $chans $c]
 if {$i>"-1"} {
   set bla $wins(w,[crypt $c])
   set ni [lsort $ni]
##   $bla.fn.nicks delete 0 end
   foreach a $ni { $bla.fn.nicks insert end $a }
   }
 set data "\n$rest"
 }
if {$cmd=="366"} {  ## end of names list
 scan $rest "%s %s" bla c
 set c [string tolower $c]
 set i [lsearch $chans $c]
 if {$i>"-1"} {
   set bla $wins(w,[crypt $c])
   set ni [lsort [$bla.fn.nicks get 0 end]]
   $bla.fn.nicks delete 0 end
   foreach a $ni { $bla.fn.nicks insert end $a }
   }
 set data "\n$rest"
 }
if {$cmd=="367"} {  ## banlist
 set c [string tolower [lindex $rest 0]]
 set w "$wins(w,[crypt $c]).banlist"
 window.banlist $w
 wm title $w "$c banlist"
 wm iconname $w "Bans for [string tolower $c]"
 bind $w <FocusIn> "updatetitle $w 0"

 set bandata [lrange $rest 1 end]
 if { [string index $bandata 0]==":" } { set bandata [string range $bandata 1 end] }
 scan $bandata "%s %s %s" masq niq time
 set time [clock format $time]
 while {[string length $masq]<35} {set masq "$masq "}
 while {[string length $niq]<15} {set niq "$niq "}
 $w.a.bans insert end "$masq $niq $time"
 $w.a.bans see end
 updatetitle $w 1
 set data ""
 }
if {$cmd=="368"} { # banlist end
 set c [string tolower [lindex $rest 0]]
 set w $wins(w,[crypt $c])
 if {[winfo exists "$w.banlist"]==0} {instext $w.ft.text notice "\n*** No bans for $c"; updatetitle $w 1}
 set data ""
 }
if {$cmd=="482"} { # needop
 set c [string tolower [lindex $rest 0]]
 set w $wins(w,[crypt $c])
 instext $w.ft.text notice "\n*** You are not an op on $c."
 updatetitle $w 1
 set data ""
 }
if {$cmd=="221"} { # umode
 set data "\n*** Mode $to: [string trimleft $rest ":"]"
 set dtag mode
 }
if {$cmd=="324"} { # chanmode
 scan $rest "%s" c
 set cl [string tolower $c]
 set cc [crypt $cl]
 set w $wins(w,$cc)
 set m [rtrimleft $rest "$c "]
 set m [string trimright $m " "]
 GetChanModes $cc $m
 updatemodewin $c
 InvertChanModes $cc
 set data ""
 }
if {$cmd=="329"} { # chanmode set-by and time
 set data ""
 }
if {$cmd=="371"} { # info reply
 set data "\nINFO: [string range $rest 1 end]"
 set dtag notice
 }
if {$cmd=="374"} { set data ""} ;# end of info
if {$cmd=="306"} { set away 1; set dtag whoisaway; set data "\n[string range $rest 1 end]" }
if {$cmd=="305"} { set away 0; set dtag whoisaway; set data "\n[string range $rest 1 end]" }
if {$cmd=="001"} { set data "\n[string range $rest 1 end]"
                   toserver "/wi" ;# get userip
		   notifyus
		   window.quickwin
		   wm iconify .serverwin.quickwin
		   set id [array startsearch aexec]
		   while {[array anymore aexec $id]} {
		     set a $aexec([array nextelement aexec $id])
		     if {$a!=""} {toserver "$a"}
		     }
		   array donesearch aexec $id
		   }
if {$cmd=="002"} { set data "\n[string range $rest 1 end]" }
if {$cmd=="003"} { set data "\n[string range $rest 1 end]" }
if {$cmd=="004"} { set data "\n$rest"; set netname [dindex 0 $rest] }
if {$cmd=="005"} { set data "\n$rest" }
if {$cmd=="251"} { set data "\n[string range $rest 1 end]" }
if {$cmd=="252"} { set data "\n$rest" }
if {$cmd=="253"} { set data "\n$rest" }
if {$cmd=="254"} { set data "\n$rest" }
if {$cmd=="255"} { set data "\n[string range $rest 1 end]" }
if {$cmd=="265"} { set data "\n[string range $rest 1 end]" }
if {$cmd=="266"} { set data "\n[string range $rest 1 end]" }
if {$cmd=="377"} { set data "\n$rest" }

if {$cmd=="311"} {
 scan $rest "%s %s %s" nick id ip
 set real [rtrimleft $rest "$nick $id $ip * :"]
 set w [WhoisGetFocus]
 instext $w whoistitle "\n\[WHOIS\] ----------------------- ----- --- -- -"
 instext $w whoisnick "\n      Nick: $nick!$id@$ip"
 instext $w whoisreal "\n  Realname: $real"
 set data ""
 if {[string tolower $nick]==[string tolower $mynick]} { set myip $ip }
 }
if {$cmd=="301"} { scan $rest "%s" nick
                   instext [WhoisGetFocus] whoisaway "\n      Away: [rtrimleft $rest "$nick :"]"
		   set data "" }
if {$cmd=="313"} { scan $rest "%s" nick
                   instext [WhoisGetFocus] whoisircop "\n     IRCop: $nick [rtrimleft $rest "$nick :"]"
		   set data "" }
if {$cmd=="319"} { scan $rest "%s" nick
                   instext [WhoisGetFocus] whoischans "\n  Channels: [rtrimleft $rest "$nick :"]"
		   set data "" }
if {$cmd=="312"} { set nick [dindex 0 $rest]
                   instext [WhoisGetFocus] whoisserver "\n    Server: [drange 1 end $rest]"
                   set data "" }
if {$cmd=="317"} { set a [dindex 2 $rest]; set b ", no signon info."
                   if {$a!=":seconds"} {set b ", signon at [clock format $a]"}
                   instext [WhoisGetFocus] whoisidle "\n [dindex 1 $rest] seconds idle$b"
##                   instext [WhoisGetFocus] whoisidle "\n [dindex 1 $rest] seconds idle, signon at [clock format [dindex 2 $rest]]"
                   set data "" }
if {$cmd=="318"} { set data "" } ;# end of whois
if {$cmd=="369"} { set data "" } ;# end of whowas
if {$cmd=="219"} { set data "" } ;# end of stats

if {$cmd=="341"} { set data "\n\[INVITE\] You invite [dindex 0 $rest] to [dindex 1 $rest]"; set dtag notify } ;# invite
if {$cmd=="315"} { set data "\n$rest" } ;# end of /who list
if {$cmd=="401"} { set data "\n$rest" } ;# no such nick/channel
if {$cmd=="491"} { set data "\n$rest" } ;# no O lines for your host
if {$cmd=="481"} { set data "\n$rest" } ;# permission denied - not an ircop
if {$cmd=="474"} { set data "\n$rest" } ;# cannot join channel (+b)
if {$cmd=="473"} { set data "\n$rest" } ;# cannot join channel (+i)
if {$cmd=="471"} { set data "\n$rest" } ;# cannot join channel (+l)
if {$cmd=="475"} { set data "\n$rest" } ;# cannot join channel (+k)
if {$cmd=="446"} { set data "\n$rest" } ;# users disabled
if {$cmd=="421"} { set data "\n$rest" } ;# unknown command
if {$cmd=="381"} { set data "\n$rest"; set oper 1 } ;# ur now an ircop
if {$cmd=="461"} { set data "\n$rest" } ;# kline not enough parameters
if {$cmd=="361"} { set data "\n$rest" } ;# +l not enough parameters
if {$cmd=="372"} { set data "\n$rest" } ;# unknown mode char
if {$cmd=="501"} { set data "\n$rest" } ;# unknown mode flag
if {$cmd=="412"} { set data "\n$rest" } ;# no text to send
if {$cmd=="406"} { set data "\n$rest" } ;# there was no such nickname
if {$cmd=="433"} { set data "\n$rest" } ;# nick in use
if {$cmd=="314"} {
 scan $rest "%s %s %s" nick id ip
 set real [rtrimleft $rest "$nick $id $ip * :"]
 set w [WhoisGetFocus]
 instext $w whoistitle "\n\[WHOWAS\] ---------------------- ----- --- -- -"
 instext $w whoisnick "\n      Nick: $nick!$id@$ip"
 instext $w whoisreal "\n  Realname: $real"
 set data ""
 }
 
if {$cmd=="352"} {
 scan $rest "%s %s %s %s %s" ch id ip serv nick
 set cn [crypt $nick]
 set dbusers($cn) "$id@$ip"
 set data "\n\[WHO\] $ch $nick!$id@$ip :$serv"
 }

if {$cmd=="302"} { # Userhost reply     nick[*]=[+|-]ident@hostname
 set bla [split [string range $rest 1 end] "="]
 set nick [string trimright [lindex $bla 0] "*"]
 set idip [split [string range [lindex $bla 1] 1 end] "@"]
 set id [lindex $idip 0]
 set ip [lindex $idip 1]

 set cn [string tolower [crypt $nick]]
if {[catch "set h $gotip($cn,0)"]==0} {
  set st $gotip($cn,0)
  if {$st==1} { RealBan $nick $id $ip }
  if {$st==2} { RealNuke $nick $id $ip }
  if {$st==3} { RealBan $nick $id $ip
                RealNuke $nick $id $ip }
  if {$st==4} { set a "$nick!$id@$ip"
                set b [.serverwin.quickwin.a.l get 0 end]
                if {[dsearch 0 $a $b]==-1} {.serverwin.quickwin.a.l insert end $a}
                }
  }
 set data "\n\[USERHOST\] $nick is $id@$ip"
 }

if {$cmd=="303"} {
  set data ""
  set n [string range $rest 1 end]
  if {$n==""} {return}
  instext [WhoisGetFocus] notify "\nCurrently online: $n"
  set n [string tolower $n]
  foreach a $n {
   set i [lsearch $notify(notyet) $a]
   if {$i>-1} {
     set notify(notyet) [lreplace $notify(notyet) $i $i]
     lappend notify(online) $a
     }
   }
 }
if {$cmd=="375"} {set data "\n[string range $rest 1 end]"}
if {$cmd=="372"} {set data "\n[string range $rest 1 end]"}
if {$cmd=="376"} {set data "\n[string range $rest 1 end]"}
if {$cmd=="332"} {  ## Topic
 scan $rest "%s" chan
 set rest [rtrimleft $rest "$chan "]
 set chan [string tolower $chan]
 
 if { [string index $rest 0]==":" } { set rest [string range $rest 1 end] }
 set n [lsearch $chans $chan]
 set bla $wins(w,[crypt $chan])
 instext $bla.ft.text topic1 "\n*** Topic for $chan: $rest"
 set wins(t,[crypt $chan]) $rest
 updatetitle $bla 1
 set data ""
 }
if {$cmd=="333"} {  ## Topic set by
 scan $rest "%s" chan
 set chan [string tolower $chan]
 set rest [rtrimleft $rest "$chan "]
 
 if { [string index $rest 0]==":" } { set rest [string range $rest 1 end] }
 set n [lsearch $chans $chan]
 set bla $wins(w,[crypt $chan])
 instext $bla.ft.text topic2 "\n*** Topic set by [lindex $rest 0] on [clock format [lindex $rest 1]]"
 updatetitle $bla 1
 set data ""
 }
if {$cmd=="TOPIC"} {
 set chan [string tolower $to]
 set cc [crypt $chan]
 if { [string index $rest 0]==":" } { set rest [string range $rest 1 end] }
 set n [lsearch $chans $chan]
 set bla $wins(w,$cc)
 instext $bla.ft.text settopic "\n*** $from sets topic: $rest"
 set wins(t,$cc) $rest
 set a $wins(m,$cc)
 if {$a!=""} {set a "($a)"}
 wm title $bla "\[$wins(s,$cc)\] $chan $a $rest"
 updatetitle $bla 1
 set data ""
 }
if {$cmd=="KICK"} {
 set chan [string tolower $to]
 scan $rest "%s" victim
 set rest [rtrimleft $rest "$victim "]
 
 set iam 0
 if {[string tolower $victim]==[string tolower $mynick]} { set iam 1 }

 if { [string index $rest 0]==":" } { set rest [string range $rest 1 end] }
 if {$travtime>0} {canceltravban "travban $victim $chan*"}
 set n [lsearch $chans $chan]
 set bla $wins(w,[crypt $chan])
 if {$iam==1} { instext $bla.ft.text kick "\n*** You were kicked off $chan by $from ($rest)" }
 if {$iam==0} { instext $bla.ft.text kick "\n*** $victim was kicked off $chan by $from ($rest)" }
 updatetitle $bla 1
 set ni [$bla.fn.nicks get 0 end]
 set n [lsearch $ni $victim]
 if {$n<0} { set n [lsearch $ni "+$victim"] }
 if {$n<0} { set n [lsearch $ni "@$victim"] }
 if {$n<0} { set n [lsearch $ni "+@$victim"] }
 if {$n<0} { set n [lsearch $ni "@+$victim"] }
 set ni [lsort [lreplace $ni $n $n]]
 $bla.fn.nicks delete 0 end
 foreach a $ni { $bla.fn.nicks insert end $a }
 
 set data ""
 if {$iam==1} { set nc [lsearch $chans $chan]
                set chans [lreplace $chans $nc $nc]
		set cc [crypt $chan]
		set wins(w,cc) ""
		set wins(m,cc) ""
		set wins(t,cc) ""
                $bla.fn.nicks delete 0 end
                if {$autojoin==1} { toserver "/j $chan" }
	        if {$autojoin==0} { killwin $bla
                               	    set data "\n\[KICK\] You were kicked off $chan by $from ($rest)" }
                set gotip([crypt [string tolower $from]],0) 4
                toserver /userhost $from"
     	        set dtag kick
		}
 }
 
if {$cmd=="MODE"} {
 set chan [string tolower [string trimleft $to ":"]]
 if {$chan==[string tolower $mynick]} {
   instext .serverwin.in.text mode "\n*** Mode $mynick: [string trimleft $rest ":"]"
   updatetitle .serverwin 1
   return
   }
 set cc [crypt $chan]
 set n [lsearch $chans $chan]
 if {$n>-1} { set data "" }
 set bla $wins(w,$cc)
 instext $bla.ft.text mode "\n*** $from sets mode: $rest on $chan"
 GetChanModes $cc $rest
 InvertChanModes $cc
 updatemodewin $chan
 updatetitle $bla 1
   
 set nicks [$bla.fn.nicks get 0 end]
 scan $rest "%s " mods
 set users [rtrimleft $rest "$mods "]
 set new ""
 set lol "" 
 for { set i 0 } { $i<[string length $mods] } {incr i} {
  set a [string index $mods $i]
  if {$a=="+"} {set lol $a}
  if {$a=="-"} {set lol $a}
  if {$a=="o"} {
   scan $users "%s" who
   set users [rtrimleft $users "$who "]

   set n [lsearch $nicks $who]
   if {$n<0} { set n [lsearch $nicks "@$who"] }
   if {$n<0} { set n [lsearch $nicks "+$who"] }
   if {$n<0} { set n [lsearch $nicks "+@$who"] }
   if {$n<0} { set n [lsearch $nicks "@+$who"] }
   set cur [lindex $nicks $n]
   set new ""
   if {$lol=="+"} {
    if {[string index $cur 0]!="@"} {if {[string index $cur 1]!="@"} {set new "@$cur"}}
    } else {
    if {[string index $cur 0]=="@"} {set new [string range $cur 1 end]}
    if {[string index $cur 1]=="@"} {set new "[string index $cur 0][string range $cur 2 end]"}
    }
   }
  if {$a=="v"} {
   scan $users "%s" who
   set users [rtrimleft $users "$who "]

   set n [lsearch $nicks $who]
   if {$n<0} { set n [lsearch $nicks "@$who"] }
   if {$n<0} { set n [lsearch $nicks "+$who"] }
   if {$n<0} { set n [lsearch $nicks "+@$who"] }
   if {$n<0} { set n [lsearch $nicks "@+$who"] }
   set cur [lindex $nicks $n]      
   set new ""      
   if {$lol=="+"} {
    if {[string index $cur 0]!="+"} {if {[string index $cur 1]!="+"} {set new "+$cur"}}
    } else {
    if {[string index $cur 0]=="+"} {set new [string range $cur 1 end]}
    if {[string index $cur 1]=="+"} {set new "[string index $cur 0][string range $cur 2 end]"}
    }
   }
  if {$a=="k"} {scan $users "%s" who
                set users [rtrimleft $users "$who "]}
  if {$a=="l"} { if {$lol=="+"} {scan $users "%s" who
                                 set users [rtrimleft $users "$who "]}}
  if {$a=="b"} {
    if {$lol=="+"} {
       scan $users "%s" mask
       set users [rtrimleft $users "$mask "]

      set wins(b,[crypt $chan]) $mask
      if {[string match $mask "$mynick!$ident@$myip"]==1 && [string compare $from $mynick]!=0} { toserver "/c $chan -ob $from $mask" }
      }
    }
    
  if {$new!=""} {
    if {$n>-1} {set nicks [lreplace $nicks $n $n]}
    lappend nicks $new
    set nicks [lsort $nicks]
    $bla.fn.nicks delete 0 end
    foreach a $nicks { $bla.fn.nicks insert end $a }
    set new ""
    }
  }
## ^^foreach
### toserver "/c $chan"
 }

if {$cmd=="QUIT"} {
 if { [string index $to 0]==":" } { set to [string range $to 1 end] }
 set qmsg "$to $rest"
 set dbusers([crypt $from]) ""
# set qmsg $rest
 foreach xa $chans {
  set a $wins(w,[crypt $xa])
  set nicks [$a.fn.nicks get 0 end]
  set n [lsearch $nicks $from]
  if {$n<0} { set n [lsearch $nicks "@$from"] }
  if {$n<0} { set n [lsearch $nicks "+$from"] }
  if {$n<0} { set n [lsearch $nicks "+@$from"] }
  if {$n<0} { set n [lsearch $nicks "@+$from"] }
  if {$n>"-1"} {
    $a.fn.nicks delete $n
    instext $a.ft.text quit "\n*** $from\($fromhost\) has quit IRC ($qmsg)"
    updatetitle $a 1
    if {$travtime>0} {canceltravban "travban $from $xa*"}
    }
  }
 set a [.serverwin.quickwin.a.l get 0 end]
 set f [dsearch 0 "$from!$fromhost" $a]
 if {$f>-1} {.serverwin.quickwin.a.l delete $f}
 
 set data ""
 }

if {$cmd=="NICK"} {
 if { [string index $to 0]==":" } { set to [string range $to 1 end] }
 if {$from==$mynick} { set mynick $to }
 set ct [crypt $to]; set cf [crypt $from]
 set dbusers($ct) $dbusers($cf);
 
 foreach xa $chans { ## scan chanwins
  set a $wins(w,[crypt $xa])
  set nicks [$a.fn.nicks get 0 end]
  set n [lsearch $nicks $from]
  set st ""
  if {$n<0} { set n [lsearch $nicks "@$from"]
              set st "@" }
  if {$n<0} { set n [lsearch $nicks "+$from"]
              set st "+" }
  if {$n<0} { set n [lsearch $nicks "+@$from"]
              set st "+@" }
  if {$n<0} { set n [lsearch $nicks "@+$from"]
              set st "@+" }
  if {$n>"-1"} {
    set nicks [lreplace $nicks $n $n]
    lappend nicks "$st$to"
    set nicks [lsort $nicks]
    $a.fn.nicks delete 0 end
    foreach b $nicks { $a.fn.nicks insert end $b }
    instext $a.ft.text nick "\n*** $from\($fromhost\) is now known as $to"
    updatetitle $a 1
    }
  }
 set llf [crypt [string tolower $from]]; set llt [crypt [string tolower $to]]
 foreach b $querys { ## scan querywins
    if {$b==$llf} { set n [lsearch $querys $b]
                     set querys [lreplace $querys $n $n $llt]
		     set wins(q,$llt) $wins(q,$llf)
		     set wins(q,$llf) ""
		     set bla $wins(q,$llt)
                     bind $bla.entry <Return> "toquery $llt $bla"
      		     wm title $bla "$to - queried"
      		     wm iconname $bla "[string tolower $to]"
                     instext $bla.ft.text nick "\n*** $from is now known as $to"
		     }
    }
 set a "$from!$fromhost"
 set b [.serverwin.quickwin.a.l get 0 end]
 set c [dsearch 0 $a $b]
 if {$c>-1} { .serverwin.quickwin.a.l delete $c
              .serverwin.quickwin.a.l insert $c "$to!$fromhost" }
 set data ""
 }
  
if { [string index $rest 0]==":" } { set rest [string range $rest 1 end] }

if {$cmd=="PRIVMSG"} {
  set a [string index $rest 0]
  set b [string index $rest [expr "[string length $rest] - 1"]]
  if {$a=="\x01"} { if {$a==$b} { set cmd "CTCP"
                                  set rest [string range $rest 1 [expr "[string length $rest] - 2"]]
                                  }}  
 }
if {$cmd=="NOTICE"} {
  set a [string index $rest 0]
  set b [string index $rest [expr "[string length $rest] - 1"]]
  if {$a=="\x01"} { if {$a==$b} { set cmd "CTCPREP"
                                  set rest [string range $rest 1 [expr "[string length $rest] - 2"]]
                                  }}
 }
if {$cmd=="CTCP"} {
  if {[string tolower $to]==[string tolower $mynick]} {set to "you"}
  scan $rest "%s" typ
  set rest [rtrimleft $rest "$typ "]
  set data ""
  set a "\n\[CTCP\] $typ from $from to $to: $rest" 
  if { $typ=="PING" } { puts $sck "NOTICE $from :\x01PING $rest\x01"
                        flush $sck }
  if { $typ=="VERSION" } { puts $sck "NOTICE $from :\x01VERSION $version\x01"
                           flush $sck }
  if { $typ=="PAGE" } { if {$pagebell==1} {bell}
                        puts $sck "NOTICE $from :uh, you paged me."
                        flush $sck }
  if { $typ=="ACTION" } { set to [string tolower $to]
                          set n [lsearch $chans $to]
                          if {$n<0} {
                            Query $from
			    set bla $wins(q,[crypt [string tolower $from]])
                            instext $bla.ft.text action "\n * $from $rest"
			    } else { ## Channel action
			    set bla $wins(w,[crypt $to])
                            instext $bla.ft.text action [format "\n * %s %s" $from $rest]
                            }
			    updatetitle $bla 1; set a ""
                         }
  if {$a!=""} {instext [WhoisGetFocus] ctcp "$a"}
  }
if {$cmd=="CTCPREP"} {
  if {[string tolower $to]==[string tolower $mynick]} {set to "you"}
  scan $rest "%s" typ
  set rest [rtrimleft $rest "$typ "]
  set data ""
  set a "\n\[CTCP\] $typ reply from $from to $to: $rest" 
  if { $typ=="PING" } { set a "\n\[CTCP\] PING reply from $from: [expr "[clock seconds] - $rest"] seconds" }
  instext [WhoisGetFocus] ctcprep "$a"
 }

 if {$cmd=="PRIVMSG"} {
  set to [string tolower $to]
  set n [lsearch $chans $to]
  if {$n<0} {
##   set data "\n\[MSG\] ($from) $rest"
      Query $from
      set lf [string tolower $from]
      set nn [lsearch $querys [crypt $lf]]
      set bla $wins(q,[crypt $lf])
      instext $bla.ft.text "" "\n<$from> $rest"
      updatetitle $bla 1
      set data ""
  } else { ## Channel text
    set bla $wins(w,[crypt $to])
##    instext $bla.ft.text "" "\n<$from> $rest"
    instext $bla.ft.text "" [format "\n<%s> %s" $from $rest]
    updatetitle $bla 1
    set data ""
    }
 }
if {$cmd=="NOTICE"} {
  set data "";
  if {$from==$netname} {set data "\n\[SERVER\] $rest"; set dtag servnotice }
  if {$from!=$netname} { instext [WhoisGetFocus] notice "\n\[NOTICE\] ($from) $rest" }
 }
if {$cmd=="WALLOPS"} {
  if {$from==$mynick} {set from ""}
  set data "\n\[WALLOPS\] $from $to $rest"; set dtag servnotice
  }

if {$cmd=="INVITE"} {set data "";instext [WhoisGetFocus] invite "\n\[INVITE\] $from invites you to $rest"}

if {$cmd=="321"} {  ## LIST start
 window.chanlist
 bind .serverwin.chanlist <FocusIn> "updatetitle .serverwin.chanlist 0"
 
 .serverwin.chanlist.b.chans delete 0 end 
 set l_all ""
 set listmode 1
 set data ""
 }
if {$cmd=="322"} {  ## LIST data
 if {$listmode==1} { scan $rest "%s %s" c u
		     set t [rtrimleft $rest "$c $u :"]
		     while {[string length $c]<15} { set c "$c "}
		     while {[string length $u]<5} { set u "$u "}
 		     lappend l_all "$c $u $t"
                     set data ""}
 }
if {$cmd=="323"} {  ## LIST end
 if {$listmode==1} { sortchanlist 0; set listmode 0; set data "" }
 } 

if {$data!=""} { instext .serverwin.in.text $dtag $data
                 updatetitle .serverwin 1
		 }
#update
}

proc sortchanlist {typ} {
global l_all
set a "-increasing"
if {$typ==1} {set a "-decreasing"}
set l_all [lsort $a -dictionary -index $typ $l_all]
.serverwin.chanlist.b.chans delete 0 end 
foreach a $l_all { .serverwin.chanlist.b.chans insert end $a }
updatetitle .serverwin.chanlist 1
}

proc sortbanlist {typ w} {
set a "-increasing"
if {$typ==2} {set a "-decreasing"}
set l [lsort $a -dictionary -index $typ [$w.a.bans get 0 end]]
$w.a.bans delete 0 end 
foreach a $l { $w.a.bans insert end $a }
updatetitle $w 1
}

proc disconnect {args} {
global sck quitmsg nid chans querys gotip l_all wins away netname hist notify
global dbusers usedsk
catch [puts $sck "QUIT :$quitmsg"]
catch [flush $sck]
catch [close $sck]
killwin .serverwin
set chans ""
set querys ""
set l_all ""
unset wins; set wins("","") ""
unset gotip; set gotip("","") ""
unset hist; set hist(s,"","") ""; set hist(i,"") 0; set hist(t,"") 0;
unset dbusers; set dbusers("") ""
set notify(notyet) $notify(names)
set notify(online) ""
set netname ""
set away 0; set oper 0; set usedsk "0"
wm deiconify .
}

proc connect {args} {
global server serverport sck realname ident mynick hist
disconnect
wm withdraw .
window.serverwin
set a [crypt ".serverwin"]
set hist(s,$a,0) "";set hist(i,$a) 0;set hist(t,$a) 0
wm title .serverwin "dirc - connecting"
wm iconname .serverwin "connecting"
colors .serverwin.in.text
wm protocol .serverwin WM_DELETE_WINDOW "disconnect"
bind .serverwin <FocusIn> "updatetitle .serverwin 0"

set sck [socket $server $serverport]
fileevent $sck readable readsock
wm title .serverwin "\[0\] dirc - $server"
wm iconname .serverwin "dirc: [string tolower $server]"
puts $sck "USER $ident ehore ehore :$realname"
puts $sck "NICK $mynick"
flush $sck
update
}

proc killwin {w args} {
 if {[winfo exists $w]} {destroy $w}
 }

proc closequery {w args} {      
global querys wins
set n ""
foreach a $querys {if {$wins(q,$a)==$w} {set n $a; break}}
set wins(q,$n) ""
set n [lsearch $querys $n]
set querys [lreplace $querys $n $n]
killwin $w
}

proc toquery {t w args} {
global sck mynick
set t [decrypt $t]
set args [$w.entry get]
$w.entry delete 0 end
hist.add [string tolower $t] $args
set bla [string index $args 0]
if {$bla!="/"} {
 instext $w.ft.text "" "\n<$mynick> $args"
 updatetitle $w 1
 puts $sck "PRIVMSG $t :$args"
 flush $sck
 } else {
    if {[string match "/me *" $args]=="1"} {
      scan $args "%s" bla
      set act [rtrimleft $args "$bla "]
      set args "/ctcp $t ACTION $act"
      instext $w.ft.text action "\n * $mynick $act"
      updatetitle $w 1
      }
    set a [string trimright [string tolower $args] " "]
    if {$a=="/p" || $a=="/ping" || $a=="/ver" || $a=="/version" || $a=="/page"} {set args "$args $t"}
    toserver $args
    }
 }

proc tochan {c w args} {
global sck mynick nickcomplete chans wins
set args [$w.entry get]
if {$args==""} {return}
set cc [crypt [string tolower $c]]
$w.entry delete 0 end
hist.add $c $args
set bla [string index $args 0]
if {$bla!="/"} {
 if {$nickcomplete==1} {
   set to [lindex $args 0]
   if {[string match "*:" $to]==1} {
     set to [string trimright $to ":"]
     set blala [GetNicks $c]
     set yess $to
     set to [string tolower $to]
     set m [string tolower $mynick]
     foreach a $blala { if {[string match "*$to*" [string tolower $a]]==1 && [string tolower $a]!=$m} { set yess $a; break }}
     set bla ""; scan $args "%s" bla
     set args "$yess: [rtrimleft $args "$bla "]"
     }
   }
 instext $w.ft.text "" "\n<$mynick> $args"
 updatetitle $w 1
 puts $sck "PRIVMSG $c :$args"
 flush $sck
 } else {
  if {$args=="/part"} {set args "/l"}
  if {$args=="/l"} {set args "/l $c"} 
  set w1 ""; set w2 ""
  scan $args "%s" w1
  set w2 [rtrimleft $args "$w1 "]
  if {[string match "/k *" $args]=="1"} {set args "/k $c $w2"}
  if {[string match "/c *" $args]=="1"} {set args "/c $c $w2"}
  if {[string match "/t *" $args]=="1"} {set args "/t $c :$w2"}
  if {[string match "/op *" $args]=="1"} {
    set bla ""
    set cnt 0
    set victims $w2
    set vc [llength $victims]
    for {set i 0} {$i<$vc} {incr i} {
     lappend bla [lindex $victims $i]
     incr cnt
     if {$cnt==3} { toserver "/c $c +ooo $bla"
                    set cnt 0; set bla "" }
     }
     if {$bla!=""} { toserver "/c $c +ooo $bla" }
     set args ""
    }
  if {[string match "/dop *" $args]=="1"} {
    set bla ""
    set cnt 0
    set victims $w2
    set vc [llength $victims]
    for {set i 0} {$i<$vc} {incr i} {
     lappend bla [lindex $victims $i]
     incr cnt
     if {$cnt==3} { toserver "/c $c -ooo $bla"
                   set cnt 0; set bla "" }
     }    
     if {$bla!=""} { toserver "/c $c -ooo $bla" }
     set args ""
    }
  if {$args=="/mop"} {
    set bla ""
    set cnt 0
    set victims ""
    set vv [$w.fn.nicks get 0 end]
    foreach a $vv { if {[string match "*@*" $a]==0} { lappend victims [string trimleft $a "+"] } }
    set vc [llength $victims]
    if {$vc>0} {
      for {set i 0} {$i<$vc} {incr i} {
       lappend bla [lindex $victims $i]
       incr cnt
       if {$cnt==3} { toserver "/c $c +ooo $bla"
                     set cnt 0; set bla "" }
       }    
      if {$bla!=""} { toserver "/c $c +ooo $bla" }
      }
     set args ""
    }
  if {$args=="/mdop"} {
    set bla ""
    set cnt 0
    set victims ""
    set vv [$w.fn.nicks get 0 end]
    foreach a $vv { if {[string match "*@*" $a]==1} {
     set dn [string trimleft [string trimleft [string trimleft $a "@"] "+"] "@"]
     if {[string tolower $mynick]!=[string tolower $dn]} {lappend victims $dn} } }
    set vc [llength $victims]
    if {$vc>0} {
      for {set i 0} {$i<$vc} {incr i} {
       lappend bla [lindex $victims $i]
       incr cnt
       if {$cnt==3} { toserver "/c $c -ooo $bla"
                     set cnt 0; set bla "" }
       }    
      if {$bla!=""} { toserver "/c $c -ooo $bla" }
      } 
     set args ""
    }
  if {$args=="/cb"} {
    set ban $wins(b,$cc)
    if {$ban!=""} {set args "/c $c -b $ban"} else {set args ""}
    }
  if {$args=="/bans"} {
    killwin "$wins(w,$cc).banlist"
    set args "/c $c b"
    } 
  if {$args=="/hop"} {set args "/cycle"} 
  if {$args=="/cycle"} {toserver "/l $c"; set args "/j $c"}
  if {[string match "/inv *" $args]} {set args "/invite $w2 $c"}
  if {$args=="/c"} {set args "/c $c"} 
  if {$args=="/cw"} {set args ""; window.modes "$wins(w,$cc).modes" $c}
  if {$args=="/p"} {set args "/p $c"}
  if {$args=="/ver"} {set args "/ver $c"}
  if {$args=="/t"} {set args "/t $c"} 
  if {$args=="/sc"} {set args "/names"} 
  if {[string match "/me *" $args]=="1"} {
    set act $w2
    set args "/ctcp $c ACTION $act"
    instext $w.ft.text action "\n * $mynick $act"
    updatetitle $w 1
    }
  if {$args=="/names"} {
    set args "/names $c"
    $wins(w,$cc).fn.nicks delete 0 end
    }
  if {$args!=""} {toserver $args}
 }
}

proc toserver {args} {
global sck mynick version away quitmsg chans querys wins
global defaultawayreason defaultbackreason
global travmsg travtime logdir autojoin nickcomplete beep pagebell dbusers
global rightkickreason rightkillreason rightklinereason rightzlinereason

set data ""; set dtag ""
set args [join $args]
set bla [string index $args 0]
set rep 0
if {$bla=="/"} {
 scan $args "%s" lola
## set args [rtrimleft $args "$lola "]
 set args [drange 1 end $args]
 set lola [string tolower $lola]
 set w1 ""; set w2 ""; set w3 ""
 scan $args "%s %s" w1 w2
 set w3 [drange 2 end $args]
 set w23 [drange 1 end $args]
# set w3 [rtrimleft $args "$w1 $w2 "]
# set w23 [string trimleft "$w2 $w3" " "]

 if {$lola=="/userdb"} {
  set lola ""; set args ""
  puts "\n"
  set id [array startsearch dbusers]
  while {[array anymore dbusers $id]} {
   set cn [array nextelement dbusers $id]
   if {$cn!={""}} {puts "\[userdb\] [decrypt $cn]: $dbusers($cn)"}
   } 
  array donesearch dbusers $id
  puts "\n"
  }
 if {$lola=="/set"} { set lola ""; eval "set $args"; set args "" }
 if {$lola=="/query"} { set lola ""; Query $args; set args "" }
 if {$lola=="/who"} { set lola "/w" }
 if {$lola=="/qw"} {set args ""; window.quickwin; return}
 if {$lola=="/whois"} { set lola "/wi" }
 if {$lola=="/whowas"} { set lola "/ww" }
 if {$lola=="/ping"} { set lola "/p" }
 if {$lola=="/msay"} {
   foreach a $chans {
     set w $wins(w,[crypt $a])
     instext $w.ft.text "" "\n<$mynick> $args"
     puts $sck "PRIVMSG $a :$args"
     }
   foreach a $querys {
     instext $wins(q,$a).ft.text "" "\n<$mynick> $args"
     puts $sck "PRIVMSG [decrypt $a] :$args"
     }
   flush $sck; set args "" }
 if {$lola=="/mnot"} {
   foreach a $chans {
     set a [decrypt $a]
     puts $sck "NOTICE $a :$args"
     instext [WhoisGetFocus] notice "\n\[NOTICE\] $a $args"
     }
   foreach a $querys {
     set a [decrypt $a]
     instext [WhoisGetFocus] notice "\n\[NOTICE\] $a $args"
     puts $sck "NOTICE $a :$args"
     }
   flush $sck; set args "" }
 if {$lola=="/mctcp"} {
   foreach b $chans {
     set a [crypt $b]
     puts $sck "PRIVMSG $b :\x01$args\x01"
     set c [string tolower [dindex 0 $args]]
     if {$c=="action"} {instext $wins(w,$a).ft.text action "\n * $mynick [drange 1 end $args]"}
     if {$c!="action"} {instext [WhoisGetFocus] ctcp "\n\[CTCP\] $b $args"}
     }
   foreach a $querys {
     set b [decrypt $a]
     puts $sck "PRIVMSG $b :\x01$args\x01"
     set c [string tolower [dindex 0 $args]]
     if {$c=="action"} {instext $wins(q,$a).ft.text action "\n * $mynick [drange 1 end $args]"}
     if {$c!="action"} {instext [WhoisGetFocus] ctcp "\n\[CTCP\] $b $args"}
     }
   flush $sck; set args "" }
 if {$lola=="/mctcprep"} {
   foreach b $chans {
     set a [crypt $b]
     puts $sck "NOTICE $b :\x01$args\x01"
     instext [WhoisGetFocus] ctcprep "\n\[CTCP-REPLY\] $b $args"
     }
   foreach a $querys {
     set a [decrypt $a]
     puts $sck "NOTICE $a :\x01$args\x01"
     instext [WhoisGetFocus] ctcprep "\n\[CTCP-REPLY\] $a $args"
     }
   flush $sck; set args "" }
 if {$lola=="/um"} { set args "MODE $mynick $args" }
 if {$lola=="/userhost"} { set args "USERHOST $args" }
 if {$lola=="/rehash"} { set args "REHASH $args" }
 if {$lola=="/trace"} { set args "TRACE $args" }
 if {$lola=="/stats"} { set args "STATS $args" }
 if {$lola=="/admin"} { set args "ADMIN $args" }
 if {$lola=="/oper"} { set args "OPER $args" }
 if {$lola=="/kline"} { set args "KLINE :$args" }
 if {$lola=="/unkline"} { set args "UNKLINE :$args" }
 if {$lola=="/zline"} { set args "ZLINE :$args" }
 if {$lola=="/unzline"} { set args "UNZLINE :$args" }
 if {$lola=="/globops"} { set args "GLOBOPS :$args" }
 if {$lola=="/wallops"} { set args "WALLOPS :$args" }
 if {$lola=="/locops"} { set args "LOCOPS :$args" }
 if {$lola=="/kill"} { set args "KILL $args"; set rep 1 }
 if {$lola=="/time"} { set args "TIME $args" }
 if {$lola=="/restart"} { set args "RESTART $args" }
 if {$lola=="/die"} { set args "DIE $args" }
 if {$lola=="/help"} { set args "HELP $args" }
 if {$lola=="/squit"} { set args "SQUIT $args" }
 if {$lola=="/connect"} { set args "CONNECT $args" }
 if {$lola=="/users"} { set args "USERS $args" }
 if {$lola=="/motd"} { set args "MOTD $args" }
 if {$lola=="/invite"} { set args "INVITE $args" }
 if {$lola=="/lusers"} { set args "LUSERS $args" }
 if {$lola=="/away"} {
   if {$away==0} {
     if {$args==""} {set args $defaultawayreason}
     set args "$args \x1f\[[clock format [clock seconds] -format {%H:%M}]\]\x1f"
     toserver "/mctcp ACTION is away, $args"
     set args "AWAY :$args"
     } else {set args ""; instext [WhoisGetFocus] notice "\nYou are already away"}
   }
 if {$lola=="/back"} {
   if {$away==1} {
     if {$args==""} {set args $defaultbackreason}
     set args "$args \x1f\[[clock format [clock seconds] -format {%H:%M}]\]\x1f"
     toserver "/mctcp ACTION is back, $args"
     set args "AWAY"
     } else {set args ""; instext [WhoisGetFocus] notice "\nYou are not away"}
   }
 if {$lola=="/p"} { instext [WhoisGetFocus] ctcp "\n\[PING\] $args"; set args "PRIVMSG $args :\x01PING [clock seconds]\x01" }
 if {$lola=="/version"} { set lola "/ver" }
 if {$lola=="/ver"} { instext [WhoisGetFocus] ctcp "\n\[VERSION\] $args"; set args "PRIVMSG $args :\x01VERSION\x01" }
 if {$lola=="/page"} { instext [WhoisGetFocus] ctcp "\nPAGE $w1 $w2 $w3"; set args "PRIVMSG $w1 :\x01PAGE $w23\x01" }
 if {$lola=="/info"} { set args "INFO $args" }
 if {$lola=="/links"} { set args "LINKS $args" }
 if {$lola=="/w"} { set args "WHO $args" }
 if {$lola=="/wi"} { if {[string trimleft $args " "]==""} {set args $mynick}
                     set args "WHOIS $args" }
 if {$lola=="/ww"} { set args "WHOWAS $args" }
 if {$lola=="/ison"} { set args "ISON :$args" }
 if {$lola=="/kick"} { set lola "/k" }
 if {$lola=="/k"} { set args "KICK $w1 $w2 :$w3" }
 if {$lola=="/topic"} { set lola "/t" }
 if {$lola=="/t"} { set args "TOPIC $args" }
 if {$lola=="/names"} { set args "NAMES $args" }
 if {$lola=="/list"} { set args "LIST $args" }
 if {$lola=="/part"} { set lola "/l" }
 if {$lola=="/l"} { set args "PART $args" }
 if {$lola=="/msg"} { set lola "/m" }
 if {$lola=="/m"} { instext [WhoisGetFocus] msg "\n\[MSG\] $args"
                    set args "PRIVMSG $args"; set rep 1 }
 if {$lola=="/notice"} { set lola "/n" }
 if {$lola=="/n"} { instext [WhoisGetFocus] notice "\n\[NOTICE\] $args"
                    set args "NOTICE $args"; set rep 1 }
 if {$lola=="/join"} { set lola "/j" }
 if {$lola=="/j"} {
    if { [string index $args 0]!="#" } { set args "#$args" }
    set args "JOIN $args"
    }
 if {$lola=="/mode"} { set lola "/c" }
 if {$lola=="/c"} { set args "MODE $args" }
 if {$lola=="/nick"} { set args "NICK $args" }
 if {$lola=="/ctcp"} { set args "PRIVMSG $w1 :\x01$w23\x01"
                       instext [WhoisGetFocus] ctcp "\n\[CTCP\] $w1 $w2 $w3" }
 if {$lola=="/ctcprep"} { set args "NOTICE $w1 :\x01$w23\x01"
                          instext [WhoisGetFocus] ctcprep "\n\[CTCP-REPLY\] $w1 $w2 $w3" }
 if {$lola=="/quit"} { if {$args==""} {set args $quitmsg}
                       set args "QUIT :$args" }
    }

scan $args "%s" w1
set w2 [rtrimleft $args "$w1 "]
instext .serverwin.in.text $dtag $data
updatetitle .serverwin 1

if {$rep==1} {
  scan $args "%s %s" w1 w2
  set w3 [rtrimleft $args "$w1 $w2 "]
  set args "$w1 $w2 :$w3"
  }
puts $sck $args
flush $sck
if {[string match "QUIT*" $args]} {disconnect}
##puts $args
}

proc GetNicks {c args} {
global chans wins
set nck ["$wins(w,[crypt [string tolower $c]]).fn.nicks" get 0 end]
set res ""
foreach a $nck { lappend res "[string trimleft [string trimleft [string trimleft $a "@"] "+"] "@"]" }
return $res
}

proc QuerySelection {b} {  # Query on double-click
set n [$b.fn.nicks curselection]
if {$n>-1} { Query [string trimleft [string trimleft [string trimleft [$b.fn.nicks get $n] "@"] "+"] "@"] }
}

proc RightPopup {b w x y} {  # Smart right-mouse-popup
global chans rightkickreason nukes wins oper rightkillreason rightklinereason
global rightzlinereason gotip
set c ""
foreach a $chans {if {$wins(w,[crypt $a])==$b} {set c $a; break}}

set n [$b.fn.nicks curselection]
if {$n>-1} {
    set isop 0
    set hasvoice 0
    set hamnick [$b.fn.nicks get $n]
    if {[string index $hamnick 0]=="@"} {set isop 1}
    if {[string index $hamnick 1]=="@"} {set isop 1}
    if {[string index $hamnick 0]=="+"} {set hasvoice 1}
    if {[string index $hamnick 1]=="+"} {set hasvoice 1}
    set nick [string trimleft [string trimleft [string trimleft $hamnick "@"] "+"] "@"]
    $w delete 0 end
    if {$isop==0} {$w add command -label {Op (+o)} -command "toserver /c $c +o $nick"}
    if {$isop==1} {$w add command -label {Deop (-o)} -command "toserver /c $c -o $nick"}
    if {$hasvoice==0} {$w add command -label {Voice (+v)} -command "toserver /c $c +v $nick"}
    if {$hasvoice==1} {$w add command -label {Unvoice (-v)} -command "toserver /c $c -v $nick"}
    $w add command -label {Query} -command "Query $nick"
    $w add command -label {Add to QuickList} -command "set gotip([crypt [string tolower $nick]],0) 4
                                                       toserver /userhost $nick"
    $w add cascade -label {Info} -menu $w.info
    $w.info delete 0 end
    $w.info add command -label {Whois} -command "toserver /wi $nick"
    $w.info add command -label {Userhost} -command "toserver /userhost $nick"
    $w.info add command -label {Links} -command "toserver /links"
    $w.info add separator
    $w.info add command -label {Stats C} -command "toserver /stats c"
    $w.info add command -label {Stats H} -command "toserver /stats h"
    $w.info add command -label {Stats K} -command "toserver /stats k"
    $w.info add command -label {Stats L} -command "toserver /stats l"
    $w.info add command -label {Stats M} -command "toserver /stats m"
    $w.info add command -label {Stats O} -command "toserver /stats o"
    $w.info add command -label {Stats U} -command "toserver /stats u"
    $w.info add command -label {Stats Y} -command "toserver /stats y"
    $w.info add command -label {Stats Z} -command "toserver /stats z"
    $w add separator
    $w add command -label "Kick ($rightkickreason)" -command "toserver /kick $c $nick $rightkickreason"
    $w add cascade -label {Ban} -menu $w.ban
    $w add cascade -label {Nuke} -menu $w.nuke
    $w.ban delete 0 end
    $w.ban add command -label {*!ident@*.host} -command "Ban $c $nick 0"
    $w.ban add command -label {*!ident@ip} -command "Ban $c $nick 1"
    $w.ban add command -label {*!*@ip} -command "Ban $c $nick 2"
    $w.ban add command -label {nick!*@*} -command "Ban $c $nick 3"
    $w.ban add command -label {nick!ident@*} -command "Ban $c $nick 4"
    $w.ban add command -label {*!*@*.host} -command "Ban $c $nick 5"
      $w.nuke delete 0 end
      set nsize [array size nukes]
      for {set i 0} {$i<$nsize} {incr i} {
        $w.nuke add command -label [lindex $nukes($i) 0] -command "Nuke $nick $i"
        }
    if {$oper==1} {
      $w add separator
      $w add cascade -label {Oper} -menu $w.oper
      $w.oper delete 0 end
      $w.oper add command -label "Kill ($rightkillreason)" -command "toserver /kill $nick $rightkillreason"
      $w.oper add cascade -label {Lines} -menu $w.oper.lines
      $w.oper.lines delete 0 end
      $w.oper.lines add command -label "*!*@ip K-Line ($rightklinereason)" -command "Nuke $nick K 0"
      $w.oper.lines add command -label "*!*@*.host K-Line ($rightklinereason)" -command "Nuke $nick K 1"
      $w.oper.lines add separator
      $w.oper.lines add command -label "ip Z-Line ($rightzlinereason)" -command "Nuke $nick K 2"
      $w.oper.lines add command -label "*.host Z-Line ($rightzlinereason)" -command "Nuke $nick K 3"
      $w.oper add separator
      $w.oper add command -label {Rehash server} -command "toserver /rehash"
      }
    catch [tk_popup $w $x $y 0]
    }
}

proc Query {nick} {
global querys wins hist gotip
set lnick [crypt [string tolower $nick]]
set nn [lsearch $querys $lnick]
 if {$nn<0} {  ## Create new query window
  lappend querys $lnick
  set bla ".serverwin.query_"
  for { set i 0 } { $i<[string length $nick] } {incr i} {
    set a [string index $nick $i]
    if {$a=="."} {set a "0"}
    if {$a=="^"} {set a "1"}
    if {$a=="|"} {set a "2"}
    if {$a=="\["} {set a "3"}
    if {$a=="\]"} {set a "4"}
    if {$a=="`"} {set a "5"}
    if {$a=="'"} {set a "6"}
    if {$a=="/"} {set a "7"}
    if {$a=="-"} {set a "8"}
    if {$a=="_"} {set a "9"}
    set bla "$bla$a"
    }
  set wins(q,$lnick) $bla
  window.query $bla
  set hist(s,$lnick,0) "";set hist(i,$lnick) 0;set hist(t,$lnick) 0
  wm title $bla "$nick - queried"
  wm iconname $bla [string tolower $nick]
  colors $bla.ft.text
  set ln [string tolower $nick]
  bind $bla.entry <Return> "toquery $lnick $bla"
  bind $bla.entry <Up> "hist.up $bla.entry $ln"
  bind $bla.entry <Down> "hist.down $bla.entry $ln"
  wm protocol $bla WM_DELETE_WINDOW "closequery $bla"
  bind $bla <FocusIn> "updatetitle $bla 0"
  set gotip([crypt [string tolower $nick]],0) 4
  toserver "/userhost $nick"
  }
}

proc Ban {c n t} {
global gotip
 if {$t==3} {toserver "/c $c -o+b $n $n!*@*"} else {
  set cn [crypt [string tolower $n]]
  set a 0
  catch "set a $gotip($cn,0)"
  if {$a==2} {set a 3} else {set a 1}
     set gotip($cn,0) $a
     set gotip($cn,1) $c
     set gotip($cn,2) $t
     toserver "/userhost $n"
   }
}

proc RealBan {n id ip} {
global gotip
set cn [crypt [string tolower $n]]
set mask [GetMaskFromIP $ip]
set a $gotip($cn,0)
if {$a==3} {set a 2} else {set a 0}
set gotip($cn,0) $a
set c $gotip($cn,1)
set t $gotip($cn,2)
if {$t==0} { toserver "/c $c -o+b $n *!$id@$mask" } 
if {$t==1} { toserver "/c $c -o+b $n *!$id@$ip" } 
if {$t==2} { toserver "/c $c -o+b $n *!*@$ip" } 
if {$t==4} { toserver "/c $c -o+b $n $n!$id@*" } 
if {$t==5} { toserver "/c $c -o+b $n *!*@$mask" } 
}

proc Nuke {n t args} {
global gotip
set args [join $args]
set cn [crypt [string tolower $n]]
set a 0
catch "set a $gotip($cn,0)"
if {$a==1} {set a 3} else {set a 2}
  set gotip($cn,0) $a
  set gotip($cn,3) $t
  if {$args!=""} {set gotip($cn,4) $args}
  toserver "/userhost $n"
}

proc RealNuke {nick id ip} {
global gotip nukes rightklinereason rightzlinereason

set n [crypt [string tolower $nick]]
set a $gotip($n,0)
if {$a==3} {set a 1} else {set a 0}
set gotip($n,0) $a
set t $gotip($n,3)
if {$t=="K"} {
 set a "/kline"
 set t $gotip($n,4)
 set h "*!*@$ip $rightklinereason"
 if {$t==1} {set h "*!*@[GetMaskFromIP $ip] $rightklinereason"}
 if {$t==2} {set h "$ip $rightzlinereason"; set a "/zline"}
 if {$t==3} {set h "[GetMaskFromIP $ip] $rightzlinereason"; set a "/zline"}
 toserver "$a $h"
 return
 }

 set clk [clock seconds]
 set l [expr "[string length $clk] - 1"]
 set a [string range $clk [expr "$l-3"] end]
 if {$a>255} {set a 204}
 set spoofip "$a.[string range $clk 0 1].42.[string range $clk 3 4]"
 set bla [drange 1 end $nukes($t)]
 set bla [sreplace "%ip" $ip $bla]
 set bla [sreplace "%nick" $nick $bla]
 set bla [sreplace "%spoofip" $spoofip $bla]
 catch [join $bla] res
 if {$res!=""} {puts $res}
}

proc filter {st ch} {
 set tmp [split $st $ch]; set tmp2 ""
 foreach tmp3 $tmp { set tmp2 "$tmp2$tmp3" }
 return tmp2
}

proc rtrimleft {bigstr srcstr} {
set istring1 [string length $srcstr]
if {$srcstr == [string range $bigstr 0 [expr $istring1-1]]} {
  return [string range $bigstr $istring1 end] }
}

proc crypt {args} {
set x [join $args]
##set res "cn"
set res ""
for { set i 0 } { $i<[string length $x] } {incr i} {
    set a [string index $x $i]
    if {$a=="\$"} {set a "_a"}
    if {$a=="\["} {set a "_b"}
    if {$a=="\]"} {set a "_c"}
    if {$a=="\{"} {set a "_d"}
    if {$a=="\}"} {set a "_e"}
    if {$a=="\\"} {set a "_f"}
    if {$a=="\""} {set a "_g"}
    if {$a=="#"} {set a "_h"}
    if {$a=="&"} {set a "_i"}
    if {$a=="."} {set a "_j"}
    if {$a=="^"} {set a "_k"}
    if {$a=="`"} {set a "_l"}
    if {$a=="_"} {set a "__"}
    set res "$res$a"
    }
return $res
}

proc decrypt {args} {
set x [join $args]
set res ""
for { set i 0 } { $i<[string length $x] } {incr i} {
    set a [string index $x $i]
    if {$a=="_"} {
     incr i
     set a [string index $x $i]
     if {$a=="a"} {set a "\$"}
     if {$a=="b"} {set a "\["}
     if {$a=="c"} {set a "\]"}
     if {$a=="d"} {set a "\{"}
     if {$a=="e"} {set a "\}"}
     if {$a=="f"} {set a "\\"}
     if {$a=="g"} {set a "\""}
     if {$a=="h"} {set a "#"}
     if {$a=="i"} {set a "&"}
     if {$a=="j"} {set a "."}
     if {$a=="k"} {set a "^"}
     if {$a=="l"} {set a "`"}
     if {$a=="_"} {set a "_"}
     }
    set res "$res$a"
    }
return $res
}

proc WhoisGetFocus {args} {
set a [join [split [focus] "."]]
set wa ".[lindex $a 0].[lindex $a 1]"
if {[string match ".serverwin.query_*" $wa]} {return "$wa.ft.text"}
if {[string match ".serverwin.chan_*" $wa]} {return "$wa.ft.text"}
return ".serverwin.in.text"
}

proc updatetitle {w s} {
set t [wm title $w]
scan $t "%s " a
if {$s==0} {
  if {$a=="\(*\)"} {wm title $w [rtrimleft $t "$a "]}
  } else {
  if {$a!="\(*\)"} {if {[focus]!=$w} { wm title $w "\(*\) $t"}}
  }
}

proc GetChanModes {cc args} {
global wins
set n 0
set what 1

set args [join $args]
set m ""
scan $args "%s " m
set args [rtrimleft $args "$m "]

set m [string tolower $m]
for {set i 0} {$i<[string length $m]} {incr i} {
  set a [string index $m $i]
  if {$a=="+"} {set what 1}
  if {$a=="-"} {set what 0}
foreach b {n t i s p m} {if {$a==$b} {set wins(mb,$cc,$b) $what}}
  if {$a=="o" || $a=="v"} {incr n}
  if {$what==1} {
    if {$a=="k"} {set wins(mb,$cc,k) [dindex $n $args]; incr n}
    if {$a=="l"} {set wins(mb,$cc,l) [dindex $n $args]; incr n}
    } else {
    if {$a=="k"} { if {[dindex $n $args]==$wins(mb,$cc,k)} {set wins(mb,$cc,k) ""}
                   incr n }
    if {$a=="l"} {set wins(mb,$cc,l) ""}
    }
  }
}

proc InvertChanModes {cc} {
global wins
set m "+";set p ""
foreach a {n t m i s p} {if {$wins(mb,$cc,$a)} {set m "$m$a"}}
if {$wins(mb,$cc,l)>0} {set m "$m{l}"; set p " $wins(mb,$cc,l)"}
if {$wins(mb,$cc,k)!=""} {set m "$m{k}"; set p "$p $wins(mb,$cc,k)"}
if {$m=="+"} {set m ""}
set a [set wins(m,$cc) "$m$p"]
if {$a!=""} {set a "($a)"}
wm title $wins(w,$cc) "\[$wins(s,$cc)\] [string tolower [decrypt $cc]] $a $wins(t,$cc)"
}

proc GetMaskFromIP {ip} {
set parts [split $ip "."]
set isdomain 0
foreach a $parts {
  catch [set x [expr "$a - 100"]] eh
  if {[string match "syntax*" [string tolower $eh]]==1} { set isdomain 1; break
    } else { if {$a>255} {set isdomain 1; break}
             if {$a<0} {set isdomain 1; break}
             }
  } 
if {$isdomain==1} {set res "*.[drange 1 end $parts]"}
if {$isdomain==0} {set a "[dlength $parts]"; set res "[drange 0 [expr "$a-1"] $parts].*"}
set son ""; foreach a $res { set son "$son.$a" }
return [string trimright [string trimleft $son "."] "."]
}

proc hist.add {c args} {
global hist
if {[join $args]==""} {return}
set cc [crypt $c]
set hist(t,$cc) [expr "$hist(t,$cc)+1"]
set hist(s,$cc,$hist(t,$cc)) [join $args]
}

proc hist.next {c} {
global hist
set cc [crypt $c]
set hist(i,$cc) [expr "$hist(i,$cc)+1"]
if {$hist(i,$cc)>$hist(t,$cc)} {set hist(i,$cc) $hist(t,$cc); return ""}
return "$hist(s,$cc,$hist(i,$cc))"
}

proc hist.prev {c} {
global hist
set cc [crypt $c]
set hist(i,$cc) [expr "$hist(i,$cc)-1"]
if {$hist(i,$cc)<0} {set hist(i,$cc) $hist(t,$cc)}
return "$hist(s,$cc,$hist(i,$cc))"
}

proc hist.up {w c} {
#hist.add $c [$w get]
$w delete 0 end
set a [hist.prev $c]
if {$a!=""} {$w insert 0 $a}
}

proc hist.down {w c} {
#hist.add $c [$w get]
$w delete 0 end
set a [hist.next $c]
if {$a!=""} {$w insert 0 $a}
}

proc notifyus {args} {
global notify
toserver "/ison $notify(notyet)"
after $notify(interval) notifyus
}

proc travban {n c h} {
global wins mynick sck travmsg
set n [string tolower $n]
set a [string tolower [GetNicks $c]]
if {[lsearch $a $n]==-1} {
  toserver "/c $c +b *!$h"
  instext $wins(w,[crypt $c]).ft.text "" "\n<$mynick> $travmsg"
  puts $sck "PRIVMSG $c :$travmsg"
  flush $sck
  }
}

proc canceltravban {args} {
set r 0
set args [join $args]
set l [after info]
foreach a $l {
 set b [join [lindex [after info $a] 0]]
 if {[string match $args $b]} {after cancel $a; set r 1; break}
 }
return $r
}

################ ## #

init
