
proc dindex {idx args} {
set args "[string trimright [string trimleft [join $args] " "] " "] "
set dt ""
set dtsave 0
set myidx 0
for {set i 0} {$i<[string length $args]} {incr i} {
   set char [string index $args $i]
   if {$myidx==$idx} {set dtsave 1}
   if {$char==" "} {
     if {$dtsave==1} {return $dt}
     incr myidx
     }
   if {$dtsave==1} {set dt "$dt$char"}
   } 
return ""
}

proc drange {sidx eidx args} {
set args [string trimright [string trimleft [join $args] " "] " "]
if {$eidx=="end"} {set eidx [dlength $args]}
set dr ""
incr eidx
for {set i $sidx} {$i<$eidx} {incr i} {
   set bla [dindex $i $args]
   if {$bla!=-1} {set dr "$dr $bla"}
   }
return [string trimleft $dr " "]
}

proc dlength {args} {
set args [string trimright [string trimleft [join $args] " "] " "]
set cnt 0
for {set i 0} {$i<[string length $args]} {incr i} {
   if {[string index $args $i]==" "} {incr cnt}
   } 
return $cnt
}

proc ddelete {idx args} {
set args [string trimright [string trimleft [join $args] " "] " "]
set dr ""
set l [dlength $args]
incr l
for {set i 0} {$i<$l} {incr i} { if {$i!=$idx} {set dr "$dr [dindex $i $args]"} }
return [string trimleft $dr " "]
}

proc dinsert {idx element args} {
set args [string trimright [string trimleft [join $args] " "] " "]
set element [string trimright [string trimleft $element " "] " "]
set l [expr "[dlength $args] + 1"]
set bla [expr "$idx - 1"]
return [string trimleft [string trimright "[drange 0 $bla $args] $element [drange $idx $l $args]" " "] " "]
}

proc dreplace {idx element args} {
set args [string trimright [string trimleft [join $args] " "] " "]
set element [string trimright [string trimleft $element " "] " "]
set dr ""
set l [dlength $args]
if {$idx>$l} {set dr "$args $element"} else {
  incr l
  for {set i 0} {$i<$l} {incr i} {
     if {$i==$idx} {set dr "$dr $element"} else {set dr "$dr [dindex $i $args]"}
     }
  }
return [string trimleft $dr " "]
}

proc dsearch {startsearch element args} {
set args [string trimright [string trimleft [join $args] " "] " "]
set element [string trimright [string trimleft $element " "] " "]
set l [dlength $args]
incr l
for {set i $startsearch} {$i<$l} {incr i} {
   if {[dindex $i $args]==$element} {return $i}
   } 
return -1
}

proc dappend {element args} {
set args [string trimright [string trimleft [join $args] " "] " "]
set element [string trimright [string trimleft $element " "] " "]
return "$args $element"
}

proc sdelete {st en args} {
set args [join $args]
set dr ""
set l [string length $args]
incr l
for {set i 0} {$i<$l} {incr i} {if {$i<$st || $i>$en} {set dr "$dr[string index $args $i]"}}
return $dr
}

proc sinsert {idx substr args} {
set substr [join $substr]
set args [join $args]
return "[string range $args 0 $idx]$substr[string range $args [expr "$idx + 1"] end]"
}

proc sreplace {find rep args} {
set find [join $find]
set rep [join $rep]
set args [join $args]
set fl [string length $find]
set i [string first $find $args]
while {$i!=-1} {
 set args [sdelete $i [expr "$i+$fl-1"] $args]
 set args [sinsert [expr "$i-1"] $rep $args]
 set i [string first $find $args]
 }
return $args
}
