#include "group.h"

/*
 * The values in this array are those taken from the file "/etc/group"
 *  in the Slackware 1.1.0 distribution of Slackware.
 */
identify group[]={{"root",0},{"other",1},{"bin",2},{"sys",3},{"adm",4},
		 {"uucp",5},{"users",6},{"mail",7},{"info",8},{"wheel",10},
		 {"daemon",12},{"cron",16},{"tty",17},{"lp",18},{"disk",19},
		 {"mem",20},{"kmem",21},{"sysadmin",23},{"news",24},
		 {"shadow",49},{"group",50},{"litl1",10002}};

/*
 * The values in this array are those taken from the file "/etc/passwd"
 *  in the Slackware 1.1.0 distribution of Slackware.
 */
identify user[]={{"root",0},{"daemon",1},{"bin",2},{"adm",4},{"uucp",5},
		{"news",24},{"sync",255},{"anonymous",403},{"ftp",404},
		{"gonzo",418},{"satan",419},{"snake",420},
		{"dglaude",10066}};

char *identsearch(int id, identify tbl[], int size)
{
 int i=0;
 while(i<size){
  if(tbl[i].id==id) break;
  i++;
 }
 return (i!=size)?(tbl[i].name):(NULL);
}

char *getuser(int uid)
{
return (identsearch(uid, user, sizeof(user)/sizeof(identify)));
}

char *getgroup(int gid)
{
return (identsearch(gid, group, sizeof(group)/sizeof(identify)));
}
