unit User;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, Dialogs;

type
  TBtnBottomDlg = class(TForm)
    Bevel1: TBevel;
    ListBox1: TListBox;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Label2: TLabel;

    procedure FormCreate(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    function GetUnixUser(UserNm: String): String;
    { Public declarations }
  end;

var
  BtnBottomDlg: TBtnBottomDlg;

implementation


Uses Startfrm, nwconn, nwbindry, adduser, eduser;
{$R *.DFM}

function TBtnBottomDlg.GetUnixUser(UserNm: String): String;
var MyProperty: TProperty;
    MorSegs: Boolean;
    PropFlg: Byte;
begin
  if ReadPropertyValue(UserNm, OT_USER, 'UNIX_USER', 1, MyProperty, MorSegs, PropFlg)
     =false then result:='' else result:=StrPas(Addr(MyProperty));
end;

procedure TBtnBottomDlg.FormCreate(Sender: TObject);
var ID: Byte;
    ObjName1, UserName: String[24];
    longint1  :longint;
    RepID1: longint;
    RepType1: Word;
    RepFlag1, RepSecu1: Byte;
    RepProp1: Boolean;
begin
  Caption:='Editing User accounts at '+Form1.panel1.caption;
  {Get Usernames, with Unix names and add to listbox1}
  longint1:=-1;
  while ScanBinderyObject('*', OT_USER, longint1, ObjName1, RepType1,
    RepID1, RepFlag1, RepSecu1, RepProp1)=true do
  begin
    UserName:=ObjName1;
    RepID1:=RepID1 AND $7FFF;
    ListBox1.Items.Add(ObjName1+', '+IntToStr(RepID1)+',  '+GetUnixUser(UserName));
  end;
end;


procedure TBtnBottomDlg.BitBtn4Click(Sender: TObject);
begin
  Close;
end;

procedure TBtnBottomDlg.BitBtn2Click(Sender: TObject);
var UserName: String;
    Int1: Integer;
begin
  {Don't clear up groups yet, just remove bind. entry}
  if ListBox1.ItemIndex<>-1 then
  begin
    UserName:=''; Int1:=1;
    While ListBox1.Items[ListBox1.ItemIndex][Int1]<>',' do
    begin
      UserName:=UserName+ListBox1.Items[ListBox1.ItemIndex][Int1];
      Int1:=Int1+1;
    end;
    if UserName='SUPERVISOR' then MessageDlg('Deleting SUPERVISOR would be a VERY BAD idea!', mtWarning, [mbOK], 0);
    if MessageDlg('Delete user '+UserName+'?', mtConfirmation, [mbYes, mbNo], 0)=mrYes
    then begin
      if DeleteBinderyObject(UserName,OT_USER)<>TRUE then
        MessageDlg('Could not remove user '+UserName, mtError, [mbCancel], 0);
    end;
    Paint;
  end;
end;

procedure TBtnBottomDlg.FormPaint(Sender: TObject);
begin
  ListBox1.Items.Clear;
  FormCreate(self);
end;

procedure TBtnBottomDlg.BitBtn1Click(Sender: TObject);
begin
  BtnBottomDlg2.ShowModal;
  FormPaint(self);
end;

procedure TBtnBottomDlg.BitBtn3Click(Sender: TObject);
begin
  if ListBox1.ItemIndex<>-1 then BtnBottomDlg3.ShowModal;
  FormPaint(self);
end;

end.
