unit Eduser;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs;

type
  TBtnBottomDlg3 = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    Button1: TButton;
    Label1: TLabel;
    procedure FormShow(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    UserNAme: String;
    Int1: Integer;
    { Public declarations }
  end;

var
  BtnBottomDlg3: TBtnBottomDlg3;

implementation

{$R *.DFM}

uses User, nwBindry, SysUtils, ChgPass2;

function IsUserPrivileged(UserName:String): Boolean;
begin
  IsUserPrivileged:=IsBinderyObjectInSet(UserName, OT_USER, 'SECURITY_EQUALS',
    'SUPERVISOR', OT_USER);
end;

procedure TBtnBottomDlg3.FormShow(Sender: TObject);
begin
  UserName:=''; Int1:=1;
    While BtnBottomDlg.ListBox1.Items[BtnBottomDlg.ListBox1.ItemIndex][Int1]<>',' do
    begin
      UserName:=UserName+BtnBottomDlg.ListBox1.Items[BtnBottomDlg.ListBox1.ItemIndex][Int1];
      Int1:=Int1+1;
    end;
  Edit1.Text:=BtnBottomDlg.GetUnixUser(UserName);
  Caption:='Editing User '+UserName;
  CheckBox1.Checked:=((IsUserPrivileged(UserName)) or (UserName='SUPERVISOR'));
  CheckBox1.Enabled:=(UserName<>'SUPERVISOR');
  Button1.Enabled:=(UserName<>'SUPERVISOR');
end;

function GetNewPass: String;
begin
  PassWordDlg.ShowModal;
  GetNewPAss:=PasswordDlg.Password.Text;
end;


procedure TBtnBottomDlg3.OKBtnClick(Sender: TObject);
var SX: Integer;
    MyPThing: TProperty;

begin
  For SX:=1 to 128 do MyPThing[SX]:=0;
  StrPCopy(Addr(MyPThing), Edit1.Text);
  WritePropertyValue(UserName, OT_USER, 'UNIX_USER', 1, MyPThing, False);
  if UserName<>'SUPERVISOR' then
  begin
    DeleteProperty(UserName, OT_USER, 'SECURITY_EQUALS');
    CreateProperty(Edit1.Text, OT_USER, 'SECURITY_EQUALS', BF_SET, $31);
    if CheckBox1.Checked then AddBinderyObjectToSet(Edit1.Text, OT_USER,
        'SECURITY_EQUALS','SUPERVISOR', OT_USER)
    else AddBinderyObjectToSet(Edit1.Text, OT_USER,'SECURITY_EQUALS','EVERYONE', OT_USER_GROUP);
  end;
  MessageDlg('Changes to user will take effect next time they login.', mtInformation, [mbOK], 0);
  Close;
end;

procedure TBtnBottomDlg3.Button1Click(Sender: TObject);
var Successish: Boolean;
    Int3: Integer;
    Prop1: TProperty;
begin
  Successish:=DeleteBinderyObject(UserName, OT_USER);
  if Successish=TRUE then
  begin
    if CreateBinderyObject(UserName, OT_USER, 0, $31)=FALSE then Successish:=False
    else begin
      CreateProperty(UserNAme, OT_USER, 'UNIX_USER', 0, $30);
      CreateProperty(UserName, OT_USER, 'SECURITY_EQUALS', BF_SET, $31);
      CreateProperty(UserName, OT_USER, 'GROUPS_I''M_IN', BF_SET, $32);
      For Int3:=1 to 128 do Prop1[Int3]:=0;
      StrPCopy(Addr(Prop1), Edit1.Text);
      WritePropertyValue(UserName, OT_USER, 'UNIX_USER', 1, Prop1, False);
      {Security}
      if CheckBox1.Checked then AddBinderyObjectToSet(UserName, OT_USER,
        'SECURITY_EQUALS','SUPERVISOR', OT_USER)
      else AddBinderyObjectToSet(UserName, OT_USER,'SECURITY_EQUALS','EVERYONE', OT_USER_GROUP);
      {Groups}
      AddBinderyObjectToSet(UserName, OT_USER, 'GROUPS_I''M_IN','EVERYONE', OT_USER_GROUP);
      {Set Password}
      if ChangeEncrBinderyObjectPassword(Username, OT_USER, '', GetNewPass)=FALSE then
        MessageDlg('There was an error setting the password. The password is empty!', mtwarning, [mbOK], 0);
    end;
  end;
   if Successish=FALSE then MessageDlg('Failed. Sorry.', mtError, [mbOK], 0) else
   MessageDlg('Password Changed.', mtError, [mbOK], 0);
end;

end.
