{$X+,B-,V-}
program test;

{ Test program for the nwMess unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Test the following nwMess functions:

  BroadcastToConsole
  GetBroadcastMessage
  GetBroadCastMode
  SetBroadcastMode
  SendBroadcastMessage
  SendConsoleBroadcast

}

uses nwmisc,nwMess;

Var t,tbm,bm:byte;
    connL,connResultL:TconnectionList;
    mess    :string;

Procedure DisplayBrMode(bm:byte);
begin
 Case bm of
 00: begin writeln('Server Stores : Netware Messages and User Messages,');
           writeln('Shell automaticly displays messages.')
     end;
 01: begin writeln('Server Stores : Server Messages. (User messages discarded)');
           writeln('Shell automaticly displays messages.')
     end;
 02: begin writeln('Server stores : Server messages only.');
           writeln('Applications have to use GetBroadCastMessage to see if there is a message.')
     end;
 03: begin writeln('Server stores : Server messages and User messages.');
           writeln('Applications have to use GetBroadCastMessage to see if there is a message.')
     end;
 else writeln('Unknown broadcastMode')
 end; {case}
end;

begin
writeln;
writeln('Testing BroadcastToConsole..');
writeln('This will make the server beep ! (NOT an error this time)');
writeln;
writeln('<Return> to continue..');
readln(mess);

if BroadcastToConsole('Hello, Console Operator!')
 then writeln('BroadcastToConsole: Msg was broadcasted..')
 else writeln('Broadcast To Console error:'+hexstr(nwMess.result,2));

writeln;
if GetBroadcastMode(bm)
 then begin
      writeln('GetBroadcastMode: $',HexStr(bm,2));
      DisplayBrMode(bm);

      t:=3;
      while (t>=0) and (t<=3)
       do if SetBroadcastMode(t) and GetBroadcastMode(tbm) and (tbm=t)
           then dec(t) { ok, try next mode, alowed modes: 0,1,2,3 }
           else begin
                writeln('SetBroadcastMode/GetBroadcastMode test failed.');
                t:=$80;
                end;

      if t=byte(-1)
       then begin
            SetBroadCastMode(bm); { restore old broadcastmode.. }
            if nwmess.result=$00
             then begin
                  writeln;
                  writeln('SetBroadcastMode tested OK..');
                  end
             else writeln('SetBroadcastMode error: Old mode couldn''t be restored..');
            end;
      end
 else writeln('GetBroadcastMode error:'+hexstr(nwMess.result,2));

writeln;
for t:=1 to 20 do connL[t]:=t;
IF sendBroadcastMessage('Hello u there!',20,connL,connResultL)
 then begin
      writeln('SendBroadcastMessage: Msg was broadcasted..');
      writeln('--and displayed at the folowing connections:');
      for t:=1 to 20 do if connResultL[t]=$00 then write(t,' ');
      writeln;
      end
 else writeln('SendBroadcastMessage error:'+hexstr(nwMess.result,2));

writeln;
IF SendConsoleBroadcast('Testmessage from Console-operator..',0,connL)
 then writeln('SendConsoleBroadcast: console message sent.')
 else begin
      write('SendConsoleBroadCast: Error ');
      if nwMess.result=$C6
       then writeln('! You need to have console privileges..')
       else writeln(HexStr(nwMess.result,2));
      end;

GetBroadCastMode(bm);

writeln;
if SetBroadCastMode(3) { store all messages at the server, no notification.. }
 then begin
      writeln('Test of getBroadCastMessage..');
      writeln('--use SEND on another workstation and send a message to this station.');
      writeln;
      writeln('Polling for a message.....');
      REPEAT {} UNTIL GetBroadCastMessage(mess);
      writeln('Message: ',mess);
      end;

SetBroadCastMode(bm); { restore broadcastmode }

end.