{$X+,B-,V-}
program SendHello;

{ Simple IPX demonstration program with 1 ESR.}

uses crt,nwMisc,nwIPX;

CONST IOSocket=$5678;

Var NewStack   :array[1..512] of word; { !! used by ESR }
    StackBottom:word;                  { !! used by ESR }

    SendEcb    :Tecb;
    IpxHdr     :TipxHeader;
    socket     :word;
    dest       :TinternetworkAddress;
    buf        :array[1..546] of byte;
    t          :byte;
    w          :word;
    s          :string;
    PacketSent :boolean;

{$F+}
Procedure SendESRhandler;
begin
PacketSent:=true;
end;
{$F-}

{$F+}
Procedure SendESR; assembler;
asm { ES:SI are the only valid registers when entering this procedure ! }
    mov dx, seg stackbottom
    mov ds, dx

    mov dx,ss  { setup of a new local stack }
    mov bx,sp  { ss:sp copied to dx:bx}
    mov ax,ds
    mov ss,ax
    mov sp,offset stackbottom
    push bx
    push dx

    CALL SendEsrHandler

    pop dx
    pop bx
    mov sp,bx { restore stack }
    mov ss,dx
end;
{$F-}

begin
IF NOT IpxInitialize
 then begin
      writeln('Ipx needs to be installed.');
      halt(1);
      end;
socket:=IOSocket;
IF NOT IPXopenSocket(Socket,SHORT_LIVED_SOCKET)
 then begin
      writeln('IPXopenSocket returned error# ',nwIPX.result);
      halt(1);
      end;

for t:=1 to 4 do dest.net[t]:=$00; { this net / segment }
for t:=1 to 6 do dest.node[t]:=$FF; { all nodes }
dest.socket:=IOsocket;
w:=0;

Repeat
  inc (w);

  { Fill buffer (ECB.fragment[2]^) }
  str(w:4,s);
  s:=s+' IPX: Hello World';
  FillChar(buf,546,#0);
  move(s[1],buf,ord(s[0]));

  { setup ECB and IPX header }
  PacketSent:=False;
  IPXsetupSendECB(Addr(SendESR),IOsocket,dest,@buf,ord(s[0]),
                  IpxHdr,SendEcb);
  IPXsendPacket(SendEcb);

  REPEAT

  IpxRelinquishControl;
  delay(100);

  IF PacketSent
   then begin
        { ECB.InUseFlag was lowered, now determine if packet was sent: }
        CASE SendEcb.CompletionCode OF
         $00:writeln('IPX packet #',w:0,' was sent.');
         $FC:writeln('The send of packet #',w:0,' was canceled.');
             { impossible, as this cancelation to be done by THIS program, and it doesn't }
         $FD:writeln('Packet# ',w:0,' is malformed and was not sent.');
             { illegal param: packet length, number of fragments, fragment size. }
         $FE:writeln('Packet# ',w:0,' was undelivered. No stations listening.');
         $FF:writeln('Packet# ',w:0,' not sent due to a hardware error.');
        end;
        end;

  UNTIL PacketSent or Keypressed;

  delay(750); { delay 0.75 sec before sending another packet }

UNTIL keypressed;

IF NOT IPXcloseSocket(IOsocket)
then writeln('IPXcloseSocket returned error# ',nwIPX.result);

end.