{$X+,V-,B-}
program tstconn2;

{ Testprogram for the nwConn unit / NwTP 0.6 API. (c) 1993, 1995, R.Spronk }

{ Purpose: testing of nwConn calls }

{ Tests the following nwConn functions:

  GetConnectionIdTable
  GetEndOfJobStatus
  GetPrimaryConnectionId
  GetNetwareErrorMode
  GetNetwareShellVersion
  GetWorkstationEnvironment
  SetEndOfJobStatus
  SetNetwareErrorMode
  SetPrimaryConnectionId

}

uses nwMisc,nwConn;

Var MajorVersion,MinorVersion,RevisionLevel:byte;
    OStype,OSversion,HardwareType,ShortHWType :string;

    primConnId,TestConnId:byte;

    c:byte;
    ConnInfo:TconnectionIDtableEntry;

    status,status1:boolean;

    mode,mode1:byte;

begin
Writeln('Testing GetNWshellVersion.');
IF GetNetwareShellVersion(MajorVersion,MinorVersion,RevisionLevel)
 then begin
      write(' Shell version: ',MajorVersion,'.',Minorversion);
      if RevisionLevel>0
       then writeln(' Rev.',chr(ord('A')+RevisionLevel-1))
       else writeln;
      if MajorVersion>=3
       then begin
            writeln;
            Writeln('Testing GetWSEnvironment.');
            IF GetWorkstationEnvironment(OStype,OSversion,
                              HardwareType,ShortHWType)
             then begin
                  writeln(' OStype      :',OStype);
                  writeln(' OSversion   :',OSversion);
                  writeln(' HardwareType:',HardwareType);
                  writeln(' ShortHWtype :',ShortHWtype);
                  end
             else writeln('GetWSenvironment returned error#:',HexStr(nwConn.result,2));



            end;
      end
 else writeln('GetNWshellversion returned error#:',HexStr(nwConn.result,2));

writeln;
writeln('Tesing SetPrimaryConnectionId.');
GetPrimaryConnectionId(primConnId);
writeln(' Primary connId=',primConnId);
IF SetPrimaryConnectionId(0)
 then begin
      writeln(' OK. prim.connid set to 0');
      GetPrimaryConnectionId(testConnId);
      if testConnId<>0
       then writeln('ERR. primary connection wasn''t changed.');
      end;
SetPrimaryConnectionId(primConnId);
GetPrimaryConnectionId(testConnId);
If testConnId=primConnId
 then writeln(' Primary connId reset to ',testConnId)
 else writeln('Error setting primary connectionId');

writeln;
writeln('Testing GetConnectionIDtable.');
for c:=1 to 8
 do begin
    GetConnectionIdTable(c,ConnInfo);
    if ConnInfo.SlotInuse>0
     then with ConnInfo
          do begin
             writeln(' Data for server with connId=',c);
             Writeln('  Adress of server :$',HexDumpstr(ServerAddress,24),' (net,node HI-LO, socket LO-HI)');
             Writeln('  Router address   :$',HexDumpStr(RouterAddress,12));
             writeln('  My connection Nbr:',ConnectionNumber);
             writeln('  Connection Status:$',hexStr(connectionStatus,2));

             end;

    end;

writeln;
writeln('Testing Set/Get endOfJobStatus');
GetEndOfJobStatus(status);
SetEndOfJobStatus(NOT status);
GetEndOfJobStatus(status1);
if status1=NOT status
 then writeln(' Tested OK.')
 else writeln(' Error: test failed.');
SetEndOfJobStatus(status);
GetEndOfJobStatus(status1);
if status1=status
 then writeln(' EOJ status reset to original mode.')
 else writeln('Err: status not reset to original mode.');

writeln;
writeln('Testing Set/Get netwareErrorMode.');
GetNetwareErrorMode(mode);
SetNetwareErrorMode(2);
GetNetwareErrorMode(mode1);
if mode1=2
 then writeln(' Tested OK.')
 else writeln(' Error: test failed.');
SetNetwareErrorMode(mode);
GetNetwareErrorMode(mode1);
if mode1=mode
 then writeln(' Error Mode reset to original mode.')
 else writeln('Err: error mode not reset to original mode.');

end.