/***************************************************************************
 * part.c - Routines for handling disk partitions
 *
 * Copyright (C) 1995 Claus Tondering, ct@login.dknet.dk
 * This file may be redistributed under the terms of the GNU Public License.
 ***************************************************************************/
 
#include <string.h>
#include <sys/types.h>
#include "genhd.h"
#include "part.h"
#include "diskio.h"
#include "ext2_fs.h"
#include "e2err.h"


struct firstsector fs, fs2;

#if 0
void dump_sector(struct firstsector *);
#endif

/**********************************************************************
 * get_part() fetches 16 partition descriptors from the disk.
 *
 * Returns error code.
 **********************************************************************/

int
get_part(int disk, struct part_desc *pl)
{
	int i, next, err;
	long startsect, offset;

#if 0
	printf("Reading sector 0\n");
#endif
	err=readdisk(disk, 0, 1, &fs);
	if (err) return err;

#if 0
	dump_sector (&fs);
#endif

	if (fs.magic!=FIRST_SECT_MAGIC)
		return E2E_BADPART;
	
	memset(pl,0,sizeof(*pl)*16);
	for (i=0; i<4; i++) {
		if (fs.part[i].sys_ind) {
			pl[i].is_extended = fs.part[i].sys_ind==EXTENDED_PARTITION;
			pl[i].start = fs.part[i].start_sectlo+(fs.part[i].start_secthi<<16);
			pl[i].length = fs.part[i].nr_sectslo+(fs.part[i].nr_sectshi<<16);
			pl[i].parttype = fs.part[i].sys_ind;
		}
	}
	next=4;

	for (i=0; i<4; i++) {
		if (fs.part[i].sys_ind==EXTENDED_PARTITION) {
			startsect = pl[i].start;
			offset = 0;
			while (1) {
				if (next==16)
					return 0;

#if 0
				printf("Reading sector 0x%x\n", startsect+offset);
#endif
				err=readdisk(disk, startsect+offset, 1, &fs2);
				if (err) return err;
				
#if 0
				dump_sector (&fs2);
#endif

				if (fs2.magic!=FIRST_SECT_MAGIC)
					return E2E_BADPART;

				pl[next].start = startsect + offset + fs2.part[0].start_sectlo+(fs2.part[0].start_secthi<<16);
				pl[next].length = fs2.part[0].nr_sectslo+(fs2.part[0].nr_sectshi<<16);
				next++;
				if (fs2.part[1].sys_ind!=EXTENDED_PARTITION)
					break;
				offset = fs2.part[1].start_sectlo+(fs2.part[1].start_secthi<<16);
			}
		}
	}
	return 0;
}


/**********************************************************************
 * getfstype finds the type of the file system on the partition.
 * It is not very good at it, but it identifies ext2 file systems,
 * which is the important thing.
 *
 * Returns the file system type or a negative error code.
 **********************************************************************/

int
getfstype(int disk, unsigned short parttype, unsigned long start)
{
	static union {
		u_char	bytes[512];
		u_short shorts[256];
		u_long	longs[128];
	} testblock;
	int err;

	if (parttype == PART_SWAP)
		return SWAP;

	if (parttype == PART_DOS32)
		return MSDOSFS;

	err=readdisk(disk, start, 1, &testblock);
	if (err) return -err;

#if 0
	if (strncmp(testblock.bytes+3,"MSDOS",5)==0) /* There must be a better way to do this */
		return MSDOSFS;
#endif

	err=readdisk(disk, start+2, 1, &testblock);
	if (err) return -err;

	if (testblock.shorts[28]==EXT2_SUPER_MAGIC)
		return EXT2FS;

	err=readdisk(disk, start+7, 1, &testblock);
	if (err) return -err;

	if (memcmp(testblock.bytes+0x1f6, "SWAP-SPACE", 10)==0)
		return SWAP;

	return 0;
}

#if 0
void dump_sector(struct firstsector *f)
{
	int i;

	printf("Initial 0x1be bytes:");
	for (i=0; i<0x1be; i++) {
		if ((i&0xf)==0) printf("\n");
		printf("%02x ",f->fill[i]);
	}
	
	for (i=0; i<4; i++) {
		printf("\nPartition descriptor %i:\n",i);
		printf("    boot_ind: %02x\n",f->part[i].boot_ind);
		printf("    head: %02x\n",f->part[i].head);
		printf("    sector: %02x\n",f->part[i].sector);
		printf("    cyl: %02x\n",f->part[i].cyl);
		printf("    sys_ind: %02x\n",f->part[i].sys_ind);
		printf("    end_head: %02x\n",f->part[i].end_head);
		printf("    end_sector: %02x\n",f->part[i].end_sector);
		printf("    end_cyl: %02x\n",f->part[i].end_cyl);
		printf("    start_sectlo: %04x\n",f->part[i].start_sectlo);
		printf("    start_secthi: %04x\n",f->part[i].start_secthi);
		printf("    nr_sectslo: %04x\n",f->part[i].nr_sectslo);
		printf("    nr_sectshi: %04x\n",f->part[i].nr_sectshi);
	}

	printf("Magic: %04x\n",f->magic);
	printf("----------------------------------------\n");
}
#endif
