// Test.cpp : Defines the entry point for the application.
//

#include "ux.h"
#include "resource.h"

#define NOLOAD 999
#define MAX_LOADSTRING 256
#define REGSTR_PATH_CONFIG  ("Software\\EMb Productions\\Ux")

// Global Variables:
HDC			hDC;
HBITMAP		hLinuxBM;
HINSTANCE	hInst;						// current instance
TCHAR		szTitle[MAX_LOADSTRING];	// The title bar text
TCHAR		szEmail[MAX_LOADSTRING];	// email address
TCHAR		szManual[MAX_LOADSTRING];
TCHAR		szLoadLin[MAX_LOADSTRING];
TCHAR		szBuffer[256];
TCHAR		szCmdLine[256];
UINT		idTimer;

TCHAR szRecent1[256];
TCHAR szRecent2[256];
TCHAR szRecent3[256];
TCHAR szRecent4[256];

TCHAR szRoot1[256];
TCHAR szRoot2[256];
TCHAR szRoot3[256];
TCHAR szRoot4[256];


// Foward declarations of functions included in this code module:
LRESULT CALLBACK	Splash (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	Config(HWND, UINT, WPARAM, LPARAM);
void				UpdateCmdLine(HWND hDlg, bool bNoLL);
bool				SelectFileDlg(HWND hDlg, LPSTR szFile, int nSize, LPSTR szTitle, LPSTR szFilter);
HBITMAP				LoadBitmapFromFile(HWND hwnd, LPSTR szBitmapFile);



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	//	HACCEL hAccelTable;
	//	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TEST);

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDS_EMAIL, szEmail, MAX_LOADSTRING);
	LoadString(hInstance, IDS_MANUAL, szManual, MAX_LOADSTRING);
	LoadString(hInstance, IDS_LOADLIN, szLoadLin, MAX_LOADSTRING);

	hInst = hInstance;
	

	LRESULT res = DialogBox(hInstance, (LPCTSTR)IDD_CONFIG, NULL, (DLGPROC)Config);
	if (res == NOLOAD)
		return 1;
	else
		DialogBox(hInstance, (LPCTSTR)IDD_SPLASH, NULL, (DLGPROC)Splash);
	return 0;
}





// Mesage handler for Splash picture.
LRESULT CALLBACK Splash(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:	
			{
				
				DWORD dwPenguin=IDC_INTERNAL;
				DWORD dwValType=REG_SZ;
				LONG res; HKEY skey; DWORD valtype, valsize, val;
				TCHAR szBuffer[256];
				DWORD dwBufferSize;

				SetWindowText(hDlg, szTitle);

				res=RegOpenKeyEx(HKEY_CURRENT_USER, REGSTR_PATH_CONFIG, 0, KEY_ALL_ACCESS, &skey);
				if (res!=ERROR_SUCCESS) {
					MessageBox(hDlg, "Error reading registry\nWrong settings, reconfigure ux!", "ux Error", MB_OK);
					EndDialog(hDlg, NOLOAD);
				}

				valsize=sizeof(val); 
				res=RegQueryValueEx(skey,"Use Penguin",0,&valtype,(LPBYTE)&val,&valsize);
				if (res==ERROR_SUCCESS) dwPenguin=val;
				else {
					MessageBox(hDlg, "Error reading registry\nWrong settings, reconfigure ux!", "ux Error", MB_OK);
					EndDialog(hDlg, NOLOAD);
				}

				switch (dwPenguin)
				{
					case IDC_INTERNAL:
						{
							hLinuxBM = LoadBitmap(hInst, (LPCTSTR)IDB_BITMAP1);
						}
						break;
					case IDC_POTHER:
						{
							dwBufferSize=sizeof(szBuffer);
							res=RegQueryValueEx(skey, "Picture", NULL, &dwValType, (LPBYTE)&szBuffer, &dwBufferSize);
							if (res==ERROR_SUCCESS)	{
								hLinuxBM = LoadBitmapFromFile(hDlg, szBuffer);
								if (hLinuxBM == (HBITMAP) (-1)) {

									if (MessageBox(hDlg, "Unable to load bitmapfile!\nContinue to load Linux?", "Warning", MB_YESNO | MB_ICONEXCLAMATION)==IDNO) {
										EndDialog(hDlg, NOLOAD);
									} else {
										hLinuxBM = LoadBitmap(hInst, (LPCTSTR)IDB_BITMAP1);
									}
								}
							}
						}

				}

				RegCloseKey(skey);
				SetWindowPos(hDlg, HWND_TOPMOST, 0, 0, 0, 0, 
					SWP_NOSIZE | SWP_NOMOVE);

				idTimer = SetTimer(hDlg, IDT_TIMER, 4000, NULL);
				return TRUE;
			}

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				DeleteObject(hLinuxBM);
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
		case WM_PAINT:
			{
				PAINTSTRUCT     ps; 
				HDC             hMemDC; 
				BITMAP          bm; 
				HBITMAP         hOldBm; 
				RECT            rectClient; 
				int             x, y; 
				

				GetDC(hDlg);
				BeginPaint(hDlg, &ps);

				//
				 
                hMemDC = CreateCompatibleDC(ps.hdc); 
 
                // Select our logo bitmap 
                hOldBm = (HBITMAP) SelectObject(hMemDC, hLinuxBM); 				
                GetObject(hLinuxBM, sizeof(BITMAP), (LPSTR)&bm); 
 
                SetWindowPos(hDlg, HWND_TOPMOST, 
					(GetSystemMetrics(SM_CXSCREEN)-bm.bmWidth)/2
					- GetSystemMetrics(SM_CXEDGE)-1,
					(GetSystemMetrics(SM_CYSCREEN)-bm.bmHeight)/2
					- GetSystemMetrics(SM_CYCAPTION)
					- GetSystemMetrics(SM_CYEDGE)-2, 
					bm.bmWidth+2*GetSystemMetrics(SM_CXEDGE)+2, 
					bm.bmHeight+2*GetSystemMetrics(SM_CYEDGE)+
					GetSystemMetrics(SM_CYCAPTION)+2,
					SWP_SHOWWINDOW);

				GetClientRect(hDlg, &rectClient); 
				x = (rectClient.right - bm.bmWidth) / 2; 
                y = (rectClient.bottom - bm.bmHeight) / 2; 
				x > 3 ? x : 0;
				y > 3 ? y : 0;
			
 
                // Now bitblt our logo into the client area 
                BitBlt(ps.hdc, x, y, bm.bmWidth, bm.bmHeight, 
					hMemDC, 0, 0, SRCCOPY); 
				//TransparentBlt(ps.hdc, x, y, bm.bmWidth, bm.bmHeight, 
				//	hMemDC, 0, 0, bm.bmWidth, bm.bmHeight, RGB(0,0,255));
 
                // Clean up 
                SelectObject(hMemDC,hOldBm); 
                DeleteDC(hMemDC); 

				ReleaseDC(hDlg, hDC);
				EndPaint(hDlg, &ps); 
			}
			return TRUE;
			break;
		case WM_TIMER:
			{
				//TCHAR		szFile[256];
				TCHAR		szMessage[256];

				KillTimer(hDlg, idTimer);
				GetCurrentDirectory(256, szBuffer);
				//wsprintf(szFile, __TEXT("loadlin.exe\0"));
				
				if ( (int) ShellExecute(hDlg, "open", szLoadLin, szCmdLine, szBuffer, SW_SHOWNA) < 33) {
					wsprintf(szMessage, __TEXT("Can't find %s in:\n %s"), szLoadLin, szBuffer);
					MessageBox(hDlg, szMessage, "Error loading Linux", MB_OK);
					EndDialog(hDlg, TRUE);
				}
				// Windows will terminate the program itself,
				// No need to do it:
				
				//DeleteObject(hLinuxBM);
				//EndDialog(hDlg, 0);
			}
			return TRUE;

	}
    return FALSE;
}


LRESULT CALLBACK Config(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			{	
				DWORD RO=IDC_RO;
				DWORD dwPinguin=IDC_INTERNAL;
				DWORD dwValType=REG_SZ;
				LONG res; HKEY skey; DWORD valtype, valsize, val;
				
				TCHAR szPicture[256];
				TCHAR szOptions[256];

				DWORD dwBufferSize;				
				HWND hWndCombo;

				//Read-only - read-write				
				res=RegOpenKeyEx(HKEY_CURRENT_USER,REGSTR_PATH_CONFIG,0,KEY_ALL_ACCESS,&skey);
				if (res!=ERROR_SUCCESS) {
					wsprintf(szBuffer, __TEXT("Welcome!\n\nThis program will load Linux for you, but only if it has\nthe right settings!!\n\nBecause UX uses loadlin.exe, you should\nread MANUAL.TXT first before using this program.\n\nPress YES to open this file, or NO to resume..."));
					res=MessageBox(hDlg, szBuffer, "Welcome to ux", MB_YESNO);
					if (res==IDYES) ShellExecute(hDlg, "open", szManual, NULL, NULL, SW_SHOWNORMAL);
				}
				valsize=sizeof(val); 
				res=RegQueryValueEx(skey,"Mount root device ro",0,&valtype,(LPBYTE)&val,&valsize);
				if (res==ERROR_SUCCESS) RO=val;
				CheckRadioButton(hDlg, IDC_RO, IDC_RW, RO);

				//internal picture
				res=RegQueryValueEx(skey,"Use Penguin",0,&valtype,(LPBYTE)&val,&valsize);
				if (res==ERROR_SUCCESS) dwPinguin=val;
				CheckRadioButton(hDlg, IDC_INTERNAL, IDC_POTHER, dwPinguin);
				if (dwPinguin==IDC_INTERNAL) {
					EnableWindow(GetDlgItem(hDlg, IDC_PICBROWSE), FALSE);
					EnableWindow(GetDlgItem(hDlg, IDC_PICTURE), FALSE);
				}

				//other picture
				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Picture", NULL, &dwValType, (LPBYTE)&szPicture, &dwBufferSize);
				if (res==ERROR_SUCCESS)	
					SetDlgItemText(hDlg, IDC_PICTURE, szPicture);
			
				
				hWndCombo=GetDlgItem(hDlg, IDC_IMAGE);
				
				//recent images:
				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent Linux Image 1", NULL, &dwValType, (LPBYTE)&szRecent1, &dwBufferSize);
				SetDlgItemText(hDlg, IDC_IMAGE, szRecent1);
				if (res!=ERROR_SUCCESS)	wsprintf(szRecent1, ("%s"), "vmlinuz");
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRecent1);
				

				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent Linux Image 2", NULL, &dwValType, (LPBYTE)&szRecent2, &dwBufferSize);
				if (res!=ERROR_SUCCESS)	wsprintf(szRecent2, ("%s"), "zImage");
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRecent2);

				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent Linux Image 3", NULL, &dwValType, (LPBYTE)&szRecent3, &dwBufferSize);
				if (res!=ERROR_SUCCESS)	wsprintf(szRecent3, ("%s"), "bzImage");
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRecent3);
				
				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent Linux Image 4", NULL, &dwValType, (LPBYTE)&szRecent4, &dwBufferSize);
				if (res==ERROR_SUCCESS) SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRecent4);

				
				//Recent root devices
				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent root device 1", NULL, &dwValType, (LPBYTE)&szRoot1, &dwBufferSize);
				SetDlgItemText(hDlg, IDC_ROOT, szRoot1);
				if (res!=ERROR_SUCCESS)	wsprintf(szRoot1, ("%s"), "/dev/hda3");
				hWndCombo=GetDlgItem(hDlg, IDC_ROOT);
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRoot1);
				
				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent root device 2", NULL, &dwValType, (LPBYTE)&szRoot2, &dwBufferSize);
				if (res!=ERROR_SUCCESS)	wsprintf(szRoot2, ("%s"), "/dev/hdb1");
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRoot2);

				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent root device 3", NULL, &dwValType, (LPBYTE)&szRoot3, &dwBufferSize);
				if (res!=ERROR_SUCCESS)	wsprintf(szRoot3, ("%s"), "/dev/hdc1");
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRoot3);

				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Recent root device 4", NULL, &dwValType, (LPBYTE)&szRoot4, &dwBufferSize);
				if (res!=ERROR_SUCCESS) wsprintf(szRoot4, ("%s"), "/dev/hdc2");
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) szRoot4);

				//Other loadlin options
				dwBufferSize=sizeof(szBuffer);
				res=RegQueryValueEx(skey, "Other loadlin options", NULL, &dwValType, (LPBYTE)&szOptions, &dwBufferSize);
				if (res==ERROR_SUCCESS)	SetDlgItemText(hDlg, IDC_OTHER, szOptions);

				//last recent listitems
				res=RegQueryValueEx(skey,"Recent image",0,&valtype,(LPBYTE)&val, &valsize);
				if (res==ERROR_SUCCESS)
					SendMessage(GetDlgItem(hDlg,IDC_IMAGE), CB_SETCURSEL, (WPARAM) val, 0);

				res=RegQueryValueEx(skey,"Recent device",0,&valtype,(LPBYTE)&val, &valsize);
				if (res==ERROR_SUCCESS) 
					SendMessage(GetDlgItem(hDlg,IDC_ROOT), CB_SETCURSEL, (WPARAM) val, 0);



				RegCloseKey(skey);
				UpdateCmdLine(hDlg, FALSE);
			}
			return TRUE;
		case WM_KEYUP:
				{ 
					UpdateCmdLine(hDlg,FALSE);
					return TRUE;
				}			
		case WM_COMMAND:
			switch (HIWORD(wParam)) {
				case CBN_CLOSEUP:
					{
						UpdateCmdLine(hDlg, FALSE);
						return TRUE;					
					}
				case CBN_EDITCHANGE:
					{
						UpdateCmdLine(hDlg, FALSE);
						return TRUE;
					}

					break;
			}
			switch (LOWORD(wParam)) {
				case IDOK:
					{
						//save configuration to registry
						UINT i=0;
						LONG res; HKEY skey; DWORD val, disp;
						TCHAR szShort[256];
						DWORD dwBufsize;
						dwBufsize=sizeof(szBuffer);
						res=RegCreateKeyEx(HKEY_CURRENT_USER,REGSTR_PATH_CONFIG,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&skey,&disp);
						if (res!=ERROR_SUCCESS) {
							MessageBox(hDlg, "Error writing to registry!\nReconfigure ux", "ux serious error", MB_OK);
							EndDialog(hDlg, NOLOAD);
						}

						//first all dwords:ro/rw and internal picture
						(IsDlgButtonChecked(hDlg, IDC_RO)==BST_CHECKED) ? val=IDC_RO : val=IDC_RW;
						RegSetValueEx(skey,"Mount root device ro", 0, REG_DWORD, (CONST BYTE*)&val, sizeof(val));
						(IsDlgButtonChecked(hDlg, IDC_INTERNAL)==BST_CHECKED) ? val=IDC_INTERNAL : val=IDC_POTHER;
						RegSetValueEx(skey,"Use Penguin", 0, REG_DWORD, (CONST BYTE*)&val, sizeof(val));

						val=SendMessage(GetDlgItem(hDlg, IDC_IMAGE), CB_GETCURSEL, 0, 0);
						if (val!=CB_ERR)
							RegSetValueEx(skey,"Recent image", 0, REG_DWORD, (CONST BYTE*)&val, sizeof(val));


						val=SendMessage(GetDlgItem(hDlg, IDC_ROOT), CB_GETCURSEL, 0, 0);
						if (val!=CB_ERR)
							RegSetValueEx(skey,"Recent device", 0, REG_DWORD, (CONST BYTE*)&val, sizeof(val));


						
						//strings:
						GetDlgItemText(hDlg, IDC_PICTURE, szBuffer, dwBufsize);
						RegSetValueEx(skey, "Picture", 0, REG_SZ, (CONST BYTE*)&szBuffer, dwBufsize);

						GetDlgItemText(hDlg, IDC_OTHER, szBuffer, dwBufsize);
						RegSetValueEx(skey, "Other loadlin options", 0, REG_SZ, (CONST BYTE*)&szBuffer, dwBufsize);

						GetDlgItemText(hDlg, IDC_IMAGE, szBuffer, dwBufsize);
						if (GetShortPathName(szBuffer, szShort, sizeof(szShort)) == 0) {
							MessageBox(hDlg, "No valid Linux kernel image selected", "Error", MB_OK|MB_ICONEXCLAMATION);
							SetFocus(GetDlgItem(hDlg, IDC_IMAGE));
							return FALSE;
						}
						if (_tcscmp(szBuffer, szRecent1)!=0 &&
							_tcscmp(szBuffer, szRecent2)!=0 &&
							_tcscmp(szBuffer, szRecent3)!=0 &&
							_tcscmp(szBuffer, szRecent4)!=0) {
							wsprintf(szRecent4, szRecent3);
							wsprintf(szRecent3, szRecent2);
							wsprintf(szRecent2, szRecent1);
							wsprintf(szRecent1, szBuffer);
							val=0;
							RegSetValueEx(skey,"Recent image", 0, REG_DWORD, (CONST BYTE*)&val, sizeof(val));
						}						
						RegSetValueEx(skey, "Recent Linux Image 1", 0, REG_SZ, (CONST BYTE*)&szRecent1, dwBufsize);
						RegSetValueEx(skey, "Recent Linux Image 2", 0, REG_SZ, (CONST BYTE*)&szRecent2, dwBufsize);
						RegSetValueEx(skey, "Recent Linux Image 3", 0, REG_SZ, (CONST BYTE*)&szRecent3, dwBufsize);
						RegSetValueEx(skey, "Recent Linux Image 4", 0, REG_SZ, (CONST BYTE*)&szRecent4, dwBufsize);

						GetDlgItemText(hDlg, IDC_ROOT, szBuffer, dwBufsize);
						if (_tcslen(szBuffer)==0) {
							MessageBox(hDlg, "No root device entered!", "Error", MB_OK|MB_ICONEXCLAMATION);
							SetFocus(GetDlgItem(hDlg, IDC_ROOT));
							return FALSE;
						}
						while ((szBuffer[i]!='/') && (i<=_tcslen(szBuffer))) {
							i++;
						}
						if ((szBuffer[i]!='/') ||
							(szBuffer[i+1]!='d') ||
							(szBuffer[i+2]!='e') ||
							(szBuffer[i+3]!='v') ||
							(szBuffer[i+4]!='/')
							) {
							MessageBox(hDlg, "Root device doesn't contain the string \"/dev/\" !", "UX error", MB_OK|MB_ICONEXCLAMATION);
							SetFocus(GetDlgItem(hDlg, IDC_ROOT));
							return FALSE;
						}


						if (_tcscmp(szBuffer, szRoot1)!=0 &&
							_tcscmp(szBuffer, szRoot2)!=0 &&
							_tcscmp(szBuffer, szRoot3)!=0 &&
							_tcscmp(szBuffer, szRoot4)!=0) {
							wsprintf(szRoot4, szRoot3);
							wsprintf(szRoot3, szRoot2);
							wsprintf(szRoot2, szRoot1);
							wsprintf(szRoot1, szBuffer);
							val=0;
							RegSetValueEx(skey,"Recent device", 0, REG_DWORD, (CONST BYTE*)&val, sizeof(val));
						}
						RegSetValueEx(skey, "Recent root device 1",  0, REG_SZ, (CONST BYTE*)&szRoot1, dwBufsize);
						RegSetValueEx(skey, "Recent root device 2",  0, REG_SZ, (CONST BYTE*)&szRoot2, dwBufsize);
						RegSetValueEx(skey, "Recent root device 3",  0, REG_SZ, (CONST BYTE*)&szRoot3, dwBufsize);
						RegSetValueEx(skey, "Recent root device 4",  0, REG_SZ, (CONST BYTE*)&szRoot4, dwBufsize);

						
						RegCloseKey(skey);

						UpdateCmdLine(hDlg, TRUE);

						//MessageBox(hDlg, szCmdLine, "loadlin Command line", MB_OK);
						EndDialog(hDlg, LOWORD(wParam));
						return TRUE;
					}
				case IDCANCEL:
					{
						EndDialog(hDlg, NOLOAD);
						return TRUE;
					}
				case IDC_INTERNAL: 
				case IDC_POTHER:
					{
						if (IsDlgButtonChecked(hDlg, IDC_INTERNAL)==BST_CHECKED)
						{
							EnableWindow(GetDlgItem(hDlg, IDC_PICBROWSE), FALSE);
							EnableWindow(GetDlgItem(hDlg, IDC_PICTURE), FALSE);
						} else {
							EnableWindow(GetDlgItem(hDlg, IDC_PICBROWSE), TRUE);
							EnableWindow(GetDlgItem(hDlg, IDC_PICTURE), TRUE);
						}
						return TRUE;
					}
				case IDC_RO:
				case IDC_RW:
					{
						UpdateCmdLine(hDlg, FALSE);
						return TRUE;
					}
				case IDC_BROWSE:
					{
						TCHAR szFile[256];
						TCHAR szShort[256];
						static char szFilter[]="Linux kernel images\0*.*\0";

						GetDlgItemText(hDlg, IDC_IMAGE, szFile, 256);
						SelectFileDlg(hDlg, (LPSTR)&szFile, sizeof(szFile), "Select a linux kernel image", szFilter);
						GetShortPathName(szFile, szShort, 256);

						SetDlgItemText(hDlg, IDC_IMAGE, szShort);
						UpdateCmdLine(hDlg, FALSE);

						return TRUE;
					}
				case IDC_PICBROWSE:
					{
						TCHAR szFile[256];
						static char szFilter[]="Bitmaps\0*.bmp\0";

						GetDlgItemText(hDlg, IDC_PICTURE, szFile, sizeof(szFile));
						SelectFileDlg(hDlg, (LPSTR)&szFile, sizeof(szFile), "Select a splash picture\0", szFilter);

						SetDlgItemText(hDlg, IDC_PICTURE, szFile);
						UpdateCmdLine(hDlg, FALSE);

						return TRUE;
					}
				case IDC_OTHER:
					{
						UpdateCmdLine(hDlg, FALSE);
						return TRUE;
					}
				case IDC_MANUAL:
					{
						//MessageBox(hDlg, "Open manual.txt", "Ux", MB_OK);
						ShellExecute(hDlg, "open", szManual, NULL, NULL, SW_SHOWNORMAL);
						return TRUE;
					}
			}			
			break;
	}
    return FALSE;
}


void UpdateCmdLine(HWND hDlg, bool bNoLL)
{
	TCHAR szBuffer[256];

	szCmdLine[0]=0;
	szBuffer[0]=0;
	//GetDlgItemText(hDlg, IDC_IMAGE, szBuffer, sizeof(szBuffer));
	SendMessage(GetDlgItem(hDlg, IDC_IMAGE), CB_GETLBTEXT, 
		SendMessage(GetDlgItem(hDlg, IDC_IMAGE), CB_GETCURSEL, 0, 0),
		(LPARAM) (LPCSTR) &szBuffer);
	if (szBuffer[0]==0) GetDlgItemText(hDlg, IDC_IMAGE, szBuffer, sizeof(szBuffer));
	if (!bNoLL)
		wsprintf(szCmdLine, TEXT("loadlin.exe %s "), szBuffer);
	else
		wsprintf(szCmdLine, TEXT("%s "), szBuffer);
		
	szBuffer[0]=0;
	//GetDlgItemText(hDlg, IDC_ROOT, szBuffer, sizeof(szBuffer));
	SendMessage(GetDlgItem(hDlg, IDC_ROOT), CB_GETLBTEXT, 
		SendMessage(GetDlgItem(hDlg, IDC_ROOT), CB_GETCURSEL, 0, 0),
		(LPARAM) (LPCSTR) &szBuffer);
	if (szBuffer[0]==0) GetDlgItemText(hDlg, IDC_ROOT, szBuffer, sizeof(szBuffer));
	_tcscat(szCmdLine, szBuffer);
	_tcscat(szCmdLine, " ");
	if (IsDlgButtonChecked(hDlg, IDC_RO)==TRUE)
		_tcscat(szCmdLine, "ro ");
	else
		_tcscat(szCmdLine, "rw ");
	szBuffer[0]=0;
	GetDlgItemText(hDlg, IDC_OTHER, szBuffer, sizeof(szBuffer));
	_tcscat(szCmdLine, szBuffer);

	SetDlgItemText(hDlg, IDC_CMDLINE, szCmdLine);
}


bool SelectFileDlg(HWND hDlg, LPSTR szFile, int nSize, LPSTR szTitle, LPSTR szFilter)
{
	OPENFILENAME ofn; 
	TCHAR szFileTitle[256];

	ofn.lStructSize = sizeof(OPENFILENAME); 
	ofn.hwndOwner = hDlg; 
	ofn.lpstrFilter = szFilter; 
	ofn.lpstrCustomFilter = (LPSTR) NULL; 
	ofn.nMaxCustFilter = 0L; 
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile; 		
	ofn.nMaxFile = nSize;
	ofn.lpstrFileTitle = szFileTitle; 
	ofn.nMaxFileTitle = sizeof(szFileTitle); 						
	ofn.lpstrInitialDir = (LPSTR) NULL; 						
	ofn.lpstrTitle = szTitle; 						
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY; 						
	ofn.nFileOffset = 0; 						
	ofn.nFileExtension = 0; 						
	ofn.lpstrDefExt = (LPSTR) NULL;					
						
	if (!GetOpenFileName(&ofn))
		return FALSE;
	else 
		return TRUE;

}






HBITMAP LoadBitmapFromFile(HWND hwnd, LPSTR szBitmapFile)
{
	HANDLE hfbm;
	HGLOBAL hmem1, hmem2;
	DWORD dwRead;
	LPVOID lpvBits;
	HBITMAP hbm;
	UINT nNumColors;

	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	LPBITMAPINFO lpbmi;
	HDC hdc;


	// Retrieve a handle identifying the file. 
 
	hfbm = CreateFile(szBitmapFile, GENERIC_READ, 
		FILE_SHARE_READ, (LPSECURITY_ATTRIBUTES) NULL, 
        OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, 
        (HANDLE) NULL); 

	// Retrieve the BITMAPFILEHEADER structure. 
 
	ReadFile(hfbm, &bmfh, sizeof(BITMAPFILEHEADER), &dwRead, 
		(LPOVERLAPPED)NULL); 

	// Retrieve the BITMAPFILEHEADER structure.  
	ReadFile(hfbm, &bmih, sizeof(BITMAPINFOHEADER), 
		&dwRead, (LPOVERLAPPED)NULL); 
 
	// Allocate memory for the BITMAPINFO structure. 
 
	hmem1 = GlobalAlloc(GHND, sizeof(BITMAPINFOHEADER) + 
		((1<<bmih.biBitCount) * sizeof(RGBQUAD))); 
 
	lpbmi = (LPBITMAPINFO) GlobalLock(hmem1); 
 
	// Load BITMAPINFOHEADER into the BITMAPINFO structure. 
 
	lpbmi->bmiHeader.biSize = bmih.biSize; 
	lpbmi->bmiHeader.biWidth = bmih.biWidth; 
	lpbmi->bmiHeader.biHeight = bmih.biHeight; 
	lpbmi->bmiHeader.biPlanes = bmih.biPlanes; 
	lpbmi->bmiHeader.biBitCount = bmih.biBitCount; 
	lpbmi->bmiHeader.biCompression = bmih.biCompression; 
	lpbmi->bmiHeader.biSizeImage = bmih.biSizeImage; 
	lpbmi->bmiHeader.biXPelsPerMeter = bmih.biXPelsPerMeter; 
	lpbmi->bmiHeader.biYPelsPerMeter = bmih.biYPelsPerMeter; 
	lpbmi->bmiHeader.biClrUsed = bmih.biClrUsed; 
	lpbmi->bmiHeader.biClrImportant = bmih.biClrImportant; 
 
	// Retrieve the color table. 
	// 1 << bmih.biBitCount == 2 ^ bmih.biBitCount 


    // no color table for 24-bit, default size otherwise 
    nNumColors = (UINT)lpbmi->bmiHeader.biClrUsed; 
    if (0 == nNumColors) 
    { 
		if (lpbmi->bmiHeader.biBitCount <= 8)
        { 
            nNumColors = 1 << lpbmi->bmiHeader.biBitCount;             // standard size table 
        } 
	} 
 
    // Fill in some default values if they are zero 
    if (0 == lpbmi->bmiHeader.biClrUsed) 
	{
		lpbmi->bmiHeader.biClrUsed = nNumColors; 
	} 


 
	ReadFile(hfbm, lpbmi->bmiColors, 
		((nNumColors) * sizeof(RGBQUAD)), 
		&dwRead, (LPOVERLAPPED) NULL); 
	 
	// Allocate memory for the required number of bytes. 
 
	hmem2 = GlobalAlloc(GHND, (bmfh.bfSize - bmfh.bfOffBits)); 
 
	lpvBits = GlobalLock(hmem2); 
 
	// Retrieve the bitmap data. 
 
	ReadFile(hfbm, lpvBits, (bmfh.bfSize - bmfh.bfOffBits), 
		&dwRead, (LPOVERLAPPED) NULL); 
 
	// Create a bitmap from the data stored in the .BMP file. 
	hdc = GetDC(hwnd); 
	hbm = CreateDIBitmap(hdc, &bmih, 
		CBM_INIT, lpvBits, 
		lpbmi, DIB_RGB_COLORS); 
	ReleaseDC(hwnd, hdc);

 
	// Unlock the global memory objects and close the .BMP file. 
 
	GlobalUnlock(hmem1); 
	GlobalUnlock(hmem2); 
	CloseHandle(hfbm); 
 
	// Set the fDisplayBitmap flag. 
 
	if (hbm)
		return hbm;
	else {
		//MessageBox 
		return (HBITMAP) -1;
	}

 
	// Paint the window (and draw the bitmap). 
 
	//	GetClientRect(hwnd, &rect); 
	///InvalidateRect(hwnd, &rect, TRUE); 
	//UpdateWindow(hwnd); 
}