/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cctype>
#include<cmath>
#include<new>
#include"mplot.h"

extern short Expander(char* s,char** strexp);

/*
** La funzione Leggi_item legge un item da expr,ossia un numero,
** un nome di funzione,un segno operazionale o una parentesi.
** Restituisce lo spiazzamento(offset) del carattere di expr
** immediatamente successivo all'item letto;in caso di
** errore,restituisce il numero dell'errore con segno negativo.
** L'item letto viene trascritto,se e' un numero,un nome di funzione
** o un segno d'operazione,in una locazione opportuna di
** lista[],servendosi della variabile ausiliaria pos,la quale
** viene posta a 0 la prima volta che la funzione viene chiamata.
** Successivamente essa viene incrementata nei seguenti casi:
** a) prima della trascrizione di un segno operazionale
** b) subito dopo tale trascrizione
** c) in corrispondenza di una parentesi aperta,a meno che
      questa non si trovi in expr[0] o non sia preceduta da
      un segno operazionale o da un'altra parentesi aperta.
** L'adozione di queste regole fa si' che i vari item siano
** trascritti in locazioni distinte di lista[] e che non com-
** paiano elementi nulli tra due item,sempreche' non siano
** stati commessi degli errori nella digitazione dell'espressione.
** Le parentesi non vengono trascritte ma provocano l'incremento
** o il decremento della variabile livello,usata per memorizzare
** il livello di parentesi corrente e posta uguale a 0 la prima volta
** che Leggi_item() viene chiamata.Sia pos che livello sono dichiarate
** static affinche' il loro valore resti in memoria tra una chiamata
** e l'altra di Leggi_item().
*/
/*
** Alla funzione viene inizialmente passato psz=expr
** da parte della procedura Check_Move;
** successivamente viene passato expr+valore di ritorno ottenuto
** con la precedente chiamata,fino a che la funzione non incontra
** il carattere nul e non restituisce -100.
*/

/* possibili valori di ritorno: >=0,-1,-9,-10,-11,-24,-100,-FATAL_ERROR */
/*
  La variabile globale nel viene utilizzata per tener conto del
  numero degli item da trascrivere in lista[]
*/

static short
Read_item(char *psz,char *expr,struct item lista[],short *nel)
{
  static short pos,livello;
  short aux;                    /* aux=Variabile ausiliaria */

  if(psz == expr)
    {
      pos = 0;       /* pos da'la posizione dell'elemento corrente di lista */
      livello = 0;   /* livello da'il livello di parentesi corrente         */
    }                /* Inizializzazione terminata */

  if(*psz == '\0')
    {
      /* nel(numero item trascritti nella lista) e' pari al valore */
      /* raggiunto da pos quando psz punta alla fine di expr incre-*/
      /* mentato di 1.                                             */
      *nel = pos + 1;   
      return -100;  
    }		      
  else if(*psz == '$')  /* il Simbolo $ identifica la costante PI */
    {
      /*(0) Prima che la funzione Leggi_Item() venga chiamata per */
      /*  la prima volta all'interno di Check_Move(),gli */
      /*  elementi di lista[] vengono tutti inizializzati in modo */
      /*  tale che .psz==NULL.Di conseguenza,se lista[pos].psz e` */
      /*  non nullo viene restituito un intero diverso da zero al */
      /*  fine di segnalare un erore di sintassi,che consiste ti- */
      /*  picamente nella mancanza di un segno operazionale o di  */
      /*  una parentesi e che provocherebbe la sovrascrittura di  */
      /*  un item di expr gia' trascritto.   */
      if (lista[pos].psz)
	return -24;
      /*(1) a lista[pos].psz viene riservata memoria per */
      /*    contenere il numero PI                       */
      lista[pos].psz = new(nothrow) char[MAX_CHAR];
      if(! lista[pos].psz)
	return -FATAL_ERROR;
      /*(2) la costante PI viene trascritta in lista[pos.psz] */
      sprintf(lista[pos].psz,"%15.13f",PI);
      /*(3) viene ritornato l'offset dell'elemento successivo all'item letto */
      return(psz+1-expr);
    }
  else if(*psz == '\?') /* il simbolo ? viene usato per indicare */
    {                   /* un parametro                          */
      /*(0) vedi quanto detto in   else if(*psz=='$') */
      if(lista[pos].psz)
	return -24;
      /*(1) a lista[pos].psz viene riservata memoria */
      lista[pos].psz = new(nothrow) char[MAX_CHAR];
      if(! lista[pos].psz)
	return -FATAL_ERROR;
      lista[pos].psz[0]='\?';
      lista[pos].psz[1]='\0';
      /*(2) lista[pos].prec viene impostato a -2 per indicare */
      /*    che lista[pos] ha a che fare con il parametro "?" */
      lista[pos].prec=-2;
      /*(3) viene ritornato l'offset dell'elemento successivo all'item letto */
      return(psz+1-expr);
    }
  else if(*psz == '!') /* il simbolo ! viene usato per indicare */
    {                  /* un parametro                          */
      /*(0) vedi quanto detto in   else if(*psz=='$') */
      if(lista[pos].psz)
	return -24;
      /*(1) a lista[pos].psz viene riservata memoria */
      lista[pos].psz = new(nothrow) char[MAX_CHAR];
      if(! lista[pos].psz)
	return -FATAL_ERROR;
      lista[pos].psz[0]='!';
      lista[pos].psz[1]='\0';
      /*(2) lista[pos].prec viene impostato a -3 per indicare */
      /*    che lista[pos] ha a che fare con il parametro "!" */
      lista[pos].prec=-3;
      /*(3) viene ritornato l'offset dell'elemento successivo all'item letto */
      return(psz+1-expr);
    }
  else if(isnumberelement(*psz)) 
    /* Se psz punta a un numberelement la fun- */
    /*zione si prepara a trascrivere un numero */
    {                              
      aux=0;
      /*(0) vedi quanto detto in   else if(*psz=='$') */
      if(lista[pos].psz)
	return -24;
      /*(1) a lista[pos].psz viene riservata memoria per contenere un numero */
      lista[pos].psz = new(nothrow) char[MAX_CHAR];
      if(! lista[pos].psz)
	return -FATAL_ERROR;
      /*(2) viene copiato in lista[pos].psz il numero individuato */
      do
	{
	  if(aux==MAX_CHAR-1)
	    return -1;  /* Segnalazione di input numerico troppo lungo */
	  lista[pos].psz[aux]=*psz;
	  aux++;
	  psz++;
	}
      while (isnumbercomponent(*psz));
      lista[pos].psz[aux]='\0';
      /*(3) terminata la copia del numero viene ritornato l'offset dello */
      /**** elemento di expr che segue il numero                         */
      return(psz-expr);   /* Rifletti! non va bene return(psz+1-expr) */
    }
  else if(isoperation(*psz))
    {
      /* viene incrementato pos affinche' il segno di operazione */
      /* venga copiato in una cella di lista[] successiva a quel-*/
      /* la corrente                                             */
      pos++;   
      if(pos>=MAX_LUN-1)
	return -10;
      /* viene ritornato -10,per segnalare l'eccesso di dati immessi */
      /*(1) memorizza in lista[pos].prec il livello di parentesi in cui */
      /*    e' collocata l'operazione                                   */
      lista[pos].prec=livello*1000;
      /*(2) a lista[pos].psz viene riservata memoria */
      lista[pos].psz = new(nothrow) char[MAX_CHAR];
      if(! lista[pos].psz)
	return -FATAL_ERROR;
      /*(3) il segno operazionale viene copiato in lista[pos].psz */
      lista[pos].psz[0]=*psz;
      lista[pos].psz[1]='\0';
      /*(4) vengono predisposte le cose affinche' l'item successivo */
      /*    venga copiato in una nuova cella di lista[]             */
      pos++;
      /*(5) viene ritornato l'offset dell'elemento di expr successivo */
      /*    all'item letto                                            */
      return(psz+1-expr);
    }
  else if(*psz=='(')
    {
      /* Se la parentesi non si trova ad inizio espressione e non e' pre- */
      /* ceduta da un segno d'operazione ne' da un'altra parentesi aperta */
      /* vengono predisposte le cose  affinche' l'item  successivo  venga */
      /* copiato nella cella successiva di lista[] rispetto a quella cor- */
      /* rente */
      if( psz > expr && !isoperation (*(psz-1)) && *(psz-1) != '(' )
	pos++;
      /* Viene incrementato il livello di parentesi; ritorna  -10 in caso */
      /* di eccesso di dati immessi o superamento del massimo livello  di */
      /* parentesi consentito...			                    */
      livello++;
      if(pos > MAX_LUN-1 || livello > 31)
	return -10;
      return(psz+ 1- expr); /* altrimenti ritorna l'offset dell'elemento */
      /*che segue l'item letto */
    }
  else if(*psz==')')
    {
      /* Viene segnalata l'uscita da un livello di parentesi e,in caso */
      /* di un eccesso di parentesi chiuse rispetto a quelle aperte,ri-*/
      /* torna -11							 */
      livello--;
      if(livello<0)
	return -11;
      return(psz+1-expr);  /* se non e` riscontrata alcuna anomalia */
                 /*il valore e` quello solito                       */
    }                            
  else       /* Si aspetta di dover leggere il nome di una funzione */
    {
      /* Ritorna -10 in caso di eccesso di dati immessi */
      if(pos==MAX_LUN-1)
	return -10;
      /* Memorizza il livello di parentesi all'interno del quale */
      /* e' annidata la funzione                                 */
      lista[pos].prec=livello*1000;
      /* Vedi quanto detto in   else if(*psz=='$') */
      if(lista[pos].psz)
	return -24;
      /* Riserva memoria a lista[pos].psz per la conservazione */
      /* del nome della funzione                               */
      lista[pos].psz = new(nothrow) char[MAX_CHAR];
      if(! lista[pos].psz)
	return -FATAL_ERROR;
      /* La lettura del nome di funzione viene interrotta al primo */
      /* carattere matematico trovato                              */
      aux=0;
      do
	{
	  if (aux == MAX_CHAR - 1)
	    return -7;	/* Segnalazione di chiamata a funzione inesistente */
	  lista[pos].psz[aux]=*psz;
	  aux++;
	  psz++;
	}
      while((*psz) && !ischarmathematic(*psz) );
      lista[pos].psz[aux]='\0';
      if(*psz=='\0' || *psz==')')
	return -9;
      /* Viene ritornato l'offset in expr dell'elemento successivo */
      /* all'ultimo item letto 		                           */
      return(psz-expr);  /* Rifletti! non va bene return(psz+1-expr) */
    }
}


/* La funzione Check_Move ha il compito di controllare se la */
/* espressione immessa e' in realta' un comando e poi di  verificarne */
/* la correttezza; da ultimo,se non si tratta di un meta-paracomando, */
/* la spezza nei suoi item costituenti e memorizza questi in lista[]. */
/* Se l'espressione e' scorretta o contiene un comando ritorna un va- */
/* lore maggiore di zero opportuno,altrimenti ritorna zero.           */

short
Check_Move (char *expr,struct item lista[],short *nel)
{
  short lun,i,j,k;                               /* lun=strlen(expr) */
  char *psz,*expr2;
  /* nolp[j]:=numero d'ordine all'interno del livello j di parentesi */
  unsigned nolp[32];

  /* Inizializzazione della lista */
  for(i=0;i<MAX_LUN;i++)         
    {
      /* Ogni elemento della lista viene posto uguale all'elemento */
      /* NULLO: .psz=NULL,.prec=-1				   */
      lista[i].psz=NULL;         
      lista[i].prec=-1;          
      lista[i].type=-1;
      lista[i].valore=0;
      lista[i].prec2=0;
    }
  *nel = 0;     /*nel:variabile globale=numero elementi lista[] non nulli*/
  /* Misura la lunghezza dell' espressione immessa */
  lun=strlen(expr);
  /* Controlla che nell'espressione non vi siano caratteri non accetta- */
  /* bili dal programma.                                                */
  for (k = 0; k < lun; k++)	
    {
      if (!ischaragreable(expr[k])) 
	return 1;
    }
  /* Ogniqualvolta il segno '-' compare in expr come operatore */
  /* unario viene sostituito con '_'.                          */
  /* Se '-' compare dopo 'E' viene sostituito con '\'',mentre, */
  /* nelle stesse condizioni,'+' viene  sostituito con  il ca- */
  /* rattere '\"'.                                             */
  Transform(expr);
  k=Expander(expr,&expr2);
  if(k!=0)
     {
       delete[] expr2; // added in data 28/11/2001
       return k; /* Si e` verificato l'errore numero k */
     }
  /* Controlla che in expr2 non compaiano due o piu'segni */
  /* di operazione l'uno di seguito all'altro; se cio'ac- */
  /* cade termina restituendo 2                           */
  for(k=0,i=0;k<lun;k++)          
    {				    
      if(isoperation(expr2[k]))    
	{
	  if(i==0)
	    i++;
	  else
	     {
	       delete[] expr2; // added in data 13/10/2001
	       return 2;
	     }
	}
      else
	i=0;
    }
  /* Controlla che in expr2 non compaiano una parentesi chiusa seguita */
  /* subito da una parentesi aperta.                                   */
  for (k=0 ; k < lun-1 ; k++)
    {
      if( (expr2[k]==')') && (expr2[k+1]=='(') )
	{
	   delete[] expr2; 
	   return 27;
	}
    }
  /* Comincia l' analisi vera e propria dell' espressione */
  psz = expr2;
  while((k=Read_item (psz,expr2,lista,nel)) >= 0)
    psz = expr2 + k;
  delete[] expr2;     /* Ormai expr2 non serve piu` */
  if(k != -100)
    return -k;	     /* Si e' verificato l'errore numero (-k) */
  else
    {
      /* A questo punto gli unici elementi di lista[] non NULLI per i */
      /* quali la precedenza e' impostata a -1 sono relativi a valori */
      /* numerici.Il ciclo che segue sostituisce il segno "-" ai  se- */
      /* gni "_" e "\'" in tutti i numeri memorizzati in lista; inol- */
      /* tre sostituisce il segno "+" al segno "\"".                  */ 
      
      for(i=0;i < *nel;i++)
	{
	  if(lista[i].psz != NULL && lista[i].prec == -1)
	    {
	      for(j = 0; j < strlen(lista[i].psz) ; j++)
		{
		  if ((lista[i].psz[j] == '_') || (lista[i].psz[j] == '\'')) 
		    lista[i].psz[j] = '-';
		  else if(lista[i].psz[j] == '\"')
		    lista[i].psz[j] = '+';
		}
	    }
	}
      for(i = 0 ; i < *nel; i++)
	/* N.B.: nel=numero elementi di lista[] non nulli*/
	{
	  if(lista[i].psz==NULL) 
	    /* Tra gli elementi di lista[]  che dovrebbero */
	    /* essere non nulli ne e` stato trovato uno nu-*/
	    /* lo; viene percio` ritornato il valore 9: es-*/
	    /* pressione vuota o argomento mancante.       */
	    return 9;
	}                          
      for(i = 0; i < 32; i++)
	nolp[i]=99;   /* Ogni livello di parentesi puo' contenere al piu' */
      /* 99 tra funzioni e operazioni                                     */

      /* Viene completata la procedura di assegnazione di un numero d'ordine */
      /* alle operazioni e funzioni che compaiono in expr2,sulla base dello  */
      /* ordine di priorita` di ciascuna; a parita` di livello  di parentesi */
      /* le funzioni hanno una precedenza superiore  alle operazioni,tra  le */
      /* quali vigono le regole di priorita' specificate ad inizio funzione. */
      /* A parita' di livello di parentesi e di priorita' operazionale vengo-*/
      /* no valutate,sia le operaz. che le funz.,secondo l'ordine di succes- */
      /* sione in expr2                                                      */
      for(i = 0; i < *nel; i++)
	{
	  if(!strcmp(lista[i].psz,"^") )
	    lista[i].prec+=800;
	  else if( !strcmp(lista[i].psz,"\\") )
	    lista[i].prec+=700;
	  else if( !strcmp(lista[i].psz,"&") )
	    lista[i].prec+=600;
	  else if( !strcmp(lista[i].psz,"%") )
	    lista[i].prec+=500;
	  else if( !strcmp(lista[i].psz,"/") )
	    lista[i].prec+=400;
	  else if( !strcmp(lista[i].psz,"*") )
	    lista[i].prec+=300;
	  else if( !strcmp(lista[i].psz,"-") )
	    lista[i].prec+=200;
	  else if( !strcmp(lista[i].psz,"+") )
	    lista[i].prec+=100;
	  else if( isupper(lista[i].psz[0]) )
	    lista[i].prec+=900;
	}
      for (i = 0; i < *nel; i++)
	{
	  if (lista[i].prec >= 0)
	    {
	      j = lista[i].prec / 1000;
	      lista[i].prec += nolp[j];	/* Tiene conto della posizione */
	      nolp[j]--;		/* dell'item  all'interno  del */
	    }			        /* livello di prentesi.        */
	}				        
      /* Fine procedura di assegnazione dei numeri d'ordine            */
      return 0;    /* Non si e' verificato nessun errore               */
    }
}


