/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include"mplot.h"
#include"open_files.h"

#if (defined(HAVE_UNISTD_H) && defined(HAVE_SYS_TYPES) && defined(HAVE_SYS_STAT) && defined(HAVE_FCNTL_H))

#include<unistd.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<cstdlib>
#include<cstdio>
#include<cstring>
#include<cerrno>

/*
struct stat
{
  dev_t         st_dev;       device 
  ino_t         st_ino;       inode 
  mode_t        st_mode;      protection 
  nlink_t       st_nlink;     number of hard links 
  uid_t         st_uid;       user ID of owner 
  gid_t         st_gid;       group ID of owner 
  dev_t         st_rdev;      device type (if inode device) 
  off_t         st_size;      total size, in bytes 
  unsigned long st_blksize;   blocksize for filesystem I/O 
  unsigned long st_blocks;    number of blocks allocated 
  time_t        st_atime;     time of last access 
  time_t        st_mtime;     time of last modification 
  time_t        st_ctime;     time of last change 
};
*/

// The next utility function returns 0 when st1 and st2 are equal,
// !0 when they are different.

static int statcmp(struct stat st1,struct stat st2)
{
  int retval=0;

  retval= (st1.st_dev != st2.st_dev) || (st1.st_ino != st2.st_ino) ;
  retval= retval || (st1.st_mode != st2.st_mode) || (st1.st_nlink != st2.st_nlink);
  retval= retval || (st1.st_uid != st2.st_uid) || (st1.st_gid != st2.st_gid);
#ifdef HAVE_ST_RDEV
  retval= retval || (st1.st_rdev != st2.st_rdev)
#endif
  retval= retval || (st1.st_size != st2.st_size);
#if (defined(HAVE_ST_BLKSIZE) && defined(HAVE_ST_BLOCKS))
  retval= retval || (st1.st_blksize != st2.st_blksize) || (st1.st_blocks != st2.st_blocks);
#endif
  retval= retval || (st1.st_atime != st2.st_atime) || (st1.st_mtime != st2.st_mtime);
  retval= retval || (st1.st_ctime != st2.st_ctime);
  return retval;
}

FILE* open_file(const char* path, int mode, int* errcode)
{
  int m,mf,fd;
  struct stat mstat,mfstat;
  FILE* pf;

  *errcode=NO_ERROR;
  if( (m=lstat(path,&mstat)) ) // *path does not exist or can not be stated
    {
      switch(errno)
	{
	case EBADF:
	case ENOTDIR:
	case ELOOP:
	case EFAULT:
	case EACCES:
	case EINTR:
	case ENOMEM:
	case EOVERFLOW: //in place of ENOMEM under Solaris
	case ENOLINK:
	case ENAMETOOLONG:
	  *errcode=errno;
	  return NULL;
	case ENOENT:
	  if(mode==TO_READ)
	    {
	      *errcode=UNEXIST_FILE;
	      return NULL;
	    }
	  else
	    {
	      if( (fd=open(path,O_WRONLY | O_CREAT | O_TRUNC,S_IWUSR | S_IRUSR | S_IRGRP | S_IROTH)) < 0)
		{
		  *errcode=errno;
		  return NULL;
		}
	      else
		pf=fdopen(fd,"w");
	    }
	  break;
	default:
	  *errcode=CHECK_ERROR;
	  return NULL;
	}
    }
  else // m==0 : path exists and can be stated
    {
      long flag= mstat.st_mode - (S_IFREG + S_IWUSR + S_IRUSR + S_IRGRP + S_IROTH); 

      if(flag==0)
	{
	  if(mstat.st_nlink > 1)
	    {
	      *errcode=IDONOTLIKE_HDLNS;
	      return NULL;
	    }
	  switch(mode)
	    {
	    case TO_READ:
	      if( (fd=open(path,O_RDONLY)) >= 0)
		{
		  // If the previous condition is true
		  // you can call fstat() on *path
		  mf=fstat(fd,&mfstat);
		  if( (mf) )
		    {
		      *errcode=errno;
		      return NULL;
		    }
		  else if( (statcmp(mstat,mfstat)) )
		    {
		      *errcode=CHECK_ERROR;
		      return NULL;
		    }
		  else
		    pf=fdopen(fd,"r");
		}
	      else // fd < 0 !!!
		{
		  *errcode=errno;
		  return NULL;
		}
	      break;
	    case TO_WRITE:
	      *errcode=FILE_EXISTS;
	      return NULL;
	    case TO_OVERWRITE:
	      // We open the file just to better examine it
	      if( (fd=open(path,O_RDONLY)) >= 0)
		{
		  // If the previous condition is true
		  // you can call fstat() on *path
		  mf=fstat(fd,&mfstat);
		  close(fd); // We need not check the r.v. of close()
		  // because we have not written any data.
		  if( (mf) )
		    {
		      *errcode=errno;
		      return NULL;
		    }
		  else if( (statcmp(mstat,mfstat)) )
		    {
		      *errcode=CHECK_ERROR;
		      return NULL;
		    }
		  else
		    {
		      if( (fd=open(path,O_WRONLY | O_TRUNC)) < 0 )
			{
			  *errcode=errno;
			  return NULL;
			}
		      else
			pf=fdopen(fd,"w");
		    }
		}
	      else // fd < 0 !!!
		{
		  *errcode=errno;
		  return NULL;
		}
	    } // end of switch(mode)
	}
      else
	{
	  *errcode=TYPE_OR_PERMS;
	  return NULL;
	}
    } // end of the outer if
  return pf;
}

#else

#include<FL/filename.H>
#include<cstdio>
#include<cstdlib>
#include<cstring>

#define DIRSIZE 1025 // It could be sufficient to contain a dirname

static void erase_dirlist(struct dirent** list,int length)
{
  int i;

  for( i = length ; i > 0 ; delete list[--i] )
    ;
  delete list;
}

FILE* open_file(const char* path, int mode, int* errcode)
{
  FILE *pf;
  const char* filename=filename_name(path);
  char dirname[DIRSIZE];
  int i,retval;          // i: counter variable 
  unsigned char found=0; // found: boolean variable
  struct dirent** dirlist;

  *errcode=NO_ERROR;
  if(filename==path) // the file in the path is in the cwd
    retval=filename_list(".",&dirlist);
  else
    {
      strncpy(dirname,path,filename-path);
      dirname[filename-path]='\0'; // In this way I should include the
      // final '/'
      retval=filename_list(dirname,&dirlist);
    }
  if(retval<0) //Error in scanning directory containing the file
    {
      *errcode=FAILED_SCANDIR;
      return NULL; 
    }
  else // Scandir completed successfully
    {
      for(i=0 ; i<retval ; i++)
	{
	  if( !strcmp(dirlist[i]->d_name,filename) ) // *path exists
	    {
	      found=1;
	      switch(mode)
		{
		case TO_READ:
		  if( !(pf=fopen(path,"r")) )
		    {
		      *errcode=TYPE_OR_PERMS;
		      erase_dirlist(dirlist,retval);
		      return NULL; //there is some problem with *path
		      //(you have no access to it ?)
		    }
		  break;
	        case TO_WRITE:
		  *errcode=FILE_EXISTS; //*path already exists
		  erase_dirlist(dirlist,retval);
		  return NULL;
		case TO_OVERWRITE:
		  if( !(pf=fopen(path,"w")) )
		    {
		      *errcode=TYPE_OR_PERMS;
		      erase_dirlist(dirlist,retval);
		      return NULL; //there is some problem with *path
		      //(you have no access to it ?)
		    }
		}
	      break; // I have found *path, stop !!
	    }
	}
      erase_dirlist(dirlist,retval);
      if(found==0) // *path does not exist
	{
	  if(mode==TO_READ)
	    {
	      *errcode=UNEXIST_FILE;
	      return NULL;
	    }
	  else
	    {
	      if( !(pf=fopen(path,"w")) )
		{
		  *errcode=TYPE_OR_PERMS;
		  return NULL; //there is some problem with *path
		  //(you have no access to it ?)
		}
	    }
	}
    } // end else
  return pf;
}

#endif  
      

