/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#ifndef _NUMBUTILS_
#define _NUMBUTILS_

#define ISVN   0
#define UFLOW  1
#define OFLOW  2
#define NAN    3

typedef unsigned long strsize;
typedef signed char signed_byte;
typedef unsigned char byte;
typedef union {
  signed_byte c;
  byte b;
  short s;
  unsigned short w;
  int i;
  unsigned int u;
  long I;
  unsigned long U;
  float f;
  double F;
} __number;

int stosbyt(const char* str,signed_byte *value);
int stobyt(const char* str,byte *value);
int stoshr(const char* str,short* value);
int stoushr(const char* str,unsigned short* value);
int stoint(const char* str,int* value);
int stouint(const char* str,unsigned int* value);
int stolng(const char* str,long* value);
int stoulng(const char* str,unsigned long* value);
int stoflt(const char* str,float* value);
int stodbl(const char* str,double* value);
/* **************** */
long ntolng(__number n,const char tp);
unsigned long ntoulng(__number n,const char tp);
float  ntoflt(__number n,const char tp);
double ntodbl(__number n,const char tp);

#define UNFMTSPEC -1    /* Specificatore di formato inaccettabile */ 
#define TOOSHORTLIST -2 /* La lista puntata da str contiene meno numeri del */
                        /* previsto                                         */
int stonlist(const char* str, const char* fmt, __number numberlist[], int* errcode);

#endif
