/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cstdlib>
#include<cerrno>
#include<cstring>
#include<cctype>
#include<climits>
#include<cfloat>
#include<new>
#include"numbutils.h"

/*_____ Una buona funzione di conversione da stringa a signed byte ______*/
/* La funzione tenta di convertire in un sbyte  la sequenza di caratteri */
/* contenuta in str facendo uso della funzione di libreria strtol.       */
/* La funzione restituisce :                                             */ 
/*  ISVN==0 se la conversione ha successo                                */
/* UFLOW==1 in caso di underflow                                         */
/* OFLOW==2 in caso di overflow                                          */
/*   NAN==3 in caso di conversione impossibile (la p. iniz. della strin- */
/*    ga non e' un numero ovvero c' e' un errore nel formato  numerico ) */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le,in caso di underflow viene impostata a SCHAR_MIN mentre in caso di */ 
/* overflow viene impostata a SCHAR_MAX.                                 */
/* Attenzione!!!  Se str=="\0" stosbyt imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */

int stosbyt(const char* str,signed_byte* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  long  v;
  strsize l;

  errno=0;
  l=strlen(str);
  t=new(nothrow)char[l+2];
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    } 
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtol(t,&endp,10);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  else if(v<SCHAR_MIN)
    {
      *value=SCHAR_MIN;
      delete[] t;
      return UFLOW;
    }
  else if(v>SCHAR_MAX)
    {
      *value=SCHAR_MAX;
      delete[] t;
      return OFLOW;
    }
  else
      *value=(signed_byte)v;
  delete[] t;
  return ISVN;
}

/*_________ Una buona funzione di conversione da stringa a byte _________*/
/* La funzione tenta di convertire in un byte  la sequenza di caratteri  */
/* contenuta in  str facendo uso  della funzione  di libreria  strtoul.  */
/* La funzione restituisce :                                             */ 
/*  ISVN==0 se la conversione ha successo                                */
/* OFLOW==2 in caso di overflow                                          */
/*   NAN==3 in caso di conversione impossibile (la p. iniz. della strin- */
/*    ga non e` un numero o il numero e` negativo o c' e` un errore  nel */
/*    formato  numerico).                                                */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le o quando il numero contenuto in str e` negativo,mentre in caso  di */
/* overflow viene impostata a UCHAR_MAX.                                 */
/* Attenzione!!!   Se str=="\0" stobyt imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */

int stobyt(const char* str,byte *value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  unsigned long  v;
  strsize l;

  errno=0;
  for(l=0 ; str[l]!='\0' && isspace(str[l])!=0 ; l++)
    ;
  if(str[l]=='-')
    {
      *value=0;
      return NAN;
    }
  else
    l=strlen(str);
  t=new(nothrow)char[l+2];
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    } 
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtoul(t,&endp,10);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  else if(v>UCHAR_MAX)
    {
      *value=UCHAR_MAX;
      delete[] t;
      return OFLOW;
    }
  else
      *value=(byte)v;
  delete[] t;
  return ISVN;
}


/*________ Una buona funzione di conversione da stringa a intero ________*/
/* La funzione tenta di convertire in uno short la sequenza di caratteri */
/* contenuta in str facendo uso della funzione di libreria strtol.       */
/* La funzione restituisce :                                             */ 
/*  ISVN==0 se la conversione ha successo                                */
/* UFLOW==1 in caso di underflow                                         */
/* OFLOW==2 in caso di overflow                                          */
/*   NAN==3 in caso di conversione impossibile (la p. iniz. della strin- */
/*    ga non e' un numero ovvero c' e' un errore nel formato  numerico ) */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le,in caso di underflow viene impostata a SHRT_MIN mentre in caso  di */ 
/* overflow viene impostata a SHRT_MAX.                                  */
/* Attenzione!!!   Se str=="\0" stoshr imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */

int stoshr(const char* str,short* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  long  v;
  strsize l;

  errno=0;
  l=strlen(str);
  t=new(nothrow)char[l+2];
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    } 
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtol(t,&endp,10);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  else if(v<SHRT_MIN)
    {
      *value=SHRT_MIN;
      delete[] t;
      return UFLOW;
    }
  else if(v>SHRT_MAX)
    {
      *value=SHRT_MAX;
      delete[] t;
      return OFLOW;
    }
  else
      *value=(short)v;
  delete[] t;
  return ISVN;
}

/*___Una buona funzione di conversione da stringa a intero non negativo__*/
/* La funzione tenta di convertire in un  unsigned short  la sequenza di */
/* caratteri contenuta in  str facendo uso  della funzione  di libreria  */
/* strtoul.                                                              */
/* La funzione restituisce :                                             */ 
/*  ISVN==0 se la conversione ha successo                                */
/* OFLOW==2 in caso di overflow                                          */
/*   NAN==3 in caso di conversione impossibile (la p. iniz. della strin- */
/*    ga non e` un numero o il numero e` negativo o c' e` un errore  nel */
/*    formato  numerico).                                                */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le o quando il numero contenuto in str e` negativo,mentre in caso  di */
/* overflow viene impostata a USHRT_MAX.                                 */
/* Attenzione!!!  Se str=="\0" stoushr imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */

int stoushr(const char* str,unsigned short* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  unsigned long  v;
  strsize l;

  errno=0;
  for(l=0 ; str[l]!='\0' && isspace(str[l])!=0 ; l++)
    ;
  if(str[l]=='-')
    {
      *value=0;
      return NAN;
    }
  else
    l=strlen(str);
  t=new(nothrow)char[l+2];
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    } 
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtoul(t,&endp,10);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  else if(v>USHRT_MAX)
    {
      *value=USHRT_MAX;
      delete[] t;
      return OFLOW;
    }
  else
      *value=(unsigned short)v;
  delete[] t;
  return ISVN;
}

/*________ Una buona funzione di conversione da stringa a intero ________*/
/* La funzione  tenta  di convertire in un int la sequenza  di caratteri */
/* contenuta in str facendo uso della funzione di libreria strtol.       */
/* La funzione restituisce :                                             */ 
/*  ISVN==0  se la conversione ha successo                               */
/* UFLOW==1  in caso di underflow                                        */
/* OFLOW==2  in caso di overflow                                         */
/*   NAN==3  in caso di conversione impossibile (la parte iniziale della */
/*           stringa non e' un numero ovvero c' e' un errore nel formato */
/*           numerico ).                                                 */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le,in caso di underflow viene impostata a INT_MIN mentre in caso  di  */ 
/* overflow viene impostata a INT_MAX.                                   */
/* Attenzione!!!   Se str=="\0" stoint imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */
 
int stoint(const char* str,int* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  long v;
  strsize l;

  errno=0;
  l=strlen(str);
  t=(char*)malloc((l+2)*sizeof(char));
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    }
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtol(t,&endp,10);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  else if(v<INT_MIN) 
    {
      *value=INT_MIN;
      delete[] t;
      return UFLOW;
    }
  else if(v>INT_MAX)
    {
      *value=INT_MAX;
      delete[] t;
      return OFLOW;
    }
  else if(errno==ERANGE)
    {
      delete[] t;
      if(v==LONG_MIN)
	{
	  *value=INT_MIN;
	  return UFLOW;
	}
      else
	{
	  *value=INT_MAX;
	  return OFLOW;
	}
    }
  else
      *value=(int)v;
  delete[] t;
  return ISVN;
}

/* __Una buona funzione di conversione da stringa a intero non negativo_ */
/* La funzione tenta  di  convertire in un  unsigned int  la sequenza di */
/* caratteri contenuta in  str facendo uso  della funzione  di libreria  */
/* strtoul.                                                              */
/* La funzione restituisce :                                             */ 
/*  ISVN==0 se la conversione ha successo                                */
/* OFLOW==2 in caso di overflow                                          */
/*   NAN==3 in caso di conversione impossibile (la p. iniz. della strin- */
/*    ga non e` un numero o il numero e` negativo o c' e` un errore  nel */
/*    formato  numerico).                                                */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le o quando il numero contenuto in str e` negativo,mentre in caso  di */
/* overflow viene impostata a UINT_MAX.                                  */
/* Attenzione!!!  Se str=="\0" stouint imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */

int stouint(const char* str,unsigned int* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  unsigned long  v;
  strsize l;

  errno=0;
  for(l=0 ; str[l]!='\0' && isspace(str[l])!=0 ; l++)
    ;
  if(str[l]=='-')
    {
      *value=0;
      return NAN;
    }
  else
    l=strlen(str);
  t=new(nothrow)char[l+2];
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    } 
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtoul(t,&endp,10);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  /* Bisogna considerare che sulle architetture */
  /* a 16 bit ULONG_MAX > UINT_MAX              */
  else if(errno==ERANGE || v>UINT_MAX)
    {
      *value=UINT_MAX;
      delete[] t;
      return OFLOW;
    }
  else
    *value=(unsigned int)v;
  delete[] t;
  return ISVN;
}

/*________ Una buona funzione di conversione da stringa a intero ________*/
/* La funzione tenta di convertire in un intero la sequenza di caratteri */
/* contenuta in str facendo uso della funzione di libreria strtol.       */
/* La funzione restituisce :                                             */ 
/*  ISVN==0  se la conversione ha successo                               */
/* UFLOW==1  in caso di underflow                                        */
/* OFLOW==2  in caso di overflow                                         */
/*   NAN==3  in caso di conversione impossibile (la parte iniziale della */
/*           stringa non e' un numero ovvero c' e' un errore nel formato */
/*           numerico ).                                                 */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le,in caso di underflow viene impostata a LONG_MIN mentre in caso  di */ 
/* overflow viene impostata a LONG_MAX.                                  */
/* Attenzione!!!   Se str=="\0" stolng imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */
 
int stolng(const char* str,long* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  strsize l;

  errno=0;
  l=strlen(str);
  t=(char*)malloc((l+2)*sizeof(char));
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    }
  strncpy(t,str,l+1);
  strcat(t,":");
  *value=strtol(t,&endp,10);
  if(strcmp(endp,":"))
    {
      delete[] t;
      return NAN;
    }
  else if(errno==ERANGE)
    {
      delete[] t;
      if(*value==LONG_MIN)
	return UFLOW;
      else
	return OFLOW;
    }
  delete[] t;
  return ISVN;
}

/*___ Una buona funzione di conversione da stringa a intero non negat.___*/
/* La funzione tenta di convertire in un unsigned long la sequenza di ca-*/
/* ratteri contenuta in str usando la funzione di libreria strtoul.      */
/* La funzione restituisce :                                             */ 
/*  ISVN==0 se la conversione ha successo                                */
/* OFLOW==2 in caso di overflow                                          */
/*   NAN==3 in caso di conversione impossibile (la p. iniz. della strin- */
/*    ga non e` un numero o il numero e` negativo o c' e` un errore  nel */
/*    formato  numerico).                                                */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le o quando il numero contenuto in str e` negativo,mentre in caso  di */
/* overflow viene impostata a ULONG_MAX.                                 */
/* Attenzione!!!  Se str=="\0" stoulng imposta value a 0 senza segnalare */
/* alcun'anomalia.______________________________________________________ */
 
int stoulng(const char* str,unsigned long* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  strsize l;

  errno=0;
  for(l=0 ; str[l]!='\0' && isspace(str[l])!=0 ; l++)
    ;
  if(str[l]=='-')
    {
      *value=0;
      return NAN;
    }
  l=strlen(str);
  t=(char*)malloc((l+2)*sizeof(char));
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    }
  strncpy(t,str,l+1);
  strcat(t,":");
  *value=strtoul(t,&endp,10);
  if(strcmp(endp,":"))
    {
      delete[] t;
      return NAN;
    }
  else if(errno==ERANGE)
    {
      delete[] t;
      return OFLOW;
    }
  delete[] t;
  return ISVN;
}

/*________ Una buona funzione di conversione da stringa a float _________*/
/* La funzione tenta di convertire  in un float la sequenza di caratteri */
/* contenuta in str facendo uso della funzione di libreria strtod.       */
/* La funzione restituisce :                                             */ 
/*  ISVN==0  se la conversione ha successo                               */
/* UFLOW==1  in caso di underflow                                        */
/* OFLOW==2  in caso di overflow                                         */
/*   NAN==3  in caso di conversione impossibile (la parte iniziale della */
/*           stringa non e' un numero ovvero c' e' un errore nel formato */
/*           numerico ).                                                 */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le e in caso di underflow,viene impostata a +FLT_MAX o -FLT_MAX in ca-*/
/* so di overflow ( il segno di value concorda con  quello del numero in */
/* str ).                                                                */
/* Attenzione!!   Si consiglia di utilizzare, tutte le volte che cio` e` */
/* possibile, la funzione stodbl() giacche' la stoflt() introduce degli  */
/* errori di arrotondamento.                                             */
 
int stoflt(const char* str,float* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  double v;
  strsize l;

  errno=0;
  l=strlen(str);
  t=(char*)malloc((l+2)*sizeof(char));
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    }
  strncpy(t,str,l+1);
  strcat(t,":");
  v=strtod(t,&endp);
  if(strcmp(endp,":"))
    {
      *value=0;
      delete[] t;
      return NAN;
    }
  else if( (v<FLT_MIN) && (v>-FLT_MIN) && (v!=0) )
    {
      *value=0;
      delete[] t;
      return UFLOW;
    }
  else if( (v>FLT_MAX)  || (v<-FLT_MAX) )
    {
      *value= ( v>0 ? FLT_MAX : -FLT_MAX );
      delete[] t;
      return OFLOW;
    }
  else if(errno==ERANGE)
    {
      delete[] t;
      if(v==0)
	{
	  *value=0;
	  return UFLOW;
	}
      else
	{
	  *value= ( v>0 ? FLT_MAX : -FLT_MAX );
	  return OFLOW;
	}
    }
  else
    *value=(float)v;
  delete[] t;
  return ISVN;
}

/*________ Una buona funzione di conversione da stringa a double ________*/
/* La funzione tenta di convertire in un double la sequenza di caratteri */
/* contenuta in str facendo uso della funzione di libreria strtod.       */
/* La funzione restituisce :                                             */ 
/*  ISVN==0  se la conversione ha successo                               */
/* UFLOW==1  in caso di underflow                                        */
/* OFLOW==2  in caso di overflow                                         */
/*   NAN==3  in caso di conversione impossibile (la parte iniziale della */
/*           stringa non e' un numero ovvero c' e' un errore nel formato */
/*           numerico ).                                                 */
/* La variabile value ha valore indefinito se la conversione e`impossibi-*/
/* le e in caso di underflow,viene impostata a +HUGEVAL o -HUGEVAL in ca-*/
/* so di overflow ( il segno di value concorda con  quello del numero in */
/* str ).                                                                */
 
int stodbl(const char* str,double* value)
{
  char* endp; /* punta alla parte finale di str(quella non convertita) */
  char* t;
  strsize l;

  errno=0;
  l=strlen(str);
  t=new(nothrow)char[l+2];
  if(!t)
    {
      fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
      fprintf(stderr,"Fatal Error : It isn't possible to reserve memory\n");
      fprintf(stderr,"              for the creation of a string of %lu",l+2);
      fprintf(stderr," byte(s)\n");
      exit(EXIT_FAILURE);
    }
  strncpy(t,str,l+1);
  strcat(t,":");
  *value=strtod(t,&endp);
  if(strcmp(endp,":"))
    {
      delete[] t;
      return NAN;
    }
  else if(errno==ERANGE)
    {
      delete[] t;
      if(*value==0)
	return UFLOW;
      else
	return OFLOW;
    }
  delete[] t;
  return ISVN;
}

long ntolng(__number n, const char tp)
{
  switch(tp)
    {
    case 'c':
      return (long)n.c;
    case 'b':
      return (long)n.b;
    case 's':
      return (long)n.s;
    case 'w':
      return (long)n.w;
    case 'i':
      return (long)n.i;
    case 'I':
      return n.I;
    }
  fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
  fprintf(stderr,"inside \"ntolng()\" function \n");
  fprintf(stderr,"Warning : wrong format specifier\n");
  return 0;
}

unsigned long ntoulng(__number n, const char tp)
{
  switch(tp)
    {
    case 'b':
      return (unsigned long)n.b;
    case 'w':
      return (unsigned long)n.w;
    case 'u':
      return (unsigned long)n.u;
    case 'U':
      return n.U;
    }
  fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
  fprintf(stderr,"inside \"ntoulng()\" function \n");
  fprintf(stderr,"Warning : wrong format specifier\n");
  return 0;
}

float ntoflt(__number n, const char tp)
{
  switch(tp)
    {
    case 'c':
      return (float)n.c;
    case 'b':
      return (float)n.b;
    case 's':
      return (float)n.s;
    case 'w':
      return (float)n.w;
    case 'i':
      return (float)n.i;
    case 'u':
      return (float)n.u;
    case 'I':
      return (float)n.I;
    case 'U':
      return (float)n.U;
    case 'f':
      return n.f;
    }
  fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
  fprintf(stderr,"inside \"ntoflt()\" function \n");
  fprintf(stderr,"Warning : wrong format specifier\n");
  return 0;
}

double ntodbl(__number n,const char tp)
{
  switch(tp)
    {
    case 'c':
      return (double)n.c;
    case 'b':
      return (double)n.b;
    case 's':
      return (double)n.s;
    case 'w':
      return (double)n.w;
    case 'i':
      return (double)n.i;
    case 'u':
      return (double)n.u;
    case 'I':
      return (double)n.I;
    case 'U':
      return (double)n.U;
    case 'f':
      return (double)n.f;
    case 'F':
      return n.F;
    }
  fprintf(stderr,"In file \'%s\' at line %u \n",__FILE__,__LINE__);
  fprintf(stderr,"inside \"ntodbl()\" function \n");
  fprintf(stderr,"Warning : wrong format specifier\n");
  return 0;
}

#define NUMITEM_SIZE 400 /* This is should be enough (!?!) */

static char* next_numitem(const char* str)
{
  static const char *s;
  static char item[NUMITEM_SIZE];
  const char* p;
  short isize;

  if( (str) )
    {
      s=str;
      item[0]='\0';
    }
  for( ; *s!='\0' && isspace(*s)!=0 ; s++)
    ; /* the initial white spaces are jumped
         After the previous cycle one has
         *s == '\0'   OR
         *s != '\0' and it is not a white space */
  for(p=s ; *p!='\0' && isspace(*p)==0 ; p++)
    ; /* Now *p is the first white space after an item OR '\0' */
  if(p==s) /* It is possible if and only if *s=='\0' */
    return NULL;
  else
    {
      isize= (p-s+1) <= NUMITEM_SIZE ? p-s+1 : NUMITEM_SIZE;
      strncpy(item,s,isize-1);
      item[isize-1]='\0';
      s=p;
      return item;
    }
}

/*____Una funzione per estrarre una lista di numeri da una stringa____*/
/* str e` una stringa che dovrebbe contenere una lista di numeri, fmt */
/* e` una stringa di formato,ossia una sequenza composta dai seguenti */
/* caratteri, ciascuno dei quali fa riferimento a un diverso tipo nu- */
/* merico:                                                            */
/* c == signed_byte                                                   */
/* b == byte                                                          */
/* s == short                                                         */
/* w == unsigned short (word)                                         */
/* i == int                                                           */
/* u == unsigned int                                                  */
/* I == long int                                                      */
/* U == unsigned long int                                             */
/* f == float                                                         */
/* F == double                                     .                  */
/* La funzione assume che i vari numeri che compaiono nella stringa   */
/* puntata da str siano separati da spazi bianchi (il POSIX definisce */
/* come spazi bianchi i seguenti caratteri: ' ', '\t', '\n', '\f',    */
/* '\v' e '\r'); ognuno di questi valori numerici sara` chiamato item */
/* numerico.                                                          */
/* La stringa di formato fmt specifica il tipo di ogni numero che     */
/* dovrebbe comparire in str a partire dall' inizio della medesima    */
/* stringa. Ad esempio, se si ritiene che in str debbano essere       */
/* contenuti, nell'ordine, un unsigned short, un long e due numeri    */
/* di tipo float allora, affinche' la funzione stonlist() possa cor-  */
/* rettamente estrarli da str, la stringa fmt deve essere data da     */
/* "wIff".                                                            */
/* Se la funzione stonlist() riesce ad estrarre i numeri da str sulla */
/* base delle indicazioni della stringa di formato allora questi      */
/* numeri potranno essere trovati nell' array numberlist[], il quale  */
/* deve avere una dimensione sufficiente per contenere tutti i numeri */
/* in questione; questa dimensione e` data ovviamente dalla lunghezza */
/* della stringa di formato.                                          */
/* La funzione ritorna il numero dei valori numerici che e` riuscita  */
/* ad estrarre con successo da str, che e` ovviamente uguale a 0 se   */
/* non e` riuscita ad estrarre nessun numero. Inoltre, al termine     */
/* della chiamata, errcode punta al codice di uscita della funzione,  */
/* che e` 0 quando la medesima funzione termina con successo, vale    */
/* UNFMTSPEC quando la stringa di formato contiene uno specificatore  */
/* inaccettabile,TOOSHORTLIST quando il numero degli item contenuti in*/
/* expr e` inferiore a quello degli specificatori di formato mentre,  */
/* in qualsiasi altro caso, contiene il codice dell' errore relativo  */
/* al primo item di str che non e` stato possibile convertire in un   */
/* numero del tipo richiesto dal corrispondente specificatore di for- */
/* mato.                                                              */ 
/* La funzione stonlist() ritorna 0 con *errcode==0 quando la stringa */
/* str e` vuota (str=="").                                            */ 

int stonlist(const char* str, const char* fmt, __number numberlist[], int* errcode)
{
  /* La funzione assume che numberlist[] debba avere una dimensione */
  /* maggiore o uguale della lunghezza della stringa di formato; se */
  /* cosi` non sara` verra` generato  con tutta probabilita` un er- */
  /* rore di Segmentation Fault.                                    */
  /* La stessa cosa accadra` se fmt==NULL o se fmt non punta ad una */
  /* area di memoria valida.                                        */

  const char *p; /* p is used to go trought fmt */
  char* item;
  int retval;
  signed_byte c; byte b;
  short s; unsigned short w;
  int i; unsigned int u;
  long I; unsigned long U;
  float f; double F;

  *errcode=0;
  item=next_numitem(str);
  for(p=fmt ; (*p != '\0') && (item != NULL) ; p++)
    {
      switch( *p )
	{
	case 'c':
	  retval=stosbyt(item, &c);
	  numberlist[p-fmt].c=c;
	  break;
	case 'b':
	  retval=stobyt(item, &b);
	  numberlist[p-fmt].b=b;
	  break;
	case 's':
	  retval=stoshr(item, &s);
	  numberlist[p-fmt].s=s;
	  break;
	case 'w':
	  retval=stoushr(item, &w);
	  numberlist[p-fmt].w=w;
	  break;
	case 'i':
	  retval=stoint(item, &i);
	  numberlist[p-fmt].i=i;
	  break;
	case 'u':
	  retval=stouint(item, &u);
	  numberlist[p-fmt].u=u;
	  break;
	case 'I':
	  retval=stolng(item, &I);
	  numberlist[p-fmt].I=I;
	  break;
	case 'U':
	  retval=stoulng(item, &U);
	  numberlist[p-fmt].U=U;
	  break;
	case 'f':
	  retval=stoflt(item, &f);
	  numberlist[p-fmt].f=f;
	  break;
	case 'F':
	  retval=stodbl(item, &F);
	  numberlist[p-fmt].F=F;
	  break;
	default:
	  *errcode=UNFMTSPEC;
	  return (p-fmt);
	}
      if(retval != ISVN)
	{
	  *errcode=retval;
	  return (p-fmt);
	}
      else
	item=next_numitem(NULL);
    } /* end for(...) */
  /* From the previous cycle we can exit because
     1)   *p == '\0' and/or
     2) item == NULL;                            */
  if( (*p) && !item )
    *errcode=TOOSHORTLIST;
  return (p-fmt);
}
