/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cstdlib>
#include<cstring>
#include<cmath>
#include<cfloat>
#include<FL/Fl_Widget.H>
#include<FL/fl_draw.H>
#include<FL/Enumerations.H>
#include"graphut.h"
#include"mycanvas.h"

static unsigned char paint[MAX_NC][3]={{0,0,0},
    {0,120,120},{140,0,120},{100,120,0},
    {196,0,36},{0,196,0},{0,0,160},
    {0,188,188},{196,98,196},{216,160,0}
};

// The iround() function is a portable replacement for rint().
static int iround(double x)
{
  double fp, ip;
  int rounded;

  fp = modf (x, &ip);
  if (fp >= 0)
    rounded = (int)((fp > 0.5) ? ip + 1 : ip);
  else
    rounded = (int)((fp < -0.5) ? ip - 1 : ip);
  return rounded;
}

int mycanvas::zoomfactor(const short inc)
{
  if((inc != 0) && (inc != 1) && (inc != -1))
    return -2;
  if(cnvtype==C2D)
    {
      if((par2d.zoom+=inc) > MAX_ZOOM || par2d.zoom < MIN_ZOOM)
	{
	  par2d.zoom-=inc;
	  return -1;
	}
      else
	{
	  if( (par2d.zoom %2) )
	    {
	      if(inc==-1)
		{
		  if(par2d.w*5 < MAX_DIM)
		    {
		      par2d.w*=5; 
		      par2d.h*=5; 
		    }
		}
	      else
		{
		  if(par2d.w*0.5 >= MIN_DIM)
		    {
		      par2d.w*=0.5; 
		      par2d.h*=0.5; 
		    }
		}
	    } //end case "par2d.zoom is even"
	  else
	    {
	      if(inc==-1)
		{
		  if(par2d.w*2 < MAX_DIM)
		    {
		      par2d.w*=2; 
		      par2d.h*=2; 
		    }
		}
	      else
		{
		  if(par2d.w*0.2 >= MIN_DIM)
		    {
		      par2d.w*=0.2; 
		      par2d.h*=0.2; 
		    }
		}
	    } // end case "par2d.zoom is odd"
	} // end else related to if((par2d.zoom+=inc)...)
    } //end if(cnvtype...)
  else
    {
      if((par3d.zoom+=inc) > MAX_ZOOM || par3d.zoom < MIN_ZOOM)
	{
	  par3d.zoom-=inc;
	  return -1;
	}
      else
	{
	  if( (par3d.zoom %2) )
	    {
	      if(inc==-1)
		{
		  if(par3d.R*5 < MAX_DIM)
		    par3d.R*=5; 
		}
	      else
		{
		  if(par3d.R*0.5 >= MIN_DIM)
		    par3d.R*=0.5; 
		}
	    } //end case "par3d.zoom is even"
	  else
	    {
	      if(inc==-1)
		{
		  if(par3d.R*2 < MAX_DIM)
		    par3d.R*=2; 
		}
	      else
		{
		  if(par3d.R*0.2 >= MIN_DIM)
		    par3d.R*=0.2; 
		}
	    } // end case "par3d.zoom is odd"
	} // end else related to if((par3d.zoom+=inc)...)
    }
  return 0;
}

int mycanvas::set_par2d(const struct Param2d *p) 
{
  par2d.x0=p->x0;
  par2d.y0=p->y0;
  par2d.w =p->w;
  par2d.h =p->h;
  par2d.t1=p->t1;
  par2d.t2=p->t2;
  par2d.nnod=p->nnod;
  par2d.nc=p->nc;
  return set_dim(par2d.nnod,par2d.nc);
}

int mycanvas::set_par3d(const struct Param3d *p) 
{
  par3d.x0=p->x0;
  par3d.y0=p->y0;
  par3d.z0=p->z0;
  par3d.R =p->R;
  par3d.s1=p->s1;
  par3d.s2=p->s2;
  par3d.t1=p->t1;
  par3d.t2=p->t2;
  par3d.nnods=p->nnods;
  par3d.nnodt=p->nnodt;
  return set_dim(par3d.nnodt,par3d.nnods);
}

struct Param2d* mycanvas::get_par2d(void) 
{
  return &par2d;
}

struct Param3d* mycanvas::get_par3d() 
{
  return &par3d;
}

void mycanvas::setv(struct point P, int index) 
{
  grid[index].x=P.x;
  grid[index].y=P.y;
  grid[index].z=P.z;
  grid[index].color=P.color;
}

void mycanvas::draw(void)
{
  Fl_Color oldink=fl_color();

  fl_color(FL_WHITE);
  fl_rectf(x(),y(),w(),h());
  if( (draw_axes) )
    _draw_axes();
  if( (draw_grid) )
    _draw_grid();
  if( (draw_infos) )
    _draw_infos();
  _draw_center();
  if(cnvtype==C2D)
    draw2d();
  else
    draw3d();
  fl_color(oldink);
}

int mycanvas::set_dim(int vn, int vm)
{
  m=vm;
  n=vn;
  if( (table) )
    delete[] table;
  if( (grid) )
    delete[] grid;
  grid=new(nothrow) struct point[m*n];
  if( !grid )
    return -1;
  if( cnvtype != C2D )
    {
      table=new(nothrow) struct element[2*m*n];
      if( !table )
	return -1;
    }
  else
    table=0;
  return 0;
}

void mycanvas::draw2d(void)
{
  int i,j,x1,y1,x2,y2;
  short X,Y,S;
  struct point Q1,Q2;
  struct Rect R;

  X=x()+DIST; 
  Y=y()+DIST;   // Coordinates of the upper-left corner of the drawing area
  S=w()-2*DIST; // Dimensions of the drawing area (they should be equals)
  // Setting up display area
  R.x0=par2d.x0;
  R.y0=par2d.y0;
  R.a =par2d.w/2.0;
  R.b =par2d.h/2.0;
  for(j=0 ; j<m ; j++) // m is at most 9=MAX_NC-1 
    {
      fl_color(paint[j][0],paint[j][1],paint[j][2]);
      if(plotstyle[j]==CONNECTED_PLOT)
	{
	  for(i=0 ; i<n-1 ; i++)
	    {
	      if( (grid[j*n+i].color==127) || (grid[j*n+i+1].color==127) )
		continue;
	      else if( intersect(grid[j*n+i],grid[j*n+i+1],R,&Q1,&Q2) )
		{
		  x1=iround( X+S/2+S*((Q1.x-par2d.x0)/par2d.w) );
		  y1=iround( Y+S/2-S*((Q1.y-par2d.y0)/par2d.h) );
		  x2=iround( X+S/2+S*((Q2.x-par2d.x0)/par2d.w) );
		  y2=iround( Y+S/2-S*((Q2.y-par2d.y0)/par2d.h) );
		}
	      else
		continue;
	      fl_line(x1,y1,x2,y2);
	    } //end for(...) 
	} //end if(plotstyle...)
      else
	{
	  for(i=0 ; i<n ; i++)
	    {
	      if( (grid[j*n+i].color==127) )
		continue;
	      else if( !isout(grid[j*n+i].x, grid[j*n+i].y, R) )
		{
		  x1=iround( X+S/2+S*((grid[j*n+i].x-par2d.x0)/par2d.w) );
		  y1=iround( Y+S/2-S*((grid[j*n+i].y-par2d.y0)/par2d.h) );
		}
	      else
		continue;
	      switch(plotstyle[j])
		{
		case SQUARES:
		  fl_loop(x1-1,y1-1,x1+1,y1-1,x1+1,y1+1,x1-1,y1+1);
		  break;
		case DIAMONDS:
		  fl_loop(x1,y1-1,x1+1,y1,x1,y1+1,x1-1,y1);
		  break;
		case CROSSES:
		  fl_line(x1-1,y1-1,x1+1,y1+1);
		  fl_line(x1+1,y1-1,x1-1,y1+1);
		}
	    } //end for(i...)
	} //end else
    }//end for(j...)
}

void mycanvas::draw3d(void)
{
  struct point P,Q,Q1,Q2;
  int x1,y1,x2,y2,color=0;
  short X,Y,S;
  int i,j;
  struct Rect R;

  X=x()+DIST;
  Y=y()+DIST;    // Coordinates of the upper-left corner of the drawing area
  S=w()-2*DIST;  // Dimensions of the drawing area (they should be equals)
  for(j=0 ; j<m   ; j++) // if m==1 j can be only 0
    {
      for(i=0 ; i<n-1 ; i++)
	{
	  P=Assonometria(&par3d,grid[j*n+i]);
	  Q=Assonometria(&par3d,grid[j*n+i+1]);
	  table[j*(n-1)+i].index=j*n+i;
	  table[j*(n-1)+i].key=(P.color+Q.color)/2;
	  table[j*(n-1)+i].type=0;
	}
    }
  for(i=0 ; i<n ; i++)
    {
      for(j=0 ; j<m-1 ; j++) // if m==1 the instructions below are not
	{                        // executed
	  P=Assonometria(&par3d,grid[j*n+i]);
	  Q=Assonometria(&par3d,grid[(j+1)*n+i]);
	  table[m*(n-1)+i*(m-1)+j].index=j*n+i;
	  table[m*(n-1)+i*(m-1)+j].key=(P.color+Q.color)/2;
	  table[m*(n-1)+i*(m-1)+j].type=1;
	}
    }
  qsort(table, m*(n-1)+n*(m-1), sizeof( struct element ), &colorcmp);
  R.x0=R.y0=0;
  R.a =R.b =par3d.R;
  for(i=0; i<m*(n-1)+n*(m-1) ; i++)
    {
      if(table[i].key > NGRAYS-1) // P.color or Q.color is equal to 127; 
	continue;                 // you must not draw this line !
      else
	j=table[i].index;
      if(table[i].type==0)
	{
	  P=Assonometria(&par3d,grid[(j/n)*n+j%n]);
	  Q=Assonometria(&par3d,grid[(j/n)*n+j%n+1]);
	}
      else
	{
	  P=Assonometria(&par3d,grid[(j/n)*n+j%n]);
	  Q=Assonometria(&par3d,grid[(j/n+1)*n+j%n]);
	}
      if( intersect(P, Q, R, &Q1, &Q2) )
	{
	  x1=iround( X+S/2+S/2*(Q1.x/par3d.R) );
	  y1=iround( Y+S/2-S/2*(Q1.y/par3d.R) );
	  x2=iround( X+S/2+S/2*(Q2.x/par3d.R) );
	  y2=iround( Y+S/2-S/2*(Q2.y/par3d.R) );
//  	  fprintf(stderr,"P1.x= %f\t P1.y= %f\n",P1.x,P1.y);
//  	  fprintf(stderr,"Q1.x= %f\t Q1.y= %f\n",Q1.x,Q1.y);
//  	  fprintf(stderr,"P2.x= %f\t P2.y= %f\n",P2.x,P2.y);
//  	  fprintf(stderr,"Q2.x= %f\t Q2.y= %f\n\n",Q2.x,Q2.y);
	}
      else
	continue;
      if( color != (int)((P.color+Q.color)/2) )
	{
	  color=(int)((P.color+Q.color)/2);
	  fl_color(fl_gray_ramp(color));
	}
      fl_line(x1,y1,x2,y2);
    }
//    fprintf(stderr,"\n\n");
}

void mycanvas::_draw_infos(void)
{
  char s[50];
  short X,Y,S;

  fl_color(110,40,60);
  X=x()+DIST;
  Y=y()+DIST;  // Coordinates of the upper-left corner of the drawing area
  S=w()-2*DIST;// Dimensions of the drawing area (they should be equals)
  fl_font(FL_COURIER,10);
  if(cnvtype==C2D)
    {
      snprintf(s,50,"   X0= %15.3f",par2d.x0);
      fl_draw(s,X,y()+9);
      snprintf(s,50,"\t   Y0= %15.3f",par2d.y0);
      fl_draw(s,X+S/2,y()+9);
      snprintf(s,50,"   W= %10.3f",par2d.w);
      fl_draw(s,X,y()+h()-1);
      snprintf(s,50,"\t H= %10.3f",par2d.h);
      fl_draw(s,X+S/3,y()+h()-1);
      /*********************************************/
      //        strcpy(s,"x= ");
      //        strcat(s,prm[0].x); // No matter, s[] is enough long !
      //        strcpy(s,"y= ");
      //        strcat(s,prm[0].y); // No matter, s[] is enough long !
      /*********************************************/
      // If the grid have been requested you have to
      // write the gridstep
      if( (draw_grid) )
	{
	  snprintf(s,50," GRIDSTEP= %6.4f",gridstep);
	  fl_draw(s,X+2*S/3,y()+h()-1);
	}
    } // end of the first if
  else
    {
      snprintf(s,50,"   X0= %15.3f",par3d.x0);
      fl_draw(s,X,y()+9);
      snprintf(s,50,"\t   Y0= %15.3f",par3d.y0);
      fl_draw(s,X+S/3,y()+9);
      snprintf(s,50,"\t   Z0= %15.3f",par3d.z0);
      fl_draw(s,X+2*S/3,y()+9);
      snprintf(s,50,"   R= %10.3f",par3d.R);
      fl_draw(s,X,y()+h()-1);
      // If the grid have been requested you have to
      // write the gridstep
      if( (draw_grid) )
	{
	  snprintf(s,50," GRIDSTEP= %6.4f",gridstep);
	  fl_draw(s,X+S/2,y()+h()-1);
	}
    }
}

void mycanvas::_draw_center(void)
{
  short X,Y,S;

  X=x()+DIST;
  Y=y()+DIST;  // Coordinates of the upper-left corner of the drawing area
  S=w()-2*DIST;// Dimensions of the drawing area (they should be equals)
  fl_color(FL_RED);
  fl_line(X+S/2-3,Y+S/2,X+S/2+3,Y+S/2);
  fl_line(X+S/2,Y+S/2-3,X+S/2,Y+S/2+3);
  fl_color(FL_BLACK);
}

void mycanvas::_draw_axes(void)
{
#define EPS 0.000001
  int x1,y1,x2,y2,cx,cy;
  short X,Y,S;

  X=x()+DIST;
  Y=y()+DIST;    // Coordinates of the upper-left corner of the drawing area
  S=w()-2*DIST;  // Dimensions of the canvas (they should be equals)
  fl_font(FL_COURIER,10);
  if(cnvtype==C2D)
    {
      if( absv(par2d.y0) <= par2d.h/2.0 )
	{
	  fl_color(230);
	  x1=X;
	  x2=X+S;
	  y1=y2=iround( Y+S/2+S*(par2d.y0/par2d.h) );
	  fl_line(x1,y1,x2,y2);
	  fl_color(110,40,60);
	  cx=X+S-10;
	  cy=iround( Y+S/2+S*(par2d.y0/par2d.h)-2 );
	  fl_draw("x",cx,cy);
	}
      if( absv(par2d.x0) <= par2d.w/2.0 )
	{
	  fl_color(FL_MAGENTA);
	  y1=Y;
	  y2=Y+S;
	  x1=x2=iround( X+S/2-S*(par2d.x0/par2d.w) );
	  fl_line(x1,y1,x2,y2);
	  fl_color(110,40,60);
	  cy=Y+10;
	  cx=iround( X+S/2-S*(par2d.x0/par2d.w)+2 );
	  fl_draw("y",cx,cy);
	}
    }
  else
    {
      struct point P1={
	par3d.x0+par3d.R,par3d.y0,par3d.z0,0
      };
      struct point P2={
	par3d.x0,par3d.y0+par3d.R,par3d.z0,0
      };
      struct point P3={
	par3d.x0,par3d.y0,par3d.z0+par3d.R,0
      };

      P1=Assonometria(&par3d,P1);
      P2=Assonometria(&par3d,P2);
      P3=Assonometria(&par3d,P3);
      if( norm(P1.x,P1.y) > EPS)
	{
	  fl_color(230);
	  x1=iround( X+S/2+S/2*( xsq(P1.x,P1.y,par3d.R)/par3d.R ) );
	  y1=iround( Y+S/2-S/2*( ysq(P1.x,P1.y,par3d.R)/par3d.R ) );
	  x2=iround( X+S/2+S/2*( xsq(-P1.x,-P1.y,par3d.R)/par3d.R ) );
	  y2=iround( Y+S/2-S/2*( ysq(-P1.x,-P1.y,par3d.R)/par3d.R ) );
	  fl_line(x1,y1,x2,y2);
	  fl_color(110,40,60);
	  x1=iround( X+S/2+S/2*( xsq(P1.x,P1.y,0.97*par3d.R)/par3d.R ) );
	  y1=iround( Y+S/2-S/2*( ysq(P1.x,P1.y,0.97*par3d.R)/par3d.R ) );
	  fl_draw("x",x1,y1);
	}
      if( norm(P2.x,P2.y) > EPS )
	{
	  fl_color(FL_MAGENTA);
	  x1=iround( X+S/2+S/2*( xsq(P2.x,P2.y,par3d.R)/par3d.R ) );
	  y1=iround( Y+S/2-S/2*( ysq(P2.x,P2.y,par3d.R)/par3d.R ) );
	  x2=iround( X+S/2+S/2*( xsq(-P2.x,-P2.y,par3d.R)/par3d.R ) );
	  y2=iround( Y+S/2-S/2*( ysq(-P2.x,-P2.y,par3d.R)/par3d.R ) );
	  fl_line(x1,y1,x2,y2);
	  fl_color(110,40,60);
	  x1=iround( X+S/2+S/2*( xsq(P2.x,P2.y,0.97*par3d.R)/par3d.R ) );
	  y1=iround( Y+S/2-S/2*( ysq(P2.x,P2.y,0.97*par3d.R)/par3d.R ) );
	  fl_draw("y",x1,y1);
	}
      if( norm(P3.x,P3.y) > EPS )
	{
	  fl_color(FL_YELLOW);
	  x1=iround( X+S/2+S/2*( xsq(P3.x,P3.y,par3d.R)/par3d.R ) );
	  y1=iround( Y+S/2-S/2*( ysq(P3.x,P3.y,par3d.R)/par3d.R ) );
	  x2=iround( X+S/2+S/2*( xsq(-P3.x,-P3.y,par3d.R)/par3d.R ) );
	  y2=iround( Y+S/2-S/2*( ysq(-P3.x,-P3.y,par3d.R)/par3d.R ) );
	  fl_line(x1,y1,x2,y2);
	  fl_color(110,40,60);
	  x1=iround( X+S/2+S/2*( xsq(P3.x,P3.y,0.97*par3d.R)/par3d.R ) );
	  y1=iround( Y+S/2-S/2*( ysq(P3.x,P3.y,0.97*par3d.R)/par3d.R ) );
	  fl_draw("z",x1,y1);
	}
    }
}

void mycanvas::_draw_grid(void)
{
  int x1,y1,x2,y2,j,k;
  short X,Y,S;
  struct point P1,P2,P3,P4,Q1,Q2,Q3,Q4;
  struct Rect R;

  fl_color(FL_BLUE);
  X=x()+DIST;
  Y=y()+DIST;   // Coordinates of the upper-left corner of the drawing area
  S=w()-2*DIST; // Dimensions of the drawing area (they should be equals)
  //  fl_push_clip(X,Y,S,S);
  if(cnvtype==C2D)
    {
      for(j=0 ; j*gridstep <= par2d.h/2.0 ; j++ )
	{
	  y1=iround( Y+S/2+S*((j*gridstep)/par2d.h) );
	  y2=iround( Y+S/2-S*((j*gridstep)/par2d.h) );
	  for(k=0 ; k*gridstep <= par2d.w/2.0 ; k++ )  
	    {
	      x1=iround( X+S/2+S*((k*gridstep)/par2d.w) );
	      x2=iround( X+S/2-S*((k*gridstep)/par2d.w) );
	      fl_point(x1,y1);
	      fl_point(x1,y2);
	      fl_point(x2,y1);
	      fl_point(x2,y2);
	    }
	}
    }
  else
    {
      R.x0=R.y0=0;
      R.a =R.b =par3d.R;
      P1.z=P2.z=par3d.z0;
      P3.x=P4.x=par3d.x0+par3d.R; P3.y=P4.y=par3d.y0;
      P1.color=P2.color=P3.color=0;
      for(j=0 ; j*gridstep <= par3d.R ; j++ )
	{
	  P3.z= par3d.z0+j*gridstep;
	  P4.z= par3d.z0-j*gridstep;
	  Q3=Assonometria(&par3d,P3);
	  Q4=Assonometria(&par3d,P4);
	  if(!isout(Q3.x,Q3.y,R))
	    {
	      x1=iround( X+S/2+S/2*(Q3.x/par3d.R) );
	      y1=iround( Y+S/2-S/2*(Q3.y/par3d.R) );
	      fl_point(x1,y1);
	    }
	  if(!isout(Q4.x,Q4.y,R))
	    {
	      fl_color(0,160,0);
	      x2=iround( X+S/2+S/2*(Q4.x/par3d.R) );
	      y2=iround( Y+S/2-S/2*(Q4.y/par3d.R) );
	      fl_point(x2,y2);
	      fl_color(FL_BLUE);
	    }
	  /* *** */
	  P1.y= par3d.y0+j*gridstep;
	  P2.y= par3d.y0-j*gridstep;
	  P2.x=P1.x= par3d.x0+par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
  	  if(!isout(Q1.x,Q1.y,R))
  	    {
	      x1=iround( X+S/2+S/2*(Q1.x/par3d.R) );
	      y1=iround( Y+S/2-S/2*(Q1.y/par3d.R) );
	      fl_point(x1,y1);
	    }
	  if(!isout(Q2.x,Q2.y,R))
	    {
	      x2=iround( X+S/2+S/2*(Q2.x/par3d.R) );
	      y2=iround( Y+S/2-S/2*(Q2.y/par3d.R) );
	      fl_point(x2,y2);
	    }
	  /* *** */
	  P2.x=P1.x= par3d.x0-par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  if(!isout(Q1.x,Q1.y,R))
	    {
	      x1=iround( X+S/2+S/2*(Q1.x/par3d.R) );
	      y1=iround( Y+S/2-S/2*(Q1.y/par3d.R) );
	      fl_point(x1,y1);
	    }
	  if(!isout(Q2.x,Q2.y,R))
	    {
	      x2=iround( X+S/2+S/2*(Q2.x/par3d.R) );
	      y2=iround( Y+S/2-S/2*(Q2.y/par3d.R) );
	      fl_point(x2,y2);
	    }
	}
      for(k=0 ; k*gridstep <= par3d.R ; k++ )
	{
	  P1.x= par3d.x0+k*gridstep;
	  P2.x= par3d.x0-k*gridstep;
	  /* *** */
	  P2.y=P1.y= par3d.y0+par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  if(!isout(Q1.x,Q1.y,R))
	    {
	      x1=iround( X+S/2+S/2*(Q1.x/par3d.R) );
	      y1=iround( Y+S/2-S/2*(Q1.y/par3d.R) );
	      fl_point(x1,y1);
	    }
	  if(!isout(Q2.x,Q2.y,R))
	    {
	      x2=iround( X+S/2+S/2*(Q2.x/par3d.R) );
	      y2=iround( Y+S/2-S/2*(Q2.y/par3d.R) );
	      fl_point(x2,y2);
	    }
	  /* *** */
	  P2.y=P1.y= par3d.y0-par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  if(!isout(Q1.x,Q1.y,R))
	    {
	      x1=iround( X+S/2+S/2*(Q1.x/par3d.R) );
	      y1=iround( Y+S/2-S/2*(Q1.y/par3d.R) );
	      fl_point(x1,y1);
	    }
	  if(!isout(Q2.x,Q2.y,R))
	    {
	      x2=iround( X+S/2+S/2*(Q2.x/par3d.R) );
	      y2=iround( Y+S/2-S/2*(Q2.y/par3d.R) );
	      fl_point(x2,y2);
	    }
	}
    } // end else
  //  fl_pop_clip();
}

