/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cstring>
#include<cfloat>
#include"mplot.h"
#include"mathplot.h"
#include"numbutils.h"

#define BUFFSIZE 150 /* This it would be enough */
#define MSGSIZE  60  /* ....................... */

char* LoadSFparams(FILE* pf, struct Param3d* par)
{
  char buff[BUFFSIZE];
  static char errmsg[MSGSIZE];
  __number nlist[3];
  int errcode;

  /* First we have to read lb?(s1),ub?(s2) and n?(nnods) */
  if( !fgets(buff,BUFFSIZE,pf) )
    {
      strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( stonlist(buff, "FFw", nlist, &errcode) < 3 )
    {
      strncpy(errmsg," Error occurred ( bad parameters ? )",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else
    {
      par->s1   =nlist[0].F;
      par->s2   =nlist[1].F;
      par->nnods=nlist[2].w;
    }
  if( (par->s2-par->s1<= 0) || (par->s2-par->s1 >MAX_EXTVIPRM) )
    {
      strncpy(errmsg," ub?-lb?: Its value is out of the admissible range",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( par->nnods < 2 )
    {
      strncpy(errmsg," n?: Unagreable value",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  /* Next we have to read ,lb!(t1),lb!(t2) and n!(nnodt) */
  else if( !fgets(buff,BUFFSIZE,pf) )
    {
      strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( stonlist(buff, "FFw", nlist, &errcode) < 3 )
    {
      strncpy(errmsg," Error occurred ( bad parameters ? )",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else
    {
      par->t1   =nlist[0].F;
      par->t2   =nlist[1].F;
      par->nnodt=nlist[2].w;
    }
  if( (par->t2-par->t1<= 0) || (par->t2-par->t1 >MAX_EXTVIPRM) )
    {
      strncpy(errmsg," ub!-lb!: Its value is out of the admissible range",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( (par->nnodt < 2) || (par->nnods*par->nnodt > MAX_NNOD_SF) )
    {
      strncpy(errmsg," n!: Unagreable value",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else
    return NULL;
}

char* LoadSF(mycanvas* cnv, FILE* pf, struct Param3d* par)
{
  struct point P;
  char buff[BUFFSIZE];
  static char errmsg[MSGSIZE];
  __number nlist[3];
  int errcode;
  int j,i;          /* Counter variables */

  /* Now I am going to load the curves */
  for(j=0 ; j< par->nnods ; j++)
    {
      /* Before each block i want to read an empty line */
      if( !fgets(buff,BUFFSIZE,pf) )
	{
	  strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
	  errmsg[MSGSIZE-1]='\0';
	  return errmsg;
	}
      else if( !(isempty(buff)) )
	{
	  strncpy(errmsg," Error : requested empty line",MSGSIZE-1);
	  errmsg[MSGSIZE-1]='\0';
	  return errmsg;
	}
      else
	{
	  for(i=0 ; i< par->nnodt ; i++)
	    {
	      if( !fgets(buff,BUFFSIZE,pf) )
		{
		  strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
		  errmsg[MSGSIZE-1]='\0';
		  return errmsg;
		}
	      else if( stonlist(buff, "fff", nlist, &errcode) < 3 )
		{
		  strncpy(errmsg," Error occurred ( bad coordinates ? )", MSGSIZE-1);
		  errmsg[MSGSIZE-1]='\0';
		  return errmsg;
		}
	      else
		{
		  sscanf(buff,"%f %f %f",&P.x,&P.y,&P.z); // I have decided to use sscanf()
		  //to load P.x, P.y and P.z because I want to avoid the approssimation errors 
		  P.color= ( (P.x==FLT_MAX) && (P.y==FLT_MAX) && (P.z==FLT_MAX) ) ? 127:0;
		  //The special value 127 is used to signal points you must not draw
		  cnv->setv(P,j*par->nnodt+i);
		  // i=0,...,par->nnodt-1 is the index of the vertex
		}
	    } // end for(i=0 ...
	} // end else
    } // end for(j=0 ...
  fprintf(stderr,"mplotxx: Load successfully completed\n");
  /* I would expect to have reached the end of file; if no */
  /* I make to print a warning                               */
  if( !feof(pf) )
    {
      fprintf(stderr,"Not reached EOF; perhaps there are some inused data\n");
      fprintf(stderr,"However, do not worry about that !\n");
    }
  return NULL;
}
