/* tst2.c Version 0.1.0. test datagen library in real time */
/* Copyright (C) 2004  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

int main(int argc,char **argv)
   {
   int i;
   int rslt;
   dgfmt *dg;
   slctfmt *slct1;
   char *code1;
   char *hxcode;
   char *bincode;
   char optfname[128];
   if (argc > 3) putstx(*argv);
   dg = (dgfmt *) dginit();
   if (dg == NULL)
      {
      fprintf(stderr,"tst2: out of memory "
         "initializing dg structure\n");
      } /* out of mem */
   dg->verbose = 0;
   dg->opthndl = 1;
   optfname[0] = '\0';
   i = 1;
   while (i < argc)
      {
      rslt = strcmp(*(argv+i),"-v");
      if (!rslt)
         {
         dg->verbose = 1;
         i++;
         continue;
         }
      rslt = strcmp(*(argv+i),"-o");
      if (!rslt)
         {
         if (i+1 < argc)
            {
            strcpy(optfname,*(argv+i+1));
            dg->opthndl = opnopt(optfname);
            i += 2;
            continue;
            } /* if parm available */
         else
            {
            fprintf(stderr,"tst2: missing "
               "output file name\n");
            putstx(*argv);
            } /* bad optfile */
         } /* if output file */
      else
         {
         fprintf(stderr,"tst2: invalid "
            "parameter %s\n",
            *(argv+i));
         putstx(*argv);
         } /* invalid parm */
      } /* for each parm */
   slct1 = (slctfmt *) slctinit(dg);
   if (slct1 == NULL)
      {
      fprintf(stderr,"tst2: out of memory "
         "initializing the slct1 structure\n");
      } /* out of mem */
   slctisrt(dg,slct1,"abcdef");
   slctisrt(dg,slct1,"ghi");
   slctisrt(dg,slct1,"jklmnopqrstu");
   code1   = (char *) "012";
   hxcode  = (char *) "0123456789ABCDEF";
   bincode = (char *) "01";
   putstr(dg->opthndl,"abc ");
   putstr(dg->opthndl,"\n");
   i = 3;
   while (i--)
      {
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 10;
      dgseq(dg);
      putstr(dg->opthndl,":");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 4;
      dgalfa(dg);
      putstr(dg->opthndl,":");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 4;
      dgnum(dg);
      putstr(dg->opthndl,":abc\" \"def:");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 4;
      dgalfa(dg);
      putstr(dg->opthndl,":");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 7;
      dg->tolen   = 0;
      dg->dec     = 5;
      dg->sign    = POSTSIGN;
      dgreal(dg);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->slctmax = 3;
      dgslct(dg,slct1);
      putstr(dg->opthndl,":");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 7;
      dg->tolen   = 0;
      dg->dec     = 5;
      dg->sign    = PRESIGN;
      dgreal(dg);
      putstr(dg->opthndl,":");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 7;
      dg->tolen   = 0;
      dg->dec     = 5;
      dg->sign    = ACCTSIGN;
      dgreal(dg);
      putstr(dg->opthndl,":");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 5;
      dg->tolen   = 0;
      dg->dec     = 0;
      dg->sign    = PRESIGN;
      dgreal(dg);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 64;
      dgtext(dg);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 64;
      dgltr(dg,code1);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 64;
      dgltr(dg,hxcode);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 64;
      dgltr(dg,bincode);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 24;
      dg->dec     = 11;
      dg->sign    = PRESIGN;
      dgamt(dg);
      putstr(dg->opthndl,":");
      dg->loflrng = -999.0;
      dg->hiflrng =  999.0;
      dg->dec     = 7;
      dg->sign    = PRESIGN;
      dgflrng(dg);
      putstr(dg->opthndl,":");
      dg->lointrng = -999.0;
      dg->hiintrng =  999.0;
      dg->fromlen  = 7;
      dg->dec      = 0;
      dg->sign     = PRESIGN;
      dgintrng(dg);
      putstr(dg->opthndl,"\n");
      sleep(1);
      dg->loflrng = -999.0;
      dg->hiflrng =  999.0;
      dg->dec     = 7;
      dg->sign    = PRESIGN;
      dgafrng(dg);
      putstr(dg->opthndl,":");
      dg->lointrng = -999.0;
      dg->hiintrng =  999.0;
      dg->fromlen  = 7;
      dg->dec      = 0;
      dg->sign     = PRESIGN;
      dgairng(dg);
      putstr(dg->opthndl,"\n");
      sleep(1);
      } /* transaction loop */
   cls(dg->opthndl);
   return(0);
   }  /* main */
