/* hxmem.c Version 0.1.0. Hexadecimal dump of memory */
/* Copyright (C) 2004  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

/*									*/
/*      ABOUT: Display the GNU General Public License                   */
/*									*/

#include "datagen.h"

void hxmem(unsigned char *mem,int len)
   {
   int adr;
   int linelen;
   unsigned char *p,*q;
   if (len < 1)
      {
      fprintf(stderr,"hxdmp: invalid len %d\n", len);
      exit(1);
      } /* invalid len */
   adr = 0;
   p = (unsigned char *) mem;
   q = (unsigned char *) mem + len;
   while (p < q)
      {
      linelen = len - adr;
      if (linelen > 16) linelen = 16;
      puthx(adr,linelen,p);
      adr  += 16;
      p    += 16;
      } /* for each 16 bytes of memory */
   } /* hxmem */
