/* dgticks.c Version 0.1.0. Generate current ticks field */
/* Copyright (C) 2004  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

void dgticks(dgfmt *dg)
   {
   int pfxlen;
   int tklen;
   unsigned int segment,offset;
   unsigned int tick1,tick2;
   double ticks;
   char str[128];
   segment = 0x40;
   offset  = 0x6c;
   tick1   = (unsigned int) peek(segment,offset);
   offset  = 0x6e;
   tick2   = (unsigned int) peek(segment,offset);
   ticks = ((double) tick2 * 65536.0) + (double) tick1;
   sprintf(str,"%.0f",ticks);
   tklen = strlen(str);
   if (tklen < dg->fromlen)
      {
      pfxlen = dg->fromlen - tklen;
      while (pfxlen--) putstr(dg->opthndl,"0");
      } /* if zero fill */
   putstr(dg->opthndl,str);
   } /* dgticks */
