/* dgint.c Version 0.1.0. Generate integer field */
/* Copyright (C) 2004  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The integer field has a pseudo logarithmic */
/* distribution, base 2. */
/* The dg->lentype should be CONSTANTLEN */
/* for a logarithmic distribution. */
/* A length range is also possible. */
/* Maximum number of bits is 1024. */

void dgint(dgfmt *dg)
   {
   int i,bitlen,tmplen,stk;
   int len;
   unsigned int rmndr;
   unsigned int rslt;
   unsigned int lst[128];
   unsigned long num;
   unsigned long lmt;
   char str[16];
   char dgtstk[1024];
   len = (int) calclen(dg);
   if (len > 1024 || len < 1)
      {
      fprintf(stderr,"dgint: invalid "
         "length %d\n", len);
      exit(1);
      } /* invalid len */
   if (dg->lentype == CONSTANTLEN)
      {
      lmt = (unsigned long) len;
      bitlen = (int) rndnum(lmt,dg->sd) + 1;
      } /* if not length range */
   else bitlen = len;
   if (bitlen <= 32)
      {
      num = (unsigned long) rndpwr(bitlen,dg->sd);
      sprintf(str,"%lu",num);
      putstr(dg->opthndl,str);
      return;
      } /* if simple 32 bit integer */
   tmplen = bitlen;
   i = 0;
   while (tmplen > 0)
      {
      if (tmplen < 9)
         {
         lst[i] = (int) rndpwr(tmplen,dg->sd);
         } /* if highest order 8 bits */
      else
         lst[i] = (int) rndpwr(8,dg->sd);
      tmplen -= 8;
      i++;
      } /* for each 8 bits of binary integer */
   stk = 0;
   rslt = 1;
   while (rslt)
      {
      i = bitlen >> 3;
      rslt = rmndr = 0;
      while (i >= 0)
         {
         unsigned int tmp;
         tmp = (rmndr << 8) + lst[i];
         rmndr = tmp % 10;
         lst[i] = rslt = tmp / 10;
         i--;
         } /* for each octet */
      dgtstk[stk++] = rmndr + '0';
      } /* create stack of decimal digits */
   str[1] = '\0';
   stk--;
   while (stk >= 0)
      {
      str[0] = dgtstk[stk--];
      putstr(dg->opthndl,str);
      } /* flush stack */
   } /* dgint */
