/* dgafrng.c Version 0.1.0. Generate average floating range */
/* Copyright (C) 2004  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

void dgafrng(dgfmt *dg)
   {
   int negsw;
   int i;
   double diff;
   double fact1,fact2,fact3,fact4;
   double avgfact;
   double rslt;
   char floatfmt[32];
   char str[64];
   if (dg->hiflrng < dg->loflrng)
      {
      fprintf(stderr,"\ndgafrng: invalid "
         "floating point range: %f to %f\n",
         dg->loflrng, dg->hiflrng);
      fprintf(stderr,"Low end larger than "
         "high end\n");
      exit(1);
      } /* invalid floating point range */
   if (dg->loflrng < -999999999.0)
      {
      fprintf(stderr,"\ndgafrng: invalid "
         "floating point range: %f to %f\n",
         dg->loflrng, dg->hiflrng);
      fprintf(stderr,"Low end too small.\n");
      exit(1);
      } /* invalid floating point range */
   if (dg->hiflrng > 999999999.0)
      {
      fprintf(stderr,"\ndgafrng: invalid "
         "floating point range: %f to %f\n",
         dg->loflrng, dg->hiflrng);
      fprintf(stderr,"High end too large.\n");
      exit(1);
      } /* invalid floating point range */
   fact1 = 0.0;
   i = 48;
   while (i--)
      {
      fact1 = (fact1 + (double) rnd(dg->sd)) * 0.5;
      } /* for each decimal bit */
   fact2 = 0.0;
   i = 48;
   while (i--)
      {
      fact2 = (fact2 + (double) rnd(dg->sd)) * 0.5;
      } /* for each decimal bit */
   fact3 = 0.0;
   i = 48;
   while (i--)
      {
      fact3 = (fact3 + (double) rnd(dg->sd)) * 0.5;
      } /* for each decimal bit */
   fact4 = 0.0;
   i = 48;
   while (i--)
      {
      fact4 = (fact4 + (double) rnd(dg->sd)) * 0.5;
      } /* for each decimal bit */
   avgfact = (fact1 + fact2 + fact3 + fact4) / 4.0;
   diff    = dg->hiflrng - dg->loflrng;
   rslt    = dg->loflrng + (diff * avgfact);
   if (rslt < 0.0) negsw = 1;
   else negsw = 0;
   if (negsw)
      {
      if (dg->sign == PRESIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,"(");
      } /* if negative */
   sprintf(floatfmt,"%s%d%s", "%.", dg->dec, "f");
   sprintf(str,floatfmt,fabs(rslt));
   putstr(dg->opthndl,str);
   if (negsw)
      {
      if (dg->sign == POSTSIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,")");
      } /* if negative */
   } /* dgafrng */
