/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.xml ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cXMLDocument
      {

          // inside data
          BufferedInputStream  bis ;
          cStreamCharSet       schset ;


          // methods
          public cXMLDocument ( )
          {
            this.bis    = null ;
            this.schset = null ;
          }

          public cXMLDocument ( BufferedInputStream bis )
          {
            try
            {
              this.bis    = bis ;
              this.schset = new cStreamCharSet(bis) ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

          public cXMLDocument ( File f )
          {
            FileInputStream is ;

            try
            {
              is          = new FileInputStream(f) ;
              this.bis    = new BufferedInputStream(is) ;
              this.schset = new cStreamCharSet(bis) ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

          public Vector getTAGs  ( )
          {
            String      strTag ;
            cXMLTag     tag ;
            Vector      vectorTag ;

            vectorTag = new Vector() ;
            try
            {
              strTag = schset.readStrBetween('<','>') ;
              while (strTag != null)
              {
                tag    = new cXMLTag(strTag) ;
                vectorTag.addElement((Object)tag) ;
                strTag = schset.readStrBetween('<','>') ;
              }
            }
            catch ( Exception e )
            {
            }
            return vectorTag ;
          }

          public boolean isXMLLink ( String strTag )
          {
            String[] XMLLinkTags =
                     {
                       "href", "code", "src", "background",
                       "url", "location", "action", "value",
                       "XML-XPTR"
                     } ;
            int i ;

            for (i = 0; i < XMLLinkTags.length; i++ )
            {
              if (strTag.equalsIgnoreCase(XMLLinkTags[i]))
              {
                  return true ;
              }
            }
            return false ;
          }

          public Vector getURLs ( URL  urlBase )
          {
            String      strTag, strUrl ;
            int         i ;
            URL         urltmp ;
            cXMLTag     tag ;
            Hashtable   tp ;
            Vector      vectorTAG, vectorURL ;
            Enumeration ee ;

            vectorURL = new Vector() ;
            try
            {
              vectorTAG = getTAGs() ;
              for (i=0; i<vectorTAG.size(); i++)
              {
                tag = (cXMLTag)vectorTAG.elementAt(i) ;
                tp  = tag.tagPairs() ;
                if (tp == null)
                    continue ;
                ee  = tp.keys() ;
                while (ee.hasMoreElements())
                {
                  strTag = (String)ee.nextElement() ;
                  strUrl = (String)tp.get(strTag) ;
                  if (isXMLLink(strTag) == true)
                     {
                       try
                       {
                         urltmp = new URL(strUrl) ;
                         vectorURL.addElement(urltmp) ;
                       }
                       catch ( Exception e )
                       {
                         if (urlBase != null)
                            {
                              // try relative ...
                              try
                              {
                                urltmp = new URL(urlBase,strUrl) ;
                                vectorURL.addElement(urltmp) ;
                              }
                              catch ( Exception e1 )
                              {
                              }
                            }
                       }
                     }  // if
                }   // while
              }     // for
            }       // try
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
            }
            return vectorURL ;
          }

          public Vector getURLs ( )
          {
            return getURLs(null) ;
          }

          public void close ( )
          {
            try
            {
              if (this.bis != null)
                  this.bis.close() ;
            }
            catch ( Exception e )
            {
            }
          }

      } // class cXMLDocument


  /* ................................................................... */

