/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.vp ;


   /* ... Import ........................................................ */

      import java.lang.* ;

      import wtool.base.* ;
      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cPop3ServerCommand extends cVpServerCommand
      {
   
         // ... constructors ... 
         public cPop3ServerCommand ( )
         {
           super() ;
         }
   

         // ... request command ...
         public cPop3Response request ( String reqString )
         {
           try
           {
             cPop3Command  pop3C ;
             cPop3Response pop3R ;

             pop3C = new cPop3Command(sd,reqString) ;
             pop3R = pop3C.run() ;
             super.log(pop3C,pop3R) ;
             pop3C = null ;
             return pop3R ;
           }
           catch ( Exception e )
           {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
             return null ;
           }
         }


         // ... connect/disconent ... 
         public cPop3Response connect ( String machine, 
                                        int    port )
         {
           try
           {
             cPop3Response pop3R ;

             if (this.sd != null)
                {
                  appLog.program.print("already conected.\n") ;
                  appLog.program.print("closing conection....\n") ;
                  this.close() ;
                }
             appLog.user.print("Trying connect " + machine + "(" + port + ")" + "...\n") ;
             this.sd   = new cSocket(machine,port) ;
             appLog.user.print("conected.\n") ;
             pop3R = new cPop3Response(sd) ;
             pop3R.readResponse() ;
             return pop3R ;
           }
           catch ( Exception e )
           {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
             return null ;
           }
         }
   
         public cPop3Response close ( )
         {
           try
           {
             cPop3Response pop3R ;

             pop3R = this.request("QUIT\n") ;
             sd.close() ;
             sd = null ;
             return pop3R ;
           }
           catch ( Exception e )
           {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
             return null ;
           }
         }

         public cSocket getSocket ( )
         {
           return this.sd ;
         }   


         // ... more pop3Commands ...
         public cPop3Response user ( String userName )
         {
           return this.request("USER" + userName + "\n") ;
         }

         public cPop3Response pass ( String password )
         {
           return this.request("PASS" + password + "\n") ;
         }

         public cPop3Response retr ( String mailId )
         {
           return this.request("RETR" + mailId + "\n") ;
         }

         public cPop3Response list ( )
         {
           return this.request("LIST\n") ;
         }
      }


  /* ................................................................... */

