/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.spider ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cZipSpider extends cSpider
      {

          // inside data
          cZipStore zs ;
          cUrl     urlFrom ;
          String   resumeFile ;
          boolean  overWrite, zeroLevel ;


          // methods
          public cZipSpider ( )
          {
            super() ;
            zs = null ;
            urlFrom    = null ;
            resumeFile = null ;
            overWrite  = false ;
            zeroLevel  = false ;
          }

          public cZipSpider  ( cWorkSpace spiderWS )
          {
            super(spiderWS) ;

            try
            {
              String value ;
              String sUrlFrom ;

              // url
              value    = spiderWS.getProperty("fromUrl") ;
              sUrlFrom = new String(value) ;
              urlFrom  = new cUrl(sUrlFrom) ;

              // mirrorZip
              zs = new cZipStore(urlFrom.getURL().getHost() + ".zip") ;

              // resumeFile
              value      = urlFrom.getURL().getHost() ;
              resumeFile = new String("resume." + value) ;

              // overwrite
              value     = spiderWS.getProperty("overwrite") ;
              overWrite = (value.equalsIgnoreCase("TRUE")) ;

              // zeroLevel
              value     = spiderWS.getProperty("recursive") ;
              zeroLevel = (value.equalsIgnoreCase("FALSE")) ;
            }
            catch ( Exception e )
            {
            }
          }

          public void finalize ()
          {
            zs.finish() ;
          }


          // operations ...
          public void walk ( )
          {
            boolean      ok ;
            File         f ;
            int          irI ;
            cUrl         rI ;
            cUrlList     rL ;
            cUrlShadow   rS ;

            try
            {
              rL = new cUrlList() ;
              rL.insert(urlFrom) ;

              // go download ...
              rI  = rL.getFirst() ;
              irI = 0 ;
              while (rI != null)
              {
                irI ++ ;
                appLog.user.print
                (
                  "\r" + "[" + irI + "/" + rL.length() + "]" + "\t"
                ) ;
            		rS = new cUrlShadow(rI) ;
                f  = rS.getFile(false) ;
                ok = rS.shadowToLFS(f) ;
                if (ok == true)
                   {
                     if (zeroLevel == false)
                         exploreURL(f,rL,rI.getURL()) ;
                     zs.addFile(rS.getFile(true).getPath(),
                                rS.getFile(false).getPath()) ;
                     f.delete() ;
                   }

                rI = rL.getNext() ;
              }
              zs.finish() ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

      }  // cZipSpider


  /* ................................................................... */
