/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.bin ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;
      import wtool.spider.* ;


   /* ... Class ......................................................... */


      class wcopy
      {
         /**
          *
          *   Atributos
          *
          */


         /**
          *
          *  Print a welcome intro
          *
          *     @params wVer version
          *     @return nothing
          *
          */
          public static void welcome ( cVersion wVer )
          {
            System.out.print( "\n" +
                              wVer +
                              "\n" ) ;
          }

         /**
          *
          *  Print goodbye ...
          *
          *     @params wName program name
          *     @return nothing
          *
          */
          public static void goodbye ( String wName )
          {
            System.out.print( "\n" +
                              "\n" +
                              "\t" + "thanks for use " + wName + "\n" +
                              "\n" ) ;
          }

          /**
           *
           *    wcopy <url>
           *          like cp (unix) or copy (dos), copy <url> contens into local
           *          file system. Allways dest. are current working directory.
           *
           */
          public static void main ( String args [] )
          {
            // spider
            cSpider     sbot ;
            cWorkSpace  spiderWS ;
            // wcopy
            cVersion    wcopyVer ;
            cWcpParams  wcopyPar ;


            try
            {
              // new Objects
              wcopyVer  = new cVersion(0,11,3,
                                       "acaldero@laurel.datsi.fi.upm.es",
                                       "wcopy") ;
              welcome(wcopyVer) ;
              wcopyPar  = new cWcpParams(args,1) ;
              spiderWS  = new cWorkSpace() ;

              // get params ...
              spiderWS.putProperty("fromUrl",args[0]) ;
              if ( wcopyPar.getValue("-r") == null )
                        spiderWS.putProperty("recursive","false") ;
                   else spiderWS.putProperty("recursive","true") ;
              if ( wcopyPar.getValue("-o") == null )
                        spiderWS.putProperty("overwrite","false") ;
                   else spiderWS.putProperty("overwrite","true") ;

              // wcopy
              sbot = new cMirrorSpider(spiderWS) ;
              sbot.walk() ;
              goodbye("wcopy") ;
              System.exit(0) ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

      }  // wcopy


  /* ................................................................... */
