/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.bin ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;
      import wtool.spider.* ;


   /* ... Class ......................................................... */


      class cWlsParams
      {
         /**
          *
          *   Atributos
          *
          */
          cParams wlsPar ;


          public cWlsParams ( String args [],
                              int    ibegin )
          {
            try
            {
              // check are arguments ...
              if (args.length == 0)
                 {
                   this.info() ;
                   System.exit(0) ;
                 }

              // new cParams()
              wlsPar  = new cParams() ;
              wlsPar.insert(new String("-r"),new Integer(0)) ;
              wlsPar.insert(new String("-l"),new Integer(0)) ;

              // check arguments are good ...
              if (wlsPar.checkArgs(args,ibegin) == false)
                 {
                   this.usage() ;
                   System.exit(0) ;
                 }

              // load params ...
              wlsPar.processArgs(args,ibegin) ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

          public void info ( )
          {
            System.out.print( "\n" +
                              "\t" + "\t" + "wls <url>  [-r] [-l]" + "\n" +
                              "\n" +
                              "\t" + "\t" + "<url>" + "\t" + "url to list links" + "\n" +
                              "\t" + "\t" + "-r" +    "\t" + "recurse into sublinks" + "\n" +
                              "\t" + "\t" + "-l" +    "\t" + "long information" + "\n" +
                              "\n" ) ;
          }

          public void usage ( )
          {
            System.out.print( "\n" +
                              "\t" + "Usage:" + "\n" ) ;
            info() ;
            System.out.print( "\n" ) ;
          }

          public String getValue ( String option )
          {
            return this.wlsPar.getValue(option) ;
          }

      }  // cWlsParams


  /* ................................................................... */
