/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cUrlList
      {

          // inside data
          Vector  vector ;
          int     last ;


          // methods
          public cUrlList ( )
          {
            vector = new Vector() ;
            last   = 0 ;
          }

          public void insert ( cUrl uI )
          {
            if (isInList(uI) == false)
               {
                 vector.addElement(uI) ;
               }
          }

          public boolean isInList ( cUrl uI )
          {
            int i ;
            cUrl auxRI ;

            for (i=0; i<vector.size(); i++)
            {
              auxRI = (cUrl)vector.elementAt(i) ;
              if ( uI.getURL().sameFile(auxRI.getURL()) )
                 {
                   return true ;
                 }
            }
            return false ;
          }

          public void delete ( cUrl uI )
          {
            if (isInList(uI) == true)
               {
                 vector.removeElement(uI) ;
               }
          }

          public int length ()
          {
            if (vector == null)
                return 0 ;
            return vector.size() ;
          }

          public cUrl getFirst ()
          {
            if (vector.size() > 0)
               {
                 last = 0 ;
                 return (cUrl)vector.elementAt(0) ;
               }
            return null ;
          }

          public cUrl getNext ()
          {
            last ++ ;
            if (vector.size() > last)
               {
                 return (cUrl)vector.elementAt(last) ;
               }
            return null ;
          }

          public String toString ( )
          {
            int i ;
            StringBuffer sCat ;

            sCat = new StringBuffer("") ;
            for (i=0; i<vector.size(); i++)
                {
                  sCat.append( ((cUrl)vector.elementAt(i)).toString() ) ;
                }
            return sCat.toString() ;
          }

          public boolean info ( PrintStream ps,
                                boolean     fullInfo,
                                int         whereBegin )
          {
            int i ;

            if (ps == null)
                return false ;

            ps.print("Links:       " + "\t" + (vector.size() - whereBegin) + "\n") ;
            for (i=whereBegin; i<vector.size(); i++)
                {
                  if (fullInfo == true)
                          ((cUrl)vector.elementAt(i)).info(ps) ;
                     else ps.print( ((cUrl)vector.elementAt(i)).getURL() + "\n" ) ;
                }
            return true ;
          }

      }  // cUrlList


  /* ................................................................... */
