/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cUrl
      {
         URL            url ;
         URLConnection  urlc ;
         cIdent         identification ;


         // constructor
         public cUrl ( )
         {
           url  = null ;
           urlc = null ;
           identification = new cIdent() ;
         }

         public cUrl ( URL urlR )
         throws Exception
         {
           url  = urlR ;
           urlc = null ;
           if (url == null)
               throw new Exception() ;
           identification = new cIdent() ;
         }

         public cUrl ( String spec )
         {
           try
           {
             url  = new URL(spec) ;
             urlc = null ;
             identification = new cIdent() ;
           }
           catch ( Exception e )
           {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
           }
         }


         // accesors
         public URL getURL ( )
         {
           return this.url ;
         }

         public URLConnection getURLConnection ( )
         {
           return this.urlc ;
         }

         public cIdent getIdentification ( )
         {
           return this.identification ;
         }

         public void setIdentification ( cIdent identification )
         {
           this.identification = identification ;
         }


         // operations
         public String toString ( )
         {
           return url.toString() ;
         }

         public boolean info ( PrintStream ps )
         {
           if (ps == null)
               return false ;

           ps.print( "Name:        " + "\t" + url + "\n" ) ;
           if (urlc != null)
              {
                ps.print( "Expiration:  " + "\t" + new Date(urlc.getExpiration())   + "\n" +
                          "LastModified:" + "\t" + new Date(urlc.getLastModified()) + "\n" +
                          "Type:        " + "\t" +          urlc.getContentType()   + "\n" +
                          "Size:        " + "\t" +          urlc.getContentLength() + "\n" ) ;
              }
           return true ;
         }

      }


   /* ................................................................... */

