/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;

      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cSocket extends Socket
      {
         InputStream  is ;
         OutputStream os ;
         InputStreamReader  isr ;
         OutputStreamWriter osw ;
         BufferedReader br ;
         BufferedWriter bw ;

         public cSocket ( String host,
                          int    port )
         throws IOException, UnknownHostException
         {
           super(host,port) ;
           try
           {
             is  = super.getInputStream() ;
             isr = new InputStreamReader(is) ;
             br  = new BufferedReader(isr) ;
             os  = super.getOutputStream() ;
             osw = new OutputStreamWriter(os) ;
             bw  = new BufferedWriter(osw) ;
           }
           catch ( Exception e )
           {
             appLog.system.println( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
           }
         }

         public String readLine ( )
         throws IOException
         {
           return br.readLine() ;
         }

         public int read ( char[] buffer,
                           int off,
                           int len )
         throws IOException
         {
           return br.read(buffer,off,len) ;
         }

         public int read ( byte[] buffer,
                           int off,
                           int len )
         throws IOException
         {
           return is.read(buffer,off,len) ;
         }

         public void write ( String str )
         throws IOException
         {
           bw.write(str) ;
         }

      }


   /* ................................................................... */

