/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.app ;


   /* ... Import ........................................................ */

      import java.lang.* ;


   /* ... Class ......................................................... */


      public class cVersion
      {
         /**
          *
          *   Atributos
          *
          */
          int    version ;   // orientation
          int    release ;   // new improvements
          int    update ;    // bug fix
          String author ;    // mainteiner
          String appName ;   // application name


         /**
          *
          *  Default constructor
          *
          *     @params nothing
          *     @return nothing
          *
          */
          public cVersion ( )
          {
            this.version = 0 ;
            this.release = 0 ;
            this.update  = 0 ;
            this.author  = null ;
            this.appName = null ;
          }

         /**
          *
          *  Constructor using values.
          *
          *     @params version int
          *     @params release int
          *     @params update  int
          *     @return nothing
          *
          */
          public cVersion   ( int  version,
                              int  release,
                              int  update )
          {
            this.version = version ;
            this.release = release ;
            this.update  = update ;
            this.author  = "unknow" ;
            this.appName = "unknow" ;
          }

         /**
          *
          *  Constructor using values.
          *
          *     @params version int
          *     @params release int
          *     @params update  int
          *     @params author  String
          *     @params appName String
          *     @return nothing
          *
          */
          public cVersion   ( int     version,
                              int     release,
                              int     update,
                              String  author,
                              String  appName )
          {
            this.version = version ;
            this.release = release ;
            this.update  = update ;
            this.author  = author ;
            this.appName = appName ;
          }


         /**
          *
          *  Return a string representation.
          *
          *     @params nothing
          *     @return String
          *
          */
          public String toString ( )
          {
            String ver ;

            // line 1
            ver  = "\n" ;
            // line 2
            ver += "\t" + " " + appName + " " + "\n" ;
            // line 3
            ver += "\t" ;
            for (int i=0; i<appName.length() + 2; i++)
                 ver += "-" ;
            ver += "\n" ;
            // line 4
            ver += "\n" ;
            // line 5
            ver += "\tversion " + version + "." + release + "." + update + "\n" ;
            // line 6
            ver += "\t" + author + "\n" ;
            // line 7
            ver += "\t" + "thanks to my parents and my friends ..." + "\n" ;
            // line 8
            ver += "\n" ;
            return ver ;
          }

      }  // cVersion


  /* ................................................................... */

