/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.app ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.util.* ;


   /* ... Class ......................................................... */


      public class cParams
      {
         /**
          *
          *   Atributos
          *
          */
          Hashtable  nValues ;
          Hashtable  values ;


         /**
          *
          *  Default constructor
          *
          *     @params nothing
          *     @return nothing
          *
          */
          public cParams ( )
          {
            nValues = new Hashtable() ;
            values  = new Hashtable() ;
          }

         /**
          *
          *  Insert a new "switch-value".
          *
          *     @params option String
          *     @params nValue Integer
          *     @return boolean
          *
          */
          public boolean insert ( String  option,
                                  Integer nValue )
          {
            if (nValues.containsKey(option) == true)
                return false ;
            nValues.put(option,nValue) ;
            return true ;
          }

         /**
          *
          *  Get value associate to a param switch
          *
          *     @params option switch name
          *     @return String
          *
          */
          public String getValue ( String option )
          {
            if (nValues.containsKey(option) == false)
                return null ;
            if (values.containsKey(option) == false)
                return null ;
            return (String)values.get(option) ;
          }

         /**
          *
          *  Check if options are well formed
          *
          *     @params args   String[]
          *     @params ibegin int
          *     @return boolean
          *
          */
          public boolean checkArgs ( String args [],
                                     int    ibegin )
          {
            int     i, nargs ;
            boolean ok ;

            nargs  = args.length ;
            ok     = true ;
            for (i=ibegin; i<nargs; i++)
            {
              if (nValues.containsKey(args[i]) == false)
                 {
                   System.out.print("\t" + "unknow argument: " + args[i] + "\n") ;
                   ok = false ;
                 }
            }
            return ok ;
          }

         /**
          *
          *  Check if options are well formed and
          *  store "switch-values" pairs.
          *
          *     @params args   String[]
          *     @params ibegin int
          *     @return boolean
          *
          */
          public boolean processArgs ( String args [],
                                       int    ibegin )
          {
            int i, nargs ;
            int nval ;

            nargs = args.length ;
            for (i=ibegin; i<nargs; )
            {
              if (nValues.containsKey(args[i]) == false)
                 {
                   System.out.print("unknow argument: " + args[i] + "\n") ;
                   return false ;
                 }
              nval = ((Integer)nValues.get(args[i])).intValue() ;
              if (nval == 0)
                 {
                   values.put(args[i],new String("")) ;
                   i++ ;
                 }
              if (nval > 0)
                 {
                   String options ;

                   options = args[i+1] ;
                   for (int j=1; (j<nval) && (i+1+j <nargs); j++)
                       {
                         options = options + " " + args[i+1+j] ;
                       }
                   values.put(args[i],new String(options)) ;
                   i = i + nval ;
                 }
            }
            return true ;
          }

      }  // cParams


  /* ................................................................... */
