/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 4.x,5.x and 6.x files into LaTeX          *
 * modul:       wp2latex.cc                                                   *
 * description: The main program opens and closes files and calls functions.  *
 ******************************************************************************/

///To do list:///
// PODIVAT SE NA sTRsTR
// u minipage se musi nacist vertical position a v pripade full nastavit \vsize
// podivat se na pismo wsuipa
// sjednotit LineSpacing pro vsechny verze WP
// vnorene dokumenty
// pridat podporu kodovych stranek
// udelat titulni stranku i pro WP6.x
// vyhazet pridane prazdne radky s komentarem
// pokusit se zkonvertovat invisible characters
// nechodi center tab a right tab
// tabset6() je potreba opravit
// podivat se na overstrike WP4.x

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//Non standard include files
#include <common.h>
#include "wp2latex.h"
#include <strings.h>
#include <lists.h>

#ifdef __UNIX__
 #include <unistd.h>
 #include <signal.h>
#endif

#ifdef __Disable_NULL_printf
 #define chk(x) x==NULL?"NULL":x
#else
 #define chk(x) x
#endif

/*           Version 1.0  Date 27-1-1990
	     Version 2.0  Date 7-12-1996
		     2.1  Date 19-7-1997
		     2.15 Date 17-11-1997
		     2.19 Date 1-3-1998
		     2.20 Date 14-3-1998
*/


/*
Flags:'h';       Hard return
      's';       Soft return      !!!!!!! 'r'
      'P';       Hard page
      'p';       Soft page

      'B'        Table
      'C','c'    Center (only one line)
      'I','i'    Identing (both)
      'L'        Left
      'M' [cols] Multicolumn enviroment
      'R'        Right
      'Q','q'    Equation (array of equations)
      'T'        Tabbing


      'l' size			Line Spacing
      'S' number,[tab1,tab2]	Tabset

      '!'			Ignore change Enviroment before (push)
      '^'			Ignore change Enviroment after (pop)
      #FF			end of line
*/

/*WP2LaTex switches: -1:disabled; 0:automatically enabled; 1: forced to enable*/
SBYTE   Cyrilic=false,
	colors=false,			/* Only for LaTex 2.0e */
	textcomp=-1,
	EndNotes=false,
	FancyHdr=-1,
	Columns=1,	/*-1 disabled; 0 auto two; 1 auto multi; 2 forced two; >2 forced multi*/
	InputPS=false,
	PostScript=false,
	MakeIdx=-1,
	Wasy=-1,	/*Totaly Disabled*/
	Amssymb=-1,	/*Totaly Disabled*/
	LaTeXsym=0,
	Bbm=-1,
	Rsfs=-1,
	LongTable=false,
	Czech=false,
	German=false;
boolean Index=false,
	NFSS=false,
	Tabs = true,
	twoside=false,
	SaveWPG=false,
	ExactFnNumbers=false,
	CPStyles=false;

int WPVersion=0x501,
    LaTeX_Version=0x300; /* 0x209=LaTeX 2.09; 0x300=LaTex 3.0 (or 2e) */

unsigned short CodePage, WPcharset;

void (*Convert_first_pass)(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile);
char *DocumentType="Unknown type";
#ifdef HTML
void Convert_pass1_HTML(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile);
#endif
#ifdef RTF
void Convert_pass1_RTF(FILE *FileIn,FILE  *table, FILE *StripOut,FILE *LogFile,FILE *ErrorFile);
#endif
string & fGets2(FILE *f, string & pstr);

boolean OptimizeSection;
unsigned char Verbosing;
boolean TexChars;
boolean ExtendedCheck,FixSpaces;
boolean EraseStrip=true;
char *OutputDir="./",*RelativeFigDir=".",*InputDir="./";
list Counters;
list FontTable;
list UserLists;

long  num_of_lines_stripfile,
      UnknownCharacters,UnknownObjects,CorruptedObjects;
LatTable lat;
char** UserWPCharSet=NULL;

string wpd_filename, strip_filename, table_filename, latex_filename,
       log_filename;
string wpd_password;
static FILE *wpd, *table;
static FILE *strip, *logg, *err;
static FILE *latex;


char *Open_com[26] = {
  "{\\LARGE ", "{\\Large ", "{\\large ", "{\\small ", "{\\footnotesize ",
  "$^{{\\rm ", "$_{{\\rm ", "{\\fontshape{ol}\\selectfont ", "{\\it ", "", "\\textcolor{red}{", "\\underline{\\Underline{",
  "{\\bf ", "\\StrikeOut{", "\\Underline{", "{\\sc ",
  "\\part{", "\\chapter{", "\\section{", "\\subsection{", "\\subsubsection{",
  "\\paragraph{", "\\subparagraph{","{","{","\\iffalse "
};

char *Close_com[26] = {
  "}", "}", "}", "}", "}", "}}$", "}}$", "}", "\\/}", "", "}", "}}", "}", "}",
  "}", "}", "}", "}", "}", "}", "}", "}", "}", "}", "}","\\fi "
};

int OutputStyle=First_com_section + 2;

//Definition of methods of the Percentor class
void Percentor::Actualise(long NewValue)
{
int NewPercent;

 if(EndValue==StartValue) NewPercent=100;
	else NewPercent = (int)floor(
	     (float)(NewValue - StartValue) / (EndValue - StartValue) * 100 + 0.5);

 if(NewPercent!=CurrentPercent)
		{
		CurrentPercent=NewPercent;
		Show();
		}
}


void Percentor::SetPercent(int NewPercent)
{
 if(NewPercent==CurrentPercent && displayed) return;
 CurrentPercent=NewPercent;
 Show();
}


void StrGets(string & s)
{
char c;

  c=0;
  s="";
  while(c!='\n')
      {
      c=fgetc(stdin);
      switch(c)
	 {
	 case '\n':break;
	 default:s+=c;
	 }
      }
}


void RunError(int ExitCode, const char *s)
{
  putchar('\n');
  switch (ExitCode)
    {
    case 0:    fprintf(err,_("Conversion completed.\n\n"));
	       break;
    case 0x2:  fprintf(err,_("Error: File %s not found.\n"),chk(s));
	       break;
    case 0x3:  fprintf(err,_("Error: Path not found.\n"));
	       break;
    case 0x6:  fprintf(err,_("Error: Temporary file %s cannot be created!\n"),s);
	       break;
    case 0x10: fprintf(err,_("Info: Program was aborted.\n"));
	       break;
    case 0x15: fprintf(err,_("Info: Please report this situation to enable further developping WP2LaTeX.\n"));
	       break;
    case 0x20: fprintf(err,_("Error: Output device is full.\n"));
    	       break;           
    case 0x8B: fprintf(err,_("Fatal: Program Error. Write full bug report.\n"));
               break;           
    case 0x200:fprintf(err,_("Error: No filename entered!\n"));
               break;
    case 0x201:fprintf(err,_("Error: File \"%s\" is not a WordPerfect document!\n"),wpd_filename());
	       break;
    case 0x202:fprintf(err,_("Error: Unsupported format (%s)!\n"),DocumentType);
	       break;
    case 0x203:fprintf(err,_("Error: Sorry, I have no idea how to decrypt this file!\n"));
	       break;
    }


  if (wpd != NULL)   fclose(wpd);     	  wpd = NULL;
  if (strip != NULL)
  	{
	fclose(strip);			  strip = NULL;
#ifndef DEBUG
	if(EraseStrip) unlink(strip_filename);
#endif
	}
  if (table != NULL)
	{
	fclose(table);			 table = NULL;
#ifndef DEBUG
	if(EraseStrip) unlink(table_filename);
#endif
	}
  if (latex_filename != '-')
      if (latex != NULL) fclose(latex);   latex = NULL;
  if (logg != NULL)
        {
        if(!ExitCode)
	  fprintf(logg,_("\n!!!! Fatal Exit No %d!!!!\n"),ExitCode);
	fclose(logg);		          logg = NULL;
        }

  exit(ExitCode);
}

#if defined(__UNIX__) & !defined(DEBUG)
/* This is a main signal handler */
void sig_int(int signo)
{
 switch(signo)
    {
    case SIGINT:RunError( 0x10, "");   break;
    case SIGSEGV:RunError(0x8B, "");   break;
    }
}

static void HookSignals(void)
{
 signal(SIGINT,sig_int);
 signal(SIGSEGV,sig_int);
}
#endif


/*This procedure is aimed to parse a configuration file*/
static void LoadConfigFile(const char *filename)
{
FILE *F;
string s;
int Section=0,i;

if( (F=fopen(filename,"r"))==NULL ) return;
while(!feof(F))
   {
   fGets2(F,s);
   s=cutspaces(s);
   if(s=="") continue;
   if(s=="[WPUserChars]")
	{
	Section=1;
	continue;
	}
   if(s=="[Fonts]")
	{
	Section=2;
	continue;
	}

   switch(Section)
	{
	case 0:break;
	case 1:if(sscanf(s(),"%d",&i)!=1) break;
	       if(i<0 || i>255) break;
	       while(isdigit(s[0]))
		   {
		   s=copy(s,1,length(s)-1);
		   if(s=="") break;
		   }
	       s=cutspaces(s);
	       if(UserWPCharSet==NULL)
		   {
		   UserWPCharSet=(char **)calloc(255,sizeof(char *));
		   if(UserWPCharSet==NULL) break;
		   memset(UserWPCharSet,0,255*sizeof(char *));
		   }

	       if(UserWPCharSet[i]!=NULL) free(UserWPCharSet[i]);
	       UserWPCharSet[i]=strdup(s());
	       break;
	case 2:FontTable+=s;
	       break;
	}

   }


fclose(F);
}


//This is a state machine for detecting HTML files
#define MaxChar 0x200   //this can be used to tune a quality of autodetection
static int DetectHtml(FILE *text)
{
int Status,CharNo=0,chr;
long OldFilePos;

  if(text==NULL) return(0);

  OldFilePos=ftell(text);
  fseek(text, 0L, SEEK_SET);

  Status=0;
  fseek(text,0,SEEK_SET);
  while(CharNo<MaxChar)
	{
	if( (chr=fgetc(text)) == EOF) goto NoHTML;
	CharNo++;
	switch(Status)
		{
		case 0:if(chr=='\n' || chr=='\r' || chr==' ') break;
		       if(chr=='<')
			    {
			    Status=1;
			    break;
			    }
		       goto NoHTML;
		case 1:if(chr=='!')
			    {
			    Status=6;
			    break;
			    }
		       if(chr=='h' || chr=='H')
			    {
			    Status=2;
			    break;
			    }
		       goto NoHTML;
		case 2:if(chr=='t' || chr=='T')
			    {
			    Status=3;
			    break;
			    }
		       goto NoHTML;
		case 3:if(chr=='m' || chr=='M')
			    {
			    Status=4;
			    break;
			    }
		       goto NoHTML;
		case 4:if(chr=='l' || chr=='L')
			    {
			    Status=5;
			    break;
			    }
		       goto NoHTML;
		case 5:if(chr=='>')
			    {
			    fseek(text,OldFilePos,SEEK_SET);
			    return(1);		//HTML detected
			    }
		       goto NoHTML;
		case 6:if(chr=='>') Status=0;
		       break;
		default:printf("Error: Status automat failed at state %d\n",Status);
			Status=0;
		}

	}

NoHTML:
  fseek(text,OldFilePos,SEEK_SET);
  return(0);
}

static int DetectRTF(FILE *text)
{
long OldFilePos;
char buffer[6];

  if(text==NULL) return(0);

  OldFilePos=ftell(text);
  fseek(text, 0L, SEEK_SET);

  if(fread(buffer,1,5,text)!=5) goto NoRTF;
  if(!strncmp(buffer,"{\\rtf",5))		//RTF startup detected
	{
	return(1);
	}

NoRTF:
  fseek(text,OldFilePos,SEEK_SET);
  return(0);
}



/* Checks whether the given document is a valid  WP5.x or WP6.x - document.
 * return: int: 0 if OK, else error code  */
static int Wpd_check(void)
{
  WORD id1, id2, filetype, ver, encryption, dmp3;
  DWORD StartDoc;

  Rd_word(wpd, &id1);
  Rd_word(wpd, &id2);

//*****Strong tests*****
  if (id1 == 0x57ff && id2 == 0x4350)
    {
    Rd_dword(wpd,&StartDoc);
    Rd_word(wpd, &filetype);
    Rd_word(wpd, &ver);
    Rd_word(wpd, &encryption);
    Rd_word(wpd, &dmp3);

    switch(filetype>>8)
	{
	case  0xA:DocumentType="WordPerfect Document";break;
	case  0xB:DocumentType="Dictionary file";break;
	case  0xC:DocumentType="Thesaurus file";break;
	case  0xD:DocumentType="Block";
		  RunError(0x15);
		  break;
	case  0xE:DocumentType="Rectangular Block";
		  RunError(0x15);
		  break;
	case  0xF:DocumentType="Column Block";
		  RunError(0x15);
		  break;
	case 0x10:DocumentType="Printer Resource file (.PRS)";break;
	case 0x11:DocumentType="Setup file";break;
	case 0x12:DocumentType="Reserved";break;
	case 0x13:DocumentType="Printer Resource file (.ALL)";break;
	case 0x14:DocumentType="Display Resource file (.DRS)";break;
	case 0x15:DocumentType="Overlay file";break;
	case 0x16:DocumentType="WordPerfect Graphics file";break;
	case 0x17:DocumentType="Hypenation code module";break;
	case 0x18:DocumentType="Hypenation data module";break;
	case 0x19:DocumentType="Macro Resource File";break;
	case 0x1A:DocumentType="Graphics screen Driver";break;
	case 0x1B:DocumentType="Hypenation lex module";break;
	case 0x1C:DocumentType="Printer Q codes (VAX/DG)";
		  RunError(0x15);
		  break;
	case 0x1D:DocumentType="Spell code module word list";break;
	case 0x1E:DocumentType="WP5.1 equation resource file";break;
	case 0x1F:DocumentType="Reserved";break;
	case 0x20:DocumentType="VAX.SET";break;
	case 0x21:DocumentType="Spell code module rules";break;
	case 0x22:DocumentType="Dictionary rules";break;
	case 0x23:DocumentType="Reserved";break;
	case 0x24:DocumentType=".WPD files";
		  RunError(0x15);
		  break;
	case 0x25:DocumentType="Rhymer word file";break;
	case 0x26:DocumentType="Rhymer word file";break;
	case 0x27:
	case 0x28:DocumentType="Reserved";break;
	case 0x29:DocumentType="WP5.1 ins file";
		  RunError(0x15);
		  break;
	case 0x2A:DocumentType="Mouse driver for WP5.1";break;
	case 0x2B:DocumentType="Unix setup for WP5.0";break;
	case 0x2C:DocumentType="Macintosh WP2.0 document";break;
	case 0x2D:DocumentType="VAX file WP4.0 document";
		  RunError(0x15);
		  break;
	case 0x2E:DocumentType="External spell code";break;
	case 0x2F:DocumentType="External spell dictionary";break;
	case 0x30:DocumentType="Macintosh soft graphics";break;

	case 0x38:DocumentType="WPWin5.1 App Resource library";break;
	}


    if (filetype == 0xa01)
	   /*   version == 0x0000 -> WP 5.0
	    *   version == 0x0100 -> WP 5.1
	    *   version == 0x0002 -> WP 6.0
	    *   version == 0x0102 -> WP 6.1
	    *   version == 0x0202 -> WP 7.0  */
       {
       fseek(wpd, StartDoc, SEEK_SET);
       switch(ver & 0xFF)  // major version
	   {
	   case 0:WPVersion=0x500 + (WORD)(ver>>8);
		  if(encryption==0) Convert_first_pass=Convert_pass1_WP5;
			       else Convert_first_pass=Convert_pass1_WP5_encrypted;
		  break;
	   case 2:WPVersion=0x600 + (WORD)(ver>>8);
		  if(WPVersion>=0x602) WPVersion+=0xFE;
		  if(encryption==0) Convert_first_pass=Convert_pass1_WP60;
			       else Convert_first_pass=Convert_pass1_WP6_encrypted;
		  break;
	   default:WPVersion=0x500l + (WORD)(ver>>8) + 256*(ver & 0xFF);
		   Convert_first_pass=Convert_pass1_WP60;
		   fprintf(err,_("\nWarning: Unknown WP version 0x%x. Guessing WP%d.%d. EXPECT ERRORS!!!"),ver,WPVersion>>8,WPVersion & 0xFF);
		   encryption=0;
	   }

	if(encryption!=0) fprintf(err,_("\nWarning: File seems to be encrypted. Conversion may not be possible!!"));
	}
    return 5;     /* it is a valid WP [5,6].x - document*/
    }

  if (id1 == 0xFFFE && id2 == 0x6161)	//This is a WP4.1 encrypted document
	{
	WPVersion=0x401;
	Convert_first_pass=Convert_pass1_WP4_encrypted;
	return 4;
	}


//++++Weak Tests++++

  if (id1 == 0x2125 && id2 == 0x5350)	//This is a Postscript file
	{
	fseek(wpd, 0L, SEEK_SET);
	DocumentType="Postscript file";
	return(100);
	}

  if(DetectHtml(wpd))
	{
	fseek(wpd, 0L, SEEK_SET);
	DocumentType="HTML file";
#ifdef HTML
	Convert_first_pass=Convert_pass1_HTML;
#endif
	return(110);
	}

  if(DetectRTF(wpd))
	{
	fseek(wpd, 0L, SEEK_SET);
	DocumentType="RTF file";
#ifdef RTF
	Convert_first_pass=Convert_pass1_RTF;
#endif
	return(120);
	}


//-----Forced only-----
  if(WPVersion==0x400)
	{
	fprintf(err,_("\nWarning: WP v 4.0 is forced. No autodetection is possible. ERRORS may occur!!!"));
	Convert_first_pass=Convert_pass1_WP4;
	fseek(wpd, 0L, SEEK_SET);
	ExtendedCheck = true;	/* It would be better to switch safe mode on. */
	return(4);
	}

  RunError(0x201);     /* it may be a valid WP 4.x document - but error is reported*/
  return 0;
}

static void Heading(void)
{
static boolean printed=false;
 if(printed) return;
 printed=true;

 if(Verbosing >= 1)
     printf(_("\n>>>WP2LaTeX<<< Conversion program: From Wordperfect to LaTeX Version %s \n\n"
              "  (c) TUE-Eindhoven ---- Made by R.C.Houtepen ---- Date : 24 Jan 1990\n"
	      "  (c) CVUT Prague   ---- Made by J.Fojtik     ---- Date : 1996-2000\n"),
            version);
}

/* This procedure handles parametters and the filenames*/
static int Filenames(int argc , char *argv[], boolean ArgOnly)
{
  string StrName;
  char *name;
  long p;
  char firstch;

  wpd_filename = "";
  latex_filename = "";

  for (p = 1; p < argc; p++) {
    StrName=argv[p];
    if(StrName=="") continue;
    name=StrName();
    firstch = name[0];
    if (firstch == '/') name[0] = '-';
    if (name[0] == '-')
      {
      if (!strcmp(name, "-amssymb")||!strcmp(name, "-Amssymb"))
		{
		Amssymb = false;
		continue;
		}
      if (!strcmp(name, "-bbm")||!strcmp(name, "-Bbm"))
		{
		Bbm = false;
		continue;
		}
      if (!strcmp(name, "-configfile")||!strcmp(name, "-@"))
		{
		if(++p<argc)
		    {
		    LoadConfigFile(argv[p]);
		    }
		continue;
		}
      if ((!strcmp(name, "-copyright"))||(!strcmp(name, "--copyright")))
	   {
	   Heading();
	   puts(_("\nThis program and related files are copyright (c) 1996-1999 Fojtik Jaroslav."
		  "\nThis code can be redistributed and/or modified under the terms of the GNU"
		  "\nGeneral Public License available from: http://www.gnu.org/copyleft/gpl.html."
		  "\nWith one aditional requirement:"
		  "\n         If you decide to modify, you should somehow sign a modified"
		  "\nplace in the code and you must append your name at the end of this message"
		  "\nin this manner:"
		  "\n \"Modified by Mr Xxxxx Yyyy month.day.year\""
		  "\n        If you decide to modify this code, try to ask me first. Your change may"
		  "\nbe userfull for others and it will be good to include it into further releases."
		  "\n        If you didn't contribute to WP2LaTeX in any way, you must not say that"
		  "\nyou are author of it."
		  "\n"
		  "\nThanks to:Rafael Rodriguez Pappa  for several notes and bugfixes"
		  "\n          Damil Cavar             for several bugreports"
		  "\n          Hilmar Preusse          for translating several WP extended chars"
		  "\n          and of course to all authors of previous releases of WP2LaTeX"
		  "\n"
		  "\nIf you find this program userful please send me a *POSTCARD* with"
		  "\ncharacteristic image of your country."
		  "\nMy address is: Jaroslav Fojtik; Dvouramenna 13; Prague 4; Czech Republic"
		  "\n                14000"
		  "\n"
		  "\nAuthor is not liable for any damage of your system or loose of your profit"
		  "\ncaused by using or not using this program."
		  "\n"));
	   exit(EXIT_SUCCESS);
	   }

      if (!strncmp(name, "-cp",3))
	    {
	    name+=3;
	    if(*name=='-') name++;
	    if (!strcmp(name, "852"))
		  {
		  CodePage = 852;
		  continue;
		  }
	    if (!strcmp(name, "895"))
		  {
		  CodePage = 895;
		  continue;
		  }
	    if (!strcmp(name, "1250"))
		  {
		  CodePage = 1250;
		  continue;
		  }
	    if (!strcmp(name, "ISO8859-1") || !strcmp(name, "ISO-8859-1"))
		  {
		  CodePage = ISO8859_1;
		  continue;
		  }
	    if (!strcmp(name, "ISO8859-2") || !strcmp(name, "ISO-8859-2"))
		  {
		  CodePage = ISO8859_2;
		  continue;
		  }
	    if (!strcmp(name, "Styles") || !strcmp(name, "styles"))
		  {
		  CPStyles=true;
		  continue;
		  }
	    CodePage = 0;
	    Heading();
	    printf(_("Warning: Unknown output codepage \"%s\"!"),chk(name));
	    continue;
	    }
      if (!strcmp(name, "-extractWPG")||!strcmp(name, "-extract-WPG"))
	    {
	    SaveWPG = true;
	    continue;
	    }
      if (!strcmp(name, "-fancyhdr")||!strcmp(name, "-Fancyhdr"))
		{
		FancyHdr = false;
		continue;
		}
      if (!strcmp(name, "-fix-spaces")||!strcmp(name, "-fixspaces"))
      		{
		FixSpaces = true;
		continue;
                }
      if (!strcmp(name, "-force-WP4")||!strcmp(name, "-forceWP4"))
      		{
		WPVersion=0x400;
		continue;
                }
      if (!strcmp(name, "-charset1"))
		{
		WPcharset = 1;
                continue;
                }
      if (!strcmp(name, "-charsetCZ") || !strcmp(name, "-charsetCS"))
		{
		WPcharset = 2;
		continue;
		}

      if (!strcmp(name, "-ignore-tabs") || !strcmp(name, "-ignoretabs"))
		{
		Tabs = false;
		continue;
		}

      if (!strcmp(name, "-input-PS") || !strcmp(name, "-inputPS"))
		{
		InputPS = true;
		continue;
		}

      if (!strcmp(name, "-L"))
      		{
                if(++p<argc)
		    {
		    strcpy(name, EnvLanguage);
		    strcpy(name+9, argv[p]);
		    putenv(name);
		    }
		continue;
		}

      if (!strcmp(name, "-LaTeX2") || !strcmp(name, "-latex2"))
		{
		LaTeX_Version=0x209;
		Amssymb=-1;
		if(Columns==1) Columns=0;
		continue;
		}
      if (!strcmp(name, "-LaTeX3") || !strcmp(name, "-latex3"))
		{
		LaTeX_Version=0x300;
		continue;
		}
      if (!strcmp(name, "-LaTeXsym")||!strcmp(name, "-latexsym"))
		{
		LaTeXsym = false;
		continue;
		}
      if (!strcmp(name, "-longtable") || !strcmp(name, "-LongTable"))
		{
		LongTable = true;
		continue;
		}
      if (!strcmp(name, "-optimize-section")||!strcmp(name, "-optimizesection"))
		{
		OptimizeSection = true;
		continue;
		}
      if (!strcmp(name, "-makeidx")||!strcmp(name, "-MakeIdx"))
		{
		MakeIdx = false;
		continue;
		}
      if (!strcmp(name, "-NFSS")||!strcmp(name, "-nfss"))
		{
		NFSS=true;
		continue;
		}
      if (!strcmp(name, "-no-amssymb")||!strcmp(name, "-noamssymb")||!strcmp(name, "-no-Amssymb"))
		{
		Amssymb = -1;
		continue;
		}
      if (!strcmp(name, "-no-bbm")||!strcmp(name, "-nobbm")||!strcmp(name, "-no-Bbm"))
		{
		Bbm = -1;
		continue;
		}
      if (!strcmp(name, "-no-erase-strip")||!strcmp(name, "-noerase-strip")||!strcmp(name, "-noerasestrip"))
		{
		EraseStrip = false;
		continue;
		}
      if (!strcmp(name, "-no-extract-WPG")||!strcmp(name, "-no-extractWPG")||!strcmp(name, "-noextractWPG"))
	    {
	    SaveWPG = false;
	    continue;
	    }
      if (!strcmp(name, "-no-fancyhdr")||!strcmp(name, "-nofancyhdr")||!strcmp(name, "-Fancyhdr"))
		{
		FancyHdr = -1;
		continue;
		}
      if (!strcmp(name, "-no-fix-spaces")||!strcmp(name, "-nofix-spaces")||!strcmp(name, "-nofixspaces"))
		{
		FixSpaces = false;
		continue;
		}

      if (!strcmp(name, "-no-columns")||!strcmp(name, "-nocolumns"))
		{
		Columns = -1;
		continue;
		}
      if (!strcmp(name, "-no-inputPS")||!strcmp(name, "-noinputPS"))
		{
		InputPS = -1;
		continue;
		}
      if (!strcmp(name, "-no-latexsym")||!strcmp(name, "-nolatexsym"))
		{
		LaTeXsym = -1;
		continue;
		}
      if (!strcmp(name, "-no-longtable") || !strcmp(name, "-no-LongTable")||!strcmp(name, "-nolongtable") || !strcmp(name, "-noLongTable"))
		{
		LongTable = -1;
		continue;
		}

      if (!strcmp(name, "-no-NFSS")||!strcmp(name, "-no-nfss"))
		{
		NFSS=false;
		continue;
		}
      if (!strcmp(name, "-no-makeidx")||!strcmp(name, "-nomakeidx")||!strcmp(name, "-no-MakeIdx"))
		{
		MakeIdx = -1;
		continue;
		}
      if (!strcmp(name, "-no-optimize-section")||!strcmp(name, "-nooptimize-section")||!strcmp(name, "-nooptimizesection"))
		{
		OptimizeSection = false;
		continue;
		}
      if (!strcmp(name, "-no-rsfs") || !strcmp(name, "-norsfs"))
		{
		Rsfs = -1;
		continue;
		}
      if (!strcmp(name, "-no-safemode")||!strcmp(name, "-nosafemode"))
		{
		ExtendedCheck = false;
		continue;
		}
      if (!strcmp(name, "-no-texchars")||!strcmp(name, "-notexchars"))
		{
		TexChars = false;
		continue;
		}
      if (!strcmp(name, "-no-textcomp") || !strcmp(name, "-notextcomp"))
		{
		textcomp = -1;
		continue;
		}
      if (!strcmp(name, "-no-wasy")||!strcmp(name, "-nowasy")||!strcmp(name, "-no-Wasy"))
		{
		Wasy = -1;
		continue;
		}

      if (!strcmp(name, "-rsfs"))
		{
		Rsfs = true;
		continue;
		}
      if (!strcmp(name, "-texchars"))
		{
		TexChars = true;
		continue;
		}
      if (!strcmp(name, "-textcomp"))
		{
		textcomp = true;
		continue;
		}
      if (!strcmp(name, "-safemode"))
		{
		ExtendedCheck = true;
		continue;
                }
      if (!strcmp(name, "-s"))
      		{
                if(++p<argc)
		    {
	  	    wpd_password = argv[p];
		    }
		continue;
		}
      if (!strcmp(name, "-S") || !strcmp(name, "-Silent") || !strcmp(name, "-silent"))
      		{
		Verbosing = 0;
		continue;
		}
      if (!strcmp(name, "-use-all") || !strcmp(name, "-useall"))
		{
		Amssymb = false;
		Bbm = false;
		Columns = 1;	/*-1 disabled; 0 auto two; 1 auto multi; 2 forced two; >2 forced multi*/
		EndNotes = false;
		InputPS = false,
		LaTeXsym = false;
		PostScript = false;
		Rsfs = false;
		textcomp = false;
		Wasy = false;
		continue;
		}
      if (!strcmp(name, "-v"))
		{
		printf("wp2latex %s   %s\n",version,versiondate);
		exit(EXIT_SUCCESS);
		}
      if (!strcmp(name, "-wasy")||!strcmp(name, "-Wasy"))
		{
		Wasy = false;
		continue;
		}

      if (!strcmp(name, "--help") || !strcmp(name, "-?") || !strcmp(name, "-help"))
	   {
           Heading();
	   printf(_("\nSomebody at Eindhoven Univ of Techn wrote a WordPerfect 5.0 to LaTeX"
		  "\nconversion program (only running on MSDOS of course) :=)"
		  "\n           This program was completely rewritten by Jaroslav Fojtik"
		  "\nand many new functions was added (eg conversion of math equations)"
		  "\nWrite any suggestions, reports or bugs to address FOJTIK@htc.honeywell.cz"
		  "\n     the address FOJTIK@CMP.FELK.CVUT.CZ may not be valid after 2000."
		  "\n"
                  "\nImportant note: Conversions performed by wp2latex are only partial."
		  "\nPrint the resulting document and compare carefully with original."
                  "\nIn all but the simplest documents you will have to do further editing."
                  "\nOr you may wisch to edit the WordPerfect document to remove unwanted"
		  "\ncodes (such as Tab, Tab Set), then run it through wp2latex again."
		  "\n"
		  "\nParametters: WP2LATEX [switches] [input_file [output_file]] [switches]"
		  "\n   -?  --help   Display this help page."
		  "\n   -amssymb     %sUse aditional package AMSsymb with special characters."
		  "\n   -bbm         %sUse aditional package Bbm with special characters."
		  "\n   -copyright   Display informations about Copyright to WP2LaTeX."
		  "\n   -cp-codepage Use \"codepage\" for output text. Supported code pages are"
		  "\n         \"852\"(ISO8), \"895\"(Kamenicky), \"1250\"(Win), \"ISO8859-2\", \"ISO8859_1\"."
		  "\n   -cp-styles   Turn on special styles for codepages."
		  "\n   -extract-WPG %sImages will be extracted into separate files (only WP 5.x)"
		  "\n   -fancyhdr    Use package fancyhdr.sty for headers and footers"
		  "\n   -forceWP4    Allow to convert documents from WP 4.x"
		  "\n   -configfile -@ filename   Load an external configuration file."
		  "\n   -charset1    %sSwitch internal WordPerfect char set to set 1."
		  "\n   -charsetCZ   %sSwitch internal WordPerfect char set to keybcs."
		  "\n   -i; -o; -l   Explicitely define an imput; output; log file"
		  "\n   -ignore-tabs %sRemove all [TAB] symbols from WP document."
		  "\n   -input-PS    Use Postscript features in the LaTeX (mainly images)."
		  "\n   -L LANGUAGE  Switch message translations to language LANGUAGE."
		  "\n   -LaTeX2      %sOptimize optput for LaTex 2.09."
		  "\n   -LaTeX3      %sOptimize optput for LaTex 2.e or LaTeX 3.0"
		  "\n   -latexsym    %sUse aditional package latexsym with special characters."
		  "\n   -longtable   Use aditional package longtable for better tables."
		  "\n   -makeidx     %sUse aditional package makeidx for placing index."
		  "\n   -no-amssymb  %sDisable aditional package AMSsymb with special characters."
		  "\n   -no-bbm      %sDisable aditional package Bbm with special characters."
		  "\n   -no-columns  Do not translate multicolumn text to more columns."
		  "\n   -no-extractWPG Turn an all extracing images off."
		  "\n   -no-fancyhdr Do not use package fancyhdr.sty."
		  "\n   -no-input-PS Disable using anything from Postscript in the LaTeX."
		  "\n   -no-latexsym Disable aditional package latexsym."
		  "\n   -no-safemode Disable checking features - faster conversion."
		  "\n   -no-texchars %sStandard conversion of all characters to proper TeX sequences."
		  "\n   -no-wasy     %sDisable aditional package Wasy2 with special characters."
		  "\n   -rsfs        %sUse aditional package mathrsfs with special characters."
		  "\n   -safemode    %sCheck safely consistency of each object and try to fix all"
		  "\n                incorrect things. Good for corrupted WP files."
		  "\n   -s \"password\" Password for decoding WP document (WP4.x & WP5.x only)."
		  "\n   -S -silent   %sSwitch to the silent mode."
		  "\n   -texchars    %sDo not interpret tex macros (all chars 32-128 will not be"
		  "\n                converted to TeX sequences)."
		  "\n   -v           Get info about version."
		  "\n   -wasy        %sUse aditional package Wasy2 with special characters."
		  "\n"),
		  Amssymb>=false?"*":"",
		  Bbm>=false?"*":"",
		  SaveWPG>=true?"":"*",		//bold the default options
		  WPcharset==1?"*":"",
		  WPcharset==2?"*":"",
		  Tabs<=false?"*":"",
		  (LaTeX_Version & 0xFF00) == 0x200?"*":"",
		  (LaTeX_Version & 0xFF00) == 0x300?"*":"",
		  LaTeXsym>=false?"*":"",
		  MakeIdx>=false?"*":"",
		  Amssymb>=false?"":"*",
		  Bbm>=false?"":"*",
		  TexChars>=true?"":"*",
		  Wasy>=false?"":"*",
		  Rsfs>=false?"*":"",
		  ExtendedCheck==true?"*":"",
		  Verbosing>0?"":"*",
		  TexChars<=false?"":"*",
		  Wasy>=false?"*":""
		  );
#ifndef Registered
	   puts(_("\nPlease send me a postcard. Run \"wp2latex -copyright\" for more details."));
#endif
	   exit(EXIT_SUCCESS);
	   }

      if (!strcmp(name, "-i"))
          {
	  p++;
	  wpd_filename = argv[p];
          continue;
          }
      if (!strcmp(name, "-o"))
          {
	  p++;
	  latex_filename = argv[p];
          if(latex_filename == '-') Verbosing = 0; /*disable messages to stdout*/
          continue;
          }
      if (!strcmp(name, "-l"))
          {
	  p++;
	  log_filename = argv[p];
          continue;
          }


      name[0]=firstch;
      if(firstch=='-') goto UnknownArg;
      }


    if (wpd_filename == "")
        {
        wpd_filename = name;
        continue;
        }
    if (latex_filename == "")
        {
        latex_filename = name;
        continue;
	}

UnknownArg:
    Heading();
    printf(_("Warning: Unknown argument \"%s\"!"),chk(name));
  }
  if(ArgOnly) return(0);


  if(latex_filename == '-') Verbosing=0;
  Heading();

  if (latex_filename == "")
      {
      if (Verbosing >= 1 || wpd_filename == "")
         {
	 printf(_("\nWordPerfect-filename [%s] : "), chk(wpd_filename()));
	 StrGets(StrName);
	 if (StrName != "") wpd_filename=StrName;
         }


    if (wpd_filename == "")
        { 			  /* No filename entered */
        RunError(0x200);
        }


    p=length(wpd_filename);
    while(p>0)
	 {
	 if(wpd_filename[p]=='.') break;
	 if((wpd_filename[p]=='/')||(wpd_filename[p]=='\\'))
		{
		p=length(wpd_filename);
		break;
		}
	 p--;
	 }
    if(p<=0) p=length(wpd_filename); //no extension


    if (latex_filename == "")
          {
	  latex_filename=copy(wpd_filename,0,p) + ".tex";
          }

    if (Verbosing >= 1 || latex_filename == "")
       {
       printf(_("LaTeX-filename [%s] : "), chk(latex_filename()));
       StrGets(StrName);
       if (StrName != "") latex_filename = StrName;
       }
  }

  p=length(wpd_filename);
    while(p>0)
    	 {
         if(wpd_filename[p]=='.') break;
         if((wpd_filename[p]=='/')||(wpd_filename[p]=='\\'))
	 	{
                p=length(wpd_filename);
                break;
		}
         p--;
         }

  strip_filename = copy(wpd_filename,0,p) + ".STR";
  table_filename = copy(wpd_filename,0,p) + ".TBL";


  if(Amssymb>=false && LaTeX_Version<0x300)
	fprintf(err,_("\nWarning: Package \"amssymb\" should not be used in LaTex 2.09!"));

  return(0);
}

static void CheckCompiler(void)
{
if((sizeof(__u8)!=1)||(sizeof(__u16)!=2)||(sizeof(__u32)!=4)||
   (sizeof(__s8)!=1)||(sizeof(__s16)!=2)||(sizeof(__s32)!=4))
	{
        Heading();
	fprintf(err,_("\nFatal: Code was badly compiled. Check types.h !!!!!"));
	}
}


static void CheckOptions(void)
{
if(LaTeX_Version<0x300)		//disable colors for LaTeX 2.09
	{
	if(colors>true)
		fprintf(err,_("Warning: Color style is available only for LaTex 2.0e !\n"));
	colors=-1;
	}
}

static void UpdateFigDir(void)
{
char ch;
int i;

if(wpd_filename=="") return;

if((i=GetPath(wpd_filename())) > 0)
   {
   ch=wpd_filename[++i];
   wpd_filename[i]=0;
   InputDir=strdup(wpd_filename);
   wpd_filename[i]=ch;
   }

if(latex_filename == '-') return;

if((i=GetPath(latex_filename())) > 0)
	{
	ch=latex_filename[++i];
	latex_filename[i]=0;
	if(!strcmp(latex_filename,InputDir)) OutputDir=InputDir;
			   else	OutputDir=strdup(latex_filename);
	latex_filename[i]=ch;
	}

}


static void Sys_Variable()
{
string var;
char **argv;
int argc,i;
char typ,oldtyp;

argc=0;

var=getenv("wp2latex");
if(var=="") var=getenv("WP2LATEX");
if(var=="") return;

oldtyp=0;
for(i=0;i<length(var);i++)
	{
        if((var[i]==' ')||(var[i]==9))
			{
			typ=0;
			var[i]=0;
                        }
        	   else typ=1;

        if(typ==1 && oldtyp==0) argc++;
        oldtyp=typ;
        }

if((argv=(char **)calloc(argc,sizeof(char**))) == NULL) return;
argc=0;
if(var[0]!=0) argv[argc++]=var();
for(i=1;i<length(var);i++)
	{
        if((var[i-1]==0)&&(var[i]!=0))
			 argv[argc++]=&var[i];
        }
Filenames(argc , argv, 1);
free(argv);
return;
}


/*---begin of PROGRAM---*/
int main(int argc , char *argv[])
{
  latex = NULL;		/* The output Latex file */
  strip = NULL;		/* The temporary file rough conversion */
  table = NULL;		/* The temporary file with line informations */
  wpd   = NULL;		/* The input WP file */
  logg  = NULL;		/* The output log file */
  err   = stderr;	/* The output for error messages */

/* Default initialization */
  Verbosing = 1;
  TexChars = false;
  CodePage = 0;		/*unknown - no 8 bit code generated*/
  WPcharset = 1;	/*common char set 1*/
  ExtendedCheck = true;	/*true*/
  FixSpaces = false;
  OptimizeSection = true;
  UnknownCharacters=UnknownObjects=CorruptedObjects=0;
  Convert_first_pass = NULL;

#if defined(__UNIX__) & !defined(DEBUG)
  HookSignals();
#endif

#ifdef DEBUG
  log_filename="default.log";
#endif
//  clrscr();

#ifdef __gettext__
  InitGettext();
#endif /* __gettext__ */

  CheckCompiler();
  Sys_Variable();
  Filenames(argc,argv,0);
  UpdateFigDir();
  CheckOptions();

  if ( (wpd = fopen(wpd_filename, "rb"))   == NULL )
	RunError(2,wpd_filename);
  Wpd_check();


  if ( (strip = fopen(strip_filename, "w"))   == NULL )
	RunError(2,strip_filename);
  if ( (table = fopen(table_filename, "w+b")) == NULL )
	RunError(2,table_filename);
  logg=NULL;
  if (log_filename != "")
      {
      if((logg = fopen(log_filename, "w")) == NULL )
      	{
	fprintf(err,_("\nWarning: Cannot open log file %s ..."),log_filename());
        }
	else fprintf(logg,_("%% log file for converted file %s, WP ver %d.%d\n"
			    "%% conversion program WP2LaTex v. %s from %s.\n"),
			   wpd_filename(),WPVersion >> 8,WPVersion & 0xFF,version,versiondate);
      }



  if(Convert_first_pass!=NULL)
		{
		if(Verbosing >= 1)
			printf(_("\nConverting ...\n"));
		Convert_first_pass(wpd, table, strip, logg, err);
		}
	   else RunError(0x202);  /* unsupported WP version */


  if (wpd != NULL)
          {
          fclose(wpd);
          wpd = NULL;
          }
  if (strip != NULL)
          {
          if(fflush(strip)) RunError(0x20,""); //The RunError procedure will erase strip in this case
          if(fclose(strip)) {strip = NULL;RunError(0x20,"");}
          strip = NULL;
          }
  if (table != NULL)
         {
         if(fflush(table)) RunError(0x20,""); //The RunError procedure will erase table in this case
         if(fclose(table)) {table = NULL;RunError(0x20,"");}
         table = NULL;
         }



  if(logg!=NULL) fprintf(logg,_("\n%% pass1 finished going to pass2\n\n"));

  if ( (strip = fopen(strip_filename, "r"))   == NULL )
	RunError(2,strip_filename);
  if (latex_filename == '-') latex=stdout;
      else if ( (latex = fopen(latex_filename, "w"))   == NULL )
		 RunError(2,latex_filename);
  if ( (table = fopen(table_filename, "r+b")) == NULL )
	RunError(2,table_filename);


  Convert_second_pass(strip, table, latex, logg, err);


  if (strip != NULL) fclose(strip);   strip = NULL;
  if (table != NULL) fclose(table);   table = NULL;
  if (latex_filename != '-')
       if (latex != NULL)
                 {
                 if(fclose(latex)) {latex = NULL;RunError(0x20,"");}
                 }
  latex = NULL;
  if (logg != NULL)
  	{
	fprintf(logg,_("\n%% pass2 finished\n"
	              "%%  There were %ld unconverted characters.\n"
		      "%%  There were %ld unrecognized/ignored objects.\n"),UnknownCharacters,UnknownObjects);
        if(CorruptedObjects>0)
	    fprintf(logg,_("%%  There were %ld corrupted objects.\n"),CorruptedObjects);
	if(fclose(logg))
	       fprintf(err,_("\nError: Log file is not completely written."));
        }
  logg = NULL;


/* Delete auxillary files */
  if(EraseStrip)
     {
#ifndef DEBUG
     unlink(strip_filename);
     unlink(table_filename);
#endif
     }

  return(0);
}




/* End. */
