# makefile for wp2latex for EMX (gcc)
# runs under DOS, linux, solaris and perhaps OS/2
#
TARGET_NAME = wp2latex
TARGET_DIR = ./execute/
GCC=gcc
FLAGS=-Wall -O2 -I./atoms/include/ -DRTF
OBJ=.o


# Uncomment next line for compile a debugging version of WP2LaTeX
#DEBUG=-DDEBUG -g

# Uncomment next line for allowing a gettext multilanguage translation features
# This feature is not required for succesfull run of WP2LaTeX.
#GETTEXT=-D__gettext__

# to get an error list under OS/2
# ERROR=2>&1 | tee >> errlist



ifeq ($(GETTEXT),-D__gettext__)
LIBS=-lintl
IGETTEXTOBJ=igettext$(OBJ)
endif

# for Linux - debian
ifeq ($(OSTYPE),linux-gnu)
TARGET_DIR = ../linux/
GCC = g++
endif

# for Linux - slakware
ifeq ($(OSTYPE),linux)
TARGET_DIR = ../linux/
LIBS+= -lstdc++
endif

# for Linux - Red Hat
ifeq ($(OSTYPE),Linux)
TARGET_DIR = ../linux/
LIBS+= -lstdc++
endif
#end of Linux

# for sun
ifeq ($(OSTYPE),solaris)
TARGET_DIR = ../sun/
LIBS=-lm
endif

ifeq ($(OSTYPE),sunos4)
TARGET_DIR = ../sun/
LIBS=-lm -lstdc++
endif
#end of sun

#Nothing is an indentifier for DOS? Too bad.
ifeq ($(OSTYPE),)
ifeq ($(HOSTTYPE),iris4d)
OSTYPE = iris4d
LIBS=-lm
TARGET_DIR = ../iris/
else
TARGET_DIR = ../dos/
TARGET_NAME = wp2latex.exe
OSTYPE = dos
endif
endif

# for aix
ifeq ($(OSTYPE),aix)
TARGET_DIR = ../aix/
LIBS=-lm
endif
#end of aix



######### End of definitions starting compile rules ###########

.SUFFIXES: .cc $(OBJ) .exe

.cc$(OBJ):
	$(GCC) $(FLAGS) $(DEBUG) -c $*.cc $(ERROR) -o $*$(OBJ) $(GETTEXT)

$(OBJ).exe:
	$(GCC) $*$(OBJ) $(LIBS) $(ERROR)

$(TARGET_NAME): wp2latex$(OBJ) pass1$(OBJ) pass1_4$(OBJ) pass1_5$(OBJ) pass1_6$(OBJ) pass1rtf$(OBJ) pass2$(OBJ) wp2lfuti$(OBJ) formulas$(OBJ) images$(OBJ) charactr$(OBJ) $(IGETTEXTOBJ) atoms/strings$(OBJ) atoms/sets$(OBJ) atoms/struct$(OBJ) atoms/lists$(OBJ) cptran$(OBJ)
	$(GCC) $(GETTEXT) -o $(TARGET_NAME) charactr$(OBJ) formulas$(OBJ) images$(OBJ) $(IGETTEXTOBJ) pass1$(OBJ) pass1_4$(OBJ) pass1_5$(OBJ) pass1_6$(OBJ) pass1rtf$(OBJ) pass2$(OBJ) atoms/strings$(OBJ) atoms/sets$(OBJ) atoms/struct$(OBJ) atoms/lists$(OBJ) wp2latex$(OBJ) wp2lfuti$(OBJ) cptran$(OBJ) $(LIBS) $(ERROR)
	mkdir -p $(TARGET_DIR)
	cp ./$(TARGET_NAME) $(TARGET_DIR)
	strip $(TARGET_DIR)$(TARGET_NAME)


wp2latex$(OBJ): wp2latex.cc wp2latex.h
pass1$(OBJ):    pass1.cc    wp2latex.h
pass1_4$(OBJ):  pass1_4.cc  wp2latex.h
pass1_5$(OBJ):  pass1.cc    wp2latex.h
pass1_6$(OBJ):  pass1_6.cc  wp2latex.h
pass1rtf$(OBJ): pass1rtf.cc wp2latex.h rtf.h
pass2$(OBJ):    pass2.cc    wp2latex.h
wp2lfuti$(OBJ): wp2lfuti.cc wp2latex.h
formulas$(OBJ): formulas.cc wp2latex.h
images$(OBJ):   images.cc   wp2latex.h
charactr$(OBJ): charactr.cc wp2latex.h
igettext$(OBJ): igettext.cc wp2latex.h

cptran$(OBJ):   cptran.cc cptran.h cp_lib/trn.trn


atoms/lists$(OBJ):   atoms/lists.cc
atoms/strings$(OBJ): atoms/strings.cc
atoms/struct$(OBJ):  atoms/struct.cc
atoms/sets$(OBJ):    atoms/sets.cc


cp_lib/trn.trn:
	make -C cp_lib trn.trn


all:     $(TARGET_NAME)
#	$(TARGET_NAME) -i test/charactr.wp

default: $(TARGET_NAME)


clean:
	rm -f wp2latex *.exe *$(OBJ) *.obj *.bak *.map core
	rm -f atoms/*$(OBJ) *.bak
	rm -f test/*.tex
	make -C cp_lib clean


#This work correctly only in Linux
install: $(TARGET_NAME)
	cp $(TARGET_DIR)$(TARGET_NAME) /usr/local/bin
	cp ../doc/wp2latex.1 /usr/local/man/man1/
	@echo
	@echo "I am a dumb script, you should complete installation by copying all stuff"
	@echo "from 'styles.tex' direcrory to a proper place."

uninstall: 
	rm -f /usr/local/bin/$(TARGET_NAME)	 
	rm -f /usr/local/man/man1/wp2latex.1
	rm -f /usr/local/man/cat1/wp2latex.1.gz