/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.x files into LaTeX                      *
 * modul:       igettext.cc                                                   *
 * description: This modul initializes translation features. This allow you   *
 *              to communicate with this program using your native language.  *
 *              It is possible to omit this feature when __gettext__ is not   *
 *	        defined.						      *
 ******************************************************************************/
#ifdef __gettext__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "wp2latex.h"
#include <strings.h>
#include <locale.h>

string & fGets2(FILE *f, string & pstr);


string expand_spec(string name)
{
//#ifdef DEBUG
//  fprintf(cq->log,"\n!expand_spec(%s) ",name.ch);fflush(cq->log);
//#endif
int pos,end;
string temp;

while(StrStr(name,"$(")!=NULL)
	{
	pos=StrStr(name,"$(")-name();
	end=pos+2;
	while (name[end]!=0)
	   {
	   if (name[end]==')') break;
	   end++;
	   }
	if (name[end]==0) break;
	temp=copy(name,pos+2,end-pos-2);

        if (StrStr(temp,"$(")!=NULL)
                 temp=expand_spec(temp);
//puts(temp.ch);
        if(temp!="")
		{
                temp=getenv(temp);
		}
//puts(temp.ch);
        name=copy(name,0,pos)+temp+copy(name,end+1,length(name)-end-1);

        temp=name;//!!!!
//puts(temp.ch);
	}

return(temp);
}

void Proces_File(const string filename)
{
//#ifdef DEBUG
//  fprintf(cq->log,"\n!Proces_File(%s) ",filename.ch);fflush(cq->log);
//#endif
FILE *f;
string line,temp;
int i;

if((f=fopen(filename,"r"))==NULL) return;
while(!feof(f))
  {
  fGets2(f, line);
  line=cutspaces(line);
  if(line=="")     continue;
  if(line[0]=='#') continue;

  temp="";
  for(i=0; i<length(line); i++)
           {
           if(isalpha(line[i])) temp+=line[i];
                           else break;
           }
  if(line[i++] != '=') continue;
  temp+='=';
  for(; i<length(line); i++)
           {
           if(!isalnum(line[i]) || (line[i]!='$') ||
                 (line[i]!='(') || (line[i]!=')') || (line[i]!='/') ||
                 (line[i]!='\\')|| (line[i]!=':')) temp+=line[i];
                                              else break;
           }
  if(temp!="") putenv(temp);
//puts(temp.ch);
  }
fclose(f);
}

/*This procedure provides inicialization  of gettext library.
  Its main task is to find a proper LOCALEDIR */
void InitGettext(void)
{
//#ifdef DEBUG
//  fprintf(cq->log,"\n!InitGettext() ");fflush(cq->log);
//#endif
  string Locale_Dir;

#ifdef __DJGPP__
  Proces_File(expand_spec("$(DJGPP)"));
#endif

  Locale_Dir = expand_spec("$(LOCALEDIR)");

#ifdef __DJGPP__  /* The default localedir for DJGPP is: $(DJDIR)/share/locale/  */
  if (Locale_Dir=="")
      {
      Locale_Dir = expand_spec("$(DJDIR)");
      if (Locale_Dir!="")
         {
	 Locale_Dir+="/share/locale";
         }
      else Locale_Dir = "c:/usr/local/share/locale";
      }
#else           /* The default localedir for UNIX is: /usr/share/locale/  */
if (Locale_Dir=="")
      {
//    Locale_Dir = "/usr/local/share/locale";
      Locale_Dir = "/usr/share/locale";
      }
#endif

//  puts(Locale_Dir.ch);
  setlocale(LC_ALL,"");
  bindtextdomain("wp2latex",Locale_Dir);
  textdomain("wp2latex");

  return;
}
/*setlocale (LC_ALL, "");
  bindtextdomain ("wp2latex", "d:/gcc/share/locale" );
  textdomain ("wp2latex"); 
  putenv("LANGUAGE=cs");*/
#endif __gettext__
