#include <stdio.h>
#include <stdlib.h>
//#include <alloc.h>
#include <string.h>
#include <mem.h>

#include <types.h>
#include <strings.h>
#include <dbllist.h>

#ifndef coreleft
  #define coreleft() 0
#endif

#ifndef setmem
void setmem(void *buff,int count,char number)
{
while(count>0)
	{
	*((char *)buff)++=number;
	count--;
	}
}
#endif

class codepage
	{
public: codepage(void)	{name=NULL;characters=NULL;MaxUsed=Allocated=0;};
	~codepage(void)	{free(name);free(characters);Allocated=0;};

	char *name;
	WORD Allocated;
	WORD MaxUsed;
	char **characters;

	void InsertCharacter(WORD position,char *Name);
	};


class Translator
	{
public: Translator(void)  {ToCp=FromCp=NULL;Data=NULL;}
	~Translator(void) {if(Data!=NULL) free(Data);}

	const codepage *FromCp;
	const codepage *ToCp;
	WORD *Data;

	void erase(void) {if(Data!=NULL) free(Data);ToCp=FromCp=NULL;Data=NULL;}
	};


void codepage::InsertCharacter(WORD position,char *Name)
{
int i;

if(Name==NULL) return;
if(*Name==0) return;
if(position>=Allocated)
	{
	if( (characters=(char **)realloc(characters,sizeof(char **)*(position+1)))==NULL)
		{
NoMemory:	puts("Fatal: Memory exhausted");
//		return;
		exit(-1);
		}
	do {
	   characters[Allocated++]=NULL;
	   } while(position>=Allocated);
	}

if(characters[position]!=NULL)
	{
	if(!strcmp(characters[position],Name)) return;
	printf("Warning: redefinition of character 0x%X \"%s\" -> \"%s\"!",
		position,characters[position],Name);
	free(characters[position]);
	characters[position]=NULL;
	}

if( (characters[position]=strdup(Name))==NULL ) goto NoMemory;
if(position>=MaxUsed) MaxUsed=position+1;
}

struct chardesc
	{
	WORD position;
	string name;
	};


/*This function read one line from the text file and store it to the string.*/
string & fGets2(FILE *f, string & pstr)
{
  char c;

  pstr="";
  while (!feof(f))
     {
     c = getc(f);
     if (c == '\n') break;
     if (c == '\r') continue;
     if ((unsigned char)c == 0xFF)
	if(feof(f)) break;	//Fix the situation, when 0xFF is read before eof

     pstr += c;
  }

 return(pstr);
}



string s;
#define CharSetSize 256
void ReadChar(FILE *f,codepage & cp)
{
static WORD previous=0;
WORD number=0,n2=0;
char *text,*t2;

int i;

fGets2(f, s);
if(s=="") return;

text=s();
while(isspace(*text)) text++;
if(*text==0 || *text==';') return; // empty line - useless
while(isdigit(*text))
   {
   number = number*10 + *text-'0';
   text++;
   }
if(*text==',')
   {
   text++;
   while(isdigit(*text))
	{
	n2 = n2*10 + *text-'0';
	text++;
	}
   number = CharSetSize * number + n2;
   }
if(number==0) number = previous++;
	 else previous= number;
while(isspace(*text)) text++;
if(*text==0 || *text==';') return; // only number - useless
t2=text;
while(*t2!=0)
	{
	if(*t2==';')
	    {
 	    *t2=0;
	    sync(s);
	    break;
	    }
	t2++;
	}

while(isspace(s[length(s)-1]))
	{
	s=copy(s,0,length(s)-1);
	}


cp.InsertCharacter(number,text);
}


void CreateTranslator(Translator & trn,const codepage & cp1, const codepage & cp2)
{
WORD i,j;

trn.erase();
printf("Info: Building translator %s -> %s\n",cp1.name,cp2.name);

if((trn.Data=(WORD *)calloc(cp1.MaxUsed,sizeof(WORD)))==NULL) return;
setmem(trn.Data,cp1.MaxUsed,0);

trn.FromCp = &cp1;
trn.ToCp = &cp2;

for(i=0;i<cp1.MaxUsed;i++)
    {
    if(cp1.characters[i]==NULL) continue;
    for(j=0;j<cp2.MaxUsed;j++)
	{
	if(cp2.characters[j]==NULL) continue;
	if(!strcmp(cp1.characters[i],cp2.characters[j]))
		{
		if(cp1.characters[i]!=cp2.characters[j])
			{
			free(cp1.characters[i]);	//optimize memory
			cp1.characters[i]=cp2.characters[j];
			}
		trn.Data[i]=j;
		break;
		}
	}
    }

return;
}

void LoadCodePage(string cpfilename,codepage & cp)
{
FILE *Fcp;

printf("Info: Loading codepage %s\n",cpfilename());

cp.name=strdup(cpfilename);
cpfilename+=".enc";

if( (Fcp=fopen(cpfilename,"r"))==NULL )
	{
	printf("Error: cannot open file:%s!!!\n",cpfilename());
	return;
	}

while(!feof(Fcp))
	ReadChar(Fcp,cp);

fclose(Fcp);
}


void ReadTextChar(FILE *f,doublelist & ll)
{
string s,CharN,desc;
char *text,t2;

int i;

fGets2(f, s);
if(s=="") return;

i=0;

while(isspace(s[i])) i++;
if(s[i]==';')
	return;
while(!isspace(s[i]) && (s[i]!=0) ) {CharN+=s[i];i++;}
CharN=cutspaces(CharN);
if(CharN=="") return;

while(isspace(s[i])) i++;
while(i < length(s))
	{
	if(s[i]==';' || s[i]==0) break;
	desc+=s[i];
	i++;
	}
desc=cutspaces(desc);

ll.Add(CharN,desc);
}

void LoadTextCodePage(string cpfilename,doublelist & ll)
{
FILE *Fcp;

printf("Info: Loading text codepage %s\n",cpfilename());

cpfilename+=".txc";

if( (Fcp=fopen(cpfilename,"r"))==NULL )
	{
	printf("Error: cannot open file:%s!!!\n",cpfilename());
	return;
	}

while(!feof(Fcp))
	ReadTextChar(Fcp,ll);

fclose(Fcp);
}

void CreateCodePage(string cpfilename,codepage & cp,doublelist & ll)
{
int i;

cp.name=strdup(cpfilename);

i=0;
while( ll[i]!=NULL)
	{
	cp.InsertCharacter(i,ll.Member(i,1));
	i++;
	}

}


void WriteStringTable(FILE *F,const codepage & cp,doublelist & ll)
{
int i;

if(F==NULL) return;
printf("Info: Writing string table %s.\n",cp.name);

fprintf(F,"char *Table_%s[]={\n",cp.name);

i=0;
while( ll[i]!=NULL)
	{
	fprintf(F,"  \"%s\"",ll.Member(i,0));
	i++;
	if(ll[i]==NULL) fprintf(F,"};\n");
		   else fprintf(F,",\n");
	}

}



void WriteTranslator(const codepage & cp_from, const codepage & cp_to, Translator &trn, FILE *F)
{
WORD i,Max;

if(F==NULL) return;
printf("Info: Writing translator %s -> %s\n",cp_from.name,cp_to.name);
Max=cp_from.MaxUsed;
while(Max>0)
    {
    if(trn.Data[Max-1]!=0 && trn.Data[Max-1]!=0xFFFF) break;
    Max--;
    }

fprintf(F,"WORD %s_%s[]={",cp_from.name,cp_to.name);
if(Max==0) fprintf(F," 0 };\n");
  else for(i=0;i<Max;i++)
	{
//	printf("  %d,\n",trn[i]);
	fprintf(F,"  %d%s",trn.Data[i],
		i==Max-1?"};":",");
	if(cp_from.characters[i]!=NULL && trn.Data[i]!=0)
		fprintf(F,"	/* %s */",cp_from.characters[i]);
	fputc('\n',F);
	}
fprintf(F,"\nCpTranslator %s%s(\"%sTO%s\",%u,%s_%s);\n\n",
        cp_from.name,cp_to.name,
        cp_from.name,cp_to.name,(unsigned)Max,
        cp_from.name,cp_to.name);
}


int main(void)
{
FILE *Fcp,*F;
codepage cp1250,cpkam,cpwp4a,cpwp5,cpwp5_cz,cpwp6;
codepage cphtml;
WORD i;
Translator trn;
doublelist llHTML;

puts("<<<cplib>>> (c)1999 J.Fojtik");
//printf("%ld\n",coreleft());

LoadCodePage("cp1250",cp1250);
LoadCodePage("kam",cpkam);

LoadCodePage("wp6",cpwp6);
LoadCodePage("wp5",cpwp5);
LoadCodePage("wp5_cz",cpwp5_cz);
LoadCodePage("wp4a",cpwp4a);



//if(heapcheck()<=0)
//	asm int 3;
printf("%ld\n",coreleft());




if( (F=fopen("trn.trn","w"))==NULL) return(0);


CreateTranslator(trn,cpwp6, cpwp5);
WriteTranslator(cpwp6,cpwp5,trn,F);

CreateTranslator(trn,cpwp4a, cpwp5);
WriteTranslator(cpwp4a,cpwp5,trn,F);


CreateTranslator(trn,cpwp5_cz, cpwp5);
WriteTranslator(cpwp5_cz,cpwp5,trn,F);



//if(heapcheck()<=0)
//	asm int 3;
//goto end;


/*
CreateTranslator(trn,cpkam,cpwp5);
WriteTranslator(cpkam,cpwp5,trn,F);

CreateTranslator(trn,cp1250,cpwp5);
WriteTranslator(cp1250,cpwp5,trn,F);
*/


/*
trn=CreateTranslator(cp1250,cpkam);
WriteTranslator(cp1250,cpkam,trn,F);
*/

end:
fclose(F);


LoadTextCodePage("html",llHTML);
llHTML.sort(strcmp);
CreateCodePage("html",cphtml,llHTML);
if( (F=fopen("html.trn","w"))==NULL) return(0);
CreateTranslator(trn,cphtml, cpwp5);
WriteTranslator(cphtml,cpwp5,trn,F);
WriteStringTable(F,cphtml,llHTML);
fclose(F);


trn.erase();
}