/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 4.x, 5.x or 6.x files into LaTeX          *
 * modul:       charactr.cc                                                   *
 * description: This modul contains descriptions of all extended characters   *
 *              and perform a conversion to their LaTeX ekvivalents.          *
 *                Currently there is a WP5.x character set and other charsets *
 *              are converted into it.					      *
 ******************************************************************************/
/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
#include<stdio.h>
#include<string.h>

#include "wp2latex.h"

/* This procedure initializes the table "lat" for fast conversion of ASCII
   characters. */
void Table_Init(LatTable & lat)
{
  unsigned char i;

  memset(lat,sizeof(lat),0);

  for (i = 1; i < 0x20; i++)
  	{
	strcpy(lat[i], "\\^{}\0");	/*^Character*/
        lat[i][4]='A'+i-1;
        lat[i][5]=0;
	}
  strcpy(lat[28],  "\\^{}$\\tt\\backslash$");   /*-*/
  strcpy(lat[31],  "\\^{}\\_\0");

  for (i = 0x20; i <= 0x7f; i++)
	{
	lat[i][0]=i;			/*Normal Caracters*/
	lat[i][1]=0;
	}

  if (TexChars) return;

  strcpy(lat['-'], "$-$");     /*-*/
  strcpy(lat['#'], "\\#\0");   /*#*/
  strcpy(lat['$'], "\\$\0");   /*dollar*/
  strcpy(lat['%'], "\\%\0");   /*%*/
  strcpy(lat['&'], "\\&\0");   /*&*/
  strcpy(lat['<'], "$<$\0");   /*<*/
  strcpy(lat['>'], "$>$\0");   /*>*/
  strcpy(lat['\\'],"$\\tt\\backslash$\0");   /*\*/
  strcpy(lat['^'], "\\^{}\0");   /*^*/
  strcpy(lat['_'], "\\_\0");   /*_*/
  strcpy(lat['{'], "\\{\0");   /*{*/
  strcpy(lat['|'], "$|$\0");   /*|*/
  strcpy(lat['}'], "\\}\0");   /*}*/
  strcpy(lat['~'], "\\~{}\0");   /*~*/
  strcpy(lat[0x7f], " \0");   /*Don't exist*/
}


#ifdef __BORLANDC__
char *BorlandCPPIsShit(unsigned char char_set,unsigned char  char_code, TconvertedPass1 *cq);
#endif

/*This funxtion expands an extended WP character into LaTEX sequence*/
char *Ext_chr_str(unsigned char char_set,unsigned char  char_code, TconvertedPass1 *cq)
{
/*If you have a different char subset, please write your remapping into
  char set 1 */

  switch (char_set)
     {
     case 0:
       if (char_code < 128) return(lat[char_code]);   /* Normal_char  */
       break;

     case 1:
       switch (char_code) {   /*Multinational 1*/

	    case   0: if (cq->envir == 'T') return "\\a`{}";
        	      return "\\`{}";
            case   1: return "$\\cdot$";
            case   2: return "\\~{}";
            case   3: return "\\^{}";
            case   4: return "--";
            case   5: return "/";
	    case   6: if (cq->envir == 'T') return "\\a'{}";
		      return "\\'{}";
	    case   7: if(CodePage == ISO8859_1) return "";
		      return "\\\"{}";
	    case   8: return "\\a={}";
	    case   9:
	    case  10:
	    case  11: return "'";
	    case  12: return "\\raise-1.2ex\\hbox{'}";
	    case  13: return "'";		/* something seems to be bad */
	    case  14: return "\\accent23{}";
	    case  15: return "\\.{}";
	    case  16: if (cq->envir == 'T') return "\\a'{}\\kern-0.2em\\a'{}";
                      return "\\'{}\\kern-0.2em\\'{}";
            case  17: return "\\c{}";
//	    case  18: return "\\k{}";
            case  19: return "\\v{}";

	    case  21: return "$\\overline{\\strut~}$";
	    case  22: return "\\u{}";
	    case  23: if(CodePage == ISO8859_1) return "";
		      return "\\ss{}";
	    case  24: return "\\i{}";
            case  25: return "\\j{}";
            case  26: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
		      if (CodePage == 1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'A ";
		      return "\\'{A}";
	    case  27: if (CodePage == 852 || CodePage == 895)
				return "";
		      if (CodePage == 1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'a ";
                      return "\\'{a}";
	    case  28: if(CodePage == ISO8859_1) return "";
		      return "\\^{A}";
	    case  29: if(CodePage == ISO8859_1) return "";
		      return "\\^{a}";
	    case  30: if(CodePage == ISO8859_1) return "";
		      return "\\\"{A}";
	    case  31: if(CodePage == ISO8859_1) return "";
		      return "\\\"{a}";
	    case  32: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`A ";
		      return "\\`{A}";
	    case  33: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`a ";
                      return "\\`{a}";
	    case  34: if(CodePage == ISO8859_1) return "";
		      return "\\AA ";
	    case  35: if(CodePage == ISO8859_1) return "";
		      return "\\aa ";
	    case  36: if(CodePage == ISO8859_1) return "";
		      return "\\AE ";
	    case  37: if(CodePage == ISO8859_1) return "";
		      return "\\ae ";
	    case  38: if(CodePage == ISO8859_1) return "";
		      return "\\c{C}";
	    case  39: if(CodePage == ISO8859_1) return "";
		      return "\\c{c}";
	    case  40: if (CodePage == 852 || CodePage == 895)
				return "";
		      if (CodePage == 1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'E";
		      return "\\'{E}";
	    case  41: if (CodePage == 852 || CodePage == 895)
				return "";
		      if(CodePage == 1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'e";
		      return "\\'{e}";
	    case  42: if(CodePage == ISO8859_1) return "";
		      return "\\^{E}";
	    case  43: if(CodePage == ISO8859_1) return "";
		      return "\\^{e}";
	    case  44: if(CodePage == ISO8859_1) return "";
		      return "\\\"{E}";
	    case  45: if(CodePage == ISO8859_1) return "";
		      return "\\\"{e}";
	    case  46: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`E";
                      return "\\`{E}";
	    case  47: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`e";
        	      return "\\`{e}";
            case  48: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'I";
                      return "\\'{I}";
            case  49: if (CodePage == 852 || CodePage == 895)
				return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'\\i{}";
		      return "\\'{\\i}";
	    case  50: if(CodePage == ISO8859_1) return "";
		      return "\\^{I}";
	    case  51: if(CodePage == ISO8859_1) return "";
		      return "\\^{\\i}";
	    case  52: if(CodePage == ISO8859_1) return "";
		      return "\\\"{I}";
	    case  53: if(CodePage == ISO8859_1) return "";
		      return "\\\"{\\i}";
	    case  54: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`I";
		      return "\\`{I}";
	    case  55: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`\\i";
		      return "\\`{\\i}";
	    case  56: if(CodePage == ISO8859_1) return "";
		      return "\\~{N}";
	    case  57: if(CodePage == ISO8859_1) return "";
		      return "\\~{n}";
	    case  58: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\O'";
		      return "\\'{O}";
	    case  59: if (CodePage == 852 || CodePage == 895)
				return "";
		      if (CodePage ==1250 || CodePage==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "o'";
		      return "\\'{o}";
	    case  60: if(CodePage == ISO8859_1) return "";
		      return "\\^{O}";
	    case  61: if(CodePage == ISO8859_1) return "";
		      return "\\^{o}";
	    case  62: if(CodePage == ISO8859_1) return "";
		      return "\\\"{O}";
	    case  63: if(CodePage == ISO8859_1) return "";
		      return "\\\"{o}";
	    case  64: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`O";
                      return "\\`{O}";
	    case  65: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`o";
                      return "\\`{o}";
            case  66: if (CodePage == 895) return "";
		      if (CodePage == 1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'U";
                      return "\\'{U}";
            case  67: if (CodePage == 895) return "";
		      if (CodePage == 1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'u";
		      return "\\'{u}";
	    case  68: if(CodePage == ISO8859_1) return "";
		      return "\\^{U}";
	    case  69: if(CodePage == ISO8859_1) return "";
		      return "\\^{u}";
	    case  70: if(CodePage == ISO8859_1) return "";
		      return "\\\"{U}";
	    case  71: if(CodePage == ISO8859_1) return "";
		      return "\\\"{u}";
	    case  72: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`U";
		      return "\\`{U}";
	    case  73: if(CodePage == ISO8859_1) return "";
		      if (cq->envir == 'T') return "\\a`u";
		      return "\\`{u}";
	    case  74: return "\\\"{Y}";
	    case  75: if(CodePage == ISO8859_1) return "";
		      return "\\\"{y}";
	    case  76: if(CodePage == ISO8859_1) return "";
		      return "\\~{A}";
	    case  77: if(CodePage == ISO8859_1) return "";
		      return "\\~{a}";
	    case  78: if(CodePage == ISO8859_1) return "";
		      return "\\DH ";
	    case  79: if(CodePage == ISO8859_1) return "";
		      return "\\dh ";
	    case  80: if(CodePage == ISO8859_1) return "";
		      return "\\O{}";
	    case  81: if(CodePage == ISO8859_1) return "";
		      return "\\o{}";
	    case  82: if(CodePage == ISO8859_1) return "";
		      return "\\~{O}";
	    case  83: if(CodePage == ISO8859_1) return "";
		      return "\\~{o}";
	    case  84: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'Y";
	              return "\\'{Y}";
            case  85: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2 || CodePage == ISO8859_1)
				return "";
		      if (cq->envir == 'T') return "\\a'y";
		      return "\\'{y}";
	    case  86: if(Wasy>=false) {Wasy=true;return "\\Dh ";}
		      break;
	    case  87: if(Wasy>=false) {Wasy=true;return "\\dh ";}
		      break;
	    case  88: if(Wasy>=false) {Wasy=true;return "\\Thorn ";}
		      break;
	    case  89: if(Wasy>=false) {Wasy=true;return "\\thorn ";}
		      break;
	    case  90: return "\\u{A}";
            case  91: return "\\u{a}";
	    case  92: if (cq->envir == 'T') return "\\a=A ";
	              return "\\={A}";
	    case  93: if (cq->envir == 'T') return "\\a=a ";
	              return "\\={a}";
            case  94: return "\\c{A}";
            case  95: return "\\c{a}";
            case  96: return "\\'{C}";
            case  97: return "\\'{c}";
            case  98: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
                      return "\\v{C}";
            case  99: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
                      return "\\v{c}";
            case 100: return "\\^{C}";
            case 101: return "\\^{c}";
            case 102: return "\\.{C}";
            case 103: return "\\.{c}";
            case 104: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
		      return "\\v{D}";
            case 105: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
	              return "\\v{d}";
            case 106: if (CodePage == 852) return "";
                      if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
	              return "\\v{E}";
            case 107: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
		      return "\\v{e}";
            case 108: return "\\.{E}";
            case 109: return "\\.{e}";
	    case 110: if (cq->envir == 'T') return "\\a=E ";
	              return "\\={E}";
	    case 111: if (cq->envir == 'T') return "\\a=e ";
	              return "\\={e}";
            case 112: return "\\c{E}";
            case 113: return "\\c{e}";
            case 114: return "\\'{G}";
            case 115: return "\\'{g}";
            case 116: return "\\u{G}";
            case 117: return "\\u{g}";
            case 118: return "\\v{G}";
            case 119: return "\\v{g}";
            case 120: return "\\c{G}";
            case 121: return "\\c{g}";
            case 122: return "\\^{G}";
            case 123: return "\\^{g}";
            case 124: return "\\.{G}";
            case 125: return "\\.{g}";
            case 126: return "\\^{H}";
            case 127: return "\\^{h}";

            case 129: return "$\\hbar$";
            case 130: return "\\.{I}";
            case 131: return "\\.{i}";
	    case 132: if (cq->envir == 'T') return "\\a=I ";
	    	      return "\\={I}";
	    case 133: if (cq->envir == 'T') return "\\a=\\i ";
	              return "\\={\\i}";
            case 134: return "\\c{I}";
            case 135: return "\\c{i}";
            case 136: return "\\~{I}";
            case 137: return "\\~{\\i}";
            case 138: return "IJ";
            case 139: return "ij";
            case 140: return "\\^{J}";
            case 141: return "\\^{\\j}";
            case 142: return "\\c{K}";
            case 143: return "\\c{k}";
            case 144: return "\\'{L}";
            case 145: return "\\'{l}";
            case 146: if (CodePage == 852) return "";
              	      if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
	              return "\\v{L}";
            case 147: if (CodePage == 852) return "";
		      if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
                      return "\\v{l}";
            case 148: return "\\c{L}";
            case 149: return "\\c{l}";
	    case 150: return "L\\llap{\\raise0.8ex\\hbox{.}}";
            case 151: return "l\\kern0.3ex\\llap{\\raise0.8ex\\hbox{.}}";
            case 152: return "\\L ";
            case 153: return "\\l ";
            case 154: return "\\'{N}";
	    case 155: return "\\'{n}";
	    case 156: return "\\accent39N";
	    case 157: return "\\accent39n";
            case 158: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
	              return "\\v{N}";
            case 159: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
	              return "\\v{n}";
            case 160: return "\\c{N}";
            case 161: return "\\c{n}";
            case 162: return "\\H{O}";
            case 163: return "\\H{o}";
	    case 164: if (cq->envir == 'T') return "\\a=O ";
	              return "\\={O}";
	    case 165: if (cq->envir == 'T') return "\\a=o ";
	              return "\\={o}";
            case 166: return "\\OE ";
            case 167: return "\\oe ";
            case 168: return "\\'{R}";
	    case 169: return "\\'{r}";
            case 170: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
		      return "\\v{R}";
            case 171: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
	              return "\\v{r}";
            case 172: return "\\c{R}";
            case 173: return "\\c{r}";
            case 174: return "\\'{S}";
            case 175: return "\\'{s}";
            case 176: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
		      return "\\v{S}";
            case 177: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
		      return "\\v{s}";
            case 178: return "\\c{S}";
            case 179: return "\\c{s}";
            case 180: return "\\^{S}";
            case 181: return "\\^{s}";
            case 182: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
	              return "\\v{T}";
            case 183: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
	              return "\\v{t}";
            case 184: return "\\c{T}";
            case 185: return "\\c{t}";
            case 188: return "\\u{U}";
            case 189: return "\\u{u}";
            case 190: return "\\H{U}";
            case 191: return "\\H{u}";
	    case 192: if (cq->envir == 'T') return "\\a=U ";
		      return "\\={U}";
	    case 193: if (cq->envir == 'T') return "\\a=u ";
	    	      return "\\={u}";
            case 194: return "\\c{U}";
            case 195: return "\\c{u}";
            case 196: if (CodePage == 895) return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
		      if ((LaTeX_Version & 0xFF00) >= 0x300) return "\\r{U}";
		      return "\\accent23U";
	    case 197: if (CodePage == 852) return "";
		      if (CodePage == 895) return "";
		      if (CodePage ==1250 || CodePage ==ISO8859_2) return "";
		      if ((LaTeX_Version & 0xFF00) >= 0x300) return "\\r{u}";
	              return "\\accent23u";
            case 198: return "\\~{U}";
            case 199: return "\\~{u}";
            case 200: return "\\^{W}";
            case 201: return "\\^{w}";
            case 202: return "\\^{Y}";
            case 203: return "\\^{y}";
            case 204: return "\\'{Z}";
            case 205: return "\\'{z}";
	    case 206: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
	              return "\\v{Z}";
            case 207: if (CodePage == 852) return "";
	              if (CodePage == 895) return "";
                      if (CodePage ==1250) return "";
		      if (CodePage ==ISO8859_2) return "";
	              return "\\v{z}";
            case 208: return "\\.{Z}";
            case 209: return "\\.{z}";

	    case 212: if (cq->envir == 'T') return "\\a=D ";
	    	      return "\\={D}";
	    case 213: if (cq->envir == 'T') return "\\a=d ";
	    	      return "\\={d}";
	    case 214: if (cq->envir == 'T') return "\\a=L ";
	              return "\\={L}";
	    case 215: if (cq->envir == 'T') return "\\a=l ";
	              return "\\={l}";
	    case 216: if (cq->envir == 'T') return "\\a=N ";
		      return "\\={N}";
	    case 217: if (cq->envir == 'T') return "\\a=n ";
	              return "\\={n}";
	    case 218: if (cq->envir == 'T') return "\\a`R";
		      return "\\`{R}";
	    case 219: if (cq->envir == 'T') return "\\a`r";
	              return "\\`{r}";
	    case 220: if (cq->envir == 'T') return "\\a=S ";
	              return "\\={S}";
	    case 221: if (cq->envir == 'T') return "\\a=s ";
	              return "\\={s}";
	    case 222: if (cq->envir == 'T') return "\\a=T ";
	              return "\\={T}";
	    case 223: if (cq->envir == 'T') return "\\a=t ";
	              return "\\={t}";
            case 224: return "\\u{Y}";
            case 225: return "\\u{y}";
	    case 226: if (cq->envir == 'T') return "\\a`Y";
		      return "\\`{Y}";
	    case 227: if (cq->envir == 'T') return "\\a`y";
		      return "\\`{y}";
	    case 228: return "\\accent39D";
	    case 229: return "\\accent39d";
	    case 230: return "\\accent39O";
	    case 231: return "\\accent39o";
	    case 232: return "\\accent39U";
	    case 233: return "\\accent39u";
	    }
	    break;



     case 2:  /*Multinational 2*/
       switch (char_code)
            {
	    case   0: return "\\d{~}";
            case   1: return "\\d{~}\\!\\d{~}";

            case   5: return "\\lower1.1ex\\hbox{\\^{~}}";
            case   6: return "$\\underline{\\underline{~}}$";
            case   7: return "\\b{~}";

            case   9: return "\\lower1.1ex\\hbox{\\u{~}}";

            case  15: return "\\c{}";

	    case  19: return "'";
            }
       break;


     case 3:  /*Box Drawing*/
       switch (char_code)
            {
            case   0: return "\\ShadeBox{1}";
            case   1: return "\\ShadeBox{2}";
            case   2: return "\\ShadeBox{3}";
            case   3: return "\\rule[-0.4ex]{1.9ex}{1.9ex}";
            case   4: return "\\rule[-0.4ex]{0.95ex}{1.9ex}\\kern 0.95ex ";
            case   5: return "\\rule[0.55ex]{1.9ex}{0.95ex}";
            case   6: return "\\kern 0.95ex \\rule[-0.4ex]{0.95ex}{1.9ex}";
            case   7: return "\\rule[-0.4ex]{1.9ex}{0.95ex}";
            case   8: return "\\GrBox(1010)";
            case   9: return "\\GrBox(0101)";
            case  10: return "\\GrBox(1001)";
            case  11: return "\\GrBox(0011)";
            case  12: return "\\GrBox(0110)";
            case  13: return "\\GrBox(1100)";
            case  14: return "\\GrBox(1101)";
            case  15: return "\\GrBox(1011)";
            case  16: return "\\GrBox(0111)";
            case  17: return "\\GrBox(1110)";
            case  18: return "\\GrBox(1111)";
            case  19: return "\\GrBox(2020)";
            case  20: return "\\GrBox(0202)";
            case  21: return "\\GrBox(2002)";
            case  22: return "\\GrBox(0022)";
            case  23: return "\\GrBox(0220)";
            case  24: return "\\GrBox(2200)";
            case  25: return "\\GrBox(2202)";
            case  26: return "\\GrBox(2022)";
            case  27: return "\\GrBox(0222)";
            case  28: return "\\GrBox(2220)";
            case  29: return "\\GrBox(2222)";
            case  30: return "\\GrBox(2001)";
            case  31: return "\\GrBox(0021)";
            case  32: return "\\GrBox(0120)";
            case  33: return "\\GrBox(2100)";
            case  34: return "\\GrBox(1002)";
            case  35: return "\\GrBox(0012)";
            case  36: return "\\GrBox(0210)";
            case  37: return "\\GrBox(1200)";
            case  38: return "\\GrBox(2101)";
            case  39: return "\\GrBox(1012)";
            case  40: return "\\GrBox(0121)";
            case  41: return "\\GrBox(1210)";
            case  42: return "\\GrBox(1202)";
            case  43: return "\\GrBox(2021)";
            case  44: return "\\GrBox(0212)";
            case  45: return "\\GrBox(2120)";
            case  46: return "\\GrBox(1212)";
            case  47: return "\\GrBox(2121)";
            case  48: return "\\GrBox(0010)";
            case  49: return "\\GrBox(0100)";
            case  50: return "\\GrBox(1000)";
            case  51: return "\\GrBox(0001)";
            case  52: return "\\GrBox(0020)";
            case  53: return "\\GrBox(0200)";
            case  54: return "\\GrBox(2000)";
            case  55: return "\\GrBox(0002)";
            case  56: return "\\GrBox(2010)";
            case  57: return "\\GrBox(1020)";
            case  58: return "\\GrBox(0102)";
            case  59: return "\\GrBox(0201)";
            case  60: return "\\GrBox(1102)";
            case  61: return "\\GrBox(2102)";
            case  62: return "\\GrBox(1201)";
            case  63: return "\\GrBox(2201)";
            case  64: return "\\GrBox(2011)";
            case  65: return "\\GrBox(2012)";
            case  66: return "\\GrBox(1021)";
            case  67: return "\\GrBox(1022)";
            case  68: return "\\GrBox(0112)";
            case  69: return "\\GrBox(0211)";
            case  70: return "\\GrBox(0122)";
            case  71: return "\\GrBox(0221)";
            case  72: return "\\GrBox(2110)";
            case  73: return "\\GrBox(2210)";
            case  74: return "\\GrBox(1120)";
            case  75: return "\\GrBox(1220)";
            case  76: return "\\GrBox(1112)";
            case  77: return "\\GrBox(2112)";
            case  78: return "\\GrBox(2111)";
            case  79: return "\\GrBox(1211)";
            case  80: return "\\GrBox(2211)";
            case  81: return "\\GrBox(2212)";
            case  82: return "\\GrBox(1121)";
            case  83: return "\\GrBox(1122)";
            case  84: return "\\GrBox(2122)";
            case  85: return "\\GrBox(1221)";
            case  86: return "\\GrBox(1222)";
            case  87: return "\\GrBox(2221)";
	    }
       break;

   
     case 4:  /*Typografic Symbols*/
       switch (char_code)
           {
           case   0: return "$\\bullet$";
           case   1: return "$\\circ$";
           case   2: return "\\rule[0.5ex]{1ex}{1ex}";
	   case   3: return "\\Bullet{0.75ex}";
	   case   4: return "\\lower0.6ex\\hbox{$\\star$}";
	   case   5: return "\\P ";
	   case   6: if(CodePage == ISO8859_1) return "";
		     return "\\S ";
	   case   7: if(CodePage == ISO8859_1) return "";
		     return "!`";
	   case   8: if(CodePage == ISO8859_1) return "";
		     return "?`";
	   case   9: if(CodePage == ISO8859_1) return "";
		     return "$\\ll$";
	   case  10: if(CodePage == ISO8859_1) return "";
		     return "$\\gg$";
	   case  11: if(CodePage == ISO8859_1) return "";
		     return "\\pounds{}";
	   case  12: if(CodePage == ISO8859_1) return "";
		     if(textcomp>=false) {textcomp=true;return "\\textyen{}";}
		     break;
	   case  13: return "P$\\!$t";
	   case  14: return "{\\it f}\\/";
	   case  15: if(textcomp>=false) {textcomp=true;return "\\textordfeminine{}";}
		     return "\\astrike ";
	   case  16: if(textcomp>=false) {textcomp=true;return "\\textordmasculine{}";}
		     return "\\ostrike ";
	   case  17: if(CodePage == ISO8859_1) return "";
		     if(textcomp>=false) {textcomp=true;return "\\textonehalf ";}
		     return "$\\frac{1}{2}$";
	   case  18: if(CodePage == ISO8859_1) return "";
		     if(textcomp>=false) {textcomp=true;return "\\textonequarter ";}
		     return "$\\frac{1}{4}$";
	   case  19: if(CodePage == ISO8859_1) return "";
		     if(Wasy>=false) {Wasy=true;return "\\cent ";}
		     if(textcomp>=false) {textcomp=true;return "\\textcentoldstyle{}";}
		     return "Cent ";
	   case  20: return "$^{2}$";
	   case  21: return "$^{n}$";
	   case  22: if(CodePage == ISO8859_1) return "";
		     if(textcomp>=false) {textcomp=true;return "\\textregistered ";}
		     return "\\circchar{R}";
	   case  23: if(CodePage == ISO8859_1) return "";
		     return "\\copyright ";
	   case  24: if(CodePage == ISO8859_1) return "";
		     if(Wasy>=false) {Wasy=true;return "\\currency ";}
		     if(textcomp>=false) {textcomp=true;return "\\textcurrency{}";}
		     break;
	   case  25: if(CodePage == ISO8859_1) return "";
		     if(textcomp>=false) {textcomp=true;return "\\textthreequarters{}";}
		     return "$\\frac{3}{4}$";
	   case  26: return "$^{3}$";
           case  27: return "`";	/* !!! bad */
           case  28: return "'";
           case  29: return "`";
           case  30: return "``";	/* !!! bad */
           case  31: return "''";
           case  32: return "``";
           case  33: return "--{}";
	   case  34: return "---{}";
	   case  35: if(German>=true) return "\\flq ";
		     break;
	   case  36: if(German>=true) return "\\frq ";
		     break;
	   case  37: return "\\HollowBullet{1.5ex}";
	   case  38: if(Amssymb>=false) {Amssymb=true;return "$\\square$";}
		     break;
           case  39: return "\\dag ";
           case  40: return "\\ddag ";
	   case  41: return "\\trademark ";
	   case  42: return "\\servicemark ";
	   case  43: if(textcomp>=false) {textcomp=true;return "\\textrecipe{}";}
		     break;
	   case  44: return "\\Bullet{1.5ex}";
	   case  45: return "\\HollowBullet{.75ex}";
	   case  46: if(Amssymb>=false) {Amssymb=true;return "$\\blacksquare$";}
		     return "\\rule{1.5ex}{1.5ex}";
	   case  47: return "\\rule[.5ex]{0.75ex}{0.75ex}";
	   case  48: if(Amssymb>=true) {return "$\\square$";}
		     if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		     return "$\\Box$";

	   case  50: return "\\rule[.5ex]{1ex}{0.25ex}";
	   case  51: return "ff";
	   case  52: return "ffi";
	   case  53: return "ffl";
	   case  54: return "fi";
	   case  55: return "fl";
	   case  56: return "$\\ldots$";
	   case  57: if(textcomp>=false) {textcomp=true;return "\\textdollaroldstyle{}";}
		     break;

	   case  60: if(textcomp>=false) {textcomp=true;return "\\textsf{\\texteuro}";}
		     break;
	   case  61: if(textcomp>=false) {textcomp=true;return "\\textlira{}";}
		     break;
	   case  62: return "\\raise-1.2ex\\hbox{'}";
	   case  63: return "\\raise-1.2ex\\hbox{''}";
           case  64: return "$\\frac{1}{3}$";
           case  65: return "$\\frac{2}{3}$";
           case  66: return "$\\frac{1}{8}$";
           case  67: return "$\\frac{3}{8}$";
           case  68: return "$\\frac{5}{8}$";
           case  69: return "$\\frac{7}{8}$";
           case  70: return "\\circchar{M}";
	   case  71: return "\\circchar{P}";
	   case  72: return "\\circchar{U}";

	   case  75: if(Wasy>=false) {Wasy=true;return "\\permil ";}
		     if(textcomp>=false) {textcomp=true;return "\\textperthousand{}";}
		     break;
	   case  76: if(textcomp>=false) {textcomp=true;return "\\textnumero{}";}
		     break;
	   case  77: return "\\rule[.5ex]{1em}{0.25ex}";
	   case  78: return "$^{1}$";
           case  79: return "\\twottchars(HT)";
           case  80: return "\\twottchars(FF)";
           case  81: return "\\twottchars(CR)";
           case  82: return "\\twottchars(LF)";
           case  83: return "\\twottchars(NL)";
           case  84: return "\\twottchars(VT)";
           }
       break;

   
     case 5:  /*Iconic Symbols*/
       switch (char_code)
          {
          case   0: return "$\\heartsuit$";
          case   1: return "$\\diamondsuit$";
          case   2: return "$\\clubsuit$";
	  case   3: return "$\\spadesuit$";
	  case   4: if(Wasy>=false) {Wasy=true;return "\\male ";}
		    break;
	  case   5: if(Wasy>=false) {Wasy=true;return "\\female ";}
		    break;
	  case   6: if(Wasy>=false) {Wasy=true;return "\\sun ";}
		    break;
	  case   7: if(Wasy>=false) {Wasy=true;return "\\smiley ";}
		    break;
	  case   8: if(Wasy>=false) {Wasy=true;return "\\blacksmiley ";}
		    break;
	  case   9: if(Wasy>=false) {Wasy=true;return "\\eighthnote ";}
		    break;
	  case  10: if(Wasy>=false) {Wasy=true;return "\\twonotes ";}
		    break;
	  case  11: return "\\rule{1.9ex}{0.4ex}";

	  case  13: return "$!\\kern-.2ex!$";
	  case  14: return "$\\surd$";
	  case  15: return "$\\underline\\updownarrow$";
	  case  16: if(Wasy>=false) {Wasy=true;return "$\\invneg$";}
		    break;

	  case  20: if(CodePage == ISO8859_1) return "";
		    return "$\\lnot$";

	  case  23: if(Wasy>=false) {Wasy=true;return "\\checked ";}
		    break;
	  case  24: return "$\\Box$";
	  case  25: if(Wasy>=false) {Wasy=true;return "\\XBox ";}
		    break;
	  case  26: if(Wasy>=false) {Wasy=true;return "\\frownie ";}
		    break;
	  case  27: return "$\\sharp$";
	  case  28: return "$\\flat$";
          case  29: return "$\\natural$";

	  case  30: if(Wasy>=false) {Wasy=true;return "\\phone ";}
		    break;
	  case  31: if(Wasy>=false) {Wasy=true;return "\\clock ";}
		    break;

	  case  34: return "\\verb*| |";

	  }
       break;


     case 6:  /*Math/Scientific*/
       switch (char_code)
            {
            case   0: return "-";
            case   1: return "$\\pm$";
            case   2: return "$\\leq$";
            case   3: return "$\\geq$";
            case   4: return "$\\propto$";
	    case   5: return "/";
	    case   6: if(Amssymb>=false) {Amssymb=true;return "$\\diagup$";}
		      return "/";		//bad translation
	    case   7: if(Amssymb>=false) {Amssymb=true;return "$\\diagdown$";}
		      return "$\\setminus$";
            case   8: return "$\\div$";
            case   9: return "$\\mid$";
            case  10: return "$\\langle$";
	    case  11: return "$\\rangle$";
            case  12: return "$\\sim$";
            case  13: return "$\\approx$";
            case  14: return "$\\equiv$";
            case  15: return "$\\in$";
            case  16: return "$\\cap$";
            case  17: return "$\\parallel$";
            case  18: return "$\\sum$";
            case  19: return "$\\infty$";
            case  20: return "$\\neg$";
            case  21: return "$\\rightarrow$";
            case  22: return "$\\leftarrow$";
            case  23: return "$\\uparrow$";
            case  24: return "$\\downarrow$";
            case  25: return "$\\leftrightarrow$";
	    case  26: return "$\\updownarrow$";
	    case  27: if(Wasy>=false) {Wasy=true;return "\\RIGHTarrow ";}
		      break;
	    case  28: if(Wasy>=false) {Wasy=true;return "\\LEFTarrow ";}
		      break;
	    case  29: if(Wasy>=false) {Wasy=true;return "\\UParrow ";}
		      break;
	    case  30: if(Wasy>=false) {Wasy=true;return "\\DOWNarrow ";}
		      break;
	    case  31: return "$\\cdot$";
	    case  32: if(textcomp>=false) {textcomp=true;return "\\textperiodcentered{}";}
		      return "$\\mathsmaller{\\cdot}$";
	    case  33: return "$\\circ$";
	    case  34: return "$\\bullet$";
	    case  35: return "\\AA ";
	    case  36: if(textcomp>=false) {textcomp=true;return "\\textdegree{}";}
		      return "\\degrees ";
	    case  37: return "$\\mu$";
	    case  38: return "\\raise 0.5ex\\hbox{-}";
	    case  39: return "$\\times$";
	    case  40: return "$\\int$";
	    case  41: return "$\\prod$";
            case  42: return "$\\mp$";
            case  43: return "$\\nabla$";
            case  44: return "$\\partial$";
            case  45: return "$\\prime$";
            case  46: return "$\\prime\\prime$";
            case  47: return "$\\vec{}$";
	    case  48: if(Amssymb>=false) {Amssymb=true;return "$\\mathfrak e$";}
		      return "$\\cal e$";
	    case  49: if(Amssymb>=false) {Amssymb=true;return "$\\mathfrak l$";}
		      return "$\\ell$";
            case  50: return "$\\hbar$";
            case  51: return "$\\Im$";
            case  52: return "$\\Re$";
	    case  53: return "$\\wp$";
	    case  54: if(Amssymb>=false) {Amssymb=true;return "$\\rightleftarrows$";}
		      return "\\raisebox{0.6ex}{$\\rightarrow$}\\llap{\\raisebox{-0.3ex}{$\\leftarrow$}}";
	    case  55: if(Amssymb>=false) {Amssymb=true;return "$\\leftrightarrows$";}
		      return "\\raisebox{0.6ex}{$\\leftarrow$}\\llap{\\raisebox{-0.3ex}{$\\rightarrow$}}";
	    case  56: return "$\\Rightarrow$";
            case  57: return "$\\Leftarrow$";
            case  58: return "$\\Uparrow$";
            case  59: return "$\\Downarrow$";
            case  60: return "$\\Leftrightarrow$";
            case  61: return "$\\Updownarrow$";
            case  62: return "$\\nearrow$";
            case  63: return "$\\searrow$";
            case  64: return "$\\nwarrow$";
            case  65: return "$\\swarrow$";
            case  66: return "$\\cup$";
            case  67: return "$\\subset$";
            case  68: return "$\\supset$";
            case  69: return "$\\subseteq$";
            case  70: return "$\\supseteq$";
            case  71: return "$\\ni$";
            case  72: return "$\\emptyset$";
            case  73: return "$\\lceil$";
            case  74: return "$\\rceil$";
            case  75: return "$\\lfloor$";
            case  76: return "$\\rfloor$";
            case  77: return "$\\ll$";
            case  78: return "$\\gg$";
            case  79: return "$\\angle$";
            case  80: return "$\\otimes$";
            case  81: return "$\\oplus$";
            case  82: return "$\\ominus$";
            case  83: return "$\\oslash$";
            case  84: return "$\\odot$";
            case  85: return "$\\wedge$";
            case  86: return "$\\vee$";
	    case  87: return "$\\underline\\vee$";
            case  88: return "$\\top$";
	    case  89: return "$\\bot$";
	    case  90: return "\\t{~}";
	    case  91: return "$\\vdash$";
	    case  92: return "$\\dashv$";
	    case  93: return "$\\Box$";
	    case  94: if(Amssymb>=true) return "$\\blacksquare$";
		      return "\\rule{1.5ex}{1.5ex}";
	    case  95: if(Amssymb>=false) {Amssymb=true;return "$\\lozenge$";}
		      return "$\\diamondsuit$";
	    case  96: if(Amssymb>=false) {Amssymb=true;return "$\\blacklozenge$";}
		      return "$\\diamondsuit$";  //Bad!!
            case  97: return "$[\\![$";
            case  98: return "$]\\!]$";
            case  99: return "$\\neq$";
            case 100: return "$\\not\\equiv$";
	    case 101: if(Amssymb>=false) {Amssymb=true;return "$\\because$";}
		      return "\\because ";
	    case 102: if(Amssymb>=false) {Amssymb=true;return "$\\therefore$";}
		      return "\\therefore ";
	    case 103: return "\\identical ";
            case 104: return "$\\oint$";
	    case 105: if(Rsfs>=false) {Rsfs=true;return "$\\mathscr{L}$";}
		      break;
	    case 106: if(Amssymb>=false) {Amssymb=true;return "$\\mathfrak C$";}
		      break;
	    case 107: if(Amssymb>=false) {Amssymb=true;return "$\\mathfrak Z$";}
		      break;
            case 108: return "$\\wp$";
            case 109: return "$\\bigcirc$";
	    case 110: return "$\\underline\\triangle$";
	    case 111: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\Diamond$";
            case 112: return "$\\star$";
            case 113: return "$'''$";
            case 114: return "$\\coprod$";
	    case 115: return "$\\simeq$";
	    case 116: return "$\\cong$";
            case 117: return "$\\prec$";
            case 118: return "$\\preceq$";
            case 119: return "$\\succ$";
            case 120: return "$\\succeq$";
            case 121: return "$\\exists$";
            case 122: return "$\\forall$";
	    case 123: if(Amssymb>=false) {Amssymb=true;return "$\\lll$";}
		      return "$<\\!\\!<\\!\\!<$";
	    case 124: if(Amssymb>=false) {Amssymb=true;return "$\\ggg$";}
		      return "$>\\!\\!>\\!\\!>$";
	    case 125: return "$\\uplus$";
	    case 126: if(Amssymb>=false) {Amssymb=true;return "$\\varsubsetneq$";}
		      break;
	    case 127: if(Amssymb>=false) {Amssymb=true;return "$\\varsupsetneq$";}
		      break;
	    case 128: return "$\\sqcap$";
	    case 129: return "$\\sqcup$";
	    case 130: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\sqsubset$";
	    case 131: return "$\\sqsubseteq$";
	    case 133: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\sqsupset$";
	    case 134: return "$\\sqsupseteq$";
	    case 136: return "$\\bigtriangleup$";
            case 137: return "$\\bigtriangledown$";
            case 138: return "$\\triangleleft$";
            case 139: return "$\\triangleright$";
            case 140: return "$\\bowtie$";
            case 141: return "$\\smile$";
            case 142: return "$\\frown$";
            case 143: return "$\\bigcirc$";
	    case 144: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\leadsto$";
            case 145: return "$\\hookleftarrow$";
	    case 146: return "$\\hookrightarrow$";
	    case 147: return "$\\mapsto$";
            case 148: return "$\\leftharpoonup$";
            case 149: return "$\\leftharpoondown$";
            case 150: return "$\\rightharpoonup$";
            case 151: return "$\\rightharpoondown$";
            case 152: return "$\\rightleftharpoons$";
            case 153: return "$\\rightleftharpoons$";
	    case 154: if(Amssymb>=false) {Amssymb=true;return "$\\upharpoonleft$";}
		      return "$\\uparrow$";
	    case 155: if(Amssymb>=false) {Amssymb=true;return "$\\upharpoonright$";}
		      return "$\\uparrow$";
	    case 156: if(Amssymb>=false) {Amssymb=true;return "$\\downharpoonleft$";}
		      return "$\\downarrow$";
	    case 157: if(Amssymb>=false) {Amssymb=true;return "$\\downharpoonright$";}
		      return "$\\downarrow$";
	    case 158: if(Amssymb>=false) {Amssymb=true;return "$\\rightrightarrows$";}
		      return "\\raisebox{0.6ex}{$\\rightarrow$}\\llap{\\raisebox{-0.3ex}{$\\rightarrow$}}";
	    case 159: if(Amssymb>=false) {Amssymb=true;return "$\\leftleftarrows$";}
		      return "\\raisebox{0.6ex}{$\\leftarrow$}\\llap{\\raisebox{-0.3ex}{$\\leftarrow$}}";
	    case 160: if(Amssymb>=false) {Amssymb=true;return "$\\Cup$";}
		      break;
	    case 161: if(Amssymb>=false) {Amssymb=true;return "$\\Cap$";}
		      break;
	    case 162: if(Amssymb>=false) {Amssymb=true;return "$\\Subset$";}
		      break;
	    case 163: if(Amssymb>=false) {Amssymb=true;return "$\\Supset$";}
		      break;
	    case 164: if(Amssymb>=false) {Amssymb=true;return "$\\circledcirc$";}
		      return "\\circchar{O}";
	    case 165: if(Amssymb>=false) {Amssymb=true;return "$\\circledast$";}
		      return "\\circchar{*}";
	    case 166: if(Amssymb>=false) {Amssymb=true;return "$\\circleddash$";}
		      return "\\circchar{-}";
	    case 167: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\mho$";
	    case 168: if(Amssymb>=false) {Amssymb=true;return "$\\measuredangle$";}
		      return "$\\angle$";	/*very bad*/
	    case 169: if(Amssymb>=false) {Amssymb=true;return "$\\sphericalangle$";}
		      return "$\\angle$";	/*very bad*/
	    case 170: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\lhd$";
	    case 171: if ((LaTeX_Version & 0xFF00) >= 0x300)
			if(LaTeXsym>=false) {LaTeXsym=true;}
				       else break;
		      return "$\\rhd$";
	    case 172: return "$\\triangle$";
	    case 173: return "$\\bigtriangledown$";
	    case 174: if(Amssymb>=false) {Amssymb=true;return "$\\dotplus$";}
		      return "$\\dot{+}$";
	    case 175: return "$\\dot{=}$";
	    case 176: if(Amssymb>=false) {Amssymb=true;return "$\\fallingdotseq$";}
		      return "\\image ";		/* in WP2LaTeX style */
	    case 177: if(Amssymb>=false) {Amssymb=true;return "$\\risingdotseq$";}
		      return "\\rimage ";		/* in WP2LaTeX style */
	    case 178: if(Amssymb>=false) {Amssymb=true;return "$\\Bumpeq$";}
		      break;
	    case 179: return "$\\asymp$";
	    case 180: return "$\\models$";
	    case 181: if(Amssymb>=false) {Amssymb=true;return "$\\triangleq$";}
		      return "$\\stackrel{\\triangle}{=}$";
	    case 182: if(Amssymb>=false) {Amssymb=true;return "$\\between$";}
		      return "\\between ";		/* in WP2LaTeX style */
	    case 183: return "$\\wr$";
	    case 184: if(Amssymb>=false) {Amssymb=true;return "$\\bigstar$";}
		      return "$\\star$";
	    case 185: return "$\\not<$";
            case 186: return "$\\not\\leq$";
            case 187: return "$\\not>$";
            case 188: return "$\\not\\geq$";
            case 189: return "$\\not\\sim$";
            case 190: return "$\\not\\simeq$";
            case 191: return "$\\not\\cong$";
	    case 192: return "$\\not\\approx$";
            case 193: return "$\\not\\prec$";
            case 194: return "$\\not\\preceq$";
            case 195: return "$\\not\\succ$";
            case 196: return "$\\not\\succeq$";
            case 197: return "$\\not\\subset$";
            case 198: return "$\\not\\supset$";
            case 199: return "$\\not\\subseteq$";
            case 200: return "$\\not\\supseteq$";
            case 201: return "$\\not\\sqsubset$";
            case 202: return "$\\not\\sqsupset$";
            case 203: return "$\\not\\sqsubseteq$";
            case 204: return "$\\not\\sqsupseteq$";
	    case 205: if(Amssymb>=false) {Amssymb=true;return "$\\nparallel$";}
		      return "$\\not\\parallel$";
	    case 206: if(Amssymb>=false) {Amssymb=true;return "$\\nmid$";}
		      return "$\\not\\mid$";
            case 207: return "$\\not\\asymp$";
            case 208: return "$\\not\\exists$";
	    case 209: return "$\\not\\in$";
	    case 210: if(Amssymb>=false) {Amssymb=true;return "$\\not\\Bumpeq$";}
		      break;
	    case 211: if(Rsfs>=false) {Rsfs=true;return "$\\mathscr{E}$";}
		      return "{\\rm E}";
	    case 212: if(Rsfs>=false) {Rsfs=true;return "$\\mathscr{F}$";}
		      return "{\\rm F}";
	    case 213: if(Bbm>=false) {Bbm=true;return "$\\mathbbm{C}$";}
		      return "{\\rm C}";
	    case 214: if(Bbm>=false) {Bbm=true;return "$\\mathbbm{I}$";}
		      return "{\\rm I}";
	    case 215: if(Bbm>=false) {Bbm=true;return "$\\mathbbm{N}$";}
		      return "{\\rm N}";
	    case 216: if(Bbm>=false) {Bbm=true;return "$\\mathbbm{R}$";}
		      return "{\\rm R}";
	    case 217: return "$\\stackrel{?}{=}$";

            case 219: return "$\\ni$";
            case 220: return "$\\cdots$";
            case 221: return "$\\ldots$";
            case 222: return "$\\vdots$";
	    case 223: return "$\\ddots$";
	    case 224: return "\\raisebox{1.2ex}{...}";

            case 226: return "+";
            case 227: return "-";
            case 228: return "=";
            case 229: return "*";
            case 230: return "/";
	    case 231: return "/\\kern-.5ex/";
            case 232: return "/\\kern-0.5ex/\\kern-0.5ex/";
            case 233: return "$\\cal H$";
            case 234: return "$\\cal P$";
            }
       break;

#ifdef __BORLANDC__
       }
return(BorlandCPPIsShit(char_set,char_code,cq));}
char *BorlandCPPIsShit(unsigned char char_set,unsigned char  char_code, TconvertedPass1 *cq)
{switch (char_set) {
#endif

     case 7:  /*Math/Scientific Extension*/
       switch (char_code)
            {
            case   0: return "~";
            case   1: return "~";

	    case   4: return "$\\surd$";

            case   6: return "$\\sum$";
            case   7: return "$\\prod$";
            case   8: return "$\\coprod$";
            case   9: return "$\\int$";
            case  10: return "$\\oint$";
            case  11: return "$\\bigl|$";
            case  12: return "$\\Bigl|$";
            case  13: return "$\\biggl|$";
            case  14: return "$\\Biggl|$";
            case  16: return "$\\bigl\\|$";
            case  17: return "$\\Bigl\\|$";
            case  18: return "$\\biggl\\|$";
            case  19: return "$\\Biggl\\|$";

            case  21: return "$\\bigl\\{$";
            case  22: return "$\\Bigl\\{$";
            case  23: return "$\\biggl\\{$";
            case  24: return "$\\Biggl\\{$";
	    case  25: return "$\\mathchar\"4338$";
	    case  26: return "$\\mathchar\"433C$";
	    case  27: return "$\\mathchar\"433A$";
	    case  28: return "$\\mathchar\"433E$";
	    case  29: return "$\\bigr\\}$";
            case  30: return "$\\Bigr\\}$";
            case  31: return "$\\biggr\\}$";
	    case  32: return "$\\Biggr\\}$";
	    case  33: return "$\\mathchar\"4339$";
	    case  34: return "$\\mathchar\"433D$";
	    case  35: return "$\\mathchar\"433B$";
	    case  36: return "$\\mathchar\"433E$";
	    case  37: return "$\\bigl\\lfloor$";
            case  38: return "$\\Bigl\\lfloor$";
            case  39: return "$\\biggl\\lfloor$";
            case  40: return "$\\Biggl\\lfloor$";
            case  41: return "$\\lfloor$";

            case  43: return "$\\bigr\\rfloor$";
            case  44: return "$\\Bigr\\rfloor$";
	    case  45: return "$\\biggr\\rfloor$";
            case  46: return "$\\Biggr\\rfloor$";
	    case  47: return "$\\rfloor$";

            case  49: return "$\\bigl\\lceil$";
            case  50: return "$\\Bigl\\lceil$";
            case  51: return "$\\biggl\\lceil$";
            case  52: return "$\\Biggl\\lceil$";
            case  53: return "$\\lceil$";

            case  55: return "$\\bigr\\rceil$";
            case  56: return "$\\Bigr\\rceil$";
            case  57: return "$\\biggr\\rceil$";
            case  58: return "$\\Biggr\\rceil$";
            case  59: return "$\\rceil$";

            case  85: return "$\\rightarrow$";
            case  86: return "$\\leftarrow$";

            case  91: return "$\\Rightarrow$";
	    case  92: return "$\\Leftarrow$";

	    case  94: return "$\\uparrow$";
            case  95: return "$\\downarrow$";
            case  97: return "$\\Uparrow$";
            case  98: return "$\\Downarrow$";
            case  99: return "$\\|$";
            case 100: return "$\\bigl($";
            case 101: return "$\\Bigl($";
            case 102: return "$\\biggl($";
            case 103: return "$\\Biggl($";

            case 107: return "$\\bigr)$";
            case 108: return "$\\Bigr)$";
            case 109: return "$\\biggr)$";
            case 110: return "$\\Biggr)$";

            case 114: return "$\\bigl[$";
            case 115: return "$\\Bigl[$";
            case 116: return "$\\biggl[$";
	    case 117: return "$\\Biggl[$";

	    case 121: return "$\\bigr]$";
            case 122: return "$\\Bigr]$";
            case 123: return "$\\biggr]$";
            case 124: return "$\\Biggr]$";

            case 128: return "$\\bigl\\langle$";
            case 129: return "$\\Bigl\\langle$";
            case 130: return "$\\biggl\\langle$";
            case 131: return "$\\Biggl\\langle$";
            case 132: return "$\\bigr\\rangle$";
            case 133: return "$\\Bigr\\rangle$";
            case 134: return "$\\biggr\\rangle$";
            case 135: return "$\\Biggr\\rangle$";
            case 136: return "$\\bigl/$";
            case 137: return "$\\Bigl/$";
            case 138: return "$\\biggl/$";
            case 139: return "$\\Biggl/$";
            case 140: return "$\\bigr\\backslash$";
	    case 141: return "$\\Bigr\\backslash$";
            case 142: return "$\\biggr\\backslash$";
	    case 143: return "$\\Biggr\\backslash$";
            case 144: return "$\\bigcup$";
            case 145: return "$\\bigcap$";
            case 146: return "$\\uplus$";
            case 147: return "$\\biguplus$";
            case 148: return "$\\sqcup$";
            case 149: return "$\\bigsqcup$";
            case 150: return "$\\wedge$";
            case 151: return "$\\bigwedge$";
            case 152: return "$\\vee$";
            case 153: return "$\\bigvee$";
            case 154: return "$\\otimes$";
            case 155: return "$\\bigotimes$";
            case 156: return "$\\oplus$";
            case 157: return "$\\bigoplus$";
            case 158: return "$\\odot$";
            case 159: return "$\\bigodot$";
            case 160: return "$\\lmoustache$";
	    case 161: return "$\\rmoustache$";

	    case 164: return "$\\mathchar\"437C$";
	    case 165: return "$\\mathchar\"437D$";

	    case 168: return "$\\widehat{~}$";
	    case 169: return "$\\widehat{\\kern1em}$";
	    case 170: return "$\\widehat{\\kern2em}$";
	    case 171: return "$\\widetilde{~}$";
	    case 172: return "$\\widetilde{\\kern1em}$";
	    case 173: return "$\\widetilde{\\kern2em}$";

	    case 177: return "$\\overline{~}$";
	    case 178: return "$\\overline{\\kern1em}$";
	    case 179: return "$\\overline{\\kern2em}$";
	    case 180: return "$\\ominus$";

	    case 184: return "$\\bigl[\\!\\bigl[$";
            case 185: return "$\\Bigl[\\!\\!\\Bigl[$";
            case 186: return "$\\biggl[\\!\\!\\biggl[$";
            case 187: return "$\\Biggl[\\!\\!\\Biggl[$";

            case 191: return "$\\bigl]\\!\\bigl]$";
            case 192: return "$\\Bigl]\\!\\!\\Bigl]$";
            case 193: return "$\\biggl]\\!\\!\\biggl]$";
            case 194: return "$\\Biggl]\\!\\!\\Biggl]$";

            case 198: return "$\\rightharpoonup$";
            case 199: return "$\\rightharpoondown$";
            case 200: return "$\\leftharpoonup$";
	    case 201: return "$\\leftharpoondown$";

	    case 207: return "\\raisebox{0.3ex}{-}\\llap{\\raisebox{-0.1ex}{-}}";
	    case 208: if(Amssymb>=false) {Amssymb=true;return "$\\rightrightarrows$";}
		      return "\\raisebox{0.6ex}{$\\rightarrow$}\\llap{\\raisebox{-0.3ex}{$\\rightarrow$}}";
	    case 209: if(Amssymb>=false) {Amssymb=true;return "$\\leftleftarrows$";}
		      return "\\raisebox{0.6ex}{$\\leftarrow$}\\llap{\\raisebox{-0.3ex}{$\\leftarrow$}}";
	    case 210: return "\\raisebox{0.6ex}{--}\\llap{\\raisebox{-0.3ex}{--}}";
	    case 211: return "\\raisebox{0.6ex}{$\\rightarrow$}\\llap{\\raisebox{-0.3ex}{---}}";
	    case 212: return "\\raisebox{0.6ex}{---}\\llap{\\raisebox{-0.3ex}{$\\rightarrow$}}";
	    case 213: return "\\raisebox{0.6ex}{$\\leftarrow$}\\llap{\\raisebox{-0.3ex}{---}}";
	    case 214: return "\\raisebox{0.6ex}{---}\\llap{\\raisebox{-0.3ex}{$\\leftarrow$}}";
	    case 215: return "\\raisebox{0.6ex}{---}\\llap{\\raisebox{-0.3ex}{---}}";

            case 221: return "$\\sqcap$";
            case 222: return "\\bigsqcap ";
            }
        break;


     case 8:  /*Greek*/
       switch (char_code)
            {
            case   0: return "A";
	    case   1: return "$\\alpha$";
            case   2: return "B";
            case   3: return "$\\beta$";
            case   4: return "B";

            case   6: return "$\\Gamma$";
            case   7: return "$\\gamma$";
            case   8: return "$\\Delta$";
            case   9: return "$\\delta$";
            case  10: return "E";
            case  11: return "$\\epsilon$";
            case  12: return "Z";
            case  13: return "$\\zeta$";
            case  14: return "H";
            case  15: return "$\\eta$";
            case  16: return "$\\Theta$";
            case  17: return "$\\theta$";
            case  18: return "I";
            case  19: return "$\\iota$";
            case  20: return "K";
            case  21: return "$\\kappa$";
            case  22: return "$\\Lambda$";
            case  23: return "$\\lambda$";
            case  24: return "M";
            case  25: return "$\\mu$";
            case  26: return "N";
            case  27: return "$\\nu$";
            case  28: return "$\\Xi$";
            case  29: return "$\\xi$";
            case  30: return "O";
            case  31: return "o";
            case  32: return "$\\Pi$";
            case  33: return "$\\pi$";
            case  34: return "P";
            case  35: return "$\\rho$";
            case  36: return "$\\Sigma$";
            case  37: return "$\\sigma$";
            case  38: return "$\\Sigma$";
            case  39: return "$\\varsigma$";
            case  40: return "T";
            case  41: return "$\\tau$";
            case  42: return "Y";
            case  43: return "$\\upsilon$";
            case  44: return "$\\Phi$";
            case  45: return "$\\phi$";
            case  46: return "X";
            case  47: return "$\\chi$";
            case  48: return "$\\Psi$";
            case  49: return "$\\psi$";
            case  50: return "$\\Omega$";
            case  51: return "$\\omega$";
            case  52: return "$\\acute\\alpha$";
            case  53: return "$\\acute\\epsilon$";
            case  54: return "$\\acute\\eta$";
            case  55: return "$\\acute\\iota$";
            case  56: return "$\\ddot\\iota$";
            case  57: return "$\\acute{o}$";
            case  58: return "$\\acute\\upsilon$";
            case  59: return "$\\ddot\\upsilon$";
            case  60: return "$\\acute\\omega$";
            case  61: return "$\\varepsilon$";
	    case  62: return "$\\vartheta$";
	    case  63: if(Amssymb>=false) {Amssymb=true;return "$\\varkappa$";}
		      break;
	    case  64: return "$\\varpi$";
            case  65: return "$\\varrho$";
            case  66: return "$\\Upsilon$";
            case  67: return "$\\varphi$";
            case  68: return "$\\varpi$";
            case  69: return ";";
	    case  70: return "$\\cdot$";
            case  71: return "\\'{}";
            case  72: return "\\\"{}";

	    case  75: if (cq->envir == 'T') return "\\a`{}";
        	      return "\\`{}";
            case  76: return "\\t{}";

            case  97: return "$\\grave\\alpha$";
            case  98: return "$\\hat\\alpha$";

            case 116: return "$\\grave\\epsilon$";

            case 123: return "$\\grave\\eta$";
            case 124: return "$\\hat\\eta$";

            case 143: return "$\\grave\\iota$";
	    case 144: return "$\\hat\\iota$";

	    case 147: return "\\mbox{\\ooalign{$\\iota$\\cr\\hfil'\\hfil}}";
	    case 148: return "\\mbox{\\ooalign{\\hfil$\\iota$\\hfil\\cr'$\\!$\\'{}}}";
	    case 149: return "\\mbox{\\ooalign{\\hfil$\\iota$\\hfil\\cr'$\\,\\grave{}$}}";

            case 155: return "$\\grave{o}$";

            case 162: return "$\\grave\\upsilon$";
            case 163: return "$\\hat\\upsilon$";

            case 174: return "$\\grave\\omega$";
            case 175: return "$\\hat\\omega$";

            case 194: return "\\raise0.7ex\\hbox{$\\prime$}";
	    case 195: return "\\lower0.2ex\\hbox{$\\prime$}";

	    case 197: if(Amssymb>=false) {Amssymb=true;return "$\\digamma$";}
		      break;

            case 200: return "\\primechar{A}";
            case 201: return "\\primechar{E}";
	    case 202: return "\\primechar{H}";
            case 203: return "\\primechar{I}";
            case 204: return "\\primechar{O}";
            case 205: return "\\primechar{Y}";
	    case 206: return "\\primechar{$\\Omega$}";
            }
       break;

    case 9:	/*Hebrew*/
       switch (char_code)
            {
	    case   0: return "$\\aleph$";
	    case   1: if(Amssymb>=false) {Amssymb=true;return "$\\beth$";}
		      break;
	    case   2: if(Amssymb>=false) {Amssymb=true;return "$\\gimel$";}
		      break;
	    case   3: if(Amssymb>=false) {Amssymb=true;return "$\\daleth$";}
		      break;
	    }
       break;


     case 10:	/*Cyrillic*/
       Cyrilic = true;
       switch (char_code)
            {
            case   0: return "A";
            case   1: return "a";
            case   2: return "B";
            case   3: return "b";
            case   4: return "V";
            case   5: return "v";
            case   6: return "G";
            case   7: return "g";
            case   8: return "D";
            case   9: return "d";
            case  10: return "E";
	    case  11: return "e";
	    case  12: return "\\\"E";
            case  13: return "\\\"e";
            case  14: return "Zh";
            case  15: return "zh";
	    case  16: return "Z";
            case  17: return "z";
            case  18: return "I";
            case  19: return "i";
            case  20: return "{\\rm \\v{\\cyr I}}";
            case  21: return "{\\rm \\v{\\cyr i}}";
            case  22: return "K";
            case  23: return "k";
            case  24: return "L";
            case  25: return "l";
            case  26: return "M";
            case  27: return "m";
            case  28: return "N";
            case  29: return "n";
	    case  30: return "O";
	    case  31: return "o";
            case  32: return "P";
            case  33: return "p";
            case  34: return "R";
	    case  35: return "r";
            case  36: return "S";
            case  37: return "s";
            case  38: return "T";
            case  39: return "t";
            case  40: return "U";
            case  41: return "u";
            case  42: return "F";
            case  43: return "f";
            case  44: return "H";
            case  45: return "h";
            case  46: return "C";
            case  47: return "c";
            case  48: return "Ch";
	    case  49: return "ch";
	    case  50: return "Sh";
            case  51: return "sh";
            case  52: return "W";
            case  53: return "w";
	    case  54: return "\\Cdprime ";
            case  55: return "\\cdprime ";
            case  56: return "Y";
            case  57: return "y";
	    case  58: return "\\Cprime ";
            case  59: return "\\cprime ";
            case  60: return "{\\char3}";
            case  61: return "{\\char11}";
            case  62: return "Yu";
            case  63: return "yu";
            case  64: return "Ya";
            case  65: return "ya";
            case  68: return "\\Dbar ";
            case  69: return "\\dbar ";
	    case  70: return "\\'G";
	    case  71: return "\\'g";
	    case  72: return "{\\char5}";
            case  73: return "{\\char13}";
            case  74: return "\\Dz ";
	    case  75: return "\\dz ";
            case  76: return "{\\rm I\\cyr}";
            case  77: return "{\\rm i\\cyr}";
            case  78: return "\\\"{I}";
            case  79: return "\\\"{\\i}";
            case  80: return "J";
            case  81: return "j";
            case  82: return "{\\char1}";
            case  83: return "{\\char9}";
            case  84: return "{\\char0}";
            case  85: return "{\\char8}";
            case  86: return "{\\char7}";
	    case  87: return "{\\char15}";
            case  88: return "\\'K";
	    case  89: return "\\'k";
	    case  90: return "\\u{U}";
            case  91: return "\\u{u}";
            case  92: return "\\Dzh ";
            case  93: return "\\dzh ";
	    case  94: return "{\\char35}";
            case  95: return "{\\char43}";
            case  96: return "{\\char21}";
            case  97: return "{\\char29}";
            case  98: return "{\\char20}";
            case  99: return "{\\char28}";

            case 110: return "\\'A";
            case 111: return "\\'a";
            case 112: return "\\'E";
            case 113: return "\\'e";
            case 114: return "\\'I";
            case 115: return "\\'i";
            case 116: return "\\'O";
	    case 117: return "\\'o";
	    case 118: return "\\'U";
            case 119: return "\\'u";
            case 120: return "\\'Y";
            case 121: return "\\'y";
	    case 122: return "\\'{\\char3}";
            case 123: return "\\'{\\char11}";
            case 124: return "\\'{\\char16}";	// \'{Yu} do not work!
            case 125: return "\\'{\\char24}";	// \'{yu} do not work!
	    case 126: return "\\'{\\char23}";	// \'{Ya} do not work!
            case 127: return "\\'{\\char31}";	// \'{ya} do not work!
            case 128: return "\\`A";
            case 129: return "\\`a";
            case 130: return "\\`{\\char69}";	// \`E is transformed to hard E
            case 131: return "\\`{\\char101}";	// \`e is transformed to hard e
            case 132: return "\\`{\\char19}";
            case 133: return "\\`{\\char27}";
            case 134: return "\\`I";
            case 135: return "\\`i";
	    case 136: return "\\`O";
	    case 137: return "\\`o";
	    case 138: return "\\`U";
	    case 139: return "\\`u";
	    case 140: return "\\`Y";
	    case 141: return "\\`y";
	    case 142: return "\\`{\\char3}";
	    case 143: return "\\`{\\char11}";
	    case 144: return "\\`{\\char16}";	// \`{Yu} do not work!
	    case 145: return "\\`{\\char24}";	// \`{yu} do not work!
	    case 146: return "\\`{\\char23}";	// \`{Ya} do not work!
	    case 147: return "\\`{\\char31}";	// \`{ya} do not work!
	    case 148: return "\\'{}";
	    case 149: return "\\`{}";
	    }
       break;


    case 12:	/*User Character Set*/
       if(UserWPCharSet==NULL)
	   {
NoUserChar:cq->perc.Hide();
	   fprintf(cq->err, _("\nWarning: Please add user character No:%d into external config file!"),(int)char_code);
	   break;
	   }
       if(UserWPCharSet[char_code]==NULL) goto NoUserChar;
       return(UserWPCharSet[char_code]);


     }

  UnknownCharacters++;
  return(" -?- ");
}

#ifdef _1

LatTable lat;
unsigned short CodePage, WPcharset;
boolean Cyrilic;
unsigned char Verbosing;
boolean TexChars;



int main(void)
{
int i;
TconvertedPass1 cq;

Table_Init(lat);
for(i=0;i<255;i++)
	{
        printf("%d %d: %s\n\r",i,1,Ext_chr_str(1,i,&cq));
        }
printf("\n\r");

return(0);
}
#endif  /**/


/* End. */
