#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>

#include "types.h"

/* #ifdef LoEndian
   #else */


/* These procedures should be safe for all cases */

/* Read a double word from binary file in a LowEndian Format
 * parameters: FILE  *f :  binary input file
 * return:     DWORD *num : readed double word  */
int RdDWORD_LoEnd( DWORD *num, FILE *f )
{
unsigned char b;
if(!fread( &b, 1,1,f)) return 0; *num=(DWORD)b;
if(!fread( &b, 1,1,f)) return 1; *num+=(DWORD)b * 256l;
if(!fread( &b, 1,1,f)) return 2; *num+=(DWORD)b * 256l * 256l;
if(!fread( &b, 1,1,f)) return 3; *num+=(DWORD)b * 256l * 256l * 256l;
return 4;
}

/* Read a word from binary file in a LowEndian Format
 * parameters: FILE  *f :  binary input file
 * return:     WORD *num : readed word  */
int RdWORD_LoEnd( WORD *num, FILE *f )
{
unsigned char b;
if(!fread( &b, 1,1,f)) return 0; *num=(WORD)b;
if(!fread( &b, 1,1,f)) return 1; *num+=(WORD)b * 256l;
return 2;
}


/* Read a double word from binary file in a HighEndian Format
 * parameters: FILE  *f :  binary input file
 * return:     DWORD *num : readed double word  */
int RdDWORD_HiEnd( DWORD *num, FILE *f )
{
unsigned char b;
if(!fread( &b, 1,1,f)) return 0; *num=(DWORD)b * 256l * 256l * 256l;
if(!fread( &b, 1,1,f)) return 1; *num+=(DWORD)b * 256l * 256l;
if(!fread( &b, 1,1,f)) return 2; *num+=(DWORD)b * 256l;
if(!fread( &b, 1,1,f)) return 3; *num+=(DWORD)b;
return 4;
}


/* Read a word from binary file in a HiEndian Format
 * parameters: FILE  *f :  binary input file
 * return:     WORD *num : readed word  */
int RdWORD_HiEnd( WORD *num, FILE *f )
{
unsigned char b;
if(!fread( &b, 1,1,f)) return 0; *num=(WORD)b * 256l;
if(!fread( &b, 1,1,f)) return 1; *num+=(WORD)b;
return 2;
}


/* Write a double word to the binary file in a LowEndian Format
 * parameters: FILE  *f :  binary input file
 *             DWORD num : double word to be written */
int WrDWORD_LoEnd( DWORD num, FILE *f )
{
BYTE b;
b = (BYTE)((num >> 8*0) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 0;
b = (BYTE)((num >> 8*1) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 1;
b = (BYTE)((num >> 8*2) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 2;
b = (BYTE)((num >> 8*3) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 3;
return 4;
}

/* Write a word to the binary file in a LowEndian Format
 * parameters: FILE  *f :  binary input file
 *             WORD num : word to be written */
int WrWORD_LoEnd( WORD num, FILE *f )
{
BYTE b;
b = (BYTE)((num >> 8*0) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 0;
b = (BYTE)((num >> 8*1) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 1;
return 2;
}


/* Write a double word to the binary file in a LowEndian Format
 * parameters: FILE  *f :  binary input file
 *             DWORD num : double word to be written */
int WrDWORD_HiEnd( DWORD num, FILE *f )
{
BYTE b;
b = (BYTE)((num >> 8*3) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 0;
b = (BYTE)((num >> 8*2) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 1;
b = (BYTE)((num >> 8*1) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 2;
b = (BYTE)((num >> 8*0) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 3;
return 4;
}

/* Write a word to the binary file in a HighEndian Format
 * parameters: FILE  *f :  binary input file
 *             WORD num : word to be written */
int WrWORD_HiEnd( WORD num, FILE *f )
{
BYTE b;
b = (BYTE)((num >> 8*1) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 0;
b = (BYTE)((num >> 8*0) & 0x00ffl); if(!fwrite( &b, 1,1,f)) return 1;
return 2;
}
/* #endif */



int loadstruct(FILE *F,char *description, ...)
{
 va_list ap;
 int loaded=0;
 int ArraySize;

 va_start(ap, description);
 while(*description!=0)
   {

   switch(*description)
     {
     case 'b':
     case 'B':loaded+=fread(va_arg(ap,char *),1,1,F);
              break;
     case 'w':loaded+=RdWORD_LoEnd( va_arg(ap,WORD *),F);
     	      break;
     case 'W':loaded+=RdWORD_HiEnd( va_arg(ap,WORD *),F);
     	      break;
     case 'd':loaded+=RdDWORD_LoEnd( va_arg(ap,DWORD *),F);
     	      break;
     case 'D':loaded+=RdDWORD_HiEnd( va_arg(ap,DWORD *),F);
     	      break;

     case 'a':
     case 'A':ArraySize=0;
     	      while (isdigit(*(++description)))
	         {
                 ArraySize=10*ArraySize + (int)(*description-'0');
                 }
              description--;

              loaded+=fread(va_arg(ap,char *),ArraySize,1,F);
              break;


     default:printf("Error: Unknown character %c !", *description);
     }

   description++;
   }

return(loaded);
}


int savestruct(FILE *F,char *description, ...)
{
 va_list ap;
 int writed=0;
 int ArraySize;

 va_start(ap, description);
 while(*description!=0)
   {

   switch(*description)
     {
     case 'b':
     case 'B':writed+=fwrite(&va_arg(ap,char),1,1,F);
              break;
     case 'w':writed+=WrWORD_LoEnd( va_arg(ap,WORD),F);
     	      break;
     case 'W':writed+=WrWORD_HiEnd( va_arg(ap,WORD),F);
     	      break;
     case 'd':writed+=WrDWORD_LoEnd( va_arg(ap,DWORD),F);
     	      break;
     case 'D':writed+=WrDWORD_HiEnd( va_arg(ap,DWORD),F);
     	      break;

     case 'a':
     case 'A':ArraySize=0;
     	      while (isdigit(*(++description)))
	         {
                 ArraySize=10*ArraySize + (int)(*description-'0');
                 }
              description--;

              writed+=fwrite(va_arg(ap,char *),ArraySize,1,F);
              break;


     default:printf("Error: Unknown character %c !", *description);
     }

   description++;
   }

return(writed);
}

