#include <stdlib.h>
#include <limits.h>
#include <string.h>

#include <types.h>
#include <sets.h>


//Constructors Of set class
set::set(void)
{
 data=NULL;
 MinElement=MaxElement=0;
}

set::set(int number)
{
 MaxElement=number | 0xF;
 MinElement=MaxElement-15;
 data=(WORD *)malloc(2);
 *data=1<<(number & 15);
}

set::set(const set & s)
{
int size;

size=(s.MaxElement-s.MinElement+1)>>3;
if(size==0)
	{
        data=NULL;
        goto Empty;
        }
if((data=(WORD *)malloc(size))==NULL)
	{
Empty:  MaxElement=MinElement=0;
        }

memcpy(data,s.data,size);
MaxElement=s.MaxElement;
MinElement=s.MinElement;
return;
}


set::set(int Min, int Max)
{
int size;

 MaxElement=Max;
 MinElement=Min;
 if(Min>Max)
 	{
        MaxElement=Min;
	MinElement=Max;
        }

 size=(MaxElement-MinElement+1)>>3;
 if((data=(WORD *)malloc(size))==NULL) return;
 memset(data,0,size);
}

set::set(int *Array, int Size)
{
int i;
int *Element;

 MaxElement=INT_MIN;
 MinElement=INT_MAX;

 Element=Array;
 for(i=Size;i>0;i--)
 	{
        if(*Element!=TrickInterval)
          {
          if(*Element>MaxElement) MaxElement=*Element;
          if(*Element<MinElement) MinElement=*Element;
          }
        Element++;
        }
 if(MaxElement<MinElement)
 	{
        data=NULL;
        MaxElement=MinElement=0;
        return;
        }

 MaxElement|=0xF;
 MinElement&=~0xF;
 i=(MaxElement-MinElement+1)>>3;
 if((data=(WORD *)malloc(i))==NULL) return;
 memset(data,0,i);

 Element=Array;
 i=0;
 while(Size-->0)
 	{
        if(*Element==TrickInterval)
        	{
                Element++;
                if(Size-- <= 0) break;
                if(*Element==TrickInterval) break;
                for(i++;i<=*Element-MinElement;i++)
			*(data+(i>>4))|=(int)1<<(i&0xF);
                }
           else {
                i=*Element-MinElement;
	        *(data+(i>>4))|=(int)1<<(i&0xF);
                }
        Element++;
        }
}



//Destructor Of class set
//set::~set(void)
//{
// erase(*this);
//}


//copy constructor for class set
set &set::operator=(const set & s)
{
int size;

size=(s.MaxElement-s.MinElement+1)>>3;
if(size==0)
	{
        free(data);
        data=NULL;
        goto Empty;
        }
if((s.MaxElement!=MaxElement)||(s.MinElement!=MinElement))
	{
        free(data);
        data=(WORD *)malloc(size);
        }
if(data==NULL)
	{
Empty:  MaxElement=MinElement=0;
	return(*this);
        }

memcpy(data,s.data,size);
MaxElement=s.MaxElement;
MinElement=s.MinElement;

return(*this);
}

int set::operator==(const set &s) const
{
int size1,size2,offset;
WORD *Data1,*Data2;

 if(data==NULL)
 	{
        return(EmptyCheck(s));
        }
 if(s.data==NULL)
 	{
        return(EmptyCheck(*this));
        }

 size1=(MaxElement-MinElement+1)>>4;
 size2=(s.MaxElement-s.MinElement+1)>>4;
 offset=(MinElement-s.MinElement+1)>>4;
 Data1=data;
 Data2=s.data;

 while((size1>0)||(size2>0))
 	{
	if(offset>0)
        	{
                offset--;
                size2--;        //tady je chyba, pridat test size
                if(*Data2++ !=0 ) return(0);
                continue;
                }
        if(offset<0)
        	{
                offset++;
                size1--;
                if(*Data1++ !=0 ) return(0);
                continue;
                }

        size1--;
        size2--;
	if(size2<0)
        	{
                if(*Data1++ !=0 ) return(0);
                continue;
                }
        if(size1<0)
        	{
                if(*Data2++ !=0 ) return(0);
                continue;
                }

	if(*Data1++ != *Data2++) return(0);
        }

return(1);

}


int set::operator IN (const set &s) const
{
int size,size2,offset;
WORD *InData,*CheckedData;

 size=(MaxElement-MinElement+1)>>4;
 size2=(s.MaxElement-s.MinElement+1)>>4;
 offset=(MinElement-s.MinElement+1)>>4;
 InData=data;
 CheckedData=s.data;
 if(offset<0)
 	{
        CheckedData-=offset;	//offset is negative!
        size2+=offset;
        offset=0;
        }

 while(size-->0)
 	{
	if(offset>0)
        	{
                offset--;
                if(*InData++ !=0 ) return(0);
                continue;
                }
	if(size2<=0)
        	{
                if(*InData++ !=0 ) return(0);
                continue;
                }

        size2--;
	if((*InData++ | *CheckedData)!=*CheckedData++) return(0);
        }

return(1);
}

//Receiving one bit from set
int set::operator[](int i) const
{
 if((i>MaxElement)||(i<MinElement)) return(0);
 i-=MinElement;
 return( (*(data+(i>>4)) & 1<<(i&0xF)) != 0);
}


//Addind sets
set operator+(const set & s1, const set & s2)
{
int size1,size2,offset;
WORD *Data1,*Data2,*OutData;

 if((s1.data==NULL)&&(s2.data==NULL))
 	{
        return set();
        }

 set tmp(min(s1.MinElement,s2.MinElement),max(s1.MaxElement,s2.MaxElement));

 size1=(s1.MaxElement-s1.MinElement+1)>>4;
 size2=(s2.MaxElement-s2.MinElement+1)>>4;
 offset=(s1.MinElement-s2.MinElement+1)>>4;
 Data1=s1.data;
 Data2=s2.data;
 OutData=tmp.data;

 while((size1>0)||(size2>0))
 	{
	if(offset>0)
        	{
                offset--;
                if(size2--<=0) *OutData++=0;
                	  else *OutData++=*Data2++;
                continue;
                }
        if(offset<0)
        	{
                offset++;
                if(size1--<=0) *OutData++=0;
			  else *OutData++=*Data1++;
                continue;
                }

        size1--;
        size2--;
	if(size2<0)
        	{
                *OutData++=*Data1++;
                continue;
                }
        if(size1<0)
        	{
                *OutData++=*Data2++;
                continue;
                }

        *OutData++=*Data1++ | *Data2++;
        }


return(tmp);
}

set operator-(const set & s1, const set & s2)
{
int size,size2,offset;
WORD *Data2,*OutData;

 if((s1.data==NULL)||(s2.data==NULL))
 	{
        return s1;
        }

 set tmp(s1);

 size=(s1.MaxElement-s1.MinElement+1)>>4;
 size2=(s2.MaxElement-s2.MinElement+1)>>4;
 offset=(s1.MinElement-s2.MinElement+1)>>4;
 Data2=s2.data;
 OutData=tmp.data;

 if(offset<0)		 //s.MinElement>MinElement
 	{
        OutData-=offset; //offset is negative!
        size+=offset;
        offset=0;
        }
 if(offset>0)		 //s.MinElement>MinElement
 	{
        Data2+=offset;
        size2-=offset;
        offset=0;
        }

 while(size-->0)
 	{
        if(size2-- <= 0) break;

	*OutData++ &= ~*Data2++;
        }

return(tmp);
}

set operator&(const set & s1, const set & s2)
{
int size,size2,offset;
WORD *Data2,*OutData;

 if((s1.data==NULL)||(s2.data==NULL))
 	{
        return set();
        }

 set tmp(s1);

 size=(s1.MaxElement-s1.MinElement+1)>>4;
 size2=(s2.MaxElement-s2.MinElement+1)>>4;
 offset=(s1.MinElement-s2.MinElement+1)>>4;
 Data2=s2.data;
 OutData=tmp.data;

 while(offset<0)		 //s.MinElement>MinElement
 	{
        *OutData++ =0;
        size--;
        offset++;
        }
 if(offset>0)		 //s.MinElement>MinElement
 	{
        Data2+=offset;
        size2-=offset;
        offset=0;
        }

 while(size-->0)
 	{
        if(size2-- <= 0) break;

	*OutData++ &= *Data2++;
        }

return(tmp);
}

set operator^(const set & s1, const set & s2)
{
int size1,size2,offset;
WORD *Data1,*Data2,*OutData;

 if((s1.data==NULL)&&(s2.data==NULL))
 	{
        return set();
        }

 set tmp(min(s1.MinElement,s2.MinElement),max(s1.MaxElement,s2.MaxElement));

 size1=(s1.MaxElement-s1.MinElement+1)>>4;
 size2=(s2.MaxElement-s2.MinElement+1)>>4;
 offset=(s1.MinElement-s2.MinElement+1)>>4;
 Data1=s1.data;
 Data2=s2.data;
 OutData=tmp.data;

 while((size1>0)||(size2>0))
 	{
	if(offset>0)
        	{
                offset--;
                if(size2--<=0) *OutData++=0;
                	  else *OutData++=*Data2++;
                continue;
                }
        if(offset<0)
        	{
                offset++;
                if(size1--<=0) *OutData++=0;
			  else *OutData++=*Data1++;
                continue;
                }

        size1--;
        size2--;
	if(size2<0)
        	{
                *OutData++=*Data1++;
                continue;
                }
        if(size1<0)
        	{
                *OutData++=*Data2++;
                continue;
                }

        *OutData++=*Data1++ ^ *Data2++;
        }

return(tmp);
}



int EmptyCheck(const set &s)
{
int size;
WORD *CheckedData;

 size=(s.MaxElement-s.MinElement+1)>>3;
 if((s.data==NULL)||(size==0)) return(1);

 CheckedData=s.data;
 while(size-->0)
 	{
        if(*CheckedData++!=0) return(0);  // set is not empty
	};
 return(1);
}

char *int2str(char *str,int i)
{
int q,qq;
char c;

if(i<0) {
	i=-i;
        *str++='-';
	}
q=0;
do {
   *str++=i%10+'0';
   i=i/10;
   q++;
   } while(i>0);

qq=q;
q=q/2;
while(q>=1)
	{
        c=*(str-q);
        *(str-q)=*(str-qq-1+q);
        *(str-qq-1+q)=c;
        q--;
        }

*str=0;
return(str);
}

char *set2str(char *str,const set &s)
{
int i,Last,num;
char *retstr=str;

Last=TrickInterval;
num=0;
*str++='[';
if(s.data!=NULL)
  for(i=s.MinElement;i<=s.MaxElement+1;i++)
	{
        if(s[i]) {
        	 if(Last==i-1)
                 	{	//interval detected
                        num++;
                        Last++;
                        continue;
                        }
                 str=int2str(str,i);
                 num=0;
                 *str++=',';
                 Last=i;
        	 }
            else {
                 if((Last==i-1)&&(num>0))
                 	{
                        * --str='.';
                        * ++str='.';
                        str++;
                        str=int2str(str,Last);
                        *str++=',';
                        Last=TrickInterval;
                        }
                 num=0;
                 }
        }
if(* --str == '[') ++str;
*str=']';
* ++str=0;
return(retstr);
}

int Card(const set &s)
{
int i,ret=0;

for(i=s.MinElement;i<=s.MaxElement;i++)
	{
        if(s[i]) ret++;
        }
return(ret);
}

void erase(set & s)
{
 if((s.MaxElement!=s.MinElement)&&(s.data!=NULL)) free(s.data);
 s.data=NULL;
 s.MaxElement=s.MinElement=0;
}

int sync(set & s)
{
int ret=0;

if(s.data==NULL)
	{
        if(s.MinElement!=s.MaxElement) ret=SetsId | Bad_Bounds;
        s.MinElement=s.MaxElement=0;
        return(ret);
        }

if(s.MinElement==s.MaxElement)   // data !=  NULL     here
	{
        ret=SetsId | Bad_Bounds;
        }

if(ret!=0)	//sorry, something is wrong, I must erase all set here
	{
        free(s.data);
        s.MinElement=s.MaxElement=0;
        s.data=NULL;
        }

if(s.MinElement>s.MaxElement)   // only this error may be perhaps fixed
	{
        ret=s.MinElement;
        s.MinElement=s.MaxElement;
        s.MaxElement=ret;
        ret=SetsId | Bad_Bounds;
        }


return(ret);
}

