#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <lists.h>



list::list(const char *str)
{
flag=0;
number=1;
if( (pstr=(char **)malloc(sizeof(char *)))==NULL)
	{
	numalloc=number=0;
	return;
	}
numalloc=1;
if( (*pstr = strdup(str)) == NULL) number=0;
			      else number=1;
}

list::list(const list &l)
{
int i;
char **cpstr1,**cpstr2;

flag=0;
if( (cpstr1=pstr=(char **)calloc(sizeof(char *),l.number))==NULL)
	{
	numalloc=number=0;
	return;
	}
cpstr2=l.pstr;
number=numalloc=l.number;
for(i=0;i<l.number;i++)
	{
	*cpstr1++ = strdup(*cpstr2++);
	}
}



list &list::operator=(const list &l)
{
int i;
char **cpstr1,**cpstr2;

erase(*this);
if( (cpstr1=pstr=(char **)calloc(sizeof(char *),l.number))==NULL)
	{
	numalloc=number=0;
	return(*this);
	}
cpstr2=l.pstr;
number=numalloc=l.number;
for(i=0;i<l.number;i++)
	{
	*cpstr1++ = strdup(*cpstr2++);
	}

return(*this);
}


int list::operator==(const list &l) const
{
int i;
char **cpstr1,**cpstr2;

if(number!=l.number) return(0);
cpstr1=pstr;
cpstr2=l.pstr;

for(i=0;i<number;i++)
	{
	if(strcmp(*cpstr1++,*cpstr2++)) return(0);
	}
return(1);
}


int list::operator IN(const char *str) const
{
int i;
char **cpstr;


if(pstr==NULL)
	{
	if(str==NULL) return(-1);
	if(*str==0) return(-1);
	return(0);
	}
cpstr=pstr;
for(i=0;i<number;i++)
	{
	if(strcmp(str,*cpstr++)) return(i);
	}
return(-1);
}

int operator IN(const char *str,const list &l)
{
int i;
char **cpstr;

 cpstr=l.pstr;
 for(i=0;i<l.number;i++)
	{
	if(!strcmp(str,*cpstr++)) return(i+1);
	}
 return(0);
}

int InsertNewSTR(list & l, char *str)
{
if(l.number>=l.numalloc || l.pstr==NULL)
	{
	if( (l.pstr=(char **)realloc(l.pstr,++l.numalloc*sizeof(char *)))==NULL)
		{
		l.number=l.numalloc=0;
		return(-1);
		}
	}

l.pstr[l.number]=str;

return(l.number++);
}

int list::operator+=(const char *str)
{
if(number>=numalloc || pstr==NULL)
	{
	if( (pstr=(char **)realloc(pstr,++numalloc*sizeof(char *)))==NULL)
		{
		number=numalloc=0;
		return(-1);
		}
	}

if( (pstr[number]=strdup(str))==NULL )
   {
   return(-1);
   }

return(number++);
}


void erase(list &l)
{
int i;
char **cpstr;

if(l.flag!=1)
  {
  if( (cpstr=l.pstr) == NULL ) return;
  for(i=0;i<l.number;i++)
	{
	if(*cpstr!=NULL) free(*cpstr);
	cpstr++;
	}
  free(l.pstr);
  }
l.pstr=NULL;
l.numalloc=l.number=0;
l.flag=0;
}


int sync(list &l)
{
int i,ret;
char **cpstr;

ret=0;
if(l.pstr==NULL)
      {
      if(l.numalloc!=0) {l.numalloc=0;  ret=ListsId | Bad_Size;}
      if(l.number!=0)   {l.number=0;    ret=ListsId | Bad_Number;}
      return(ret);
      }

if(l.numalloc==0)
	{
	l.number=0;
	l.pstr=NULL;
	return(ListsId | Bad_Size);
	}

if(l.number>l.numalloc)
	{
	l.number=l.numalloc;
	ret=ListsId | Bad_Number;
	}

cpstr=l.pstr;
for(i=0;i<l.number;i++)
	{
        if(*cpstr==NULL) ret=ListsId | Bad_Item;
        cpstr++;
	}

return(ret);
}


int AddNewSTR(list & l,TSorter sorter, const char *str)
{
int i,q;
char **cpstr,*dupstr;

cpstr=l.pstr;
i=0;

if(sorter!=NULL)
  while(i<l.number)
	{
	q = sorter(str,*cpstr);
	if(q==0) return(i);
	if(q<0) break;
	i++;
	cpstr++;
	}
else i=l.number;

if( (cpstr=(char **)calloc(sizeof(char *),l.number+1))==NULL) return(-1);
if((dupstr=strdup(str))==NULL)
	{
	free(cpstr);
	return(-1);
	}

memmove(cpstr,l.pstr,i*sizeof(char *));
cpstr[i]=dupstr;
memmove(cpstr+i+1,l.pstr+i,(l.number-i)*sizeof(char *));
free(l.pstr);

l.pstr=cpstr;
l.numalloc=++l.number;

return(i);
}


////////////// Sorters etc. //////////////

inline void split(TSorter sorter, char **item, int d, int h, int &i, int &j)
{
char *pivot,*temp;

i=h;j=d;
pivot=item[(d+h)/2];

do {
   while(sorter(item[j],pivot)<0) j++;
   while(sorter(item[i],pivot)>0) i--;

   if(i>=j)
     {
     temp=item[i];
     item[i]=item[j];
     item[j]=temp;
     i--;
     j++;
     }
   } while(j<i);
}

void Qsort(TSorter sorter, char **item, int d, int h)
{
int i,j;

split(sorter,item,d,h,i,j);
if(d<i) Qsort(sorter,item,d,i);
if(h>j) Qsort(sorter,item,j,h);
}


int operator IN(const char *str,const sortedlist &l)
{
int hi,lo,pivot,s;

 if(l.pstr==NULL)
	{
	if(str==NULL) return(-1);
	if(*str==0) return(-1);
	return(0);
	}
 if(l.sorter==NULL) return(str IN (list)l);
 lo=0;
 hi=l.number;

 while(hi>=lo)
	{
	pivot=(lo+hi)/2;
	s=l.sorter(str,l.pstr[pivot]);
	if(s>0)
	   {
	   lo=pivot+1;
	   continue;
	   }
	if(s==0) return(pivot+1);
	if(s<0)
	   {
	   hi=pivot-1;
	   continue;
	   }
	}

 return(0);
}


int RemoveDups(sortedlist & l)
{
int i,r;
char **apstr,**bpstr;

if(l.pstr==0 || l.number<=1) return(0);
r=0;
apstr=bpstr=l.pstr;
for(i=0;i<l.number-1;i++)
	{
	if(!strcmp(*apstr,apstr[1]))
		{
		r++;
		free(*apstr);
		*apstr=NULL;
		apstr++;
		}
	else {
	     if(*bpstr==NULL)
		{
		*bpstr=*apstr;
		*apstr=NULL;
		}
	     apstr++,bpstr++;
	     }
	}
if(*bpstr==NULL)
    {
    *bpstr=*apstr;
    *apstr=NULL;
    }

l.number-=r;
return(r);
}




